<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		//$this->load->library('encrypt');
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
            $this->session->set_flashdata('registerMessage','Please Login First',':old:');
            return redirect('index.php/welcome/admin');
        }
		
	}

	public function index()
	{
		redirect(base_url().'index.php/admin/dashboard');
	}

	public function dashboard(){
		$data['currentMenu'] = 'dashboard';
		$data['pageType'] = 'Admin';
		$data['pageHeading'] = 'Dashboard';
		$data['pageTitle'] = "Dashboard | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}

		
		
		$this->load->view('templates/header',$data);
		$this->load->view('admin/dashboard/dashboard',$data);
		$this->load->view('templates/footer');
	}



	
}
