<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function index()
	{
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}

		$where = array();
		$data['customers'] = $this->general_model->get('mst_customers',$where);
		
		$data['currentMenu'] = 'customers';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'customers';
		$data['pageTitle'] = "customers | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('masters/customers/customers',$data);
		$this->load->view('templates/footer');
	}

	

	public function edit($client_id=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		
		$where = array();
		$whereEdit = array('client_id' => $client_id);

		$data['customers'] = $this->general_model->get('mst_customers',$where);
		$data['singlecustomers'] =$this->general_model->get('mst_customers',$whereEdit);

		//
		$where1 = array('client_id'		=> $client_id);
		$whereInvoiceAmount = array('status' => 5);

		$OutstandingAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$where1);
		$OutstandingtotalAmount = $this->general_model->getSum('totalAmount','trn_sales_invoice',$whereInvoiceAmount);
		$outStandingBills = $this->general_model->getCount('trn_customer_outstandings',$where);

		$whereCustomer = array('client_id'	=> $client_id);
		$customerDetails = $this->general_model->get('mst_customers',$whereCustomer);

		if(is_array($OutstandingtotalAmount)){
			$data['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'] + $OutstandingtotalAmount[0]['totalAmount'];
		}else{
			$data['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'];
		}

		$whereOverDue = array(
			'client_id'															=> $client_id,
			'DATEDIFF(CURRENT_DATE(), bill_date) >'	=> $customerDetails[0]['creditPeriod']
		);
		$overDueAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$whereOverDue);
		$overDueBillCount = $this->general_model->getCount('trn_customer_outstandings',$whereOverDue);

		$data['overdueamount'] = $overDueAmount[0]['bill_os_amt'];
		$data['overDueBillCount'] = $overDueBillCount;
		$data['outStandingBills'] = $outStandingBills;


		$data['loginRedirect']=base_url().'index.php/masters/customers/update';
		
		$data['currentMenu'] = 'customers';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Customers';
		$data['pageTitle'] = "Customers | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('masters/customers/editCustomer',$data);
		$this->load->view('templates/footer');
	}

	public function update(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('is_credit', 'Is Credit', 'required|numeric');
		$this->form_validation->set_rules('creditLimit', 'Credit Limit', 'required');
		$this->form_validation->set_rules('creditPeriod', 'Credit Period', 'required');
		$this->form_validation->set_rules('blockon_creditlimit', 'Block on Credit Limit', 'required|numeric');
		$this->form_validation->set_rules('blockon_overdue', 'Block on Overdue', 'required|numeric');
		$this->form_validation->set_rules('priceType', 'Price Type', 'required|numeric');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/masters/customers');
		}else{

			if($this->input->post('is_credit') == "1"){
				$is_credit = 1;
			}else{
				$is_credit = 0;
			}

			if($this->input->post('blockon_creditlimit') == "1"){
				$blockon_creditlimit = 1;
			}else{
				$blockon_creditlimit = 0;
			}

			if($this->input->post('blockon_overdue') == "1"){
				$blockon_overdue = 1;
			}else{
				$blockon_overdue = 0;
			}

			$data = array(
				'is_credit'		 				=>	$is_credit,
				'creditLimit'   			=>  $this->input->post('creditLimit'),
				'creditPeriod' 				=>  $this->input->post('creditPeriod'),
				'blockon_creditlimit' =>  $blockon_creditlimit,
				'blockon_overdue'   	=>  $blockon_overdue,
				'priceType'   				=>  $this->input->post('priceType'),
			);
			$where = array(
				'client_id'					=> $this->input->post('client_id')
			);
			$this->general_model->update('mst_customers',$data,$where);
			$this->session->set_flashdata('registerMessage','Customer Updated Successfully',':old:');
			redirect(base_url().'index.php/masters/customers');
		}
	}

}
