<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MaterialRequest extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function index()
	{
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNView",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		$userID = $_SESSION['userId'];
		$whereUser = array('user' => $userID);
		$userDepts = $this->general_model->get('mst_user_departments',$whereUser);

		$where = array();
		$deptList = array();
		if(is_array($userDepts)){
			foreach($userDepts as $userDept){
				$deptID = $userDept['department'];
				array_push($deptList, $deptID);
			}
		}

		$where = array();
		if(isset($_SESSION['admin_logged_in'])){
			$data['materialrequests'] = $this->general_model->get_material_requests($where);
		}else{
			$data['materialrequests'] = $this->general_model->get_material_requests($where, null, null, null, null, null, null, 'department', $deptList);
		}


		
		

		$data['loginRedirect']=base_url().'index.php/transactions/MaterialRequest/newmrn';
		
		$data['currentMenu'] = 'materialrequest';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Material Requests';
		$data['pageTitle'] = "Material Requests | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/materialrequest/materialrequest',$data);
		$this->load->view('templates/footer');
	}

	public function newmrn(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNCreate",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$data['departments'] = $this->general_model->get_list('departmentID','departmentName','sys_departments', array('' => 'Select Department'), array('sys_departments.isDeleted' => 0));

		$data['projects'] = $this->general_model->get_list('projectID','projectName','mst_projects', array('' => 'Select Project'), array('mst_projects.isDeleted' => 0));

		$data['locations'] = $this->general_model->get_list('deliveryLocationID','deliveryLocationName','sys_delivery_locations', array('' => 'Select Location'), array('sys_delivery_locations.isDeleted' => 0));

		$data['suppliers'] = $this->general_model->get_list('supplierID','supplierName','mst_suppliers', array('' => 'Select Supplier'), array('mst_suppliers.isDeleted' => 0));

		$data['items'] = $this->general_model->get_list('itemID','itemName','mst_items', array('select' => 'Select Item'), array('mst_items.isDeleted' => 0));

		$data['mrnNo'] = $this->general_model->getmax('mrnNo','trn_material_requests');
		
		$data['loginRedirect']=base_url().'index.php/transactions/MaterialRequest/add';
		
		$data['currentMenu'] = 'materialrequest';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Material Request';
		$data['pageTitle'] = "Material Request | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/materialrequest/newmrn',$data);
		$this->load->view('templates/footer');
	}

	
	public function add(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNCreate",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('department', 'Department', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderProject', 'Project', 'required|numeric');
		$this->form_validation->set_rules('deliveryLocation', 'Delivery Location','required|numeric');
		$this->form_validation->set_rules('materialRequestDate', 'Date', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/transactions/MaterialRequest/newmrn');
		}else{
			$itemCheckCount = count($this->input->post('qty'));
			$hexItemQty = $this->input->post('qty');
			//print_r($this->input->post('qty')); exit;
			if($itemCheckCount == 1 && $hexItemQty[0] == "" ){
				$this->session->set_flashdata('registerMessage',"Atleast one item should be added",':old:');
				redirect(base_url().'index.php/transactions/MaterialRequest/newmrn');
			}

			$mrnNo = $this->general_model->getmax('mrnNo','trn_material_requests');

			$materialRequestDate = date('Y-m-d', strtotime(str_replace('/','-', $this->input->post('materialRequestDate'))));

			$data = array(
				'mrnNo'		 							=>	$mrnNo,
				'materialRequestDate' 	=>	$materialRequestDate,
				'department' 						=>  $this->input->post('department'),
				'project'   						=>  $this->input->post('purchaseOrderProject'),
				'deliveryLocation'  		=>  $this->input->post('deliveryLocation'),
				'supplier'  						=>  $this->input->post('supplier'),
				'narration'  						=>  $this->input->post('narration'),
				'reqBy'									=> 	$this->session->userdata['userId'],
				'materialRequestStatus' =>  1
			);
			$materialRequestID = $this->general_model->insert('trn_material_requests',$data);

			// Details
			$itemType = $this->input->post('itemType');
			$itemID = $this->input->post('itemID');
			$item = $this->input->post('item');
			$brand = $this->input->post('brand');
			$packing = $this->input->post('packing');
			$qty = $this->input->post('qty');
			$itemsupplier = $this->input->post('itemsupplier');


			$itemCount = count($this->input->post('itemType'));
			for($i=0; $i<$itemCount; $i++){
				if($itemID[$i] == "select"){
					$singleItem = 0;
				}else{
					$singleItem = $itemID[$i];
				}
				$dataDetails = array(
					'materialRequest'				=> $materialRequestID,
					'itemType'							=> $itemType[$i],
					'item'									=> $singleItem,
					'itemDescription'				=> $item[$i],
					'itemDescriptionExtra'	=> '',
					'brand'									=> $brand[$i],
					'packing'								=> $packing[$i],
					'qty'										=> $qty[$i],
					'supplier'							=> $itemsupplier[$i],
					'isProcessed'						=> 0
				);
				$this->general_model->insert('trn_mrn_details',$dataDetails);
			}


			$this->session->set_flashdata('registerMessage','Item Added Successfully',':old:');
			redirect(base_url().'index.php/transactions/MaterialRequest');
		}
	}

	public function edit($materialRequestID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		
		$where = array('materialRequestID' => $materialRequestID);
		$whereDetails = array('materialRequest'	=> $materialRequestID, 'isProcessed'	=> 0);

		$data['materialrequest'] = $this->general_model->get_material_requests($where);
		$data['mrnDetails'] = $this->general_model->get_mrn_details($whereDetails);
		

		$data['departments'] = $this->general_model->get_list('departmentID','departmentName','sys_departments', array('select' => 'Select Department'), array('sys_departments.isDeleted' => 0));

		$data['projects'] = $this->general_model->get_list('projectID','projectName','mst_projects', array('select' => 'Select Project'), array('mst_projects.isDeleted' => 0));

		$data['locations'] = $this->general_model->get_list('deliveryLocationID','deliveryLocationName','sys_delivery_locations', array('select' => 'Select Location'), array('sys_delivery_locations.isDeleted' => 0));

		$data['suppliers'] = $this->general_model->get_list('supplierID','supplierName','mst_suppliers', array('select' => 'Select Supplier'), array('mst_suppliers.isDeleted' => 0));

		$data['items'] = $this->general_model->get_list('itemID','itemName','mst_items', array('select' => 'Select Item'), array('mst_items.isDeleted' => 0));


		$data['loginRedirect']=base_url().'index.php/transactions/MaterialRequest/update';
		
		$data['currentMenu'] = 'materialrequest';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'materialrequest';
		$data['pageTitle'] = "materialrequest | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/materialrequest/editMrn',$data);
		$this->load->view('templates/footer');
	}

	public function update(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('department', 'Department', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderProject', 'Project', 'required|numeric');
		$this->form_validation->set_rules('deliveryLocation', 'Delivery Location','required|numeric');
		$this->form_validation->set_rules('materialRequestDate', 'Date', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/transactions/MaterialRequest/edit/'.$this->input->post('materialRequestID'));
		}else{
			$itemCheckCount = count($this->input->post('qty'));
			$removeItems = $this->input->post('removeItems');
			$hexItemQty = $this->input->post('qty');
			//print_r($this->input->post('qty')); exit;
			// if($itemCheckCount == 1 && $hexItemQty[0] == "" && is_null($removeItems)){
			// 	$this->session->set_flashdata('registerMessage',"Atleast one item should be added",':old:');
			// 	redirect(base_url().'index.php/transactions/MaterialRequest/edit/'.$this->input->post('materialRequestID'));
			// }

			$materialRequestDate = date('Y-m-d', strtotime(str_replace('/','-', $this->input->post('materialRequestDate'))));
			
			$data = array(
				'mrnNo'		 							=>	$this->input->post('mrnNo'),
				'materialRequestDate' 	=>	$materialRequestDate,
				'department' 						=>  $this->input->post('department'),
				'project'   						=>  $this->input->post('purchaseOrderProject'),
				'deliveryLocation'  		=>  $this->input->post('deliveryLocation'),
				'supplier'  						=>  $this->input->post('supplier'),
				'narration'  						=>  $this->input->post('narration'),
				'reqBy'									=> 	$this->session->userdata['userId'],
				'materialRequestStatus' =>  1
			);

			$where = array(
				'materialRequestID'					=> $this->input->post('materialRequestID')
			);
			$this->general_model->update('trn_material_requests',$data,$where);

			$removeItems = $this->input->post('removeItems');
			if(is_array($removeItems)){
				for($i=0;$i<count($removeItems);$i++){
					$whereDelete = array('mrnDetailsID' => $removeItems[$i]);
					$this->general_model->delete('trn_mrn_details', $whereDelete);
				}
			}

			// Details
			$itemType = $this->input->post('itemType');
			$itemID = $this->input->post('itemID');
			$item = $this->input->post('item');
			$brand = $this->input->post('brand');
			$packing = $this->input->post('packing');
			$qty = $this->input->post('qty');
			$itemsupplier = $this->input->post('itemsupplier');


			$itemCount = count($this->input->post('itemType'));
			$itemDescCount = count($this->input->post('item'));
			if($item[0] != ""){
				for($i=0; $i<$itemCount; $i++){
					if($itemID[$i] == "select"){
						$singleItem = 0;
					}else{
						$singleItem = $itemID[$i];
					}
					$dataDetails = array(
						'materialRequest'				=> $this->input->post('materialRequestID'),
						'itemType'							=> $itemType[$i],
						'item'									=> $singleItem,
						'itemDescription'				=> $item[$i],
						'itemDescriptionExtra'	=> '',
						'brand'									=> $brand[$i],
						'packing'								=> $packing[$i],
						'qty'										=> $qty[$i],
						'supplier'							=> $itemsupplier[$i],
						'isProcessed'						=> 0
					);
					$this->general_model->insert('trn_mrn_details',$dataDetails);
				}
			}
			

			$this->session->set_flashdata('registerMessage','MRN Upddated Successfully',':old:');
			redirect(base_url().'index.php/transactions/MaterialRequest');
		}
	}

	public function view($materialRequestID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNView",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		
		$where = array('materialRequestID' => $materialRequestID);
		$whereDetails = array('materialRequest'	=> $materialRequestID, 'isProcessed'	=> 0);

		$data['materialrequest'] = $this->general_model->get_material_requests($where);
		$data['mrnDetails'] = $this->general_model->get_mrn_details($whereDetails);
		
		$data['currentMenu'] = 'materialrequest';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'materialrequest';
		$data['pageTitle'] = "materialrequest | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/materialrequest/viewMrn',$data);
		$this->load->view('templates/footer');
	}

	public function print($materialRequestID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("MRNPrint",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		
		$where = array('materialRequestID' => $materialRequestID);
		$whereDetails = array('materialRequest'	=> $materialRequestID, 'isProcessed'	=> 0);

		$data['materialrequest'] = $this->general_model->get_material_requests($where);
		$data['mrnDetails'] = $this->general_model->get_mrn_details($whereDetails);

		$where = array('companyID'	=> 1);
		$data['settings'] = $this->general_model->get('gen_settings',$where);
		
		$data['currentMenu'] = 'materialrequest';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'materialrequest';
		$data['pageTitle'] = "materialrequest | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/materialrequest/printMrn',$data);
		$this->load->view('templates/footer');
	}

	

	public function getItemDesc(){
		$itemID = $_POST['itemID'];
		$where = array('itemID' => $itemID);
		$items = $this->general_model->get('mst_items', $where);
		if(is_array($items)){
			echo $items[0]['itemDescription'];
		}else{
			echo "";
		}
		exit;
	}
}
