<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PurchaseOrders extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function index()
	{
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POView",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		

		$where = array();
		$data['purchaseorders'] = $this->general_model->get_purchase_orders($where);

		$data['loginRedirect']=base_url().'index.php/transactions/PurchaseOrders/newpo';
		
		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Purchase Orders';
		$data['pageTitle'] = "Purchase Orders | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/purchaseorders',$data);
		$this->load->view('templates/footer');
	}

	public function newpo(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POCreate",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$data['departments'] = $this->general_model->get_list('departmentID','departmentName','sys_departments', array('' => 'Select Department'), array('sys_departments.isDeleted' => 0));

		$data['projects'] = $this->general_model->get_list('projectID','projectName','mst_projects', array('' => 'Select Project'), array('mst_projects.isDeleted' => 0));

		$data['locations'] = $this->general_model->get_list('deliveryLocationID','deliveryLocationName','sys_delivery_locations', array('' => 'Select Location'), array('sys_delivery_locations.isDeleted' => 0));

		$data['suppliers'] = $this->general_model->get_list('supplierID','supplierName','mst_suppliers', array('' => 'Select Supplier'), array('mst_suppliers.isDeleted' => 0));

		$data['tax'] = $this->general_model->get_list('taxID','taxName','sys_tax', array('' => 'Select VAT'), array('sys_tax.isDeleted' => 0));

		$data['items'] = $this->general_model->get_list('itemID','itemName','mst_items', array('select' => 'Select Item'), array('mst_items.isDeleted' => 0));

		$data['purchaseOrderNo'] = $this->general_model->getmax('purchaseOrderNo','trn_purchase_orders');
		
		$data['loginRedirect']=base_url().'index.php/transactions/PurchaseOrders/add';
		
		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Purchase Orders';
		$data['pageTitle'] = "Purchase Orders | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/newpo',$data);
		$this->load->view('templates/footer');
	}

	
	public function add(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POCreate",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('purchaseOrderDept', 'Department', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderProject', 'Project', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderDeliveryLocation', 'Delivery Location','required|numeric');
		$this->form_validation->set_rules('purchaseOrderSupplier', 'Supplier','required|numeric');
		$this->form_validation->set_rules('purchaseOrderTax', 'VAT','required|numeric');
		$this->form_validation->set_rules('purchaseOrderDate', 'Date', 'required');

		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/transactions/PurchaseOrders/newpo');
		}else{

			$purchaseOrderNo = $this->general_model->getmax('purchaseOrderNo','trn_purchase_orders');

			$purchaseOrderDate = date('Y-m-d', strtotime(str_replace('/','-', $this->input->post('purchaseOrderDate'))));

			$data = array(
				'purchaseOrderNo'		 						=>	$purchaseOrderNo,
				'purchaseOrderDate' 						=>	$purchaseOrderDate,
				'purchaseOrderSupplier' 				=>  $this->input->post('purchaseOrderSupplier'),
				'purchaseOrderProject' 					=>  $this->input->post('purchaseOrderProject'),
				'purchaseOrderDept' 						=>  $this->input->post('purchaseOrderDept'),
				'purchaseOrderReference'   			=>  $this->input->post('purchaseOrderReference'),
				'purchaseOrderNarration'  			=>  $this->input->post('purchaseOrderNarration'),
				'purchaseOrderDeliveryLocation' =>  $this->input->post('purchaseOrderDeliveryLocation'),
				'purchaseOrderTax'  						=>  $this->input->post('purchaseOrderTax'),
				'purchaseOrderTotal'  					=>  $this->input->post('purchaseOrderTotal'),
				'purchaseOrderDiscount'  				=>  $this->input->post('purchaseOrderDiscount'),
				'purchaseOrderTaxAmount'  			=>  $this->input->post('purchaseOrderTaxAmount'),
				'purchaseOrderNetTotal'  				=>  $this->input->post('purchaseOrderNetTotal'),
				'createdBy'											=> 	$this->session->userdata['userId']
			);
			$purchaseOrder = $this->general_model->insert('trn_purchase_orders',$data);

			// Details
			$mrnDetailsID = $this->input->post('mrnDetailsID');
			$poItemQty = $this->input->post('poItemQty');
			$poItemRate = $this->input->post('poItemRate');
			$poItemDiscountPer = $this->input->post('poItemDiscountPer');
			$poItemDiscountAmount = $this->input->post('poItemDiscountAmount');
			$poItemVatPer = $this->input->post('poItemVatPer');
			$poItemVatAmount = $this->input->post('poItemVatAmount');
			$poItemTotal = $this->input->post('poItemTotal');


			$itemCount = count($this->input->post('mrnDetailsID'));
			for($i=0; $i<$itemCount; $i++){
				
				$dataDetails = array(
					'purchaseOrder'				=> $purchaseOrder,
					'mrnDetailsID'				=> $mrnDetailsID[$i],
					'poItemRate'					=> $poItemRate[$i],
					'poItemDiscountPer'		=> $poItemDiscountPer[$i],
					'poItemDiscountAmount'=> $poItemDiscountAmount[$i],
					'poItemVatPer'				=> $poItemVatPer[$i],
					'poItemVatAmount'			=> $poItemVatAmount[$i],
					'poItemQty'						=> $poItemQty[$i],
					'poItemTotal'					=> $poItemTotal[$i],
				);
				$this->general_model->insert('trn_po_details',$dataDetails);

				$dataMRN = array('isProcessed'	=> 1);
				$whereMRN = array('mrnDetailsID'	=> $mrnDetailsID[$i]);
				$this->general_model->update('trn_mrn_details',$dataMRN,$whereMRN);
			}


			$this->session->set_flashdata('registerMessage','PO Added Successfully',':old:');
			redirect(base_url().'index.php/transactions/PurchaseOrders');
		}
	}

	public function edit($purchaseOrderID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		$where = array('purchaseOrderID' => $purchaseOrderID);
		$whereDetails = array('purchaseOrder' => $purchaseOrderID);

		$data['purchaseorders'] = $this->general_model->get_purchase_orders($where);
		$data['podetails'] =$this->general_model->get_po_details($whereDetails);

		$data['departments'] = $this->general_model->get_list('departmentID','departmentName','sys_departments', array('select' => 'Select Department'), array('sys_departments.isDeleted' => 0));

		$data['projects'] = $this->general_model->get_list('projectID','projectName','mst_projects', array('select' => 'Select Project'), array('mst_projects.isDeleted' => 0));

		$data['locations'] = $this->general_model->get_list('deliveryLocationID','deliveryLocationName','sys_delivery_locations', array('select' => 'Select Location'), array('sys_delivery_locations.isDeleted' => 0));

		$data['suppliers'] = $this->general_model->get_list('supplierID','supplierName','mst_suppliers', array('select' => 'Select Supplier'), array('mst_suppliers.isDeleted' => 0));

		$data['tax'] = $this->general_model->get_list('taxID','taxName','sys_tax', array('select' => 'Select VAT'), array('sys_tax.isDeleted' => 0));

		$data['items'] = $this->general_model->get_list('itemID','itemName','mst_items', array('select' => 'Select Item'), array('mst_items.isDeleted' => 0));

		$data['loginRedirect']=base_url().'index.php/transactions/PurchaseOrders/update';
		
		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'purchaseorders';
		$data['pageTitle'] = "Purchase Orders | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/editPo',$data);
		$this->load->view('templates/footer');
	}

	public function update(){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('purchaseOrderDept', 'Department', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderProject', 'Project', 'required|numeric');
		$this->form_validation->set_rules('purchaseOrderDeliveryLocation', 'Delivery Location','required|numeric');
		$this->form_validation->set_rules('purchaseOrderSupplier', 'Supplier','required|numeric');
		$this->form_validation->set_rules('purchaseOrderTax', 'VAT','required|numeric');
		$this->form_validation->set_rules('purchaseOrderDate', 'Date', 'required');

		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/transactions/PurchaseOrders/newpo');
		}else{


			$purchaseOrderDate = date('Y-m-d', strtotime(str_replace('/','-', $this->input->post('purchaseOrderDate'))));

			$data = array(
				'purchaseOrderNo'		 						=>	$this->input->post('purchaseOrderNo'),
				'purchaseOrderDate' 						=>	$purchaseOrderDate,
				'purchaseOrderSupplier' 				=>  $this->input->post('purchaseOrderSupplier'),
				'purchaseOrderProject' 					=>  $this->input->post('purchaseOrderProject'),
				'purchaseOrderDept' 						=>  $this->input->post('purchaseOrderDept'),
				'purchaseOrderReference'   			=>  $this->input->post('purchaseOrderReference'),
				'purchaseOrderNarration'  			=>  $this->input->post('purchaseOrderNarration'),
				'purchaseOrderDeliveryLocation' =>  $this->input->post('purchaseOrderDeliveryLocation'),
				'purchaseOrderTax'  						=>  $this->input->post('purchaseOrderTax'),
				'purchaseOrderTotal'  					=>  $this->input->post('purchaseOrderTotal'),
				'purchaseOrderDiscount'  				=>  $this->input->post('purchaseOrderDiscount'),
				'purchaseOrderTaxAmount'  			=>  $this->input->post('purchaseOrderTaxAmount'),
				'purchaseOrderNetTotal'  				=>  $this->input->post('purchaseOrderNetTotal'),
				'createdBy'											=> 	$this->session->userdata['userId']
			);
			$where = array('purchaseOrderID'	=> $this->input->post('purchaseOrderID'));
			$this->general_model->update('trn_purchase_orders',$data, $where);

			// Delete Existing Entries
			$whereDelete = array('purchaseOrder'	=> $this->input->post('purchaseOrderID'));
			$this->general_model->delete('trn_po_details',$whereDelete);


			// Details
			$mrnDetailsID = $this->input->post('mrnDetailsID');
			$poItemQty = $this->input->post('poItemQty');
			$poItemRate = $this->input->post('poItemRate');
			$poItemDiscountPer = $this->input->post('poItemDiscountPer');
			$poItemDiscountAmount = $this->input->post('poItemDiscountAmount');
			$poItemVatPer = $this->input->post('poItemVatPer');
			$poItemVatAmount = $this->input->post('poItemVatAmount');
			$poItemTotal = $this->input->post('poItemTotal');


			$itemCount = count($this->input->post('mrnDetailsID'));
			for($i=0; $i<$itemCount; $i++){
				
				$dataDetails = array(
					'purchaseOrder'				=> $this->input->post('purchaseOrderID'),
					'mrnDetailsID'				=> $mrnDetailsID[$i],
					'poItemRate'					=> $poItemRate[$i],
					'poItemDiscountPer'		=> $poItemDiscountPer[$i],
					'poItemDiscountAmount'=> $poItemDiscountAmount[$i],
					'poItemVatPer'				=> $poItemVatPer[$i],
					'poItemVatAmount'			=> $poItemVatAmount[$i],
					'poItemQty'						=> $poItemQty[$i],
					'poItemTotal'					=> $poItemTotal[$i],
				);
				$this->general_model->insert('trn_po_details',$dataDetails);

				$dataMRN = array('isProcessed'	=> 1);
				$whereMRN = array('mrnDetailsID'	=> $mrnDetailsID[$i]);
				$this->general_model->update('trn_mrn_details',$dataMRN,$whereMRN);
			}


			$this->session->set_flashdata('registerMessage','PO Updated Successfully',':old:');
			redirect(base_url().'index.php/transactions/PurchaseOrders');
		}
	}


	public function getmrn(){
		$project = $_POST['project'];
		$department = $_POST['department'];

		$where = array('department' => $department, 'project' => $project);
		$mrns = $this->general_model->get_material_requests($where);
		$returnData = '<table id="materialRequestTable" class="table table-striped table-bordered text-nowrap w-100"><thead><tr><th class="wd-15p"><input type="checkbox" name="" class="form-control selectall" /></th><th class="wd-15p">MRN #</th><th class="wd-15p">Project Name</th><th class="wd-15p">Project Code</th><th class="wd-15p">Dept.</th><th class="wd-15p">Requested By</th></tr></thead><tbody>';
		if(is_array($mrns)){
			foreach($mrns as $mrn){
				$whereDetails = array('materialRequest' => $mrn["materialRequestID"], 'isProcessed' => 0);
				$mrnDetailsCount = $this->general_model->getCount('trn_mrn_details', $whereDetails);
				if($mrnDetailsCount > 0){
					$returnData .= '<tr><td><input type="checkbox" name="mrnId[]" value="'.$mrn["materialRequestID"].'" class="form-control mrnId" /></td><td>'.$mrn["mrnNo"].'</td><td>'.$mrn["projectName"].'</td><td>'.$mrn["projectCode"].'</td><td>'.$mrn["departmentName"].'</td><td>'.$mrn["userFullName"].'</td></tr>';
				}else{
					$returnData .='<tr><td colspan="6">No Unproccessed MRN Found</td></tr>';
				}
				
			}
		}else{
			
		}
		$returnData .='</tbody></table> <a href="#" class="btn btn-primary getItems" name="">Fetch Items</a>';
		echo $returnData;
		exit;
	}

	public function getmrnitems(){
		$mrnId = $_POST['mrnId'];
		$where = array('materialRequestID'	=> $mrnId);
		$mrns = $this->general_model->get_material_requests($where);

		$whereDetails = array('materialRequest' => $mrnId, 'isProcessed' => 0);
		$mrnDetails = $this->general_model->get('trn_mrn_details',$whereDetails);

		$returnData = "";
		if(is_array($mrnDetails)){
			foreach($mrnDetails as $mrnDetail){
				$returnData .= '<tr><td><input type="checkbox" name="mrnDetailsID[]" value="'.$mrnDetail["mrnDetailsID"].'" class="form-control mrnDetailsID" /></td><td>'.$mrnDetail["itemDescription"].'</td><td>'.$mrns[0]["mrnNo"].'</td><td>'.$mrns[0]["projectCode"].'</td><td>'.$mrns[0]["departmentName"].'</td><td>'.$mrnDetail["qty"].'</td><td><input type="number" name="poqty[]" value="" class="form-control poqty" required="required"/></td></tr>';
			}
		}

		echo $returnData;
		exit;
	}

	public function getmrnitemsNew(){
		$project = $_POST['project'];
		$department = $_POST['department'];


		$where = array('department' => $department, 'project' => $project);
		$mrns = $this->general_model->get_material_requests($where);

		$returnData = "";
		if(is_array($mrns)){
			foreach($mrns as $mrnSingle){
				$whereDetails = array('materialRequest' => $mrnSingle['materialRequestID'], 'isProcessed' => 0);
				$mrnDetails = $this->general_model->get('trn_mrn_details',$whereDetails);
				if(is_array($mrnDetails)){
					foreach($mrnDetails as $mrnDetail){
						$returnData .= '<tr><td><input type="checkbox" name="mrnDetailsID[]" value="'.$mrnDetail["mrnDetailsID"].'" class="form-control mrnDetailsID" /></td><td>'.$mrnDetail["itemDescription"].'</td><td>'.$mrnSingle["mrnNo"].'</td><td>'.$mrnSingle["projectCode"].'</td><td>'.$mrnSingle["departmentName"].'</td><td>'.$mrnDetail["qty"].'</td><td><input type="number" name="poqty[]" value="" class="form-control poqty" required="required"/></td></tr>';
					}
				}
			}
		}

		echo $returnData;
		exit;
	}

	public function getmrnitemsdetails(){
		//echo 'test'; exit;
		$mrnDetailsID = $_POST['mrnDetailsID'];
		$newQty = $_POST['newQty'];

		$whereDetails = array('mrnDetailsID' => $mrnDetailsID, 'isProcessed' => 0);
		$mrnDetails = $this->general_model->get('trn_mrn_details',$whereDetails);

		$tax = $this->general_model->get_list('taxPercentage','taxName','sys_tax', array('select' => 'Select VAT'), array('sys_tax.isDeleted' => 0));
		$designationsOptionsJs = 'id="" class="form-control  poItemVatPer"';

		$returnData = "";
		if(is_array($mrnDetails)){
			foreach($mrnDetails as $mrnDetail){
				$returnData .= '<tr>';
				$returnData .= '<td><input type="text" class="form-control" name="itemDescription[]" value="'.$mrnDetail["itemDescription"].'" readonly="readonly"><input type="hidden" class="form-control" name="mrnDetailsID[]" value="'.$mrnDetail["mrnDetailsID"].'"></td>';
				$returnData .= '<td><input type="text" class="form-control" name="brand[]" value="'.$mrnDetail["brand"].'" readonly="readonly"></td>';
				$returnData .= '<td><input type="text" class="form-control" name="packing[]" value="'.$mrnDetail["packing"].'" readonly="readonly"></td>';
				$returnData .= '<td><input type="text" class="form-control poItemQty" name="poItemQty[]" value="'.$newQty.'"></td>';
				$returnData .= '<td><input type="number" step="0.001" class="form-control poItemRate" name="poItemRate[]" value=""></td>';
				$returnData .= '<td><input type="number" step="0.001" class="form-control poItemDiscountPer" name="poItemDiscountPer[]" value=""></td>';
				$returnData .= '<td><input type="number" step="0.001" class="form-control poItemDiscountAmount" name="poItemDiscountAmount[]" value=""></td>';
				//$returnData .= '<td><input type="number" class="form-control poItemVatPer" name="poItemVatPer[]" value=""></td>';
				$returnData .= '<td>'.form_dropdown('poItemVatPer[]', $tax, '5.00',$designationsOptionsJs).'</td>';
				$returnData .= '<td><input type="number"step="0.001" step="0.001" class="form-control poItemVatAmount" name="poItemVatAmount[]" value="" readonly="readonly"></td>';
				$returnData .= '<td><input type="number" step="0.001" class="form-control poItemTotal" name="poItemTotal[]" value="" readonly="readonly"></td>';
				$returnData .= '<td><a href="#" class="btn btn-primary deleteRow" name="">X</a></td>';
				$returnData .= '</tr>';
			}
		}

		echo $returnData;
		exit;
	}

	public function listPO()
	{
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POApprovalView",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}

		$userID = $_SESSION['userId'];
		
		$whereUser = array('user' => $userID);
		$userDepts = $this->general_model->get('mst_user_departments',$whereUser);

		$where = array();
		$deptList = array();
		if(is_array($userDepts)){
			foreach($userDepts as $userDept){
				$deptID = $userDept['department'];
				array_push($deptList, $deptID);
			}
		}

		$data['purchaseorders'] = $this->general_model->get_purchase_orders($where, null, null, null, null, null, null, 'purchaseOrderDept', $deptList);

		
		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Approve PO';
		$data['pageTitle'] = "Approve PO | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/listpo',$data);
		$this->load->view('templates/footer');
	}

	public function view($purchaseOrderID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POApprovalView",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		$where = array('purchaseOrderID' => $purchaseOrderID);
		$whereDetails = array('purchaseOrder' => $purchaseOrderID);

		$data['purchaseorders'] = $this->general_model->get_purchase_orders($where);
		$data['podetails'] =$this->general_model->get_po_details($whereDetails);

		
		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'purchaseorders';
		$data['pageTitle'] = "Purchase Orders | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/viewPo',$data);
		$this->load->view('templates/footer');
	}

	public function print($purchaseOrderID=0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POPrint",$_SESSION['assignedPermissions'])&&!in_array("POApprovalPrint",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		
		$where = array('purchaseOrderID' => $purchaseOrderID);
		$whereDetails = array('purchaseOrder' => $purchaseOrderID);

		$data['purchaseorders'] = $this->general_model->get_purchase_orders($where);
		$data['podetails'] =$this->general_model->get_po_details($whereDetails);

		$where = array('companyID'	=> 1);
		$data['settings'] = $this->general_model->get('gen_settings',$where);


		$data['currentMenu'] = 'purchaseorders';
		$data['pageType'] = 'transactions';
		$data['pageHeading'] = 'purchaseorders';
		$data['pageTitle'] = "Purchase Orders | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('transactions/purchaseorders/printPo',$data);
		$this->load->view('templates/footer');
	}

	public function approve($purchaseOrderID = 0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POApprovalEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}

		$userID = $_SESSION['userId']; 

		$data = array(
			'isApproved'				=> 1,
			'approvedBy'				=> $userID,
			'approvedDateTime'	=> date('Y-m-d H:i:s')
		);
		$where = array(
			'purchaseOrderID'					=> $purchaseOrderID
		);
		$this->general_model->update('trn_purchase_orders', $data, $where);

		$this->session->set_flashdata('registerMessage','PO Approved Successfully',':old:');
		redirect(base_url().'index.php/transactions/PurchaseOrders/ListPo');
	}

	public function reject($purchaseOrderID = 0){
		if(!isset($_SESSION['admin_logged_in'])&&!in_array("POApprovalEdit",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$userID = $_SESSION['userId']; 

		$data = array(
			'isApproved'				=> 2,
			'approvedBy'				=> $userID,
			'approvedDateTime'	=> date('Y-m-d H:i:s')
		);
		$where = array(
			'purchaseOrderID'					=> $purchaseOrderID
		);
		$this->general_model->update('trn_purchase_orders', $data, $where);
		$this->session->set_flashdata('registerMessage','PO Rejected Successfully',':old:');
		redirect(base_url().'index.php/transactions/PurchaseOrders/ListPo');
	}

	public function getPrjFromDept(){
		$department = $_POST['department'];
		$whereDept = array('department' => $department, 'mst_projects.isDeleted' => 0);
		$departmentProjects = $this->general_model->get_prj_dept($whereDept);

		$retProjects = "<select name='purchaseOrderProject' id='project' class='form-control project'>";
		if(is_array($departmentProjects)){ 
			foreach($departmentProjects as $departmentProject){
				$retProjects .= "<option value='".$departmentProject['projectID']."'>".$departmentProject['projectName']."</option>";
			}
		}else{    
				 $retProjects .= "<option value='0'>No Projects</option>";
		} 
		$retProjects .= "</select>";
		echo $retProjects;
	}

	public function getTaxValFromID(){
		$purchaseOrderTax = $_POST['purchaseOrderTax'];
		$where = array('taxID' => $purchaseOrderTax);
		$taxes = $this->general_model->get('sys_tax', $where);
		echo $taxes[0]['taxPercentage'];
	}

	
}
