<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SalesOrders extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function SelectCustomer()
	{
		if(!isset($_SESSION['sales_logged_in'])&&!in_array("SalesCreate",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}

		$where = array();
		$data['customers'] = $this->general_model->get('mst_customers',$where);
		 
		$data['loginRedirect']=base_url().'index.php/transactions/SalesOrders/createsalesorder';
		
		$data['currentMenu'] = 'createsalesorders';
		$data['pageType'] = 'Transactions';
		$data['pageHeading'] = 'Sales Order';
		$data['pageTitle'] = "Create Sales Order | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/salesorders/create_salesorder',$data);
		$this->load->view('templates/footer');
	}

	public function createsalesorder()
	{
		if(!isset($_SESSION['sales_logged_in'])&&!in_array("createsalesorder",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('customer', 'Customer Name', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/transactions/SalesOrders/SelectCustomer');
		}else{
			$salesOrderNumber = $this->general_model->getmax('salesOrderNumber','trn_sales_orders');
			$totalAmount = $discountAmout =  $taxAmount =  $subTotal = 0;
			$data = array(
				'salesOrderNumber'	=> $salesOrderNumber,
				'salesOrderDate'		=> date('Y-m-d'),
				'customer'					=> $this->input->post('customer'),
				'subTotal'					=> $subTotal,
				'taxAmount'					=> $taxAmount,
				'discountAmout'				=> $discountAmout,
				'totalAmount'				=> $totalAmount,
				'salesman'					=> $this->session->userdata['userId'],
				'status'					=> 1,
			);

			$salesOrderID = $this->general_model->insert('trn_sales_orders', $data);
			$this->session->set_flashdata('registerMessage','SalesOrder Added Successfully',':old:');
			redirect(base_url().'index.php/transactions/SalesOrders/addProducts/'.$salesOrderID .'');
		}
	}



	public function addProducts($salesOrderID = 0)
	{
		if(!isset($_SESSION['sales_logged_in'])&&!in_array("AddProducts",$_SESSION['assignedPermissions'])){
			redirect(base_url());
		}
		$where = array();
		$data['customers'] = $this->general_model->get('mst_customers',$where);		
		if($salesOrderID  != ''){
			$data['salesOrderID'] = $salesOrderID;
			$sales_data = $this->general_model->getCuurentSalesdataRow($salesOrderID);
			$data['customerID'] = $sales_data->customer;
		}
		else{
			$data['salesOrderID'] = 0;
			$data['customerID']   = 0;
		}
		$where = array();
		$data['salesorders'] = $this->general_model->getSalesOrderitemdetail($salesOrderID);	

		$data['loginRedirect']=base_url().'index.php/transactions/SalesOrders/addProducts';
	
		$data['currentMenu'] = 'addproducts';
		$data['pageType']    = 'Transactions';
		$data['pageHeading'] = 'Sales Order';
		$data['pageTitle']   = "Sales Order | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('transactions/salesorders/add_products',$data);
		$this->load->view('templates/footer');
	}

	public function insertItems(){
		$htmldynamicRow = '';
		$obj = array();
		$productMaxDiscountPer =  $this->input->post('productMaxDiscountPer');
		//$item_code =  $this->input->post('item_code');
		//$item_barcode =  $this->input->post('item_barcode');
		$itemDetailID   =  $this->input->post('itemDetailID');
		$itemQty        =  $this->input->post('itemQty');
		$itemPrice      =  $this->input->post('itemPrice');
		$itemTax        =  $this->input->post('itemTax');
		$rate_inc_vat   =  $this->input->post('rate_inc_vat');
		$itemTaxAmount  =  $this->input->post('itemTaxAmount');
		$itemTotal      =  $this->input->post('itemTotal');
		$item_description   =  $this->input->post('item_description');
		$productID          =  $this->input->post('productID');
		$salesOrderID       =  $this->input->post('salesOrderID');
		$itemDiscountPer    =  $this->input->post('itemDiscountPer');
		$itemDiscountAmount =  $this->input->post('itemDiscountAmount');

		// Get Item code of Parent from Item Detail ID
		$whereParent = array('item_details_id' => $itemDetailID);
		$parentItem = $this->general_model->get('mst_item_details',$whereParent);
		$item_code = $parentItem[0]['item_code'];
		$item_barcode = $parentItem[0]['item_barcode'];

		$dataDetails = array(
			'salesOrder'						=> $salesOrderID,
			'item_code'							=> $item_code,
			'item_barcode'						=> $item_barcode,
			'itemDetailID'				    	=> $itemDetailID,
			'itemPrice'							=> $itemPrice,
			'itemQty'							=> $itemQty,
			'itemDiscountPer'					=> $itemDiscountPer,
			'itemDiscountAmount'				=> $itemDiscountAmount,
			//'itemDiscountAmount'				=> $itemDiscountAmount,
			//'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
			'itemTax'							=> $itemTax,
			'itemTaxAmount'						=> $itemTaxAmount,
			'itemTotal'							=> $itemTotal
		);
		$insert = $this->general_model->insert('trn_sales_order_details', $dataDetails);
		if($insert != ''){
			$last_row = $this->general_model->getSalesorderdetlastRow($insert);
			
			if($last_row != false){
				//$rate_inc_vat = $last_row->itemPrice * 
				$this->UpdateHeaderarea($last_row->salesOrder);
				$rate_inc_vat = ($last_row->itemPrice * (1+($last_row->itemTax / 100)));
				$rate_inc_vat = number_format($rate_inc_vat, 3, '.', '');
				 $htmldynamicRow = '<tr class="rowClass dr_inv_'.$last_row->salesOrderDetailsID.'">									 
										<td  class="text-nowrap text-left " style="padding-left:4px;">
											<input type="hidden" name="salesOrderDetailsID[]"  class="salesOrderDetailsID" id="salesOrderDetailsID_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->salesOrderDetailsID.'">
											<input type="hidden" name="item_code[]"  class="item_code" id="item_code_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->item_code.'">
											<input type="hidden" name="productID[]" class=" productID_'.$last_row->salesOrderDetailsID.'" value="'.$itemDetailID.'">
											<input type="hidden" name="item_barcode[]" class="item_barcode_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->item_barcode.'">
											<input type="hidden" name="productMaxDiscountPer[]" class="productMaxDiscountPer_'.$last_row->salesOrderDetailsID.'" value="'.$productMaxDiscountPer.'">
											<input type="hidden" name="itemDetailID[]" class="itemDetailID_'.$last_row->salesOrderDetailsID.'" value="'.$itemDetailID.'">
											<input type="hidden" name="itemQty[]" class="itemQty_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemQty.'">
											<input type="hidden" name="itemPrice[]" class="itemPrice_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemPrice.'">
											<input type="hidden" name="itemTax[]" class="itemTax_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemTax.'">
											<input type="hidden" name="rate_inc_vat[]" class="rate_inc_vat_'.$last_row->salesOrderDetailsID.'" value="'.$rate_inc_vat.'">
											<input type="hidden" name="itemTaxAmount[]" class="itemTaxAmount_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemTaxAmount.'">
											<input type="hidden" name="itemTotal[]" class="itemTotal_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemTotal.'">
											<input type="hidden" name="item_description[]" class="item_description_'.$last_row->salesOrderDetailsID.'" value="'.$item_description.'">
											<input type="hidden" name="itemDiscountPer[]" class="itemDiscountPer_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemDiscountPer.'">
											<input type="hidden" name="itemDiscountAmount[]" class="itemDiscountAmount_'.$last_row->salesOrderDetailsID.'" value="'.$last_row->itemDiscountAmount.'">
											<span id="tr-ap-item-'.$last_row->salesOrderDetailsID.'">'.$item_description.'</span>
											<span class="row gutters-xs" style="padding-top:5px;">
												<span class="col-4" id="tr-ap-itemQty-'.$last_row->salesOrderDetailsID.'">'.$last_row->itemQty.' Qty</span>
												<span class="col-4" id="tr-ap-itemPrice-'.$last_row->salesOrderDetailsID.'">'.$last_row->itemPrice.'</span>
												<span class="col-4" id="tr-ap-itemTotal-'.$last_row->salesOrderDetailsID.'">'.$last_row->itemTotal.'</span>
											</span>										
										</td>									 
										<td class="text-right sales_td" style="padding-right:4px;">
											<button class="btn btn-sm btn-info edit-dr-inv  dr-inv-edt-'.$last_row->salesOrderDetailsID.'"  data-edit-id="'.$last_row->salesOrderDetailsID.'" data-edit-orderid="'.$last_row->salesOrder.'" type="button"><i class="fe fe-edit" title="Edit"></i></button> 
											<button class="btn btn-sm btn-danger dr-inv-remove dr-inv-rmv-'.$last_row->salesOrderDetailsID.'" data-delete-id="'.$last_row->salesOrderDetailsID.'" data-delete-orderid="'.$last_row->salesOrder.'"  type="button"><i class="fe fe-trash-2"   title="Remove"></i></button></td> 
										</td>
									</tr>';
									$obj['results'] = 	 $htmldynamicRow;	
										
			}
			$obj['message'] = 	'success';
		}
		else{
			$obj['message'] = 	'error';
		}
		echo json_encode($obj);
	}

	public function updateItems(){
		$obj = array();
		$productMaxDiscountPer =  $this->input->post('productMaxDiscountPer');
		$item_code =  $this->input->post('item_code');
		$item_barcode =  $this->input->post('item_barcode');
		$itemDetailID =  $this->input->post('itemDetailID');
		$itemQty =  $this->input->post('itemQty');
		$itemPrice =  $this->input->post('itemPrice');
		$itemTax =  $this->input->post('itemTax');
		$rate_inc_vat =  $this->input->post('rate_inc_vat');
		$itemTaxAmount =  $this->input->post('itemTaxAmount');
		$itemTotal =  $this->input->post('itemTotal');
		$item_description =  $this->input->post('item_description');
		$productID =  $this->input->post('productID');
		$salesOrderID =  $this->input->post('salesOrderID');
		$itemDiscountPer =  $this->input->post('itemDiscountPer');
		$itemDiscountAmount =  $this->input->post('itemDiscountAmount');
		$salesOrderDetailsID =  $this->input->post('salesOrderDetailsID');

		$this->db->trans_begin();
		$where = array(
			'salesOrderDetailsID' => $salesOrderDetailsID,
			'salesOrder'          => $salesOrderID,

		);
		$dataDetails = array(
 			'item_code'							=> $item_code,
			'item_barcode'						=> $item_barcode,
			'itemDetailID'				    	=> $itemDetailID,
			'itemPrice'							=> $itemPrice,
			'itemQty'							=> $itemQty,
			'itemDiscountPer'					=> $itemDiscountPer,
			'itemDiscountAmount'				=> $itemDiscountAmount,
 			//'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
			'itemTax'							=> $itemTax,
			'itemTaxAmount'						=> $itemTaxAmount,
			'itemTotal'							=> $itemTotal
		);
 		$this->general_model->update('trn_sales_order_details',$dataDetails,$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$obj['message'] = 	'error';
		}
		else{
			$this->db->trans_commit();			
			$this->UpdateHeaderarea($salesOrderID);
			$rowdata = $this->general_model->getSalesorderdetlastupdatedRow($salesOrderID,$salesOrderDetailsID);
			if($rowdata != false){
				$obj['productMaxDiscountPer'] = $rowdata->item_max_discount_per;
				$obj['item_code']  = $rowdata->item_code;
				$obj['item_barcode']= $rowdata->item_barcode;
				$obj['itemDetailID ']= $rowdata->itemDetailID;
				$obj['itemQty']= $rowdata->itemQty;
				$obj['itemPrice']= $rowdata->itemPrice;
				$obj['itemTax']= $rowdata->itemTax;
				$obj['rate_inc_vat']= $rowdata->item_code;
				$obj['itemTaxAmount']= $rowdata->itemTaxAmount;
				$obj['itemTotal']= $rowdata->itemTotal;
				$obj['item_description']= $rowdata->item_description;
				$obj['productID']= $rowdata->itemDetailID;
				$obj['salesOrderID']= $rowdata->salesOrder;
				$obj['itemDiscountPer']= $rowdata->itemDiscountPer;
				$obj['itemDiscountAmount']= $rowdata->itemDiscountAmount;
				$obj['salesOrderDetailsID']= $rowdata->salesOrderDetailsID;
			}
			$obj['message'] = 	'success';
		}
		echo json_encode($obj);
	}

	public function unlinkItems(){
		$this->db->trans_begin();
		$obj = array();
		$salesOrderDetailsID =  $this->input->post('sale_or_dt_id');
		$orderid             =  $this->input->post('orderid');
		$where = array(
			'salesOrderDetailsID' => $salesOrderDetailsID,
			'salesOrder'          => $orderid,

		);
		$this->general_model->delete('trn_sales_order_details',$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$obj['message'] = 	'error';
		}
		else{
			$this->db->trans_commit();
			$this->UpdateHeaderarea($orderid);
			$obj['message'] = 	'success';
		}
		echo json_encode($obj);
	}

	public function UpdateHeaderarea($id = 0){
		$salesorders = $this->general_model->getSalesOrderitemdetail($id);
		if($salesorders != false){
			$subTotal = $taxAmount = $discountAmout = $totalAmount = 0;
			foreach($salesorders as $rec){
				$subTotal += $rec['itemTotal'];
				$taxAmount += $rec['itemTaxAmount'];
				$discountAmout += $rec['itemDiscountAmount'];
				$totalAmount  += $rec['itemTotal'];
			}
			$where = array(
				'salesOrderID' => $id
			);	
			$data = array(
  				'subTotal'			=> $subTotal,
				'taxAmount'			=> $taxAmount,
				'discountAmout'		=> $discountAmout,
				'totalAmount'		=> $totalAmount,
 			);
			$this->general_model->update('trn_sales_orders', $data,$where);
		}
	}

	public function viewProductList(){
		$salesOrderID = $this->input->post('salesOrderID');
		$salesorders = $this->general_model->getSalesOrderitemdetail($salesOrderID);
		$obj = array();
		$appendDynamicRow = '';
		if(!empty($salesorders)){
			foreach($salesorders as $rec){
				$rate_inc_vat = ($rec['itemPrice'] * (1+($rec['itemTax'] / 100)));
				$rate_inc_vat = number_format($rate_inc_vat, 3, '.', '');
				$appendDynamicRow .= '<tr class="rowClass dr_inv_'.$rec['salesOrderDetailsID'].'">									 
						<td  class="text-nowrap text-left " style="padding-left:4px;">
							<input type="hidden" name="salesOrderDetailsID[]"  class="salesOrderDetailsID" id="salesOrderDetailsID_'.$rec['salesOrderDetailsID'].'" value="'.$rec['salesOrderDetailsID'].'">
							<input type="hidden" name="item_code[]"  class="item_code" id="item_code_'.$rec['salesOrderDetailsID'].'" value="'.$rec['item_code'].'">
							<input type="hidden" name="productID[]" class=" productID_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemDetailID'].'">
							<input type="hidden" name="item_barcode[]" class="item_barcode_'.$rec['salesOrderDetailsID'].'" value="'.$rec['item_barcode'].'">
							<input type="hidden" name="productMaxDiscountPer[]" class="productMaxDiscountPer_'.$rec['salesOrderDetailsID'].'" value="'.$rec['item_max_discount_per'].'">
							<input type="hidden" name="itemDetailID[]" class="itemDetailID_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemDetailID'].'">
							<input type="hidden" name="itemQty[]" class="itemQty_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemQty'].'">
							<input type="hidden" name="itemPrice[]" class="itemPrice_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemPrice'].'">
							<input type="hidden" name="itemTax[]" class="itemTax_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemTax'].'">
							<input type="hidden" name="rate_inc_vat[]" class="rate_inc_vat_'.$rec['salesOrderDetailsID'].'" value="'.$rate_inc_vat.'">
							<input type="hidden" name="itemTaxAmount[]" class="itemTaxAmount_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemTaxAmount'].'">
							<input type="hidden" name="itemTotal[]" class="itemTotal_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemTotal'].'">
							<input type="hidden" name="item_description[]" class="item_description_'.$rec['salesOrderDetailsID'].'" value="'.$rec['item_description'].'">
							<input type="hidden" name="itemDiscountPer[]" class="itemDiscountPer_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemDiscountPer'].'">
							<input type="hidden" name="itemDiscountAmount[]" class="itemDiscountAmount_'.$rec['salesOrderDetailsID'].'" value="'.$rec['itemDiscountAmount'].'">
							<span id="tr-ap-item-'.$rec['salesOrderDetailsID'].'">'.$rec['item_description'].'</span>
							<span class="row gutters-xs" style="padding-top:5px;">
								<span class="col-4" id="tr-ap-itemQty-'.$rec['salesOrderDetailsID'].'">'.$rec['itemQty'].' Qty</span>
								<span class="col-4" id="tr-ap-itemPrice-'.$rec['salesOrderDetailsID'].'">'.$rec['itemPrice'].'</span>
								<span class="col-4" id="tr-ap-itemTotal-'.$rec['salesOrderDetailsID'].'">'.$rec['itemTotal'].'</span>
							</span>										
						</td>									 
						<td class="text-right sales_td" style="padding-right:4px;">
							<a class="text-white btn btn-sm btn-info edit-dr-inv modal-edit-items  dr-inv-edt-'.$rec['salesOrderDetailsID'].'"  data-edit-id="'.$rec['salesOrderDetailsID'].'" data-edit-orderid="'.$rec['salesOrder'].'" type="button"><i class="fe fe-edit" title="Edit"></i></a> 
							<a class="text-white btn btn-sm btn-danger modal-delete-items dr-inv-remove dr-inv-rmv-'.$rec['salesOrderDetailsID'].'" data-delete-id="'.$rec['salesOrderDetailsID'].'"  data-delete-orderid="'.$rec['salesOrder'].'" type="button" onclick="unlinkdata()"><i class="fe fe-trash-2"   title="Remove"></i></a></td> 
						</td>
					</tr>';
			}
			$obj['results'] = 	 $appendDynamicRow;	
			$obj['message'] = 	'success';
		}
		else{
			$obj['message'] = 	'error';
		}
		echo json_encode($obj);
	}

	public function searchProducts(){
		$item =  $this->input->post('item');
		$customerID =  $this->input->post('cust_id');

		$where = array();
		$html ="";
		$products = $this->general_model->get_products($where,10,0,null,null,array('item_description'=>$item),null);
 		$whereCustomer = array('client_id'	=> $customerID);
		$clients = $this->general_model->get('mst_customers', $whereCustomer);
		$priceType = $clients[0]['priceType'];
		if(is_array($products)){
			foreach($products as $product){
				if($priceType != 0){
					if($priceType == 1){
						if($product['item_price1'] != "0.000"){
							$productPrice = $product['item_price1'];
							$productPriceFlag = 0;
						}else{
							$productPrice = '';
							$productPriceFlag = 1;
						}
					}else if($priceType == 2){
						if($product['item_price2'] != "0.000"){
							$productPrice = $product['item_price2'];
							$productPriceFlag = 0;
						}else{
							$productPrice = '';
							$productPriceFlag = 1;
						}
					}else if($priceType == 3){
						if($product['item_price3'] != "0.000"){
							$productPrice = $product['item_price3'];
							$productPriceFlag = 0;
						}else{
							$productPrice = '';
							$productPriceFlag = 1;
						}
					}
				}else{
					if($product['item_price1'] != "0.000"){
						$productPrice = $product['item_price1'];
						$productPriceFlag = 1;
					}else{
						$productPrice = '';
						$productPriceFlag = 1;
					}
				}
				$html .= '<li tabindex="-1" class="item_button" 
								 data-product_productID="'.$product['item_id'].'"
								 data-product_BarCode="'.$product['item_barcode'].'"
							     data-product_Code="'.$product['item_code'].'"
								 data-product_DetailsID="'.$product['item_details_id'].'"  
								 data-product_MaxDiscountPer="'.$product['item_max_discount_per'].'"
								 data-product_MinPrice="'.$product['item_min_price'].'"
								 data-product_Name="'.$product['item_description'].'"
								 data-product_Price="'.$productPrice.'"
								 data-product_PriceFlag="'.$productPriceFlag.'"
								 data-product_Tax="'.$product['productTax'].'"
								 data-product_rateInclVatFlag="'.$product['isRateInclVat'].'"
								 data-product_unit="'.$product['unitSymbol'].'" >
								<span class="classs-items">'.$product['item_description'].'</span>
								<span class="class-units">'.$product['unitSymbol'].'</span>
						</li>';


			}
		}
		else{

		}

		print($html);
	}
}
