<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Debit_note extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}


	public function list_debit_note($division_id="NIL",$filter_by="NIL",$filter_value="NIL") {
		$this->users_model->permission("Debit_note", "View");
		$title['headerTitle']="Debit Note List";
		$this->load->library('pagination');
		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		}elseif ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		if (@$this->input->post('filter_by')) {
			$filter_by =   $this->input->post("filter_by");
		}elseif ($filter_by != "NIL") {
			$filter_by	=	$filter_by;
		} else {
			$filter_by	= "NIL";
		}
		
		
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		$config["base_url"] = base_url() . "index.php/receipt/list_receipt/".$division_id."/".$filter_by."/".$filter_value;
        $config["total_rows"] = $this->furniture_quotation_model->debit_record_count($division_id,$filter_by,$filter_value);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =6;
        $this->pagination->initialize($config);
        if ($this->uri->segment(6)) {
            $page = $this->uri->segment(6)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->get_all_debit_notes($config["per_page"], $page,$division_id,$filter_by,$filter_value);
		$data['pagination'] = $this->pagination->create_links();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header',$title);
		$this->load->view('manage/list_debit_note',$data);
		$this->load->view('templates/footer');
	}
	
	public function create_debit_note(){
		$this->users_model->permission("Debit_note", "Add");
		$title['headerTitle']="New Debit Note";
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
		$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
		$this->load->view('templates/header',$title);
		$this->load->view('manage/create_debit_note',$data);
		$this->load->view('templates/footer');
	}
	
	function search_client_for_payment() {
		$html='';
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array('supplier_master.supplier_name'=>$search_mob);
		
		}else{
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array();
		}
		
		$this->db->select('supplier_master.supplier_id,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.address,supplier_master.mobile_no,supplier_master.supplier_telephone2,supplier_master.supplier_email,supplier_master.supplier_fax,supplier_master.tax_name');
		$this->db->from('supplier_master');
		$this->db->where($where);
		$this->db->like($like);
		$this->db->limit(25);
		$rs = $this->db->get();
		$records['client_list'] = $rs->result_array();
		if($records['client_list'] == false ){
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
			echo $html;
		} else {
			foreach($records['client_list'] as $index=>$client_entry) {
				$html.='<li  tabindex="-1"  value="' .$client_entry['supplier_id'] .'" ref="' .$search_name .'" data-client_code="' .$client_entry['supplier_code'] .'" data-client_name="' .$client_entry['supplier_name'] .'" class="client_buttonxxxxx" >'. $client_entry['supplier_name'] . '</li>';
			}
			echo $html;
		}
	}

	function get_outstanding_invoices(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$invoices=$this->furniture_quotation_model->get_outstanding_payment($client_id,$ref_division);

        if ($invoices != false){
				foreach($invoices as $index =>$invoice){
				//$quotation_id = $invoice['quotation_id'];
				//$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
				$amount_paid = $invoice['paid_amount'];
				$invoices[$index]['amount_paid'] =$amount_paid;
				$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
			}
        }

		
		$records['invoices'] = $invoices;
		//if($records['invoices'] == false ){
		//	echo '<label style="color:red; font-size:14.5px;">No Invoice List Available..!</label>';
		//} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_debit_note', $records);
		//}
	}

	

	public function save_debit_note(){
		$this->users_model->permission("Debit_note", "Add");
		$this->form_validation->set_rules('ledger_code','Ledger', 'required');
		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		$this->form_validation->set_rules('clientIdHidden','Client', 'required');
		$this->form_validation->set_rules('client_code','Client', 'required');

		if ($this->form_validation->run() == FALSE) {
			$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('manage/create_debit_note',$data);
			$this->load->view('templates/footer');
		} else {
			$this->db->trans_begin();
			$no_of_invoices = $this->input->post('no_of_invoices');	
			$no_of_adv_receipts = $this->input->post('no_of_adv_receipts');	

			$SQL = "SELECT MAX(debit_note_number)+1 as `new_debit_note_number` FROM debit_note where quotation_divisionid='".$this->input->post('ref_div_id')."';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			
			if($data[0]['new_debit_note_number'] != NULL and $data[0]['new_debit_note_number'] != ""){
				$debit_note_no = $data[0]['new_debit_note_number'];
			} else{
				$debit_note_no = 1;
			}

			$ref_div_id	=	$this->input->post('ref_div_id');
			$debit_note_code	=	$this->furniture_quotation_model->get_debit_note_code($ref_div_id,$debit_note_no);
			$debit_note_date	=	date( "Y-m-d", strtotime($this->input->post("credit_note_date")));

			$receipt['debit_note_number'] 	 = $debit_note_no;
			$receipt['debit_note_code']   	 = $debit_note_code;
			$receipt['supplier_id'] 		 = $this->input->post('clientIdHidden');
			$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
			$receipt['debit_note_date'] 	 = $debit_note_date;
			$receipt['debit_note_mode'] 	 = $this->input->post("ledger");
			$receipt['led_code'] 			 = $this->input->post("ledger_code");
			$receipt['taxable_type'] 		 = $this->input->post("taxable_type");
			$amount	=	((float)$this->input->post('i_total'));
			$vat=0;
			if($this->input->post("taxable_type")!=='Non Vat'){
				$vat_percentage	= $this->input->post("taxable_type");
				$taxable_amount=$amount/(1+($vat_percentage/100));
				$vat=$taxable_amount*($vat_percentage/100);
				$receipt['taxable_amount'] = round($taxable_amount,3);
				$receipt['tax_amount'] = round($vat,3);
			} else {
				$taxable_amount=$amount;
				$receipt['taxable_amount'] = $amount;
				$receipt['tax_amount'] = 0;
			}
			$receipt['net_amount'] 			 = ((float)$this->input->post('i_total'));
			$receipt['debit_note_reference'] = $this->input->post("ref_number");
			$receipt['debit_note_remarks']   = $this->input->post("remarks");
			$receipt['debit_note_generatedby'] = $this->session->userdata("user_id");
			$receiptdts['invoice_id'] = 0;
			$rcpt = $this->crud_model->insert('debit_note',$receipt);
			$debit_note_id = $this->db->insert_id();

			$xxreceipt_discount=0;
			$xxreceipt_amount=0;
			$total_paying_amount=0;

			for($i=1;$i<=$no_of_invoices;$i++) {
				$total_paying_amount=$total_paying_amount+(float)$this->input->post("current_amount_invoice_".$i);
				//$xxreceipt_amount=$xxreceipt_amount+(float)$this->input->post("current_amount_invoice_".$i);
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				$sm_id_i =$this->input->post("sm_id_".$i);
				if($amount!="" && $amount!="0"){
					$division_id=$this->input->post('ref_div_id');
					$div_data = $this->db->query("SELECT * FROM `company_division` WHERE division_id='$division_id' ");
					$division_code=$div_data->row()->division_code; 

					$cust_bill_allocations_data = array(
						'supplier_code' => $this->input->post('client_code'),
						'bill_id'       => $invid,
						'trn_no'        => $debit_note_code,
						'bill_date'     => date("Y-m-d h:m:s"),
						'bill_amt'      => ((float)$nbbbamount)*-1,
						'bill_os_amount'=> ((float)$nbbbamount)*-1,
						'bill_type'     => 'Debit Note',
						'division_id'   => $division_id,
						'trn_type'      => 'Debit Note'
					);	
					$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
				}	
			}
			if($debit_note_id){
				
				if($this->input->post('advance_payment')!='' && $this->input->post('advance_payment')!="0" && $this->input->post('advance_payment')!="0.000"){
					$cust_bill_allocations_data = array(
						'supplier_code' => $this->input->post('client_code'),
						'bill_id'       => $debit_note_code,
						'trn_no'        => $debit_note_code,
						'bill_date'     => $debit_note_date,
						'bill_amt'      => ((float)$this->input->post('advance_payment')),
						'bill_os_amount'=> ((float)$this->input->post('advance_payment')),
						'bill_type'     => 'Debit Note',
						'division_id'   => $division_id,
						'trn_type'      => 'Unallocated'
					);
						
					$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
				} 

				if($this->input->post('client_code')!=''){
					//$xxreceipt_amount	=	$total_paying_amount+(float)$this->input->post('advance_payment');
					$xxreceipt_amount	=	$total_paying_amount;
					$this->db->where("vch_no",$debit_note_code);
					$this->db->where("vch_type",'Debit Note');
					$this->db->delete('accounts');
					$accounts_data = array(
						'vch_type' 	  => 'Debit Note',
						'vch_no'  	  => $debit_note_code,
						'vch_date'    => $debit_note_date,
						'vch_ref'     => '',
						'ledger_code' => $this->input->post('client_code'),
						'rev_ledger_code' => $this->input->post('ledger_code'),
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> (float)$xxreceipt_amount,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Debit Note No '.$debit_note_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}

				if($this->input->post('i_total')!==''){
					$accounts_data = array(
						'vch_type' 	  => 'Debit Note',
						'vch_no'  	  => $debit_note_code,
						'vch_date'    => $debit_note_date,
						'vch_ref'     => '',
						'ledger_code' => $this->input->post('ledger_code'),
						'rev_ledger_code' => $this->input->post('client_code'),
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> $taxable_amount*-1,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Debit Note No '.$debit_note_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);

					if($vat>0){
						$accounts_data2 = array(
							'vch_type' 	  => 'Debit Note',
							'vch_no'  	  => $debit_note_code,
							'vch_date'    => $debit_note_date,
							'vch_ref'     => '',
							'ledger_code' => 'V0001',
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> round($vat*-1,3),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Debit Note No '.$debit_note_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data2);
					}
				}
			}

			$log_data=array(
				'trans_no'  	=>  $debit_note_code,
				'trans_type'  	=>  'Debit Note',
				'trans_op'  	=>  'Create',
				'trans_user_id' =>  $this->session->userdata('user_id')
	
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
				redirect('Debit_note/list_debit_note');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'New Debit Note Created...');	
				redirect('Debit_note/list_debit_note');
		 	}
		}
	}

	
	function view1($debit_note_id,$debit_note_no,$quotation_divisionid,$type){

		$data['records'] = $this->furniture_quotation_model->get_debit_note_details($debit_note_no,$debit_note_id,$quotation_divisionid);
		$data['debit_notes'] = $this->furniture_quotation_model->get_all_debit_notes_invdetails($debit_note_no,$debit_note_id,$quotation_divisionid);
		
		$data['debit_note_code'] 	  = $data['records'][0]['debit_note_code'];
		$data['credit_note_number']   = $data['records'][0]['debit_note_number'];
		$data['division_code'] 		  = $data['records'][0]['division_code'];
		$data['currency_code'] 		  = $data['records'][0]['currency_code'];
		$data['debit_note_date'] 	  = $data['records'][0]['debit_note_date'];
		$data['debit_note_mode'] 	  = $data['records'][0]['debit_note_mode'];
		$data['net_amount'] 		  = $data['records'][0]['net_amount'];
		$data['taxable_amount'] 	  = $data['records'][0]['taxable_amount'];
		$data['credit_note_reference']= $data['records'][0]['debit_note_reference'];
		$data['tax_amount'] 		  = $data['records'][0]['tax_amount'];
		$data['currency_name1'] 	  = $data['records'][0]['currency_name'];
		$data['debit_note_status']   = $data['records'][0]['debit_note_status'];
		$data['taxable_type'] 		  = $data['records'][0]['taxable_type'];
		$data['debit_note_remarks']   = $data['records'][0]['debit_note_remarks'];
		$data['division_id'] 		  = $data['records'][0]['division_id'];
		$data['division_code'] 		  = $data['records'][0]['division_code'];
		$data['logo_filename']        = $data['records'][0]['logo_filename'];
		$data['supplier_code']        = $data['records'][0]['supplier_code'];
		$data['ledger_name']          = $data['records'][0]['ledger_name'];


		$temp = $data['records'][0]['debit_note_generatedby'];
		$where= array('user_id'=>$temp);
		$generated_by_user 	  = $this->crud_model->get('users',$where);
		$data["generated_by"] = $generated_by_user[0]['user_name'];


		$data["received_from"]= $data['records'][0]['supplier_name'];
		$data['net_amount']   = $data['records'][0]["net_amount"];
		
		$query = $this->db->get('company_details');  
		$data['company_details'] = $query->row();
		
		
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$mpdf = new \Mpdf\Mpdf();
			$html = $this->load->view('manage/print_debit_note', $data, true);
			if($data['records'][0]['debit_note_status']==0){
				$mpdf->SetWatermarkText('Cancelled');
				$mpdf->showWatermarkText = true;
			}
			$mpdf->WriteHTML($html);
			$file_name	=	'Debit Note Voucher - '.$data['records'][0]['debit_note_code'];
			$mpdf->Output($file_name, 'I');
		}
	}
	
	
	public function cancel_debit_note($debit_note_number,$quotation_divisionid,$debit_note_id,$debit_note_code){
		$this->users_model->permission("Debit_note", "Delete");
		$this->db->where('debit_note_number',$debit_note_number);
		$this->db->where('quotation_divisionid',$quotation_divisionid);
		$data = array(
			'debit_note_status' => 0,
			'debit_note_cancelledby' => $this->session->userdata('user_name'),
			'debit_note_cancelled_date' => date('Y-m-d h:m:s')
		);
		$receipt_cancel	= $this->db->update('debit_note', $data);

		$this->db->where('trn_no',$debit_note_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('supplier_bill_allocations', $data1);

		$this->db->where('vch_no',$debit_note_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);
		
		$log_data=array(
			'trans_no'  	=>  $debit_note_code,
			'trans_type'  	=>  'Debit Note',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		if($receipt_cancel){
			$this->session->set_flashdata('response', 'Debit Note Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('Debit_note/list_debit_note');
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and ledger_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where (acoount_group_id=9 OR acoount_group_id=13) and `ledger_name` like '$client%'   union (SELECT * FROM `ledgers` where (acoount_group_id=9 OR acoount_group_id=13) and  `ledger_id` not in (SELECT `ledger_id` FROM `ledgers` where (acoount_group_id=9 OR acoount_group_id=13) and `ledger_name` like '$client%' ) ".$sql." order by ledger_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="ledger_button" tabindex="'.$n++.'" ><input type="hidden" class="ledger_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="pop_ledger_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}
}

?>