<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MaterialReservation extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
	
	}	
	
	public function index($job_card_id,$division,$job_number) {
		$data['invoice_list']=false;
		$this->db->select('JC.id,JEM.item_id,JEM.item_name,sum(material_qty) as material_qty,JC.`job_card_date`,JC.`divisionid`,JC.`project_name`,NCM.client_name');
		$this->db->from('job_estimation_material AS JEM');
		$this->db->where('JEM.job_card_id', $job_card_id);
		$this->db->join('job_card AS JC','JC.id = JEM.job_card_id and JC.job_card_status="Draft" ','inner');
		$this->db->join('new_client_master AS NCM','NCM.client_id = JC.client_id','inner');
		$this->db->group_by("JEM.item_id");
		$query4 = $this->db->get();
		$data['invoice_list'] = $query4->result_array();
		$data['job_number']   = $job_number;
		if($query4->num_rows()!==0) {
			$data['job_card_date']= $data['invoice_list'][0]['job_card_date'];
			$data['division_id']= $data['invoice_list'][0]['divisionid'];
			$data['project_name'] = $data['invoice_list'][0]['project_name'];
			$data['client_name']  = $data['invoice_list'][0]['client_name'];
		} else {
			$data['job_card_date']= '';
			$data['division_id']= '';
			$data['project_name'] = '';
			$data['client_name']  = '';
		}
		$this->load->view('templates/header');
		$this->load->view('reports/material_reservation_list',$data);
		$this->load->view('templates/footer');
	}
}

?>