<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class Proforma_invoice extends CI_Controller{
	public function __construct() {

		parent::__construct();

		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		
		$this->load->library('form_validation');
		$this->load->helper('cookie','string');
		
	}
	function index($client="") {
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header');
		$this->load->model('proforma_model');
		$data['results'] = $this->proforma_model->selectcount();
		$data['h']=$this->proforma_model->list_details($job_card_id);
		$data['detail']=$this->proforma_model->getonerow($job_card_id);
		$data['sumdetail']=$this->proforma_model->getsumrow($job_card_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;
		
		if(isset($_POST["invoice_save"])) {
			$this->load->model("proforma_model");
			$this->proforma_model->proforma_submit();
			$this->session->set_flashdata('response', 'Proforma Created...');
			redirect('proforma');
		}
		
		
	}
	
	

	public function do_draft($job_card_id){
		$this->load->model('proforma_model');
		//$this->OppLogin->permission("Quotation", "Add");
		$this->db->trans_begin();
		$query_data= $this->db->query("SELECT * FROM `proforma` WHERE ( proforma_status='1' OR proforma_status='2' ) and `job_card_id`='$job_card_id' and  `proforma_percentage` >= 100");
		if ($query_data->num_rows()==0){
			$dbdata=$this->proforma_model->jobCardRow($job_card_id);
			$jobCardDetails=$this->proforma_model->jobCardDetails($job_card_id);
			$query_data2= $this->db->query("SELECT sum(`proforma_percentage`) as proforma_percentage,sum(`proforma_percentage_amount`) as proforma_percentage_amount,sum(`proforma_vat_amount`) as proforma_vat_amount FROM `proforma` WHERE ( proforma_status='1' OR proforma_status='2' ) and `job_card_id`='$job_card_id' ");
			if ($query_data2->num_rows()==0){
				$proforma_percentage=0;
				$proforma_percentage_amount=0;
				$proforma_vat_amount=0;
			} else {
				$proforma_percentage=$query_data2->row()->proforma_percentage;
				$proforma_percentage_amount=$query_data2->row()->proforma_percentage_amount;
				$proforma_vat_amount=$query_data2->row()->proforma_vat_amount;
			}
			$proforma_number=$this->proforma_model->get_proforma_no($dbdata->divisionid);
			if($dbdata->job_card_vat_perc==$proforma_percentage){
				$this->db->trans_rollback();
				redirect('proforma');
			} else {

			$data = array(
				'proforma_number' 			=> $proforma_number,
				'quotation_divisionid' 		=> $dbdata->divisionid,
				'proforma_date'   			=> date("Y-m-d"),
				'quotation_id'    			=> $dbdata->quotation_id,
				'job_card_id'    			=> $job_card_id,
				'item_amount'    			=> 0,
				'proforma_amount'    		=> $dbdata->job_card_amount_with_vat,
				'proforma_vat_percentage'   => $dbdata->job_card_vat_perc,
				'proforma_percentage'  		=> 0,
				'proforma_percentage_amount'=> 0,
				'client_id'    				=> $dbdata->client_id,
				'client'    				=> $dbdata->client_name,
				'proforma_vat_amount'    	=> 0,
				'proforma_created_by'  		=> $this->session->userdata('user_name'),
				'created_id'  				=> $this->session->userdata('user_id'),
				'proforma_status'  			=> 1
			);
			//	print_r($data);
			//	'item_amount'    			=> $dbdata->job_card_total,
			//	'proforma_amount'    		=> $dbdata->job_card_amount_with_vat,
			//	'proforma_percentage'  		=> $dbdata->job_card_vat_perc-$proforma_percentage,

			$this->db->insert('proforma', $data);
			$insert_id = $this->db->insert_id();

				foreach($jobCardDetails as $sub_records){
					$datanew = array(
						'proforma_id' 		=> $insert_id,
						'sl_no' 			=> $sub_records->sl_no,
						'group_name' 		=> $sub_records->furniture_area,
						'group_id' 			=> $sub_records->ex_furniture_area,
						'sub_group_name' 	=> $sub_records->sub_group,
						'sub_group_id' 		=> $sub_records->sub_group_id,
						'item_order' 		=> $sub_records->item_order,
						'item_name' 		=> $sub_records->furniture_model,
						'quantity' 			=> $sub_records->furniture_quantity,
						'item_discount' 	=> $sub_records->item_discount,
						'unit_price' 		=> str_replace(",","",$sub_records->furniture_unitprice),
						'amount' 			=> str_replace(",","",$sub_records->furniture_unitprice*$sub_records->furniture_quantity),
						'vat_perce' 		=> $sub_records->vat_perce,
						'vat_amount' 		=> $sub_records->vat_amount,
						'net_amount' 		=> $sub_records->net_amount,
						'description' 		=> $sub_records->furniture_description,
						'uom' 				=> $sub_records->uom,
						'total_discount' 	=> $sub_records->total_discount
					);
					$this->db->insert('proforma_details',$datanew); 
				}
				$this->db->trans_commit();
				$path	=	base_url()."index.php/furniture/Proforma_invoice/newProforma/".$insert_id;
				redirect($path);
		   } 
		} else {
			$this->db->trans_rollback();
			redirect('proforma');
		}
		
	}

	public function getDetails() {
		$no = $this->input->post('no');
		//$jobData = $this->proforma_model->getJobData($no);
		$query= $this->db->query("SELECT j.job_card_amount_with_vat,(p.`proforma_amount`-sum(p.`proforma_percentage_amount`)) as amount FROM `job_card` j left join `proforma` p on p.job_card_id=j.id WHERE (p.proforma_status='1' OR p.proforma_status='2' ) and j.`id`='$no' ");
		if($query->row()!=false){
		$test=	$query->row();
		  echo json_encode($test);
		}else{
		  echo 0;
		}
	}

	function editProforma($proforma_id,$client="") {
		$title['headerTitle']="Proforma Edit";
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['proforma']=$this->proforma_model->getProformaRow($proforma_id);
		
		$data['proforma_no']='';
		
		$data['sumdetail']=$this->proforma_model->getsumrow($proforma_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;
		$job_card_id=$data['proforma']->job_card_id;
		$query_xxx= $this->db->query("SELECT j.job_card_amount_with_vat,p.`proforma_amount`-sum(p.`proforma_percentage_amount`) as amount,sum(p.`proforma_percentage_amount`) as excluding_balance FROM `proforma` p left join  `job_card` j on p.job_card_id=j.id WHERE ( p.proforma_status='1' OR p.proforma_status='2' ) and p.`job_card_id`='$job_card_id' and  p.proforma_id!='$proforma_id'");
		if ($query_xxx->row()->amount ==null){
			$proformed_amount=0;
		} else {
			$proformed_amount=$query_xxx->row()->amount;
		}

		if($this->furniture_quotation_model->config($data['proforma']->quotation_divisionid)){
			$config_data=$this->furniture_quotation_model->config($data['proforma']->quotation_divisionid);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=$data['proforma']->proforma_date;
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		
		$data['proforma_amount_hidden']=$data['proforma']->proforma_amount;

		$data['nb_project_value']=$data['proforma']->job_card_amount_with_vat;
		$data['nb_proforma_raised']=$proformed_amount;
		$data['excluding_balance']=$query_xxx->row()->excluding_balance;

		$data['job_card_total']=$data['proforma']->job_card_total;
		$data['job_card_vat_amount']=$data['proforma']->job_card_vat_amount;
		$data['proforma_amount']=$data['proforma']->proforma_amount;
		$data['proforma_percentage_amount']=$proformed_amount;
		$data['job_card_total']=$data['proforma']->job_card_total;
		
		if(isset($_POST["pull_items_from_job"])) {
			$data['is_posted']=1;
			$data['j']=$this->proforma_model->list_job_details($job_card_id);
			$data['h']=array();
		} else {
			$data['job_card_total']=$data['proforma']->item_amount;
			$data['job_card_vat_amount']=$data['proforma']->proforma_vat_amount;
			$data['proforma_amount']=$data['proforma']->proforma_percentage_amount;
			$data['is_posted']=0;
			$data['h']=$this->proforma_model->list_details($proforma_id);
			$data['j']=array();
		}
		

		$this->load->view('furniture/quotations/editProforma',$data);
		$this->load->view('templates/footer');

		if(isset($_POST["invoice_save"])) {
			
			$pull_nb_item = $this->input->post('pull_nb_item');
			
			if($this->input->post('proforma_net_amount')>$proformed_amount){
				$this->session->set_flashdata('response', 'Proforma Invoice amount not exceed Quotation amount...');
				redirect('proforma');
			} else {
				if($pull_nb_item==2){
					$proforma_percentage_amount=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_percentagexx=100-((($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_amount'))/$this->input->post('proforma_amount_hidden'))*100);
				} else if($pull_nb_item==1){ 
					$proforma_percentage_amount=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_percentagexx=$this->input->post('proforma_percentage');
				} else {
					$proforma_percentage_amount=$this->input->post('proforma_net_amount');
					$proforma_vat_amount=$this->input->post('proforma_percentage');
					$proforma_percentagexx=$this->input->post('proforma_percentage');
				}
				$data = array(
					'item_amount'     			=> $this->input->post('total_item'),
					'proforma_percentage'     	=> $proforma_percentagexx,
					'proforma_percentage_amount'=> $proforma_percentage_amount,
					'proforma_vat_amount'		=> $proforma_vat_amount,
					'proforma_discount'     	=> 0
				);
				$this->db->where('proforma_id', $proforma_id);
				$this->db->update('proforma', $data);
				

				$log_data=array(
					'trans_no'  	=>  $this->input->post('proforma_number'),
					'trans_type'  	=>  'Proforma',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				$count = $this->input->post('hiddenCount');
				if($pull_nb_item==2){
				
					$this->db->where('proforma_id',$proforma_id);
					$this->db->delete('proforma_details');
					for($i=1; $i<$count ; $i++){
						if($this->input->post('item_row'.$i)!=""){
							$datanew = array(
								'proforma_id' 		=> $proforma_id,
								'sl_no' 			=> $i,
								'group_name' 		=> '',
								'group_id' 			=> 0,
								'sub_group_name' 	=> '',
								'sub_group_id' 		=> 0,
								'item_order' 		=> $i,
								'item_name' 		=> $this->input->post('item_row'.$i),
								'quantity' 			=> $this->input->post('quantity_row'.$i),
								'item_discount' 	=> $this->input->post('disc_row'.$i),
								'unit_price' 		=> str_replace(",","",$this->input->post('rate_row'.$i)),
								'amount' 			=> str_replace(",","",$this->input->post('quantity_row'.$i)*$this->input->post('rate_row'.$i)),
								'vat_perce' 		=> $this->input->post('vat_perc_row'.$i),
								'vat_amount' 		=> $this->input->post('vat_amount_row'.$i),
								'net_amount' 		=> $this->input->post('total'.$i),
								'description' 		=> $this->input->post('description_row'.$i),
								'uom' 				=> $this->input->post('uom_nb'.$i),
								'total_discount' 	=> 0
							);
							$this->db->insert('proforma_details',$datanew);
					 	} 
				 	}
				} else if($pull_nb_item==1){
					$jobCardDetails=$this->proforma_model->jobCardDetails($job_card_id);
					$this->db->where('proforma_id',$proforma_id);
					$this->db->delete('proforma_details');
					foreach($jobCardDetails as $sub_records){
						$datanew = array(
							'proforma_id' 		=> $proforma_id,
							'sl_no' 			=> $sub_records->sl_no,
							'group_name' 		=> $sub_records->furniture_area,
							'group_id' 			=> $sub_records->ex_furniture_area,
							'sub_group_name' 	=> $sub_records->sub_group,
							'sub_group_id' 		=> $sub_records->sub_group_id,
							'item_order' 		=> $sub_records->item_order,
							'item_name' 		=> $sub_records->furniture_model,
							'quantity' 			=> $sub_records->furniture_quantity,
							'item_discount' 	=> $sub_records->item_discount,
							'unit_price' 		=> str_replace(",","",$sub_records->furniture_unitprice),
							'amount' 			=> str_replace(",","",$sub_records->furniture_unitprice*$sub_records->furniture_quantity),
							'vat_perce' 		=> $sub_records->vat_perce,
							'vat_amount' 		=> $sub_records->vat_amount,
							'net_amount' 		=> $sub_records->net_amount,
							'description' 		=> $sub_records->furniture_description,
							'uom' 				=> $sub_records->uom,
							'total_discount' 	=> $sub_records->total_discount
						);
						$this->db->insert('proforma_details',$datanew); 
					}
				}
				$this->session->set_flashdata('success', 'The proforma has been updated...');
				redirect('proforma');
			}
		}
	}
	function editProformaxxx($proforma_id,$client="") {
		//$job_card_id    = $this->input->post('job_card_id');
		//$client    = $this->input->post('client');
		
		$this->load->view('templates/header');
		$this->load->model('proforma_model');
		//$data['results'] = $this->proforma_model->selectcount();
		$data['proforma']=$this->proforma_model->getProformaRow($proforma_id);
		$data['h']=$this->proforma_model->list_details($proforma_id);
		
		//$data['detail']=$this->proforma_model->getonerow($proforma_id);
		
		$data['proforma_no']='';
		
		$data['sumdetail']=$this->proforma_model->getsumrow($proforma_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;

		if($this->furniture_quotation_model->config($data['proforma']->quotation_divisionid)){
			$config_data=$this->furniture_quotation_model->config($data['proforma']->quotation_divisionid);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=$data['proforma']->proforma_date;
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['proforma_amount_hidden']=$data['proforma']->proforma_amount;
		if(isset($_POST["pull_items_from_job"])) {
			$data['job_card_total']=$data['proforma']->job_card_total;
			$data['job_card_vat_amount']=$data['proforma']->job_card_vat_amount;
			$data['proforma_amount']=$data['proforma']->proforma_amount;
			$data['job_card_total']=$data['proforma']->job_card_total;
			$data['is_posted']=1;
		} else {
			$data['job_card_total']=0;
			$data['job_card_vat_amount']=0;
			$data['proforma_amount']=0;
			$data['job_card_vat_amount']=0;
			$data['is_posted']=0;
			
		}
		

		$this->load->view('furniture/quotations/editProforma',$data);
		$this->load->view('templates/footer');
		
		
		if(isset($_POST["invoice_save"])) {
			
			$pull_nb_item = $this->input->post('pull_nb_item');
			$proforma_percentage_amount=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
			$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);

			if($pull_nb_item==0){
				$proforma_percentagexx=100-((($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_amount'))/$this->input->post('proforma_amount_hidden'))*100);
			} else {
				$proforma_percentagexx=$this->input->post('proforma_percentage');
			}
			$data = array(
				'item_amount'     			=> $this->input->post('total_item'),
                'proforma_percentage'     	=> $proforma_percentagexx,
                'proforma_percentage_amount'=> $proforma_percentage_amount,
				'proforma_vat_amount'		=> $proforma_vat_amount,
				'proforma_discount'     	=> 0
			);
			$this->db->where('proforma_id', $proforma_id);
			$this->db->update('proforma', $data);
			
			$count = $this->input->post('hiddenCount');
			

			if($pull_nb_item==0){
				
				$this->db->where('proforma_id',$proforma_id);
				$this->db->delete('proforma_details');
				for($i=1; $i<$count ; $i++){
					if($this->input->post('item_row'.$i)!=""){
						$datanew = array(
							'proforma_id' 		=> $proforma_id,
							'sl_no' 			=> $i,
							'group_name' 		=> '',
							'group_id' 			=> 0,
							'sub_group_name' 	=> '',
							'sub_group_id' 		=> 0,
							'item_order' 		=> $i,
							'item_name' 		=> $this->input->post('item_row'.$i),
							'quantity' 			=> $this->input->post('quantity_row'.$i),
							'item_discount' 	=> $this->input->post('disc_row'.$i),
							'unit_price' 		=> str_replace(",","",$this->input->post('rate_row'.$i)),
							'amount' 			=> str_replace(",","",$this->input->post('quantity_row'.$i)*$this->input->post('rate_row'.$i)),
							'vat_perce' 		=> $this->input->post('vat_perc_row'.$i),
							'vat_amount' 		=> $this->input->post('vat_amount_row'.$i),
							'net_amount' 		=> $this->input->post('total'.$i),
							'description' 		=> $this->input->post('description_row'.$i),
							'uom' 				=> $this->input->post('uom_nb'.$i),
							'total_discount' 	=> 0
						);
						$this->db->insert('proforma_details',$datanew);
					 } 
				 }
			}
			$this->session->set_flashdata('response', 'Proforma Created...');
			redirect('proforma');
		}
	}

	function newProforma($proforma_id,$client="") {
		//$job_card_id    = $this->input->post('job_card_id');
		//$client    = $this->input->post('client');
		
		$this->load->view('templates/header');
		$this->load->model('proforma_model');
		//$data['results'] = $this->proforma_model->selectcount();
		$data['proforma']=$this->proforma_model->getProformaRow($proforma_id);
		$data['h']=$this->proforma_model->list_details($proforma_id);
		
		//$data['detail']=$this->proforma_model->getonerow($proforma_id);
		
		$data['proforma_no']='';
		
		$data['sumdetail']=$this->proforma_model->getsumrow($proforma_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;

		if($this->furniture_quotation_model->config($data['proforma']->quotation_divisionid)){
			$config_data=$this->furniture_quotation_model->config($data['proforma']->quotation_divisionid);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=$data['proforma']->proforma_date;
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['proforma_amount_hidden']=$data['proforma']->proforma_amount;
		if(isset($_POST["pull_items_from_job"])) {
			$data['job_card_total']=$data['proforma']->job_card_total;
			$data['job_card_vat_amount']=$data['proforma']->job_card_vat_amount;
			$data['proforma_amount']=$data['proforma']->proforma_amount;
			$data['job_card_total']=$data['proforma']->job_card_total;
			$data['is_posted']=1;
		} else {
			$data['job_card_total']=0;
			$data['job_card_vat_amount']=0;
			$data['proforma_amount']=0;
			$data['job_card_vat_amount']=0;
			$data['is_posted']=0;
			
		}
		

		$this->load->view('furniture/quotations/newProforma',$data);
		$this->load->view('templates/footer');
		
		
		if(isset($_POST["invoice_save"])) {
			
			$pull_nb_item = $this->input->post('pull_nb_item');
			$proforma_percentage_amount=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
			$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);

			if($pull_nb_item==0){
				$proforma_percentagexx=100-((($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_amount'))/$this->input->post('proforma_amount_hidden'))*100);
			} else {
				$proforma_percentagexx=$this->input->post('proforma_percentage');
			}
			$data = array(
				'item_amount'     			=> $this->input->post('total_item'),
                'proforma_percentage'     	=> $proforma_percentagexx,
                'proforma_percentage_amount'=> $proforma_percentage_amount,
				'proforma_vat_amount'		=> $proforma_vat_amount,
				'proforma_discount'     	=> 0
			);
			$this->db->where('proforma_id', $proforma_id);
			$this->db->update('proforma', $data);
			
			$count = $this->input->post('hiddenCount');
			

			if($pull_nb_item==0){
				
				$this->db->where('proforma_id',$proforma_id);
				$this->db->delete('proforma_details');
				for($i=1; $i<$count ; $i++){
					if($this->input->post('item_row'.$i)!=""){
						$datanew = array(
							'proforma_id' 		=> $proforma_id,
							'sl_no' 			=> $i,
							'group_name' 		=> '',
							'group_id' 			=> 0,
							'sub_group_name' 	=> '',
							'sub_group_id' 		=> 0,
							'item_order' 		=> $i,
							'item_name' 		=> $this->input->post('item_row'.$i),
							'quantity' 			=> $this->input->post('quantity_row'.$i),
							'item_discount' 	=> $this->input->post('disc_row'.$i),
							'unit_price' 		=> str_replace(",","",$this->input->post('rate_row'.$i)),
							'amount' 			=> str_replace(",","",$this->input->post('quantity_row'.$i)*$this->input->post('rate_row'.$i)),
							'vat_perce' 		=> $this->input->post('vat_perc_row'.$i),
							'vat_amount' 		=> $this->input->post('vat_amount_row'.$i),
							'net_amount' 		=> $this->input->post('total'.$i),
							'description' 		=> $this->input->post('description_row'.$i),
							'uom' 				=> $this->input->post('uom_nb'.$i),
							'total_discount' 	=> 0
						);
						$this->db->insert('proforma_details',$datanew);
					 } 
				 }
			}

			$this->session->set_flashdata('response', 'Proforma Created...');
			redirect('proforma');
		}
	}

	public function search_item() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql=" and item_name LIKE '%$client%' ";
		$client_contact_data = $this->db->query("SELECT * FROM `items` where `item_name` like '$client%'   ".$sql." order by item_name");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['id'].'" class="item_button" tabindex="'.$n++.'" ><input type="hidden" class="item_name" value="'.$client_contact_datas['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" />'.$client_contact_datas['item_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	function search_quotation() {
	
		$search_name = trim($this->input->post('quotation_number_new_one'));
		$search_name1 = trim($this->input->post('textfield2'));
		
		$like=null;
		$array = explode("-",$search_name.'-0');
		$like=array('quotation_number'=>$array[1],'division_code'=>$array[0]);
		//$or_like=array('quotation_number'=>$search_name);,'is_invoice'=>0
		$where=array('quotation_status'=>'Confirmed');
		$records['quotation_list']=$this->crud_model->get('view_furniture_quotations_client_project_users',
				$where,
				null,
				null,
				null,
				null,
				$like,
				null,null);
		
						
		if($records['quotation_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('furniture/quotations/proforma_search_result', $records);
			
		}
		
	}

	function search_job() {
	
		$search_name = trim($this->input->post('quotation_number_new_one'));
		$search_name1 = trim($this->input->post('textfield2'));
		
		$like=null;
		$array = explode("-",$search_name.'-0');
		//,'division_code'=>$array[0]
		$like=array('job_card_number'=>$search_name);
		//$or_like=array('quotation_number'=>$search_name);,'is_invoice'=>0
		$where=array();
		//$where=array();
		$records['quotation_list']=$this->crud_model->get('view_furniture_job_card',
				$where,
				null,
				null,
				null,
				null,
				$like,
				null,null);
		if($records['quotation_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('furniture/quotations/proforma_search_result', $records);
			
		}
		
	}

	function search_client() {
	
		$search_name = trim($this->input->post('client'));
		
		$like=null;
		if($search_name!=''){
			$like=array('client_name'=>$search_name);
		}
		
		$records['client_list']=$this->crud_model->get('new_client_master',array(), null,null,null,null,$like,null);
						
		if($records['client_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('furniture/quotations/client_search_result', $records);
			
		}
		
	}
	public function add_new_client(){
		$client = $this->input->post('client_name');
		$this->load->model("proforma_model");
		$this->proforma_model->client_data_submit();
		$this->session->set_flashdata('message', 'New Client Added...');
		redirect('furniture/proforma_invoice/index/'.$client);
   }
   /*public function insert_invoice(){
		$this->load->model("proforma_model");
		$this->proforma_model->invoice_submit();
		$this->session->set_flashdata('message', 'New Invoice Created...');
		redirect('furniture/furnitures_invoice_c');
   }*/
   public function edit($id){
			$this->load->model('proforma_model');
			$data['h1']=$this->proforma_model->invoice_getonerow($id);
			$data['h']=$this->proforma_model->list_invoice_details($id);
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/edit_invoice',$data);
			$this->load->view('templates/footer');
	}
	public function create($id){
		$title['headerTitle']="Invoice Create";
		$this->load->model('proforma_model');
		$data['h1']=$this->proforma_model->pinvoice_getonerow($id);
		$job_card_id = $data['h1']->job_card_id;
		$quotation_divisionid = $data['h1']->quotation_divisionid;
		$invtype=1;
		$data['invoice_no']=$this->proforma_model->get_invoice_no($quotation_divisionid,$invtype);
		$data['sum']=$this->proforma_model->pinvoice_get_sum_amount($job_card_id);
		$data['h']=$this->proforma_model->list_pinvoice_details($id);
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/createpinvoice',$data);
		$this->load->view('templates/footer');
	}
  	public function update(){
			$id = $this->input->post('invid');
			$this->load->model('proforma_model');
			$this->proforma_model->update($id);
			$this->session->set_flashdata('response', 'Proforma Updated...');
		    redirect('proforma');
	}
	public function pupdate($id){
		//$id = $this->input->post('invid');
		$proforma_id = $this->input->post('invid');
		$this->db->trans_begin();
		$query_data= $this->db->query("SELECT * FROM `furniture_invoice` WHERE ( invoice_status='0' ) and `proforma_id`='$proforma_id' ");
		if ($query_data->row()==false){
			$this->load->model('proforma_model');
			$this->proforma_model->pupdate($id);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				//$this->session->set_flashdata('response', 'Some Created...');
				redirect('furniture/Proforma_invoice/create/'.$id);
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Invoice created successfully...');
				redirect('invoices');
			}
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'Already created...');
			redirect('furniture/Proforma_invoice/create/'.$id);
		}
	}
  public function delete($id,$proforma_number){
		$this->load->model('proforma_model');
		$this->proforma_model->delete($id,$proforma_number);
		$this->session->set_flashdata('response', 'Proforma Cancelled...');
		redirect('proforma');
	}
  function sub_category() {
		$sub_category_name =  $this->input->post('sub_category');
		$this->db->like('item_name',$sub_category_name);
		$this->db->or_like('item_code', $sub_category_name);
		//$this->db->like('item_code',$sub_category_name);
		$query = $this->db->get('items');  
		if($query->num_rows() > 0){
					$item_list = $query->result_array();
					
					$java_script='<script type="text/javascript" >var item_list = new Array();';
					$html='<div id="search_result" ><table class="table table-bordered table-hover"><tr style="background:#434343; color:#FFFFFF;"><th>Item Code</th>
					<th>Item Name</th>
					<th>Selling Price</th>
					<th>Action</th>
					</tr>';

					foreach($item_list as $index=>$client_entry) {
						$java_script.="item_list[" . $index . "]=new Array();";
						$java_script.="item_list[" . $index . "][0]='" . $client_entry['item_name'] . "';";
						$java_script.="item_list[" . $index . "][1]='" . $client_entry['selling_price'] . "';";
						$java_script.="item_list[" . $index . "][2]='" . preg_replace( "/\r|\n/", " ", $client_entry['description'] ) . "';";
						
						$html.='<tr><td>'. $client_entry['item_code'] . '</td>
									<td>'. $client_entry['item_name'] . '</td>
									<td>'. $client_entry['selling_price'] . '</td>
									<td><button type="button" value="' .$index .'" class="client_button" style="background: #586688; color:#FFFFFF;">Select</button> </td>
						</tr>';
							
					}
					
				$java_script.='</script>';
				$html.='</table></div>';
				
				echo $java_script;
				echo $html;
		}
		else{
			return false;
		}
	}
} 
?>