<?php
class Agreement_template extends CI_Controller {
	function Agreement_template()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/agreement_template/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('agreement_template',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('agreement_template',
				array(),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->edit();

	}

	function edit()
	{


		$records=$this->crud_model->get('agreement_template');
		if($records != false){
			//true section
			$data['a_template_content']			 = $records[0]['a_template_content'];
			//$data['a_template_id']			 = $records[0]['a_template_id'];
				
			$this->load->view('templates/header');
			$this->load->view('masters/agreement_template/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/agreement_template');
		}
	}

	function do_update()
	{

		$this->form_validation->set_rules('a_template_content', 'Agreement Template Content', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$records=$this->crud_model->get('agreement_template');
			if($records != false){
				//true section
				$data['a_template_content']			 = $records[0]['a_template_content'];
				// $data['a_template_id']			         = $records[0]['a_template_id'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/agreement_template/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/agreement_template');
			}
		}
		else
		{// true section

				
			$a_template_content   = $this->input->post('a_template_content');
			$data=array(

					'a_template_content' => $a_template_content

			);

			$records=$this->crud_model->update('agreement_template',$data);

			$this->session->set_flashdata('response','<div class="alert alert-success">Agreement updated</div>');
			redirect('masters/agreement_template');

		}

	}
}

