<?php
class Worktop_finish extends CI_Controller {
	function Worktop_finish()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/worktop_finish/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_worktop_finish_with_brand',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_worktop_finish_with_brand',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_finish/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$list = $this->crud_model->get_list('worktop_brand_id','worktop_brand_name','worktop_brands',array(0=>' - Select - '));
		$data['worktop_brands'] = $list;
			
		$this->load->view('templates/header');
		$this->load->view('masters/worktop_finish/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id)
	{

		$where=array(
			'worktop_finish_id' => $id
		);
		$records = $this->crud_model->get('worktop_finish',$where);

		if($records != false){
			//true section
			$data['worktop_finish_name']			 = $records[0]['worktop_finish_name'];
			$data['worktop_finish_id']			     = $records[0]['worktop_finish_id'];
			$data['worktop_brand_id']			     = $records[0]['worktop_brand_id'];

			$list = $this->crud_model->get_list('worktop_brand_id','worktop_brand_name','worktop_brands',array(0=>' - Select - '));
			$data['worktop_brands'] = $list;

			$this->load->view('templates/header');
			$this->load->view('masters/worktop_finish/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">No data for given id</div>');
			redirect('masters/worktop_finish');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('worktop_finish_name', 'Worktop Finish Name', 'required|max_length[50]');
		$this->form_validation->set_rules('worktop_brand_id', 'Worktop Brand', 'required|is_natural_no_zero');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->create();
		}
		else
		{	// true section

			$worktop_finish_name=$this->input->post('worktop_finish_name');
			$worktop_brand_id=$this->input->post('worktop_brand_id');

			$data=array(
					    'worktop_finish_name'  => $worktop_finish_name,
				     	'worktop_brand_id'     => $worktop_brand_id
			);

			$rr=$this->crud_model->insert('worktop_finish',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Worktop Finish cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/worktop_finish');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Finish added successfully</div>');
				redirect('masters/worktop_finish');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('worktop_finish_name', 'Worktop Finish Name', 'required|max_length[50]');
		$this->form_validation->set_rules('worktop_brand_id', 'Worktop Brand', 'required|is_natural_no_zero');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit($this->input->post('worktop_finish_id'));
		}
		else
		{// true section

			$worktop_finish_name        = $this->input->post('worktop_finish_name');
			$worktop_brand_id           = $this->input->post('worktop_brand_id');
			$worktop_finish_id          =  $this->input->post('worktop_finish_id');
			$where=array(
					           'worktop_finish_id'=> $worktop_finish_id
			);
			$data=array( 
				         'worktop_finish_name'  => $worktop_finish_name,
				          'worktop_brand_id'    => $worktop_brand_id
			);
			$records=$this->crud_model->update('worktop_finish',$data,$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Finish updated</div>');
			redirect('masters/worktop_finish');
		}
	}
	function do_delete($id=0)
	{

		$where=array(
				'worktop_finish_id'=> $id
		);

		$this->crud_model->delete('worktop_finish',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Finish deleted</div>');
		redirect('masters/worktop_finish');
	}
}

