<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_quotation extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Vehicle');
	}

	public function bom_print(){
		$bom_h_id 		= $this->input->post('bom_h_id');
		$records 			= $this->crud_model->get('bom_details',array('bom_h_id'=>$bom_h_id),null,null,null,null,null,null,null,'bom_id');
		$html = '<table class="table1">
						<tr bgcolor="lightblue">
						  <th>SL# </th>
						  <th>Item Name</th>
						  <th>Amount</th>
						</tr>';
						$i=1;
		if($records!=false){
			$total_amount=0;
			foreach($records as $record){
				$total_amount+=$record['item_amount'];
				$html .= '<tr>
								<td style="text-align:center; background:lightgray;">'.$i++.'</td>
								<td style="text-align:center; background:lightgray;">
									<b>'.$record['bom_item_name'].'</b>
								</td>
								<td style="text-align:center; background:lightgray;">'.$record['item_amount'].'</td>
						  </tr>';
			}
			$html .= '<tr>
			<td style="text-align:center; background:lightgray;" colspan="2">&nbsp;</td>
						<td style="text-align:center; background:lightgray;">'.$total_amount.'</td>
						  </tr>';
		}			
		$html .= '</table>';
		echo $html;

	}
	public function index($quotation_id=0) {
		
		
	}
	function do_update_status(){

		$this->form_validation->set_rules('nbx_quotation_id', 'Quotation Id', 'required');
		$this->form_validation->set_rules('nbx_status', 'Quotation Status', 'required');

		/*if($this->input->post('quotation_status') == 'Closed'){
			$this->form_validation->set_rules('quotation_closed_reason', 'Reason for close', 'required');
		}*/
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response_status_update','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		} else {
			$where = array('id'	=> $this->input->post('nbx_quotation_id'));		
			$data_quo['status'] = $this->input->post('nbx_status');									
			$rr_quo = $this->crud_model->update('furniture_quotation',$data_quo,$where);
			redirect('furniture/furniture_quotations/index');
		}
	}

	public function discount_check(){
		$discount_percentage = $this->input->post('discount_percentage');
		print $this->crud_model->profit_based_discount_limit($discount_percentage);
	}

	public function validate_net_amount()
	{
		$total_amount = (float)$this->input->post('total_item');
		$discount = (float)$this->input->post('discount_bd');
		$vat = (float)$this->input->post('vat_amount_bd');
		$net_amount = (float)$this->input->post('grand_totoal_bd');

		$calculated_net_amount = ($total_amount - $discount) + $vat;

		if (round($calculated_net_amount,3) != $net_amount) {
			$this->form_validation->set_message('validate_net_amount', 'The net amount is not calculated correctly.');
			return false;
		}
		return true;
	}

	public function do_update_discount($quotation_id, $division_id, $quotation_number) {
		$this->form_validation->set_rules('grand_totoal_bd', 'Discount', 'required');
		$this->form_validation->set_rules('discount_bd', 'Discount', 'required|callback_validate_net_amount');
		
		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->quotation($quotation_id,$division_id,$quotation_number);
		} else {
			$data = array(
				'quotation_discount' => $this->input->post('discount_bd'),
				'quotation_vat_amount' => $this->input->post('vat_amount_bd'),
				'quotation_amount_with_vat' => $this->input->post('grand_totoal_bd'),
				'last_modified_date' => date('Y-m-d h:m:s')
			);
			//'last_modified_by' => $this->session->userdata('user_id'),
			$where=array(
				'id'=> $quotation_id
			);
			$this->crud_model->update(' furniture_quotation',$data,$where);
			$page=1;
			redirect('manage_quotation/quotation/'.$quotation_id.'/'.$division_id.'/'.$quotation_number);
		}
	}
	
	public function quotation($quotation_id=0,$division_id=0,$quotation_number=0){
		$title['headerTitle']="Manage Quote";
		$where=array('furniture_quotation.id' => $quotation_id);
		//$this->session->set_userdata('furniture_quotation_id', $quotation_id);
		$records=$this->crud_model->get_view_furniture_quotations_client_project_users($where);
		//print $this->db->last_query();
		//print_r($records);
		$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
		$records[0]['amount_paid'] =$amount_paid;
		$records[0]['balance_amount'] =$records[0]['quotation_total']- $amount_paid;
		$this->data['records'] = $records;
		
		if($this->furniture_quotation_model->check_invoice($quotation_id) == 0){
			$this->data['invoice'] = 0;
		}else{
			$this->data['invoice'] = 1;
		}
		/*To handle previous versions code start*/
		$this->data['old_quotations']=array();
		$previous_version_link='';
		if($records != false) {

			//if($records[0]['quotation_revisionnumber'] == 0) {
			//	$previous_version_link.='<a  href="'.site_url('manage_quotation/printQuotation/'.$records[0]['id'].'/normal/without_image/0/0/0').'">0</a>';
			//} else {
				$where=array('quotation_number'=>$records[0]['quotation_number'],'quotation_divisionid'=>$records[0]['quotation_divisionid']);
				$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');
				foreach($quotation_data as $single_quotation) {
					if((count($quotation_data)-1)>$single_quotation['quotation_revisionnumber']){
						$previous_version_link.='<a style="color:white;" target="_blank" title="Print Quote"  href="'.site_url('manage_quotation/printQuotation/'.$single_quotation['id'].'/normal/without_image/0/0/0/0').'">'.$single_quotation['quotation_revisionnumber'].'</a>&nbsp;&nbsp;';
					}
					//$data['old_quotations']=$single_quotation['id'];
				}
			//}
		}
		//exit;
		//print $previous_version_link;
		$this->data['previous_version_link']=$previous_version_link;
		$this->db->select('*');
		$this->db->from('furniture_invoice');
		$this->db->join('company_division','company_division.division_id = furniture_invoice.quotation_divisionid','inner');
		$this->db->where('quotation_id', $quotation_id); 
		$this->db->where('invoice_status','0');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$this->data['receipt_inv'] = $rs->result_array();
		}
		else{
			$this->data['receipt_inv'] = array();
		}
		
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('quotation_id', $quotation_id); 
		$fi = $this->db->get();
		if($fi->num_rows() > 0){
			$this->data['furniture_items'] = $fi->result_array();
			$this->data['is_enter_one_item'] = 1;
		}
		else{
			$this->data['furniture_items'] = array();
			$this->data['is_enter_one_item'] = 0;
		}


		$SQL = "SELECT * FROM proforma inner join company_division on company_division.division_id = proforma.quotation_divisionid where quotation_id='$quotation_id' And (proforma_status='1' OR proforma_status='2') ;";
		$ps = $this->db->query($SQL);
		if($ps->num_rows() > 0){
			$this->data['proforma_qtn'] = $ps->result_array();
		}
		else{
			$this->data['proforma_qtn'] = array();
		}
		if($records[0]['quotation_type']!=3){
			$SQLxx = "SELECT quotation_id FROM furniture_items  where quotation_id='$quotation_id' And estimate_yes_or_no='No' ;";
			$psxx = $this->db->query($SQLxx);
			if($psxx->num_rows() > 0){
				$this->data['not_completed_bom']=1;
			}
			else{
				$this->data['not_completed_bom']=0;
			}
		} else {
			$this->data['not_completed_bom']=0;
		}
		
		
		$this->db->select('*');
		$this->db->from('upload_files');
		$this->db->where('quotation_number', $quotation_number);
		$this->db->where('division_id', $division_id);
		//$this->db->where('qutation_id', $quotation_id); 
		$up_data = $this->db->get();
		if($up_data->num_rows() > 0){
			$this->data['rec_file'] = $up_data->result_array();
		}
		else{
			$this->data['rec_file'] = array();
		}

		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('quotation_id', $quotation_id);
		$jc_data = $this->db->get();
		if($jc_data->num_rows() > 0){
			$this->data['job_card_list'] = $jc_data->result_array();
		} else {
			$this->data['job_card_list'] = array();
		}

		if($this->furniture_quotation_model->config($division_id)){
			$config_data=$this->furniture_quotation_model->config($division_id);
			$this->data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$this->data['is_estimate'] = $config_data->is_estimate;
			$this->data['is_approve'] = $config_data->is_approve;
			$this->data['is_bom'] = $config_data->is_bom;
			$this->data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$this->data['is_category'] = $config_data->is_category;
		} else {
			$this->data['is_quote_from_master'] = 0;
			$this->data['is_estimate'] = 0;
			$this->data['is_approve'] = 0;
			$this->data['is_bom'] = 0;
			$this->data['is_optional_item_level'] = 0;
			$this->data['is_category'] = 0;
		}
		
		$this->load->view('templates/header',$title);
		$this->load->view('manage/quotation',$this->data);
		$this->load->view('templates/footer');
	}
	
	public function generateInvoice($quotation_id=0){
		
		if($this->furniture_quotation_model->check_invoice($quotation_id) == 0){
			$this->furniture_quotation_model->set_invoice_id($quotation_id);
			$generated_invoice_id = $this->session->userdata('furniture_invoice_id');
		}
		redirect('manage_quotation/quotation/'.$quotation_id);	
	}
	
	
	public function printInvoice($quotation_id=0){
		
		//$this->load->helper(array('dompdf', 'file'));
		// page info here, db calls, etc.     
		 
		 $records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
		//var_dump($records);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		
		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if($logo[0]['logo_filename']){
				array_push($records['logos_url'], $logo[0]['logo_filename']);
			}
		}
		//var_dump($records);exit;
		 $this->load->view('general/quotations/printview2', $records);
		 //$html = $this->load->view('general/quotations/printview1', $records, true);
		 //pdf_create($html, 'Quotation_No_'.$quotation_id);
		
		 //if you want to write it to disk and/or send it as an attachment  		
	}

	public function printProformaDetails($invoice_id,$type){
		
		//$this->load->helper(array('dompdf', 'file'));
		 // page info here, db calls, etc.     
		 
		 $records = $this->furniture_quotation_model->get_full_proforma_details($invoice_id,'unique');
		
		 //var_dump($records);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		$job_card_id = $records['job_card_id'];
		if($job_card_id!=0){
			$this->db->select('job_card_number');
			$this->db->from('job_card');
			$this->db->where('id', $job_card_id);
			$this->db->limit(1);
			$query2 = $this->db->get();
			$records['job_card_number'] = $query2->row()->job_card_number;
		} else {
			$records['job_card_number'] = "";
		}
		
		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo== true){
				array_push($records['logos_url'], "images/logos/".$logo[0]['logo_filename']);
			}else if($records['logo_filename']){
				array_push($records['logos_url'], "images/company_division/".$records['logo_filename']);
			}
		}
		
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row)
			{
				$company_email_name =  $row->company_name;
			}
		//var_dump($records);exit;
		 //$this->load->view('general/quotations/printview4', $records);
		 
		if($type=="pdf"){
			$records['image'] = "without_image";
			$records['print_type'] = "pdf_print_type";
			$records['controller'] = $this;

			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10,
			]);
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			$header = $this->load->view('general/quotations/proforma_pdf_header', $datas , true);
			$html = $this->load->view('general/quotations/printproforma', $datas , true);
			$footer = $this->load->view('general/quotations/proforma_pdf_footer', $datas , true);			
			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,5,42,20,10,0);
			
			$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();			
			if($records['invoice_status']==='0'){
				$mpdf->SetWatermarkText('Cancelled');
				$mpdf->showWatermarkText = true;
			}
			
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename='Proforma Invoice - '.ucfirst(strtolower($records['client_name'])).'-'.$records['invoice_number'].'.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');
		}else if($type=="normal"){
		$records['print_type'] = "normal_print_type";
		$this->load->view('general/quotations/normal_proforma_print', $records);
		}else if($type=="email"){
		
		$this->db->select('*');
		$this->db->from('emails'); 
		$query_email = $this->db->get();
		$records_email=$query_email->result_array();
		
		$records['print_type'] = "email_print_type";
		$this->load->helper(array('dompdf', 'file'));
		$html = $this->load->view('general/quotations/printproforma', $records, true);
		pdf_create($html, 'Invoice_No_'.$invoice_id,$stream=FALSE);
				$from 		= $records['salesman_email_id'];
				$fromname 	= $company_email_name;
				$to 		= $records['client_email'];
				$cc 		= @$records_email[0]['invoice_cc'];
				$subject 	= 'Invoice';
				$message 	= 'Please find attached invoice';
				$this->load->library('invoice_email');
				$send = $this->invoice_email->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$invoice_id);
				if($send){
					$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
				}else{
					$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
				}
				redirect('invoices');
		}
		 //$html = $this->load->view('general/quotations/printview1', $records, true);
		 //pdf_create($html, 'Quotation_No_'.$quotation_id);
		
		 //if you want to write it to disk and/or send it as an attachment  
	}

	public function printInvoiceDetails($invoice_id,$type){
		
		//$this->load->helper(array('dompdf', 'file'));
		 // page info here, db calls, etc.     
		 
		 $records = $this->furniture_quotation_model->get_full_invoice_details($invoice_id);
		//var_dump($records);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		//print_r( $records );
	
		if($records['job_card_id'] != ''){
			$job_card_id = $records['job_card_id'];
		}
		else{
			$job_card_id = $records['job_card_id_inv'];
		}

		$make  	    = $this->Vehicle->getMake();
		$v_category = $this->Vehicle->getv_category();
		$model      = $this->Vehicle->getModel();
		$where_job = array(
			'id' => $job_card_id
		);
		$jobrecords=$this->crud_model->get('job_card',$where_job);
		
		if($job_card_id!=0){
			$this->db->select('job_card_number');
			$this->db->from('job_card');
			$this->db->where('id', $job_card_id);
			$this->db->limit(1);
			$query2 = $this->db->get();
			//echo $this->db->last_query();
			$records['job_card_number'] = $query2->row()->job_card_number;
			$categoryArray = array_column($v_category , 'type', 'id' );
			$makeArray  = array_column($make,'title','id');
			$modelArray = array_column($model,'title','id');
			if(isset( $jobrecords[0]['vtype_id']) && isset( $categoryArray[$jobrecords[0]['vtype_id']]) ){
				$records['vtype_name'] = $categoryArray[$jobrecords[0]['vtype_id']];
			}
			else{
				$records['vtype_name'] = "";
			}

			if(isset($jobrecords[0]['make']) & isset($makeArray[$jobrecords[0]['make']])){
				$make_name = $makeArray[$jobrecords[0]['make']];
			}
			else{
				$make_name =  "";
			}
			if(isset($jobrecords[0]['model']) & isset($modelArray[$jobrecords[0]['model']])){
				$model_name = $modelArray[$jobrecords[0]['model']];
			}
			else{
				$model_name =  "";
			}
			$vname = $make_name.' - '.$model_name;
			$records['Km_in'] = $jobrecords[0]['km_in'];
			$records['reg_no'] = $jobrecords[0]['reg_no'];
			$records['job_card_number'] = $jobrecords[0]['job_card_number'];
			$records['vname'] = $vname;
			$records['chassi_number'] = $jobrecords[0]['chassi_number'];
			$records['car_year'] = $jobrecords[0]['car_year'];
			$records['car_color'] = $jobrecords[0]['car_color'];
		  
			$this->db->select('furniture_model');
			$this->db->from('job_card_details');
			$this->db->where('job_card_id', $job_card_id);
			$this->db->where('jb_type', 1);
			$this->db->order_by('job_card_details_id','DESC');
			$this->db->limit(1);
			$query4 = $this->db->get();
			$records['subject'] = $query4->row()->furniture_model;
		} else {
			$records['job_card_number'] = "";
			$records['vtype_name'] = "";
			$records['vname'] = "";
			$records['chassi_number'] = "";
			$records['car_color'] = "";
			$records['car_year'] = "";
			$records['reg_no'] = "";
			$records['subject'] = "";
			$records['Km_in'] = "";
		}

		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo== true){
				array_push($records['logos_url'], "images/logos/".$logo[0]['logo_filename']);
			}else if($records['logo_filename']){
				array_push($records['logos_url'], "images/company_division/".$records['logo_filename']);
			}
		}
		
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row)
			{
				$company_email_name =  $row->company_name;
			}
		//var_dump($records);exit;
		 //$this->load->view('general/quotations/printview4', $records);
		 
		if($type=="pdf"){
			$records['image'] = "without_image";
			$records['print_type'] = "pdf_print_type";
			$records['controller'] = $this;

			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10,
			]);
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			$header = $this->load->view('general/quotations/invoice_pdf_header', $datas , true);
			$html = $this->load->view('general/quotations/printview4', $datas , true);
			$footer = $this->load->view('general/quotations/invoice_pdf_footer', $datas , true);
			
			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,5,42,20,10,0);
			$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();
			
			if($records['invoice_status']==='1'){
				$mpdf->SetWatermarkText('Cancelled');
				$mpdf->showWatermarkText = true;
			}
			
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename='22.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');
		}else if($type=="normal"){
		$records['print_type'] = "normal_print_type";
		$this->load->view('general/quotations/normal_invoice_print',$records);
		}else if($type=="email"){
		
		$this->db->select('*');
		$this->db->from('emails'); 
		$query_email = $this->db->get();
		$records_email=$query_email->result_array();
		
		$records['print_type'] = "email_print_type";
		$this->load->helper(array('dompdf', 'file'));
		$html = $this->load->view('general/quotations/printview4',$records, true);
		pdf_create($html, 'Invoice_No_'.$invoice_id,$stream=FALSE);
				
				
				
				$from 		= $records['salesman_email_id'];
				$fromname 	= $company_email_name;
				$to 		= $records['client_email'];
				$cc 		= @$records_email[0]['invoice_cc'];
				$subject 	= 'Invoice';
				$message 	= 'Please find attached invoice';
				$this->load->library('invoice_email');
				$send = $this->invoice_email->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$invoice_id);
				if($send){
					$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
				}else{
					$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
				}
				redirect('invoices');
		}
		 //$html = $this->load->view('general/quotations/printview1', $records, true);
		 //pdf_create($html, 'Quotation_No_'.$quotation_id);
		
		 //if you want to write it to disk and/or send it as an attachment  	
	}

	function qr_code_generate($iban='',$amount=''){
		$this->load->library('ciqrcode');
		$xxx='{"iban":"'.$iban.'","amount":"'.$amount.'"}';
		$params['data'] = $xxx;
		$params['level'] = 'H';
		$params['size'] = 2;
		$params['savename'] = FCPATH.'qrcode/'.$iban.'.png';
		$this->ciqrcode->generate($params);
		$generated_qrcode	= '<img src="'.base_url().'qrcode/'.$iban.'.png" style="width: 62px; height: 62px;" />';
		print $generated_qrcode;
	}
	
	function printQuotation($quotation_id,$type,$image_type,$chekval,$without_group,$without_sub,$without_vat,$print_status=''){
		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
		$records['furniture_itemlist'] = $this->crud_model->get('furniture_items', array('furniture_items.quotation_id'=>$quotation_id), null, null, "ex_furniture_area", "ASC", null, null, null,'furniture_area' );
		if($records == false) {
				$this->session->set_flashdata('response','Please Select a Quotation First..');
				redirect('furniture/furniture_quotations');
		}		 
 		$make  	    = $this->Vehicle->getMake();
		$v_category = $this->Vehicle->getv_category();
		$model      = $this->Vehicle->getModel();
		$where_job = array(
			'id' => $records['job_card_id']
		);
		$jobrecords=$this->crud_model->get('job_card',$where_job);
		if($jobrecords != false){
			$categoryArray = array_column($v_category , 'type', 'id' );
			$makeArray  = array_column($make,'title','id');
			$modelArray = array_column($model,'title','id');
			if(isset( $jobrecords[0]['vtype_id']) && isset( $categoryArray[$jobrecords[0]['vtype_id']]) ){
				$records['vtype_name'] = $categoryArray[$jobrecords[0]['vtype_id']];
			}
			else{
				$records['vtype_name'] = "";
			}

			if(isset($jobrecords[0]['make']) & isset($makeArray[$jobrecords[0]['make']])){
				$make_name = $makeArray[$jobrecords[0]['make']];
			}
			else{
				$make_name =  "";
			}
			if(isset($jobrecords[0]['model']) & isset($modelArray[$jobrecords[0]['model']])){
				$model_name = $modelArray[$jobrecords[0]['model']];
			}
			else{
				$model_name =  "";
			}
			$vname = $make_name.' - '.$model_name;
			$records['Km_in'] = $jobrecords[0]['km_in'];
			$records['reg_no'] = $jobrecords[0]['reg_no'];
			$records['job_card_number'] = $jobrecords[0]['job_card_number'];
			$records['vname'] = $vname;
			$records['chassi_number'] = $jobrecords[0]['chassi_number'];
			$records['car_year'] = $jobrecords[0]['car_year'];
			$records['car_color'] = $jobrecords[0]['car_color'];
			$this->db->select('furniture_model');
			$this->db->from('job_card_details');
			$this->db->where('job_card_id', $records['job_card_id']);
			$this->db->where('jb_type', 1);
			$this->db->order_by('job_card_details_id','DESC');
			$this->db->limit(1);
			$query4 = $this->db->get();
			$records['subject'] = $query4->row()->furniture_model;
		}

 		/*if($type==="forapprover"){
			//$rs=$records;
			if($this->session->userdata('is_estimator')==1 && $records['estimator_id']==NULL){
				$wherenbx = array('id'	=> $quotation_id);		
				$data_quonbx['estimator_id'] = $this->session->userdata('user_id');									
				$rr_quo = $this->crud_model->update('furniture_quotation',$data_quonbx,$wherenbx);
				//redirect('furniture/Furnitures/index/'.$quotation_id);
			} else if($this->session->userdata('is_approver')==1 && $records['approver_id']==NULL){
				$wherenbx2 = array('id'	=> $quotation_id);		
				$data_quonbx2['approver_id'] = $this->session->userdata('user_id');									
				$rr_quo = $this->crud_model->update('furniture_quotation',$data_quonbx2,$wherenbx2);
				//redirect('furniture/Furnitures/index/'.$quotation_id);
			} else if( $this->session->userdata('user_id')!=$records['estimator_id'] && $this->session->userdata('user_id')!=$records['approver_id'] && $records['estimator_id']!=NULL) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! The quotation already Picked.</div>');
			redirect('furniture/furniture_quotations');
			} 
         }*/
		// $records['vtype_name'] = $vtype_name;	

		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if(@$logo[0]['logo_filename']){
				array_push($records['logos_url'], "images/logos/".$logo[0]['logo_filename']);
			}
                        //else if($records['logo_filename']){
				//array_push($records['logos_url'], "images/company_division/".$records['logo_filename']);
			//}
		}
		$records['footer_url'] = array();
		$footer_id = explode(",",$records['quotation_footer']);
		foreach($footer_id as $key=>$footer_id) {
			$where = array('footer_id' => $footer_id);
			$footer = $this->crud_model->get('footer',$where); 
			if(@$footer[0]['footer_image']){
				array_push($records['footer_url'], $footer[0]['footer_image']);
			}
		}
		
		/*$records['footer_url'] = array();
		$footer_id = $records['quotation_footer'];
		$where = array('footer_id' => $footer_id);
		$footer = $this->crud_model->get('footer',$where); 
			if($footer[0]['footer_image']){
				array_push($records['footer_url'], $footer[0]['footer_image']);
			}*/
		
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row)
			{
				$company_email_name =  $row->company_name;
			}
		//var_dump($records); exit;
		//$this->load->view('manage/printQuotation', $records);
		// $this->load->view('general/quotations/printview1', $records);
		if($image_type=="with_image"){
			$records['image']	=	"with_image";
		}else{
			$records['image']	=	"without_image";
		}

		$this->db->select('item_specifications.item_id as item_id');
		$this->db->from('furniture_items');
		$this->db->join('items','items.id = furniture_items.item_id','inner');
		$this->db->join('item_specifications','item_specifications.item_id = items.id','inner');
		$this->db->where('furniture_items.quotation_id', $quotation_id); 
		$rs_new = $this->db->get();
		if($rs_new->num_rows() > 0){
			$records['is_enter_one_item'] = 0;
			$specific_count = $rs_new->result_array();
		}
		else{
			$records['is_enter_one_item'] = 1;
			$specific_count = array();
		}
		
		$this->db->select('sum(item_discount) as is_discount');
		$this->db->from('furniture_items');
		$this->db->where('furniture_items.quotation_id', $quotation_id); 
		$rs_new = $this->db->get();
		if($rs_new->num_rows() > 0){
			$specific_count = $rs_new->result_array();
			if($rs_new->result_array()[0]['is_discount']>0){
				$records['is_discount'] = 1;
			} else {
				$records['is_discount'] = 0;
			}
		}
		else{
			$records['is_discount'] = 0;
			$specific_count = array();
		}

		$where2=array(
			'qutation_id' => $quotation_id
		);
		
		$records['upload_files_print'] = $this->crud_model->get('upload_files_print',$where2, null,null,null,null,null,null);

		$this->db->select('*');
		$this->db->from('short_list_for_estmation');
		$this->db->where('short_list_for_estmation.quotation_number', $records['quotation_number']); 
		$rs_new2 = $this->db->get();
		if($rs_new2->num_rows() > 0){
			$records['short_list'] = $rs_new2->result_array();
		}
		else{
			$records['short_list'] = array();
		}

		if($records['quotation_type']!=3){
			$SQLxx = "SELECT quotation_id FROM furniture_items  where quotation_id='$quotation_id' And estimate_yes_or_no='No' ;";
			$psxx = $this->db->query($SQLxx);
			if($psxx->num_rows() > 0){
				
				$records['not_completed_bom']=1;
			}
			else{
				$records['not_completed_bom']=0;
			}
		} else {
			$records['not_completed_bom']=0;
		}


		$records['xxxx'] = $rs_new->num_rows();
		$records['chekval'] = $chekval;
		$records['without_sub'] = $without_sub;
		$records['without_group'] = $without_group;
		$records['without_vat']   = $without_vat;
		$records['print_status'] = $print_status;
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$records['controller'] = $this;
			//$this->load->helper(array('dompdf', 'file'));
			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10,
			]);
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			
			$header = $this->load->view('general/quotations/test_qtn_pdf_header', $datas , true);
			$html = $this->load->view('general/quotations/testpdf', $datas , true);
			$footer = $this->load->view('general/quotations/test_qtn_pdf_footer', $datas , true);
			

			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,5,39,25,10,4);
			$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();
			
			if($records['quotation_status']==='Closed'){
				$mpdf->SetWatermarkText('Closed');
				$mpdf->showWatermarkText = true;
			}
			
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename=ucfirst(strtolower($records['client_name'])).'-'.$records['quotation_number_full'].'.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');
		} if($type=="testpdf"){
			$records['controller'] = $this;
			$records['print_type'] = "pdf_print_type";
			//$this->load->helper(array('dompdf', 'file'));

			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10
			]);
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			
			$header = $this->load->view('general/quotations/test_qtn_pdf_header', $datas , true);
			$html = $this->load->view('general/quotations/testpdf', $datas , true);
			$footer = $this->load->view('general/quotations/test_qtn_pdf_footer', $datas , true);
			if($records['quotation_status']==='Draft'){
				$mpdf->SetWatermarkText('DRAFT');
				$mpdf->showWatermarkText = true;
			}
			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,5,39,25,10,4);
			$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename=$records['client_name'].'-'.$records['quotation_number_full'].'.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');
		} else if($type=="normal"){
			$records['print_type'] = "normal_print_type";
			$records['controller'] = $this;
			$this->load->view('general/quotations/printnormal_trio', $records);
		}else if($type=="forapprover"){
			$records['print_type'] = "normal_print_type";
			$this->load->view('general/quotations/forapprover', $records);
		} else if($type=="shortlist"){
				$records['print_type'] = "normal_print_type";
				$this->load->view('general/quotations/shortlist', $records);
		} else if($type=="proposalpdf"){
			$mpdf = new \Mpdf\Mpdf();
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type'); 
			//$html = $this->load->view('general/quotations/printQuotationPdf', $datas, true);
			//pdf_create($html, 'Quotation_No_'.$quotation_id);
			$html = $this->load->view('general/quotations/printQuotationPdf', $datas , true);
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if($type=="simplequotation"){

			$mpdf = new \Mpdf\Mpdf();
		$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			//$html = $this->load->view('general/quotations/printQuotationPdf', $datas, true);
			//pdf_create($html, 'Quotation_No_'.$quotation_id);
			
			$html = $this->load->view('general/quotations/simplequotation', $datas , true);
			
		$mpdf->WriteHTML($html);
        $mpdf->Output();
			
		} else if($type=="discountnormal"){
		$records['print_type'] = "normal_print_type";
		$this->load->view('general/quotations/discountnormal', $records);
		}else if($type=="linewisediscount"){
		$mpdf = new \Mpdf\Mpdf();
		$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
		$html = $this->load->view('general/quotations/printviewlinewisediscount', $datas , true);
		$mpdf->WriteHTML($html);
        $mpdf->Output();
		//$html = $this->load->view('general/quotations/printviewlinewisediscount', $records, true);
		}else if($type=="email"){
		
		$this->db->select('*');
		$this->db->from('emails'); 
		$query_email = $this->db->get();
		$records_email=$query_email->result_array();
		
		$records['print_type'] = "email_print_type";
		$this->load->helper(array('dompdf', 'file'));
		$html = $this->load->view('general/quotations/printview1', $records, true);
		pdf_create($html, 'Quotation_No_'.$quotation_id,$stream=FALSE);
				
				
				
				$from 		= $records['salesman_email_id'];
				$fromname 	= $company_email_name;
				if($records['project_contact_person_email']===''){
					$to 		= $records['client_email'];
				} else {
					$to 		= $records['project_contact_person_email'];
				}
				
				$cc 		= @$records_email[0]['quote_cc'];
				$subject 	= 'Quotation for '.$records['project_name'];
				$message 	= 'Please find attached quote for '.$records['project_name'].'.<br /><br /><br /> Regards,<br />'.$records['salesman_name'].'<br />'.$records['salesman_contact_number'];
				if($rs_new->num_rows() > 0 && $chekval==1){
				$this->load->library('email_multiple');
				$send = $this->email_multiple->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$quotation_id,$specific_count);
				}else{
				$this->load->library('email_attach');
				$send = $this->email_attach->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$quotation_id);
				}
				if($send){
					$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
				}else{
					$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
				}
				redirect('manage_quotation/quotation/'.$quotation_id.'/'.$records['division_id'].'/'.$records['quotation_number']);
		}
		 //if you want to write it to disk and/or send it as an attachment  
	}
	
	function saveLpoNO(){
		$data=array('lpono' => $this->input->post('lpono'));
		$where = array('id' => $this->input->post('quotation_id'));
		$this->crud_model->update('furniture_quotation',$data,$where);
		redirect('furniture/furniture_quotations');
	}
	
	function projectStatus(){
		$data=array('project_status' => $this->input->post('statusCheckbox'));
		$where = array('id' => $this->input->post('quotation_id'));
		$this->crud_model->update('furniture_quotation',$data,$where);
		$this->session->set_flashdata('response','Project Status Updated');
		redirect('manage_quotation/quotation/'.$this->input->post('quotation_id').'/'.$this->input->post('quotation_divisionid').'/'.$this->input->post('quotation_number'));
	}
	
	function upload_it()
    {  
	
		if($this->input->post('title')!=='' && $_FILES["fileField"]["name"]!=='' ){
        $this->load->helper('form');
        $uniqueID = $this->input->post('quotation_number');
		if(!file_exists("uploads/".$uniqueID))
       	 mkdir("uploads/".$uniqueID);
        $config['upload_path'] = 'uploads/'.$uniqueID;
        $config['allowed_types'] = '*';
		$config['overwrite'] = FALSE;
		$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->set_allowed_types('*');
        $this->upload->do_upload("fileField");
	    echo $this->upload->display_errors();
		$upload_data  =   $this->upload->data();
		$uploadImage = $upload_data['file_name'];
		$newdata = array(
						'title'=>$this->input->post('title'),
						'quotation_number'=>$this->input->post('quotation_number'),
						'division_id'=>$this->input->post('quotation_division'),
						'qutation_id'=>$this->input->post('quotation_id_redrct'),
						'user_id'=>$this->session->userdata('user_id'),
						'file_name'=>$uploadImage,
					);
		 $add_file = $this->db->insert('upload_files', $newdata); 
		 if($add_file){
		 	$this->session->set_flashdata('success','File Uploaded Successfully...');
		 }else{
		 	$this->session->set_flashdata('response','Something Wrong.Try Again...');
		 }
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	     redirect('manage_quotation/quotation/'.$this->input->post('quotation_id_redrct').'/'.$this->input->post('quotation_division').'/'.$this->input->post('quotation_number').'');
	  // exit;
        
	}

	public function pickDesigner($qutation_id){
		$this->db->trans_begin();
		$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and trans_user_id is NULL order by `id` desc limit 0,1");
		if($query->row()){
			$where = array('id'	=> $qutation_id);	
			$data_quo['status'] = $query->row()->flow_id;								
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
			
			$user_id = $this->session->userdata('user_id');
			$query = $this->db->query("UPDATE `log_for_quotation` SET `trans_user_id`='$user_id' WHERE `trans_id`='$qutation_id' and trans_user_id is NULL ");
			$this->db->trans_commit();
			$this->session->set_flashdata('success','The quotation has been Picked.',':old:');
			redirect('dashboard/designer_dashboard');
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Already Picked..');
			redirect('dashboard/designer_dashboard');
		}
	}

	public function approveEstimator($qutation_id){
		$this->db->trans_begin();
		$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and trans_user_id is NULL order by `id` desc limit 0,1");
		if($query->row()){
			$where = array('id'	=> $qutation_id);	
			$data_quo['status'] = 3;								
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
			
			$user_id = $this->session->userdata('user_id');
			$query = $this->db->query("UPDATE `log_for_quotation` SET `trans_user_id`='$user_id' WHERE `trans_id`='$qutation_id' and trans_user_id is NULL ");

			$group_by=1;
			$query2 = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and group_by='$group_by'");
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $qutation_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Transfer',
				'flow_id'  		=>  3,
				'trans_date'  	=>  date('Y-m-d h:m:s'),
				'group_by'  	=>  $group_by,
				'trans_user_id' =>  $query2->row()->trans_user_id

			);
			$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);
			
			$this->db->trans_commit();
			$this->session->set_flashdata('success','The quotation has been Approved.',':old:');
			redirect('dashboard/estimator_dashboard');
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Already Approved..');
			redirect('dashboard/estimator_dashboard');
		}
	}
	
	public function pickEstimator($qutation_id){
		$this->db->trans_begin();
		$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and trans_user_id is NULL order by `id` desc limit 0,1");
		if($query->row()){
			$where = array('id'	=> $qutation_id);	
			$data_quo['status'] = $query->row()->flow_id;								
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
			
			$user_id = $this->session->userdata('user_id');
			$query = $this->db->query("UPDATE `log_for_quotation` SET `trans_user_id`='$user_id' WHERE `trans_id`='$qutation_id' and trans_user_id is NULL ");
			$this->db->trans_commit();
			$this->session->set_flashdata('success','The quotation has been Picked.',':old:');
			redirect('dashboard/estimator_dashboard');
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Already Picked..');
			redirect('dashboard/estimator_dashboard');
		}
	}

	public function pickApprover($qutation_id){
		$this->db->trans_begin();
		$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and trans_user_id is NULL order by `id` desc limit 0,1");
		if($query->row()){
			$where = array('id'	=> $qutation_id);	
			$data_quo['status'] = $query->row()->flow_id;								
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
			
			$user_id = $this->session->userdata('user_id');
			$query = $this->db->query("UPDATE `log_for_quotation` SET `trans_user_id`='$user_id' WHERE `trans_id`='$qutation_id' and trans_user_id is NULL ");
			$this->db->trans_commit();
			$this->session->set_flashdata('success','The quotation has been Picked.',':old:');
			redirect('dashboard/approver_dashboard');
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Already Picked..');
			redirect('dashboard/approver_dashboard');
		}
	}

	public function changeStatus($id,$group_by,$status,$qutation_id,$division_id,$quotation_number,$quotation_status,$quotation_number_full){
		//$this->db->where('id',$id);
		//$this->db->delete('upload_files');
		$this->session->keep_flashdata('response');
		$where = array('id'	=> $qutation_id);	
		if($status!=$quotation_status){
			if($status==='Confirmed'){
				$data_quo["quotation_confirmationdate"] = date('Y-m-d h:m:s');
			}
			$data_quo['quotation_status'] = $status;	
			$data_quo['status'] = $id;									
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
		} else {
			$data_quo['status'] = $id;								
			$this->crud_model->update('furniture_quotation',$data_quo,$where);
		}

		if($group_by==1){
			$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and group_by='$group_by'");
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $qutation_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Transfer',
				'flow_id'  		=>  $id,
				'trans_date'  	=>  date('Y-m-d h:m:s'),
				'group_by'  	=>  $group_by,
				'trans_user_id' =>  $query->row()->trans_user_id

			);
			$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);
		} else {

			$queryxx=$this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and trans_user_id is not null and group_by='$group_by'");
			if($queryxx->row() != false){
				$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$qutation_id' and group_by='$group_by'");
				$log_for_quotationg_data=array(
					'trans_id'  	=>  $qutation_id,
					'trans_type'  	=>  'Quotation',
					'trans_action'  =>  'Transfer',
					'flow_id'  		=>  $id,
					'trans_date'  	=>  date('Y-m-d h:m:s'),
					'group_by'  	=>  $group_by,
					'trans_user_id' =>  $query->row()->trans_user_id

				);
				$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);
			} else {
			
				$log_for_quotationg_data=array(
					'trans_id'  	=> $qutation_id,
					'trans_type'  	=> 'Quotation',
					'trans_action'  => 'Pick',
					'flow_id'  		=> $id,
					'trans_date'  	=> date('Y-m-d h:m:s'),
					'group_by'  	=> $group_by,
					'trans_user_id' => NULL
				);
				$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);
			}
		}
		$log_data=array(
			'trans_no'  =>  $quotation_number_full,
			'trans_type'  =>  'Quotation',
			'trans_op'  =>  'Edit',
			'trans_user_id'  =>  $this->session->userdata('user_id')
		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		$this->session->set_flashdata('success','Updated..');
		if($status==='Confirmed'){
			redirect('manage_quotation/quotation/'.$qutation_id.'/'.$division_id.'/'.$quotation_number.'');
		} else {
			//redirect('Dashboard/home');
			redirect('manage_quotation/quotation/'.$qutation_id.'/'.$division_id.'/'.$quotation_number.'');
		}
	}

	public function delete($id,$quotation_number,$division_id,$qutation_id){
		$this->db->where('id',$id);
		$this->db->delete('upload_files');
		$this->session->set_flashdata('response','File Deleted...');
		redirect('manage_quotation/quotation/'.$qutation_id.'/'.$division_id.'/'.$quotation_number.'');
	}
	function delivery_date_update(){
		$this->form_validation->set_rules('delivery_date', 'Delivery Date', 'required');
		$delivery_quotation_id = $this->input->post('delivery_quotation_id');
		$delivery_quotation_number = $this->input->post('delivery_quotation_number');
		$delivery_quotation_division = $this->input->post('delivery_quotation_division');
		//echo $this->input->post('delivery_date').'-'.date('m/d/Y');
		//break;
		if ($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Delivery Date Required</div>');
			redirect('manage_quotation/quotation/'.$delivery_quotation_id.'/'.$delivery_quotation_division.'/'.$delivery_quotation_number.'');
		}else if(strtotime($this->input->post('delivery_date'))< strtotime(date('m/d/Y'))){
			$this->session->set_flashdata('response','<div class="alert alert-error">Invalid Delivery Date</div>');
			redirect('manage_quotation/quotation/'.$delivery_quotation_id.'/'.$delivery_quotation_division.'/'.$delivery_quotation_number.'');
		}else {
		$where = array('id'	=> $delivery_quotation_id);
		$date = DateTime::createFromFormat('m/d/Y', $this->input->post('delivery_date'));
		$data_quo['delivery_date'] = $date->format('Y-m-d');									
		$rr_quo = $this->db->update('furniture_quotation',$data_quo,$where);
		if($rr_quo){
		 	$this->session->set_flashdata('response','<div class="alert alert-success">Delivery Date Updated Successfully</div>');
		 }else{
		 	$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
		 }
		 redirect('manage_quotation/quotation/'.$delivery_quotation_id.'/'.$delivery_quotation_division.'/'.$delivery_quotation_number.'');
		 }
	}
	public function duplicateQuotation($rna_id='',$rna_div='',$rna_quotation_number=''){
		$this->users_model->permission("Quotation", "Add");
		if($rna_id!='' && $rna_div!=''){
			 	$new_quotation_number= $this->furniture_quotation_model->get_new_quotation_number($rna_div);
				$where=array('furniture_quotation.id' => $rna_id);
				$na_records= $this->crud_model->get("furniture_quotation",$where);
				if($na_records != false){
					$division_dbdata = $this->EnquiryModel->company_division($na_records[0]['quotation_divisionid']);
					$qtnmr=$division_dbdata.'-'.$new_quotation_number;
						//foreach($na_records as $na_records){
					$data = array(									
						'quotation_number'			=> $new_quotation_number,
						'quotation_number_full' 	=> $qtnmr.'-0',	
						'quotation_revisionnumber'  => 0,
						'quotation_date'			=> date('Y-m-d h:m:s'),
						'quotation_divisionid'  	=> $na_records[0]['quotation_divisionid'],
						'quotation_currencyid' 		=> $na_records[0]['quotation_currencyid'],
						'salesman_id'				=> $na_records[0]['salesman_id'],
						'client_id'					=> $na_records[0]['client_id'],
						'contact_id'				=> $na_records[0]['contact_id'],
						'project_name'				=> $na_records[0]['project_name'],
						'project_location'			=> $na_records[0]['project_location'],
						'project_remarks'			=> $na_records[0]['project_remarks'],
						'quotation_total'			=> $na_records[0]['quotation_total'],
						'quotation_vat_percentage'	=> $na_records[0]['quotation_vat_percentage'],
						'quotation_vat_amount'		=> $na_records[0]['quotation_vat_amount'],
						'quotation_amount_with_vat'	=> $na_records[0]['quotation_amount_with_vat'],
						'quotation_discount'		=> $na_records[0]['quotation_discount'],
						'exstock_paymenttermid'		=> $na_records[0]['exstock_paymenttermid'],
						'byorder_paymenttermid'		=> $na_records[0]['byorder_paymenttermid'],
						'quotation_logos'			=> $na_records[0]['quotation_logos'],
						'covering_letter'			=> '',
						'terms_and_conditions'		=> '',
						'quotation_status'			=> 'Draft',
						'status'					=> '3',
						'enquiry_id'    			=> $na_records[0]['enquiry_id'],
						'quotation_type'    		=> $na_records[0]['quotation_type'],
						'last_modified_by' 			=> $this->session->userdata('user_id'),
						'last_modified_date'		=> date('Y-m-d h:m:s')
					);
					$this->crud_model->insert('furniture_quotation',$data);
					$new_quotation_id = $this->db->insert_id();
					$log_data=array(
						'trans_no'  	=>  $qtnmr.'-0',
						'trans_type'  	=>  'Quotation',
						'trans_op'  	=>  'Duplicate',
						'trans_user_id'  =>  $this->session->userdata('user_id')
					);
					$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
					$log_for_quotation_data=array(
						'trans_id'  	=>  $new_quotation_id,
						'trans_type'  	=>  'Quotation',
						'trans_action'  =>  'Create',
						'flow_id'  		=>  1,
						'group_by'  	=>  1,
						'trans_user_id' =>  $this->session->userdata('user_id')
					);
					$log_for_quotation=$this->crud_model->insert('log_for_quotation',$log_for_quotation_data);
						
					$rs = $this->crud_model->get('furniture_items',array('quotation_id'=>$rna_id), null, null, "furniture_id", "ASC");
					if($rs != false){
						foreach($rs as $furniture_item ) {
							$data = array(
								'quotation_id'			=> $new_quotation_id,
								'furniture_reference'	=> $furniture_item['furniture_reference'],
								'furniture_brand'		=> $furniture_item['furniture_brand'],
								'furniture_brand_other'	=> $furniture_item['furniture_brand_other'],
								'furniture_area'		=> $furniture_item['furniture_area'],
								'ex_furniture_area'		=> $furniture_item['ex_furniture_area'],
								'sub_group'				=> $furniture_item['sub_group'],
								'sub_group_id'			=> $furniture_item['sub_group_id'],
								'item_order'			=> $furniture_item['item_order'],
								'item_id'				=> $furniture_item['item_id'],
								'furniture_model'		=> $furniture_item['furniture_model'],
								'furniture_description'	=> $furniture_item['furniture_description'],
								'furniture_upholstery'	=> $furniture_item['furniture_upholstery'],
								'furniture_unitprice'	=> $furniture_item['furniture_unitprice'],
								'furniture_quantity'	=> $furniture_item['furniture_quantity'],
								'furniture_type'		=> $furniture_item['furniture_type'],
								'furniture_height'		=> $furniture_item['furniture_height'],
								'furniture_width'		=> $furniture_item['furniture_width'],
								'furniture_uom'			=> $furniture_item['furniture_uom'],
								'furniture_ratem2'		=> $furniture_item['furniture_ratem2'],
								'furniture_stock_type'	=> $furniture_item['furniture_stock_type'],
								'category'				=> $furniture_item['category'],
								'fabric_width'			=> $furniture_item['fabric_width'],
								'gathering'				=> $furniture_item['gathering'],
								'uom'					=> $furniture_item['uom'],
								'comments'				=> $furniture_item['comments'],
								'vat_perce'				=> $furniture_item['vat_perce'],
								'vat_amount'			=> $furniture_item['vat_amount'],
								'item_discount'			=> $furniture_item['item_discount'],
								'total_discount'		=> $furniture_item['total_discount'],
								'net_amount'			=> $furniture_item['net_amount'],
								'is_optional'			=> $furniture_item['is_optional'],
								'furniture_comments'	=> $furniture_item['furniture_comments'],
								'image'					=> $furniture_item['image'],
								'estimate_yes_or_no'	=> $furniture_item['estimate_yes_or_no'],
								'total_cost_including_overhead'	=> $furniture_item['total_cost_including_overhead']
							);
							$this->crud_model->insert('furniture_items',$data);
							$new_furniture_id = $this->db->insert_id();
							$this->copyEstimation($new_quotation_id,$new_furniture_id,$furniture_item['furniture_id'],$new_quotation_number,$na_records[0]['quotation_divisionid']);
						}

						$short_list_for_data = $this->crud_model->get('short_list_for_estmation',array('quotation_number'=>$na_records[0]['quotation_number']));
						if($short_list_for_data!=false){
							foreach($short_list_for_data as $row6){
								$shorts_data=array(
									'quotation_number'=> $new_quotation_number,
									'item_id' 		  => $row6['item_id'],
									'item_name'  	  => $row6['item_name'],
									'item_description'=> $row6['item_description'],
									'unit' 			  => $row6['unit'],
									'cost_price' 	  => $row6['cost_price'],
								);
								$this->db->insert('short_list_for_estmation', $shorts_data);
							}
						}

					}
					$this->session->set_flashdata('success','Quotation replicated successfully...');
					redirect('furniture/furniture_quotations');
				}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again');
			redirect('furniture/furniture_quotations');
		}
	}

	public function copyEstimation($quotation_id=NULL,$furniture_id=NULL,$selected_furniture_id=NULL,$quotation_number=NULL,$division_id=NULL){
		//$quotation_number = $this->input->post('quotation_number');
		//$division_id = $this->input->post('division_id');
		if ($quotation_id!='' && $furniture_id!='' && $selected_furniture_id!=''){
			//$this->db->trans_begin();
			
			$datarow					= $this->furniture_quotation_model->itemWiseDatarow($furniture_id);
			$estimation 				= $this->furniture_quotation_model->estimation($selected_furniture_id);
			$estimationMaterialsAdded 	= $this->furniture_quotation_model->estimationMaterialsAdded($selected_furniture_id);
			$estimationLabourCostAdded 	= $this->furniture_quotation_model->estimationLabourCostAdded($selected_furniture_id);
			$estimationSubContractAdded = $this->furniture_quotation_model->estimationSubContractAdded($selected_furniture_id);
			$estimationHiringAdded 		= $this->furniture_quotation_model->estimationHiringAdded($selected_furniture_id);
			$estimationOthersAdded 		= $this->furniture_quotation_model->estimationOthersAdded($selected_furniture_id);

			

			$where=array(
				'furniture_id'=> $furniture_id
			);

			$this->crud_model->delete('estimation',$where);
			$this->crud_model->delete('estimation_material',$where);
			$this->crud_model->delete('estimation_labourcost',$where);
			$this->crud_model->delete('estimation_subcontract',$where);
			$this->crud_model->delete('estimation_hiring',$where);
			$this->crud_model->delete('estimation_others',$where);

			$boq_no =  $this->furniture_quotation_model->get_boq_no($furniture_id,$division_id,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');

			if($estimation!=FALSE){
				$summary_data=array(
					'boq_no'   			=>  $boq_no,
					'furniture_id' 		=>  $furniture_id,
					'material'  		=>  $estimation['material'],
					'labourCost'   		=>  $estimation['labourCost'],
					'subcontract'   	=>  $estimation['subcontract'],
					'hiring'   			=>  $estimation['hiring'],
					'others'  			=>  $estimation['others'],
					'materialperce'  	=>  $estimation['materialperce'],
					'labourCostperce'   =>  $estimation['labourCostperce'],
					'subcontractperce'  =>  $estimation['subcontractperce'],
					'hiringperce'   	=>  $estimation['hiringperce'],
					'othersperce'  		=>  $estimation['othersperce'],
					'profitperce'  		=>  $estimation['profitperce'],
					'selling_price'  	=>  $estimation['selling_price'],
					'user_id'  			=>  $user_id
				);
				$this->db->insert('estimation', $summary_data);
			}
			
			if($estimationMaterialsAdded!=FALSE){
				foreach($estimationMaterialsAdded as $row){
					$material_data=array(
						'boq_no'   			=>  $boq_no,
						'furniture_id' 		=>  $furniture_id,
						'item_id'  			=>  $row['item_id'],
						'item_name'   		=>  $row['item_name'],
						'item_description'  =>  $row['item_description'],
						'material_qty'   	=>  $row['material_qty'],
						'material_uom'  	=>  $row['material_uom'],
						'material_unitprice'=>  $row['material_unitprice'],
						'material_total'   	=>  $row['material_total'],
						'user_id'  			=>  $user_id
					);
					$this->db->insert('estimation_material', $material_data);
				}
			}

			if($estimationLabourCostAdded!=FALSE){
				foreach($estimationLabourCostAdded as $row2){
					$labour_data=array(
						'boq_no'   				=>  $boq_no,
						'furniture_id' 			=>  $furniture_id,
						'labour_department'  	=>  $row2['labour_department'],
						'labour_no_of_ppl'   	=>  $row2['labour_no_of_ppl'],
						'labour_hours'  		=>  $row2['labour_hours'],
						'labour_total_man_hours'=>  $row2['labour_total_man_hours'],
						'labour_rate'  			=>  $row2['labour_rate'],
						'labour_total_amount'	=>  $row2['labour_total_amount'],
						'user_id'  				=>  $user_id
					);
					$this->db->insert('estimation_labourcost', $labour_data);
				}
			}

			if($estimationSubContractAdded!=FALSE){
				foreach($estimationSubContractAdded as $row3){
					$subcontract_data=array(
						'boq_no'   				=>  $boq_no,
						'furniture_id' 			=>  $furniture_id,
						'subcontract_vendor'  	=>  $row3['subcontract_vendor'],
						'subcontract_work_type' =>  $row3['subcontract_work_type'],
						'subcontract_amount'  	=>  $row3['subcontract_amount'],
						'user_id'  				=>  $user_id
					);
					$this->db->insert('estimation_subcontract', $subcontract_data);
				}
			}

			if($estimationHiringAdded!=FALSE){
				foreach($estimationHiringAdded as $row4){
					$hiring_data=array(
						'boq_no'   			=>  $boq_no,
						'furniture_id' 		=>  $furniture_id,
						'hiring_vendor'  	=>  $row4['hiring_vendor'],
						'hiring_work_type' 	=>  $row4['hiring_work_type'],
						'hiring_amount'  	=>  $row4['hiring_amount'],
						'user_id'  			=>  $user_id
					);
					$this->db->insert('estimation_hiring', $hiring_data);
				}
			}

			if($estimationOthersAdded!=FALSE){
				foreach($estimationOthersAdded as $row5){
					$others_data=array(
						'boq_no'   			=>  $boq_no,
						'furniture_id' 		=>  $furniture_id,
						'others_vendor'  	=>  $row5['others_vendor'],
						'others_work_type' 	=>  $row5['others_work_type'],
						'others_amount'  	=>  $row5['others_amount'],
						'user_id'  			=>  $user_id
					);
					$this->db->insert('estimation_others', $others_data);
				}
			}
			
			/*$a=$estimation['material']+($estimation['material']*($estimation['materialperce']/100));
			$b=$estimation['labourCost']+($estimation['labourCost']*($estimation['labourCostperce']/100));
			$c=$estimation['subcontract']+($estimation['subcontract']*($estimation['subcontractperce']/100));
			$d=$estimation['hiring']+($estimation['hiring']*($estimation['hiringperce']/100));
			$e=$estimation['others']+($estimation['others']*($estimation['othersperce']/100));

			 $data2=array(
				'furniture_unitprice'   =>  $estimation['selling_price'],
				'vat_amount'   			=>  $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100),
				'net_amount'   			=>  ($estimation['selling_price']* $datarow['furniture_quantity'])+( $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100)),
				'item_discount'   		=>  0,
				'total_discount'   		=>  0,
				'estimate_yes_or_no'	=> 'Yes',
				'total_cost_including_overhead'	=> $a+$b+$c+$d+$e
			);
			$this->db->where('furniture_id', $furniture_id);
			$this->db->update('furniture_items', $data2);

			$this->furniture_quotation_model->update_quotation_total($quotation_id); */

		}
	}

	public function update_common_comments($quotation_id){
		$where=array(
			'id'      => $quotation_id
		);
		$data=array(
			'common_comments'	=> $this->input->post('common_comments')
		);
		$this->crud_model->update('furniture_quotation',$data,$where );
		redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
	}
	public function update_item_comments($quotation_id,$furniture_id){
		$where=array(
			'furniture_id'      => $furniture_id
		);
		$loop_count=$this->input->post('comments');
		for($i=0; $i<count($loop_count); $i++){
			if($loop_count[$i]!=''){ 
				$data=array(
					'comments'	=> $loop_count[$i],
					'comment_flag'	=> 'Yes'
				);
				$this->crud_model->update('furniture_items',$data,$where );
			}
		}
		
		redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
	}

	public function updateQty($quotation_id,$furniture_id){
		$furniture_quantity=$this->input->post('furniture_quantity');
		if($furniture_quantity!='' && $quotation_id!='' && $furniture_id!=''){
			$where=array(
				'furniture_id'      => $furniture_id
			);

			$records=$this->crud_model->get('furniture_items',$where);
			if($records!=false){
				$amount= round($records[0]['furniture_unitprice']*$furniture_quantity,3);
				$rrr	=$records[0]['vat_perce']/100;
				$data=array(
					'furniture_quantity'	=> $furniture_quantity,
					'vat_amount'			=> ($amount)*$rrr,
					'net_amount'			=> ($amount)+(($amount)*$rrr)
				);
				$this->crud_model->update('furniture_items',$data,$where );
				$this->furniture_quotation_model->update_quotation_total($quotation_id);
				redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
			} else {
				redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
			}
		} else {
			redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0'); 
		}
	}

	public function updateItem($quotation_id,$furniture_id){
		$furniture_model=$this->input->post('furniture_model');
		$item_id=$this->input->post('item_id');
		if($furniture_model!=''){
			$where=array(
				'furniture_id'      => $furniture_id
			);

			$data=array(
				'furniture_model' => $furniture_model,
				'item_id'		  => $item_id
			);
			$this->crud_model->update('furniture_items',$data,$where );
			$this->furniture_quotation_model->update_quotation_total($quotation_id);
			redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
			
		} else {
			redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0'); 
		}
	}

	public function updateDescription($quotation_id,$furniture_id){
		$furniture_description=$this->input->post('furniture_description');
		if($furniture_description!=''){
			$where=array(
				'furniture_id'      => $furniture_id
			);

			if($this->input->post('furniture_description')==='<p><br></p>'){
				$furniture_description	=	"";
				
			} else {
				$furniture_description	=	str_replace('<p><br></p>', '', trim($this->input->post('furniture_description')));
			}

			$data=array(
				'furniture_description' => $furniture_description
			);
			$this->crud_model->update('furniture_items',$data,$where );
			//$this->furniture_quotation_model->update_quotation_total($quotation_id);
			redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
			
		} else {
			redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0'); 
		}
	}

	public function update_item_rate($quotation_id,$furniture_id){
		$where=array(
			'furniture_id'      => $furniture_id
		);
		$loop_count=$this->input->post('rate');
		$qty=$this->input->post('qty');
		$vat_perce=$this->input->post('vat_perce');
		for($i=0; $i<count($loop_count); $i++){
			if($loop_count[$i]!=''){ 
				$rrr	=$vat_perce[$i]/100;
				$data=array(
					'furniture_unitprice' => $loop_count[$i],
					'vat_amount'		  => ($loop_count[$i]*$qty[$i])*$rrr,
					'net_amount'		  => ($loop_count[$i]*$qty[$i])+(($loop_count[$i]*$qty[$i])*$rrr)
				);
				$this->crud_model->update('furniture_items',$data,$where );
				$estmn_data=array(
					'selling_price'	=> $loop_count[$i],
				);
				$this->crud_model->update('estimation',$estmn_data,$where );
			}
		}
		$this->furniture_quotation_model->update_quotation_total($quotation_id);
		redirect('Manage_quotation/printQuotation/'.$quotation_id.'/forapprover/without_image/0/0/0/0');
	}
	
	public function printEstimationSheet($selected_furniture_id){
		$mpdf = new \Mpdf\Mpdf();
		$datarow=$this->furniture_quotation_model->itemWiseDatarow($selected_furniture_id);
		$estimation 				=  $this->furniture_quotation_model->estimation($selected_furniture_id);
		$estimationMaterialsAdded 	=  $this->furniture_quotation_model->estimationMaterialsAdded($selected_furniture_id);
		$estimationLabourCostAdded 	=  $this->furniture_quotation_model->estimationLabourCostAdded($selected_furniture_id);
		$estimationSubContractAdded =  $this->furniture_quotation_model->estimationSubContractAdded($selected_furniture_id);
		$estimationHiringAdded 		=  $this->furniture_quotation_model->estimationHiringAdded($selected_furniture_id);
		$estimationOthersAdded 		=  $this->furniture_quotation_model->estimationOthersAdded($selected_furniture_id);

		$quotation_details = $this->furniture_quotation_model->itemWiseDatarow($selected_furniture_id);
		
		$datas['records']=$quotation_details;
		
		$datas['estimation'] 				= $estimation;
		$datas['estimationMaterialsAdded'] 	= $estimationMaterialsAdded;
		$datas['estimationLabourCostAdded'] 	= $estimationLabourCostAdded;
		$datas['estimationSubContractAdded'] = $estimationSubContractAdded;
		$datas['estimationHiringAdded'] 		= $estimationHiringAdded;
		$datas['estimationOthersAdded'] 		= $estimationOthersAdded;
		
		$datas['boq_no']				= $estimation['boq_no'];
		$datas['overhead'] 		=  $this->furniture_quotation_model->overhead();

		$uniqueID='QtnEstimation';
		if(!file_exists("pdfexport/".$uniqueID)) {
       		mkdir("pdfexport/".$uniqueID);
		}

		$mpdf->setFooter("Page {PAGENO} of {nb}");
		$html = $this->load->view('general/quotations/printEstimationSheet', $datas , true);
		$aaa=	str_replace("/","_",$estimation['boq_no']);
		$mpdf->WriteHTML($html);
		//$filename = __DIR__ . '/../../../pdfexport/'.$uniqueID.'/'.$aaa.'.pdf';
		//$mpdf->Output($filename, 'F');
		$mpdf->Output(''.$estimation['boq_no'].'.pdf','I');
	}

	public function close_quotation(){
		if($this->input->post('re_quotation')!==''){
			$data["reason_forclose"] = 	$this->input->post('reason_forclose');
			$data["quotation_status"] = 'Closed';
			$data["last_modified_by"] = $this->session->userdata('user_id');
			$data["last_modified_date"] = date('Y-m-d h:m:s');
			$where=array('id'	=> $this->input->post('re_quotation'));
			$this->crud_model->update('furniture_quotation',$data,$where);

			$log_data=array(
				'trans_no'  	=>  $this->input->post('quotation_number'),
				'trans_type'  	=>  'Quotation',
				'trans_op'  	=>  'Delete',
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$this->session->set_flashdata('success','Quotation closed successfully...');
			redirect('furniture/furniture_quotations/quotationList');
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again');
			redirect('furniture/furniture_quotations/quotationList');
		}
	}

}
?>