<?php
class company_details extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}
	function index($page=1)	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('admin/company_details/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('company_details',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('company_details',array(),$config['per_page'],$offset);
		
		$data['records_count'] = $this->crud_model->get_count('company_details',array());
		
		/*for($i=0; $i<sizeof($data['records']); $i++) {
			$main_category_id = $data['records'][$i]["id"];
			$where=array(
				'main_category'=> $main_category_id
			);
			$search_sub_category=$this->crud_model->get('sub_category',$where);
			if($search_sub_category) {
				$data['records'][$i]["hide_flag"] = 1;
			}			
		}*/
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('templates/header');
		$this->load->view('admin/company_details/list_company_details',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->load->view('templates/header');
		$this->load->view('admin/company_details/create_company_details');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$where=array(
				'company_id' => $id
		);
		$records=$this->crud_model->get('company_details',$where);
		if($records != false){
			//true section
			$data['company_id']			 	 = $records[0]['company_id'];
			$data['company_name']			 = $records[0]['company_name'];
			$data['cr_number']			 	 = $records[0]['cr_number'];
			$data['company_address']		 = $records[0]['company_address'];
			$data['telephone_no']			 = $records[0]['telephone_no'];
			$data['fax_no']			 		 = $records[0]['fax_no'];
			$data['email_id']				 = $records[0]['email_id'];
			$data['other_details']			 = $records[0]['other_details'];
			$data['company_logo']			 = $records[0]['company_logo'];
		
			$this->load->view('templates/header');
			$this->load->view('admin/company_details/edit_company_details',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">Error</div>');
			redirect('admin/company_details');
		}
	}
	function do_insert() {
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('company_name', 'Company Name', 'required|max_length[100]');
//		$this->form_validation->set_rules('address', 'Address', 'required');
//		$this->form_validation->set_rules('email', 'Email Id', 'required');
		
		$this->db->select('*');
		$this->db->from('company_details');
		$up_data_new = $this->db->get();
		
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/company_logo";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		
		
		$this->load->library('upload', $config);
		
		

		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = $up_data["upload_data"]["file_name"];
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('admin/company_details/create_company_details');
			$this->load->view('templates/footer');
		}else if($up_data_new->num_rows() == 1){
			$this->session->set_flashdata('response','<div class="alert alert-error">sorry...already a company exist.</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('admin/company_details/create_company_details');
			$this->load->view('templates/footer');
		}elseif($file_error) {
			$this->session->set_flashdata('response',"<div class='alert alert-error'>Allowed File Types : jpeg, jpg, png, gif</div>",':old:');
			$this->load->view('templates/header');
			$this->load->view('admin/company_details/create_company_details');
			$this->load->view('templates/footer');			
			
		} else {	// true section

				$data=array('company_name' => $this->input->post('company_name'),
							'cr_number' => $this->input->post('cr_number'),
							'company_address' => $this->input->post('address'),
							'telephone_no' => $this->input->post('telephone_no'),
							'fax_no' => $this->input->post('fax_no'),
							'email_id' => $this->input->post('email'),
							'other_details' => $this->input->post('other_details'),
							'company_logo' => $filename
				);

				$rr=$this->crud_model->insert('company_details',$data);
			
			
			if($rr == false) {
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Company Details cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('admin\company_details');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Company Details added successfully</div>');
				redirect('admin\company_details');

			}
		}

	}

	function do_update() {
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('company_name', 'Company Name', 'required|max_length[100]');
//		$this->form_validation->set_rules('address', 'Address', 'required');
//		$this->form_validation->set_rules('email', 'Email Id', 'required');
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/company_logo";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		
		
		$this->load->library('upload', $config);
		
		

		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = $up_data["upload_data"]["file_name"];
		}else{
			$filename = $this->input->post('image_item');
		}
		if ($this->form_validation->run() == FALSE) {
			// false section
			$company_id = $this->input->post('company_id');
			$where=array("company_id"=>$company_id);
					
			$records=$this->crud_model->get('company_details', $where);
			if($records != false){
				//true section
				$data['company_id']			 	 = $records[0]['company_id'];
				$data['company_name']			 = $records[0]['company_name'];
				$data['cr_number']			 	 = $records[0]['cr_number'];
				$data['company_address']		 = $records[0]['company_address'];
				$data['telephone_no']			 = $records[0]['telephone_no'];
				$data['fax_no']			 		 = $records[0]['fax_no'];
				$data['email_id']				 = $records[0]['email_id'];
				$data['other_details']			 = $records[0]['other_details'];
				$data['company_logo']			 = $records[0]['company_logo'];
			
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('admin/company_details/edit_company_details',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">Error</div>');
				redirect('admin/company_details');
			}
		}else {// true section

			$where=array(
				'company_id'  => $this->input->post('company_id')
			);
			$data=array('company_name' => $this->input->post('company_name'),
							'cr_number' => $this->input->post('cr_number'),
							'company_address' => $this->input->post('address'),
							'telephone_no' => $this->input->post('telephone_no'),
							'fax_no' => $this->input->post('fax_no'),
							'email_id' => $this->input->post('email'),
							'other_details' => $this->input->post('other_details'),
							'company_logo' => $filename
				);

			$records=$this->crud_model->update('company_details',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Company Details updated successfully</div>');
			redirect('admin\company_details');

		}
	}
	function do_delete($id=0) {

		/*$where=array(
			'id'=> $id
		);*/
		
		//$records=$this->crud_model->get('view_furniture_quotations_client_project_users', $where);
		
		//if(!$records) {
			$where=array(
				'company_id'=> $id
			);
			$records=$this->crud_model->get('company_details',$where);
			$filename = $records[0]["company_logo"];
			unlink(FCPATH."images/company_logo/".$filename);
			$this->crud_model->delete('company_details',$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Company Details deleted</div>');
			redirect('admin/company_details');
		/*} else {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry. You cannot delete a division that is used in the existing quotations.</div>');
			redirect('masters/company_division');
		}*/
	}
	function sub_category() {
		$sub_category_name =  $this->input->post('sub_category');
		$list = $this->crud_model->get_list('sub_id','sub_category_name','sub_category',array('select'=>' - Select - '),array('main_category'=>$sub_category_name));
		$js = 'id="textfield3", class="input-inner-new" style="height: 42px; width: 320px;"';
		$output = form_dropdown('textfield3', $list,'',$js);
    	echo $output;
		//echo $data;
	}
}
