<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
 class Furniture_Full_Details extends CI_Controller {

		function Furniture_Full_Details() {
	
			parent::__construct();
	
			if($this->session->userdata('user_logged_in') != true) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
				redirect('login');
			}
			
			$this->load->library('form_validation');
			$this->load->model('furniture_quotation_model');
			$this->load->helper('cookie');
			
		}
	
		function index($quotation_id) { 	
			if(!(isset($quotation_id))){
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
			}
			
			$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
			if($quotation_details == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
			}
			
			
			if($quotation_details['quotation_status']=="Draft" || $quotation_details['quotation_status']=="Open"){
				$this->session->set_flashdata('response','<div class="alert alert-error">Quotation is not in Confirmed or Closed Status.</div>');
				redirect('furniture/furniture_quotations');
			}
			
			$data['quotation_id'] = $quotation_id;
			
			
			// Get the details of Qutotation
			$data['quotation_id'] = $quotation_id;
			$data['quotation_number_full'] = $quotation_details['quotation_number_full'];
			$data['quotation_status'] = $quotation_details['quotation_status'];
			$data['quotation_date'] = $quotation_details['quotation_date'];
			$data['quotation_confirmationdate'] = $quotation_details['quotation_confirmationdate'];
			$data['division_code'] = $quotation_details['division_code'];
			$data['division_name'] = $quotation_details['division_name'];
			$data['currency_code'] = $quotation_details['currency_code'];
			$data['currency_name'] = $quotation_details['currency_name'];
			$data['quotation_total'] = $quotation_details['quotation_total'];
			$data['discount_percentage'] = $quotation_details['discount_percentage'];
			$data['quotation_discount_amount'] = $quotation_details['quotation_discount_amount'];
			$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
			$data['last_modified_by'] = $quotation_details['last_modified_by'];
			$data['last_modified_date'] = $quotation_details['last_modified_date'];
			$data['covering_letter'] = $quotation_details['covering_letter'];
			$data['quotation_logos'] = $quotation_details['quotation_logos'];
			$data['exstock_payment_text'] = $quotation_details['exstock_payment_text'];
			$data['byorder_payment_text'] = $quotation_details['byorder_payment_text'];
			$data['advance_required'] = $quotation_details['advance_required'];
			$data['reason_forclose'] = $quotation_details['reason_forclose'];
			$data['quotation_cprid'] = $quotation_details['quotation_cprid'];
			$where= array('user_id'=>$data['last_modified_by']);
			$last_modified = $this->crud_model->get('users',$where);
			$data['last_modified_by_user'] = $last_modified[0]['user_name'];
			
			$where= array('quotation_id'=>$quotation_id);
			$data['receipt_records'] = $this->crud_model->get('furniture_receipts',$where);
			$receipt_total = 0;
			if($data['receipt_records'] != false) {
				foreach ($data['receipt_records'] as $recrd){
					if($recrd['receipt_status'] != 0){
						$receipt_total += $recrd['receipt_amount'];
					}
				}
			}
			$data['balance'] = $data['quotation_net_total'] - $receipt_total;
			$data['amount_paid']  = $receipt_total;
			
			// Get the details of Salesman
			$data['salesman_name'] = $quotation_details['salesman_name'];
			$data['salesman_email_id'] = $quotation_details['salesman_email_id'];
			$data['salesman_contact_number'] = $quotation_details['salesman_contact_number'];
			$data['salesman_direct_number'] = $quotation_details['salesman_direct_number'];
			
			//Get the details of Client
			$data['client_name'] = $quotation_details['client_name'];
			$data['client_address'] = $quotation_details['client_address'];
			$data['client_country'] = $quotation_details['client_country'];
			$data['client_email'] = $quotation_details['client_email'];
			$data['client_telephone1'] = $quotation_details['client_telephone1'];
			$data['client_telephone2'] = $quotation_details['client_telephone2'];
			$data['client_fax'] = $quotation_details['client_fax'];
			
			//Get the details of Project
			$data['project_name'] = $quotation_details['project_name'];
			$data['project_location'] = $quotation_details['project_location'];
			$data['project_remarks'] = $quotation_details['project_remarks'];
			
			//Get the details of Funrniture 
			$data['furniture_items'] = $quotation_details['furniture_items'];
			
			//Get the deatils of Receipts
			$where= array('quotation_id'=>$quotation_id);
			$data['records'] = $this->crud_model->get('furniture_receipts',$where);
			$data['receipt_details'] = array();
			$i=0;
			if($data['records']){
				foreach($data['records'] as $receipt){
					//var_dump($receipt);
					$i++;
					$where= array('user_id'=>$receipt['receipt_generatedby']);
					$receipts_gen = $this->crud_model->get('users',$where);
					//echo "Cancelled :" .$receipt['receipt_cancelledby'];
					$where= array('user_id'=>$receipt['receipt_cancelledby']);
					$receipts_can = $this->crud_model->get('users',$where);
					$data['receipt_details'][$i] = array();
					
					array_push($data['receipt_details'][$i],$receipt['receipt_number'],$receipt['receipt_date'],$receipt['receipt_status'],$receipt['receipt_mode'],$receipt['receipt_amount'],$receipt['receipt_reference'],$receipt['receipt_bankname'],$receipt['receipt_remarks'],$receipts_gen[0]['user_name'],$receipts_can[0]['user_name'],$receipt['receipt_cancelled_date']);
					
				}
			} 
			
			$data=html_escape($data);
			$this->load->view('furniture/quotations/furniture_full_details/furniture_full_details',$data);
			
		}
	}	
?>