<?php
class EnquirySouce extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("EnquirySource", "View");
		$title['headerTitle']="Enquiry Souce List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/EnquirySouce/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('enquiry_souce',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('enquiry_souce',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/enquiry_souce/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("EnquirySource", "Add");
		$title['headerTitle']="Enquiry Souce Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/enquiry_souce/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("EnquirySource", "Edit");
		$title['headerTitle']="Enquiry Souce Edit";
		$where=array(
				'enquiry_souce_id' => $id
		);
		$records=$this->crud_model->get('enquiry_souce',$where);
		if($records != false){
			//true section
			$data['enquiry_souce_name']			 = $records[0]['enquiry_souce_name'];
			$data['enquiry_souce_id']			 = $records[0]['enquiry_souce_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/enquiry_souce/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/EnquirySouce');
		}
	}
	function do_insert() {
		$this->users_model->permission("EnquirySource", "Add");
		$title['headerTitle']="Enquiry Souce Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/enquiry_souce/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('enquiry_souce_name' => $name);

			$rr=$this->crud_model->insert('enquiry_souce',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Enquiry Source',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Enquiry Souce cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/enquiry_souce/list');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('success','Enquiry Souce added successfully');
				redirect('masters/EnquirySouce');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("EnquirySource", "Edit");
		$title['headerTitle']="Enquiry Souce Edit";
		$enquiry_souce_id = ascii_to_entities($this->input->post('enquiry_souce_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("enquiry_souce_id"=>$enquiry_souce_id);
					
			$records=$this->crud_model->get('enquiry_souce', $where);
			if($records != false){
				//true section
				$data['enquiry_souce_name']			 = $records[0]['enquiry_souce_name'];
				$data['enquiry_souce_id']			 = $records[0]['enquiry_souce_id'];
				$data['status']				= $records[0]['status'];

				$data['user_status'] = $this->config->item('user_status_array');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/enquiry_souce/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'enquiry_souce_id'  => $enquiry_souce_id
			);
			$data=array(
				'enquiry_souce_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('enquiry_souce',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Enquiry Source',	
				'masters_id'=>$enquiry_souce_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Enquiry Souce updated');
			redirect('masters/EnquirySouce');

		}
	}
	function do_delete($id=0) {
		$this->users_model->permission("EnquirySource", "Delete");
		$where=array(
			'meeting_type_id'=> $id
		);
			
		$this->crud_model->delete('meeting_type',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Enquiry Source',	
			'masters_id'=>$id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Meeting Type deleted');
		redirect('masters/EnquirySouce');
	}
}