<?php
class Insurer extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("Insurer", "View");
		$title['headerTitle']="Insurer";

		$data['insurer']  = $this->crud_model->get('insurer_master',array());
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/insurer',$data);
		$this->load->view('templates/footer');
	}
	public function create_Insurer(){
		$this->users_model->permission("Insurer", "Add");
		$title['headerTitle']="Insurer";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/create_insurer');
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("Insurer", "Add");		 
		$config = array(
			array(
                    'field' => 'insurer_name',
                    'label' => 'Insurer Name',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.',
                    )
            ),
		);		
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['name']   =  set_value('insurer_name');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Insurer";
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/create_insurer',$data);
			$this->load->view('templates/footer');
		}
		else{
            	$user_id	=	$this->session->userdata('user_id');
				$data = array(
                    'insurer_name' => $this->input->post('insurer_name'),
					'insurer_tel' => $this->input->post('insurer_tel'),
					'insurer_email' => $this->input->post('insurer_email'),
					'Creation_date' => date("Y-m-d"),
					'Created_User_id' => $user_id,
					'insurer_address' => $this->input->post('insurer_address'),
					'contact_person' => $this->input->post('contact_person'),
					'trn_name' => $this->input->post('vat_name'),
					'trn_no' => $this->input->post('vat_no'),
					'mobile_no' => $this->input->post('mobile_no'),
					'fax_no' => $this->input->post('fax_no')
                );
               
				$this->crud_model->insert('insurer_master', $data);
				
				$insert_id = $this->db->insert_id();
				$data1=array(
					'insurer_code'  =>  'IM'.sprintf("%'.04d",$insert_id)
				);
				$where = array('insurer_id' => $insert_id);
				$this->crud_model->update('insurer_master',$data1, $where);
				$tax_perce=10;

				$data=array(
					'ledger_name' 		=>	trim($this->input->post('insurer_name')),
					'ledger_code' 		=>	'IM'.sprintf("%'.04d",$insert_id),
					'acoount_group_id'  =>	18,
					'tax_percentage' 	=>	$tax_perce,
					'taxability' 		=> 	'Taxable',
					'opening_balance' 	=> 	0,
					'bank_account_number' => NULL,
					'bank_account_holder_name' => 	NULL,
					'bank_iban' 		=> 	NULL,
					'bank_swift' 		=> 	NULL,
					'bank_name' 		=> 	NULL,
					'country_id' 		=> 	18,
					'bank_branch' 		=> 	NULL,
					'created_date' 		=> date("Y-m-d"),
					'created_user_id' 	=> $user_id,
				);
	
				$records=$this->crud_model->insert('ledgers',$data);	
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Insurer Master',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);		
                if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    redirect("Insurer");
                } else {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('msg', 'Insurer Added Successfully');
                    redirect("master/Insurer");
             }
		}
	}
	public function edit_Insurer($insurer_id = ''){
		$this->users_model->permission("Insurer", "Edit");
		$title['headerTitle']="Insurer";
		
		$this->load->view('templates/header',$title);
		$data['insurer'] = $this->Vehicle->getInsurer($insurer_id);
		$data['salesman_list']  = $this->crud_model->get_list('user_id','user_name','users',array(''=>'Select Sales Man'),array('user_status'=>'Enabled'),'user_name','asc');
		//$dbdata = $this->Vehicle->getInsurecode($insurer_id);
		$where3=array(
			'customer_code' => $data['insurer']->insurer_code,
			'trn_type' 		=> 'Insurer Opening',
		);
		$data['cust_bill_allocations_records']=$this->crud_model->get('cust_bill_allocations',$where3);
		$this->load->view('masters/vehicle/edit_insurer',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		$this->users_model->permission("Insurer", "Edit");
		$config = array(
			array(
                    'field' => 'insurer_name',
                    'label' => 'Insurer Name',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.',
                    )
            ),
		);
		
		
		
	}
	 
}