<?php
class MeetingType extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("MeetingType", "View");
		$title['headerTitle']="Meeting Type List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/meetingType/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('meeting_type',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('meeting_type',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/meetingType/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("MeetingType", "Add");
		$title['headerTitle']="Meeting Type Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/meetingType/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("MeetingType", "Edit");
		$title['headerTitle']="Meeting Type Edit";
		$where=array(
				'meeting_type_id' => $id
		);
		$records=$this->crud_model->get('meeting_type',$where);
		if($records != false){
			//true section
			$data['meeting_type_name']			 = $records[0]['meeting_type_name'];
			$data['meeting_type_id']			 = $records[0]['meeting_type_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/meetingType/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/meetingType');
		}
	}
	function do_insert() {
		$this->users_model->permission("MeetingType", "Add");
		$title['headerTitle']="Meeting Type Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/meetingType/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('meeting_type_name' => $name);

			$rr=$this->crud_model->insert('meeting_type',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Meeting Type',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Meeting Type cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/meetingType');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('success','Meeting Type added successfully');
				redirect('masters/meetingType');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("MeetingType", "Edit");
		$title['headerTitle']="Meeting Type Edit";
		$meeting_type_id = ascii_to_entities($this->input->post('meeting_type_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("meeting_type_id"=>$meeting_type_id);
					
			$records=$this->crud_model->get('meeting_type', $where);
			if($records != false){
				//true section
				$data['meeting_type_name']			 = $records[0]['meeting_type_name'];
				$data['meeting_type_id']			 = $records[0]['meeting_type_id'];
				$data['status']				= $records[0]['status'];

				$data['user_status'] = $this->config->item('user_status_array');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/meetingType/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'meeting_type_id'  => $meeting_type_id
			);
			$data=array(
				'meeting_type_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('meeting_type',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Meeting Type',	
				'masters_id'=>$meeting_type_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Meeting Type updated');
			redirect('masters/meetingType');

		}
	}
	function do_delete($id=0) {
		$this->users_model->permission("MeetingType", "Delete");
		$where=array(
			'meeting_type_id'=> $id
		);
			
		$this->crud_model->delete('meeting_type',$where);
		$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Meeting Type',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Meeting Type deleted');
		redirect('masters/meetingType');
	}
}