<?php
class Payunit extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("PayUnit","View");
		$title['headerTitle']="Pay Unit List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('masters/Payunit/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('pay_unit',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('pay_unit',array(),$config['per_page'],$offset,'id','DESC');
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/payunit/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("PayUnit","Add");
		$title['headerTitle']="Pay Unit Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/payunit/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("PayUnit","Edit");
		$title['headerTitle']="Pay Unit Edit";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('pay_unit',$where);
		if($records != false){
			//true section
			$data['id']				= $records[0]['id'];
			$data['pay_unit_name']	= $records[0]['pay_unit_name'];
			$data['pay_uom']		= $records[0]['pay_uom'];
			$data['pay_hash_unit']	= $records[0]['pay_hash_unit'];
			$data['status']			= $records[0]['status'];
			$data['user_status'] 	= $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/payunit/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Payunit');
		}
	}
	function do_insert() {
		$this->users_model->permission("PayUnit","Add");
		$title['headerTitle']="Pay Unit Create";
		$this->form_validation->set_rules('pay_unit_name', 'Pay Unit', 'required|is_unique[pay_unit.pay_unit_name]|trim');
		
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/payunit/create');
			$this->load->view('templates/footer');
		} else {	
			// true section
			$userid = $this->session->userdata('user_id');
			$pay_unit_name=trim($this->input->post('pay_unit_name'));
			$pay_uom=$this->input->post('pay_uom');
			$pay_hash_unit = '#'.str_replace(' ', '_', $pay_unit_name).'#';
			$data=array(
				'pay_unit_name'=> $pay_unit_name,
				'pay_uom' 	   => $pay_uom,
				'pay_hash_unit'=> $pay_hash_unit,
				'created_id'   => $userid
			);
			$rr=$this->crud_model->insert('pay_unit',$data);
			$insert_id	=	$this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			
			$data= array(						
				'masters_type'=>'Pay Unit',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Pay Unit cannot be inserted',':old:');
				$redirect('masters/Payunit');
			} else {
				// redirect
				$this->session->set_flashdata('success','Pay Unit added successfully');
				redirect('masters/Payunit');
			}
		}
	}

	function do_update() {
		$this->users_model->permission("PayUnit","Edit");
		$title['headerTitle']="Pay Unit Edit";
		$pay_unit_id = ascii_to_entities($this->input->post('pay_unit_id'));
		$where=array("id"=>$pay_unit_id);
		$records=$this->crud_model->get('pay_unit', $where);
		$pay_unit_name=trim($this->input->post('pay_unit_name'));
		if($pay_unit_name!=$records[0]['pay_unit_name']){
			$this->form_validation->set_rules('pay_unit_name', 'Pay Unit', 'required|is_unique[pay_unit.pay_unit_name]|trim');
		}
		$this->form_validation->set_rules('pay_unit_id', 'Name', 'required');
		
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
	
		if ($this->form_validation->run() == FALSE) {
			// false section
			
			if($records != false){
				//true section
				$data['id']				= $records[0]['id'];
				$data['pay_unit_name']	= $records[0]['pay_unit_name'];
				$data['pay_uom']		= $records[0]['pay_uom'];
				$data['pay_hash_unit']	= $records[0]['pay_hash_unit'];
				$data['status']			= $records[0]['status'];
	
				$data['user_status'] = $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/payunit/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$pay_unit_name=trim($this->input->post('pay_unit_name'));
			$pay_uom=$this->input->post('pay_uom');
			$status=$this->input->post('status');
			$pay_hash_unit = '#'.str_replace(' ', '_', $pay_unit_name).'#';

			$data=array(
				'pay_unit_name'=> $pay_unit_name,
				'pay_uom' 	   => $pay_uom,
				'pay_hash_unit'=> $pay_hash_unit,
				'status' 	   => $status
			);
			$where=array(
				'id'  => $pay_unit_id
			);
		
			$records=$this->crud_model->update('pay_unit',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Pay Unit',	
				'masters_id'=>$pay_unit_id,	
				'date'		=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Pay head updated');
			redirect('masters/Payunit');
		}
	}
	function do_delete($department_id=0) {
		$this->users_model->permission("PayUnit","Delete");
		$where=array(
			'department_id'  => $department_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('department_master',$data,$where);
		$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Payroll Pay Head',	
				'masters_id'=>$department_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('success','Department deleted');
		redirect('masters/Department');
	}
}