<?php
class StaffMaster extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
		 
	}
	public function index(){
		$this->users_model->permission("StaffMaster", "View");
		$title['headerTitle']="Staff Master";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['division']  = $this->Vehicle->getdivision();
		$data['section']  = $this->Vehicle->getsection();
		$data['stafflist']  = $this->Vehicle->getstaffdetail();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/staffmaster',$data);
		$this->load->view('templates/footer');
	}
	public function create_Staff(){
		$title['headerTitle']="Staff Master";
		$this->load->view('templates/header',$title);
		$data['division']  = $this->Vehicle->getdivision();
		$data['section']  = $this->Vehicle->getsection();
		$this->load->view('masters/vehicle/create_staffmaster',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("StaffMaster", "Add");
		//$this->security->check_token();
		// Validate the CSRF token
        // if ($this->security->csrf_verify() === FALSE)
        // {
        //     // CSRF token is invalid
        //     return false;
        // }
		$config = array(
			array(
                    'field' => 'staff_name',
                    'label' => 'Staff Name',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.'
                    )
            ),
			array(
				'field' => 'division_id',
				'label' => 'Division',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
			array(
                    'field' => 'section_id',
                    'label' => 'Section',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'type',
                    'label' => 'Type',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            )
		);
		
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){	
			$data['staff_name']  = set_value('staff_name');
			$data['division_id'] = set_value('division_id');
			$data['section_id']  = set_value('section_id');
			$data['type']        = set_value('type');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$data['division']  = $this->Vehicle->getdivision();
		    $data['section']  = $this->Vehicle->getsection();
			$this->load->view('templates/header', $data);
			$this->load->view('masters/vehicle/create_staffmaster', $data);
			$this->load->view('templates/footer');
		}
		else{

			$data = array(
				'staff_name' 		=> $this->input->post('staff_name'),
				'division_id'    	=> $this->input->post('division_id'),
				'section_id' 		=> $this->input->post('section_id'),
				'type' 	=> $this->input->post('type'),
			);
			$res = $this->Vehicle->insertStaff($data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'StaffMaster',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Staff Created  Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/StaffMaster');

		}
	
	}
	public function editstaff($id = ''){
		$this->users_model->permission("StaffMaster", "Edit");
		$title['headerTitle']="Staff Master";
		$this->load->view('templates/header',$title);
		$data['division']  = $this->Vehicle->getdivision();
		$data['section']   = $this->Vehicle->getsection();
		$data['staff']     = $this->Vehicle->getstaffdata($id);
		$this->load->view('masters/vehicle/edit_staffmaster',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		$this->users_model->permission("StaffMaster", "Edit");
		$config = array(
			array(
                    'field' => 'staff_name',
                    'label' => 'Staff Name',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.'
                    )
            ),
			array(
				'field' => 'division_id',
				'label' => 'Division',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
			array(
                    'field' => 'section_id',
                    'label' => 'Section',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'type',
                    'label' => 'Type',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            )
		);
		
        $this->form_validation->set_rules($config);
		$id = $this->input->post('staff_id');
		if ($this->form_validation->run() == FALSE){	
			$data['staff_name']  = set_value('staff_name');
			$data['division_id'] = set_value('division_id');
			$data['section_id']  = set_value('section_id');
			$data['type']        = set_value('type');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$data['division']  = $this->Vehicle->getdivision();
		    $data['section']  = $this->Vehicle->getsection();
			$data['staff']     = $this->Vehicle->getstaffdata($id);
			$this->load->view('templates/header', $data);
			$this->load->view('masters/vehicle/edit_staffmaster', $data);
			$this->load->view('templates/footer');
		}
		else{

			$data = array(
				'staff_name' 		=> $this->input->post('staff_name'),
				'division_id'    	=> $this->input->post('division_id'),
				'section_id' 		=> $this->input->post('section_id'),
				'type' 	            => $this->input->post('type'),
			);
			$res = $this->Vehicle->updatetStaff($data);
			if($res){
				$insert_id = $this->input->post('staff_id');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'StaffMaster',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Staff Updated  Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/StaffMaster');

		}
	}
 
}