<?php
class Unit extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("Unit", "View");
		$title['headerTitle']="Unit List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/Unit/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('unit_master',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('unit_master',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/unit/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Unit", "Add");
		$title['headerTitle']="Unit Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/unit/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Unit", "Edit");
		$title['headerTitle']="Unit Edit";
		$where=array(
				'unit_id' => $id
		);
		$records=$this->crud_model->get('unit_master',$where);
		if($records != false){
			//true section
			$data['unit_name']			 = $records[0]['unit_name'];
			$data['unit_id']			 = $records[0]['unit_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/unit/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Unit');
		}
	}
	function do_insert() {
		$this->users_model->permission("Unit", "Add");
		$title['headerTitle']="Unit Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/unit/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('unit_name' => $name);

			$rr=$this->crud_model->insert('unit_master',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Unit',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Unit Name cannot be inserted',':old:');
				$redirect('masters/Unit');
			} else {
				// redirect
				$this->session->set_flashdata('success','Unit Name added successfully');
				redirect('masters/Unit');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("Unit", "Edit");
		$title['headerTitle']="Unit Edit";
		$unit_id = ascii_to_entities($this->input->post('unit_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("unit_id"=>$unit_id);
					
			$records=$this->crud_model->get('unit_master', $where);
			if($records != false){
				//true section
				$data['unit_name']			 = $records[0]['unit_name'];
				$data['unit_id']			 = $records[0]['unit_id'];
				$data['status']				= $records[0]['status'];

				$data['user_status'] = $this->config->item('user_status_array');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/unit/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'unit_id'  => $unit_id
			);
			$data=array(
				'unit_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('unit_master',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Unit',	
				'masters_id'=>$unit_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Unit updated');
			redirect('masters/Unit');

		}
	}
	function do_delete($unit_id=0) {
		$this->users_model->permission("Unit", "Delete");
		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Unit',	
				'masters_id'=>$unit_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Unit deleted');
		redirect('masters/Unit');
	}
}