<?php
class Quotation_kitchen extends CI_Controller {
	function Quotation_kitchen()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->library('pagination');
		//$this->output->enable_profiler(TRUE);
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('quotations/quotation_kitchen/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_quo_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',array('quotation_id'=>$this->session->userdata('quotation_id')));

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_quo_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',
				array('quotation_id'=>$this->session->userdata('quotation_id')),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();


		$records = $this->crud_model->get('kitchen_brands');
		$rs = $this->crud_model->get('kitchen_areas');
		if($records != false){
			//true section
			$list = $this->crud_model->get_list('kitchen_brand_id','kitchen_brand_name','kitchen_brands',array(0=>' - Select - '));
			$data['kitchen_brand_name']			 = $records[0]['kitchen_brand_name'];
			$data['kitchen_brand_id']			     = $records[0]['kitchen_brand_id'];

			$data['kitchen_brands'] = $list;

			$list1 = $this->crud_model->get_list('kitchen_area_id','kitchen_area_name','kitchen_areas',array(0=>' - Select - '));
			$data['kitchen_area_name']			 = $rs[0]['kitchen_area_name'];
			$data['kitchen_area_id']			     = $rs[0]['kitchen_area_id'];

			$data['kitchen_areas'] = $list1;

			$rr=$this->crud_model->get('quotation_kitchen',array('quotation_id' => $this->session->userdata('quotation_id')));
			
			if($rr!=false)
			{
				$data['quotation_kitchen_id'] = $rr[0]['quotation_kitchen_id'];
					
			}
				
				
			$this->load->view('templates/header');
			$this->load->view('quotations/quotation_kitchen/create',$data);
			$this->load->view('templates/footer');
		}
	}

	function do_insert()
	{

		$this->form_validation->set_rules('kitchen_brand_id', 'Kitchen Brand', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('drawing_number', 'Drawing Number', 'required');
		$this->form_validation->set_rules('kitchen_area_id', 'Kitchen Area', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('kitchen_front_name', 'Kitchen Front Name', 'required');
		$this->form_validation->set_rules('kitchen_front_code', 'Kitchen Front Code', 'required');
		$this->form_validation->set_rules('kitchen_handle', 'Kitchen Handle', 'required');
		$this->form_validation->set_rules('kitchen_plinth', 'Kitchen Plinth', 'required');
		$this->form_validation->set_rules('kitchen_price', 'Unit Price', 'required|numeric');
		$this->form_validation->set_rules('kitchen_quantity', 'Kitchen Quantity', 'required');
		$this->form_validation->set_rules('kitchen_more_details', 'Remarks', 'max_length[100]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{	// true section
			$da=array('status' =>1,'quotation_date' => date('Y-m-d h:m:s'));
			$where=array('quotation_id' => $this->session->userdata('quotation_id'));

			$this->crud_model->update('quotations',$da,$where);

			$rs=$this->crud_model->get('quotations');
			foreach($rs as $row)
			{
				$quotation_id=$row['quotation_id'];
			}

			$data=array(
					'quotation_id'          =>$this->session->userdata('quotation_id'),
					'drawing_number'        => $this->input->post('drawing_number'),
					'kitchen_area_id'       => $this->input->post('kitchen_area_id'),
					'kitchen_brand_id'       => $this->input->post('kitchen_brand_id'),
					'kitchen_front_name'    => $this->input->post('kitchen_front_name'),
					'kitchen_front_code'    => $this->input->post('kitchen_front_code'),
					'kitchen_handle'        => $this->input->post('kitchen_handle'),
					'kitchen_plinth'        => $this->input->post('kitchen_plinth'),
					'kitchen_quantity'      => $this->input->post('kitchen_quantity'),
					'kitchen_price'      => $this->input->post('kitchen_price'),
					'kitchen_more_details'  => $this->input->post('kitchen_more_details')
			);
			
			if($this->input->post('quotation_id')=='')
			{

				$rr=$this->crud_model->insert('quotation_kitchen',$data);


				if($rr == false)
				{
					// error

					$this->session->set_flashdata('response','<div class="alert alert-error">Quotation Kitchen cannot be inserted</div>',':old:');
					$this->load->view('templates/header');
					$this->load->view('quotations/quotation_kitchen');
					$this->load->view('templates/footer');
				}
				else
				{
					// redirect
					$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Kitchen Details added successfully</div>');
					redirect('quotations/quotation_kitchen');

				}
			}
			else {
				$where = array(
						'quotation_kitchen_id'  =>$this->input->post('quotation_kitchen_id')
				
				);
				$data=array(
						'quotation_id'          =>$quotation_id,
						'drawing_number'        => $this->input->post('drawing_number'),
						'kitchen_area_id'       => $this->input->post('kitchen_area_id'),
						'kitchen_brand_id'       => $this->input->post('kitchen_brand_id'),
						'kitchen_front_name'    => $this->input->post('kitchen_front_name'),
						'kitchen_front_code'    => $this->input->post('kitchen_front_code'),
						'kitchen_handle'        => $this->input->post('kitchen_handle'),
						'kitchen_plinth'        => $this->input->post('kitchen_plinth'),
						'kitchen_quantity'      => $this->input->post('kitchen_quantity'),
						'kitchen_price'      => $this->input->post('kitchen_price'),
						'kitchen_more_details'  => $this->input->post('kitchen_more_details')
				);
				$rr=$this->crud_model->update('quotation_kitchen',$data,$where);
				
				$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Kitchen Details Updated successfully</div>');
				redirect('quotations/quotation_kitchen/edit/'.$quotation_id);
			}
		}
		


	}
	function do_delete($id=0)
	{

		$where=array(
				'quotation_kitchen_id'=> $id
		);

		$this->crud_model->delete('quotation_kitchen',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Kitchen deleted</div>');
		redirect('quotations/quotation_kitchen');
	}
	
	/* function edit($quotation_id)
	{
		$where=array(
		
				'quotation_id'    => $quotation_id
		);
		$data['quotation_id']  = $quotation_id;
		$rs=$this->crud_model->get('view_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',$where);
		
		if($rs!=false)
		{
			//$data['quotation_id']              = $rs[0]['quotation_id'];
			$data['drawing_number']            = $rs[0]['drawing_number'];
			$data['kitchen_area_id']           = $rs[0]['kitchen_area_id'];
			$data['kitchen_brand_id']          = $rs[0]['kitchen_brand_id'];
			$data['kitchen_front_name']        = $rs[0]['kitchen_front_name'];
			$data['kitchen_front_code']        = $rs[0]['kitchen_front_code'];
			$data['kitchen_handle']            = $rs[0]['kitchen_handle'];
			$data['kitchen_plinth']            = $rs[0]['kitchen_plinth'];
			$data['kitchen_quantity']          = $rs[0]['kitchen_quantity'];
			$data['kitchen_price']             = $rs[0]['kitchen_price'];
			$data['kitchen_more_details']      = $rs[0]['kitchen_more_details'];
		}
		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_kitchen/create',$data);
		$this->load->view('templates/footer');
	} */
	function edit($quotation_id,$page=1)
	{
	//$this->session->set_userdata('quotation_id',$quotation_id);
	   $where=array(
  		             'quotation_id'  => $quotation_id 	
		     	);
		$rr=$this->crud_model->get('quotation_kitchen',$where);
					
		if($rr!=false)
		{
			$data['quotation_kitchen_id'] = $rr[0]['quotation_kitchen_id'];
				
		}
		
		$where=array(
		
				'quotation_id'    => $quotation_id
		);
		$data['quotation_id']  = $quotation_id;
		$rs=$this->crud_model->get('view_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',$where);

		if($rs!=false)
		{
			$data['quotation_id']              = $rs[0]['quotation_id'];
			$data['drawing_number']            = $rs[0]['drawing_number'];
			$data['kitchen_area_id']           = $rs[0]['kitchen_area_id'];
			$data['kitchen_brand_id']          = $rs[0]['kitchen_brand_id'];
			$data['kitchen_front_name']        = $rs[0]['kitchen_front_name'];
			$data['kitchen_front_code']        = $rs[0]['kitchen_front_code'];
			$data['kitchen_handle']            = $rs[0]['kitchen_handle'];
			$data['kitchen_plinth']            = $rs[0]['kitchen_plinth'];
			$data['kitchen_quantity']          = $rs[0]['kitchen_quantity'];
			$data['kitchen_price']             = $rs[0]['kitchen_price'];
			$data['kitchen_more_details']      = $rs[0]['kitchen_more_details'];
		}



		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('quotations/quotation_kitchen/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',array('quotation_id'=>$this->session->userdata('quotation_id')));

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',
				array('quotation_id'=>$this->session->userdata('quotation_id')),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$records = $this->crud_model->get('kitchen_brands');
		$rs = $this->crud_model->get('kitchen_areas');
		if($records != false){
			//true section
			$list = $this->crud_model->get_list('kitchen_brand_id','kitchen_brand_name','kitchen_brands',array(0=>' - Select - '));
			$data['kitchen_brand_name']			 = $records[0]['kitchen_brand_name'];
			$data['kitchen_brand_id']			     = $records[0]['kitchen_brand_id'];

			$data['kitchen_brands'] = $list;

			$list1 = $this->crud_model->get_list('kitchen_area_id','kitchen_area_name','kitchen_areas',array(0=>' - Select - '));
			$data['kitchen_area_name']			 = $rs[0]['kitchen_area_name'];
			$data['kitchen_area_id']			     = $rs[0]['kitchen_area_id'];

			$data['kitchen_areas'] = $list1;
			
				
			$this->load->view('templates/header');
			$this->load->view('quotations/quotation_kitchens/create',$data);
			$this->load->view('templates/footer');
		}
			
	}
/*	function do_update()
	{
		$quotation_id=$this->input->post('quotation_id');

		$this->form_validation->set_rules('kitchen_brand_id', 'Kitchen Brand', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('drawing_number', 'Drawing Number', 'required');
		$this->form_validation->set_rules('kitchen_area_id', 'Kitchen Area', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('kitchen_front_name', 'Kitchen Front Name', 'required');
		$this->form_validation->set_rules('kitchen_front_code', 'Kitchen Front Code', 'required');
		$this->form_validation->set_rules('kitchen_handle', 'Kitchen Handle', 'required');
		$this->form_validation->set_rules('kitchen_plinth', 'Kitchen Plinth', 'required');
		$this->form_validation->set_rules('kitchen_price', 'Unit Price', 'required|numeric');
		$this->form_validation->set_rules('kitchen_quantity', 'Kitchen Quantity', 'required');
		$this->form_validation->set_rules('kitchen_more_details', 'Remarks', 'max_length[100]');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit($quotation_id);
		}
		else
		{	// true section
			$data=array(
					'quotation_id'          =>$quotation_id,
					'drawing_number'        => $this->input->post('drawing_number'),
					'kitchen_area_id'       => $this->input->post('kitchen_area_id'),
					'kitchen_brand_id'       => $this->input->post('kitchen_brand_id'),
					'kitchen_front_name'    => $this->input->post('kitchen_front_name'),
					'kitchen_front_code'    => $this->input->post('kitchen_front_code'),
					'kitchen_handle'        => $this->input->post('kitchen_handle'),
					'kitchen_plinth'        => $this->input->post('kitchen_plinth'),
					'kitchen_quantity'      => $this->input->post('kitchen_quantity'),
					'kitchen_price'      => $this->input->post('kitchen_price'),
					'kitchen_more_details'  => $this->input->post('kitchen_more_details')
			);
			$where = array(
					'quotation_kitchen_id'  => $quotation_kitchen_id
			);
			$rr=$this->crud_model->update('quotation_kitchen',$data,$where);
			// redirect
			$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Kitchen Details Updated successfully</div>');
			redirect('quotations/quotation_kitchen/edit/'.$quotation_id);
		}
	} */
}

