<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Attendance extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Hr_model');
	}

	public function listAttendance(){
		$this->users_model->permission("Attendance","View");
		$title['headerTitle']="Attendance List";
		$data['fromDate'] = date('d-m-Y',strtotime(date('Y-m-01')));
		$data['toDate'] = date('d-m-Y',strtotime(date('Y-m-t')));
		$data['employee_datas'] = $this->Hr_model->get_all_attendance();
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/attendance/listAttendance',$data);
		$this->load->view('templates/footer');
	}

	
	public function create(){
		$this->users_model->permission("Attendance","Add");
		$this->form_validation->set_rules('attendance_date','Date','required');
		
		if ($this->form_validation->run() == FALSE)
		{
			$title['headerTitle']="Attendance Create";
			$data['pay_unit_list'] = $this->crud_model->get('pay_unit',array('status' => 1));
			$this->load->view('templates/header',$title);
			$this->load->view('transactions/attendance/create',$data);
			$this->load->view('templates/footer');
		} else {
			$array_data = array();
			$rs=false;
			$attendance_count  = $this->Hr_model->get_count_with_group_by('employee_attendance',array(),'attendance_no');
			$attendance_no=$attendance_count+1;
			$attendance_date = date("Y-m-d", strtotime($this->input->post('attendance_date')));
			$employee_id = $this->input->post('employee_id');
			$pay_unit_id  = $this->input->post('pay_unit_type');
			$pay_value = $this->input->post('pay_value');
			$comments = $this->input->post('comments');
			$this->db->trans_begin();
			for ($i = 0; $i < count($employee_id); $i++) {
				if($employee_id[$i]!='' && $pay_unit_id[$i]!='' && $pay_value[$i]!=''){
					$array_data[] = array(
						'attendance_no'	 => $attendance_no,
						'attendance_date'=> $attendance_date,
						'employee_id'	 => $employee_id[$i],
						'pay_unit_id'	 => $pay_unit_id[$i],
						'pay_value' 	 => $pay_value[$i],
						'comments' 	 	 => $comments[$i],
						'created_date' 	 => date("Y-m-d h:m:s"),
						'created_id' 	 => $this->session->userdata('user_id')
					);
				}
			}
			if(!empty($array_data)){
				$rs=$this->db->insert_batch('employee_attendance', $array_data);
			}
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=> 'Employee Attendance',
				'masters_id'  => $attendance_no,
				'date'		  => $date,
				'created_id'  => $userid,
				'masters_op'  => 'Create',
			);
			$this->crud_model->insert('log_for_masters',$data);

			if ($this->db->trans_status() === FALSE OR $rs == false) {
				$this->session->set_flashdata('response','Attendance cannot be inserted, try again.');
				redirect('transactions/Attendance/create');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Attendance added successfully');
				redirect('transactions/Attendance/listAttendance');
		 	}
		}
	}

	public function edit($attendance_no){
		$this->users_model->permission("Attendance","Add");
		$this->form_validation->set_rules('attendance_date','Date','required');
		$data['attendances'] = $this->Hr_model->get_attendance($attendance_no);
		$data['attendance_no'] = $attendance_no;
		if ($this->form_validation->run() == FALSE)
		{
			$title['headerTitle']="Attendance Create";
			$data['pay_unit_list'] = $this->crud_model->get('pay_unit',array('status' => 1));
			$this->load->view('templates/header',$title);
			$this->load->view('transactions/attendance/edit',$data);
			$this->load->view('templates/footer');
		} else {
			
			$attendance_date = date("Y-m-d", strtotime($this->input->post('attendance_date')));
			$employee_id  = $this->input->post('employee_id');
			$attendance_id= $this->input->post('attendance_id');
			$pay_unit_id  = $this->input->post('pay_unit_type');
			$pay_value    = $this->input->post('pay_value');
			$comments 	  = $this->input->post('comments');
			$this->db->trans_begin();
			$array_data = array();
			for ($i = 0; $i < count($employee_id); $i++) {
				if($employee_id[$i]!=''){
					if($attendance_id[$i]!=''){
						$update_data = array(
							'attendance_no'	 => $attendance_no,
							'attendance_date'=> $attendance_date,
							'employee_id'	 => $employee_id[$i],
							'pay_unit_id'	 => $pay_unit_id[$i],
							'pay_value' 	 => $pay_value[$i],
							'comments' 	 	 => $comments[$i],
							'created_date' 	 => date("Y-m-d h:m:s"),
							'created_id' 	 => $this->session->userdata('user_id')
						);
						$this->db->update('employee_attendance',$update_data,array('attendance_id' => $attendance_id[$i]));
					} else {
						$array_data[] = array(
							'attendance_no'	 => $attendance_no,
							'attendance_date'=> $attendance_date,
							'employee_id'	 => $employee_id[$i],
							'pay_unit_id'	 => $pay_unit_id[$i],
							'pay_value' 	 => $pay_value[$i],
							'comments' 	 	 => $comments[$i],
							'created_date' 	 => date("Y-m-d h:m:s"),
							'created_id' 	 => $this->session->userdata('user_id')
						);
					}
				}
			}
			if(!empty($array_data)){
				$this->db->insert_batch('employee_attendance', $array_data);
			}
			
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=> 'Employee Attendance',
				'masters_id'  => $attendance_no,
				'date'		  => $date,
				'created_id'  => $userid,
				'masters_op'  => 'Edit',
			);
			$this->crud_model->insert('log_for_masters',$data);

			if ($this->db->trans_status() === FALSE) {
				$this->session->set_flashdata('response','Attendance cannot be inserted');
				redirect('transactions/Attendance/listAttendance');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Attendance updated successfully');
				redirect('transactions/Attendance/listAttendance');
		 	}
		}
	}
	
	public function salary_calculator(){
		$basicSalary = 400;
		$payHeadId = 4;
		$others = 5;

		$formula = $this->getFormulaFromDatabase($payHeadId);

		if ($formula) {
			$calculatedValue = $this->calculateValue($basicSalary, $formula, $others);
			echo "The calculated value is: " . $calculatedValue;
		} else {
			echo "No formula ".$payHeadId;
		}
	}
	function getFormulaFromDatabase($payHeadId) {
		$payHeadData = $this->crud_model->get('pay_head',array('status'=>1,'id'=>$payHeadId,'is_formula'=>'1'));
		$formulas = [];
		if($payHeadData!=false){
			foreach ($payHeadData as $payHead) {
				if (!empty($payHead['set_formula'])) {
					$formulas[$payHead['id']] = $payHead['set_formula'];
				}
			}
		}
		return $formulas[$payHeadId] ?? null;
	}

	function calculateValue($basicSalary, $formula, $others) {
		$formula = str_replace('@basic_salary', $basicSalary, $formula);
		$formula = str_replace('#others', $others, $formula);
		eval("\$value = $formula;");
		return $value;
	}
}

?>