<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Payroll_unprocessing extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Hr_model');
	}

	public function list(){
		$this->users_model->permission("Attendance","View");
		$title['headerTitle']="Attendance List";
		$data['fromDate'] = date('d-m-Y',strtotime(date('Y-m-01')));
		$data['toDate'] = date('d-m-Y',strtotime(date('Y-m-t')));
		$data['employee_datas'] = $this->Hr_model->get_all_attendance();
		
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/attendance/listAttendance',$data);
		$this->load->view('templates/footer');
	}

	public function create(){
		$this->users_model->permission("Payroll_unprocessing","View");
		$title['headerTitle']="Payroll Processing";
		if($this->input->post('fromDate')!='') {
			$fromDate = $this->input->post('fromDate');
		} else {
			$fromDate = date('d-m-Y',strtotime(date('Y-m-01')));
		}
		if($this->input->post('toDate')!='') {
			$toDate = $this->input->post('toDate');
		} else {
			$toDate = date('d-m-Y',strtotime(date('Y-m-t')));
		}
		$data['fromDate'] = $fromDate;
		$data['toDate'] = $toDate;
		$data['payroll_processed_data'] = $this->Hr_model->get_payroll_processed();
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/unprocessing/create',$data);
		$this->load->view('templates/footer');
	}
	public function save(){
		$this->users_model->permission("Payroll_unprocessing","View");
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('processing_year', date('Y', strtotime($fromDate)));
				$this->db->where('processing_month', date('m', strtotime($fromDate)));
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee_id',$this->input->post('employee_id'));
			}
			$this->db->delete('employee_attendance_processed');

			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('pp_year', date('Y', strtotime($fromDate)));
				$this->db->where('pp_month', date('m', strtotime($fromDate)));
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee_id',$this->input->post('employee_id'));
			}
			$this->db->delete('employee_payroll_payables');

			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$voucher_no = ltrim(date('m', strtotime($fromDate)), '0').'-'.date('Y', strtotime($fromDate));
				$this->db->where('vch_no', $voucher_no);
			}
			$this->db->where('vch_type', 'Payroll');
			$this->db->delete('accounts');
		}
		$this->session->set_flashdata('response','Unprocessing done successfully.');
		redirect('transactions/Payroll_unprocessing/create');
	}
}

?>