
	<style>
		div.dt-buttons {
			float: right;
			padding-left: 15px;
			padding-right: 15px;
		}
		.dataTables_length {
			position: absolute;
		}
	</style>
    <!--app-content open-->
	<div class="app-content main-content">
		<div class="side-app">
			<div class="main-container">
				<!-- PAGE-HEADER -->
				<div class="page-header">
					<div class="col-xl-5 col-lg-6 col-md-5 col-sm-6">
						<h1 class="page-title">Journal List</h1>
                    </div>
					<div class="col-xl-7 col-lg-6 col-md-7 col-sm-6">
                        <div class="float-sm-end float-none my-1">
							<?php if($this->users_model->check_permission("Journal","Add")!=false){ ?>
								<a id="add__new__list" type="button" class="btn btn-md btn-primary " data-bs-target=".bd-example-modal-lg" href="<?php echo site_url('Journal/create_journal');?>"><i class="fa fa-plus"></i> Add a new Journal</a>
							<?php } ?>
						</div>
                    </div>
				</div>
			</div>
			<!-- PAGE-HEADER END -->
			<!-- ROW-1 -->
			<div class="row">
				<div class="col-md-12 col-lg-12">
					<div class="card">
						<div class="card-body">
							<h3 class="card-title">Journal List</h3>
						</div>
						<?php
							if($this->session->flashdata("response")!='') {
								echo '<div class="alert alert-danger">' . $this->session->flashdata("response") . '</div>';
								$this->session->unset_userdata('response');
							}
						?>
						<?php
							if($this->session->flashdata("success")!='') {
								echo '<div class="alert alert-success">' . $this->session->flashdata("success") . '</div>';
								$this->session->unset_userdata('success');
							}
						?>
							<table id="receipt_data" class="table card-table ">
								<thead class="thead-light"  >
									<tr>
										<th>JL Number</th>
										<th>Date</th>
										<th style="text-align:right;" >Debit Amount</th>
										<th style="text-align:right;" >Credit Amount</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$DeletePermission=$this->users_model->check_permission("Journal","Delete");
									$EditPermission=$this->users_model->check_permission("Journal","Edit");
										if($receipts != false) {
											foreach($receipts as $receipts) {
												$style='';
			
												if($receipts['journal_status']=='0'){
													$style='class="nb-td-cancel"';
												} else {
													$style='';
												}
									?>
									<tr <?php  echo $style;?> >
										<td>
											<?php echo $receipts['journal_code'];?>
										</td>
										<td><?php echo date('M d,Y',strtotime ($receipts['journal_date']));?></td>
										<td style="text-align:right;" ><?php echo number_format($receipts['dr_amount'],3);?></td>
										<td style="text-align:right;" ><?php echo number_format($receipts['cr_amount'],3);?></td>
										<td style="width:100px;">
											<div class="btn-group">
												<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
												Action <span class="caret"></span>
												</button>
												<ul class="dropdown-menu" role="menu">
													<li><a class="click2" target="_blank" href="<?php echo site_url('Journal/view1/'.$receipts["journal_id"].'/pdf'); ?>"  ><i class="fa fa-print"></i> Print</a></li>
													<?php if($EditPermission){ ?>
														<li><a class="click2" href="<?php echo site_url('Journal/edit_journal/'.$receipts["journal_id"]); ?>"  ><i class="fa fa-edit"></i> Edit</a></li>
													<?php } ?>
													<?php if($DeletePermission){ ?>
														<li><a class="click2" href="javascript:ConfirmDelete('<?php echo $receipts['journal_code'];?>','<?php echo $receipts["journal_id"];?>')"  ><i class="fa fa-mail-forward"></i> Cancel</a></li>
													<?php } ?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } } ?>
								</tbody>
							</table>
						<?php echo $pagination; ?>
						<!-- table-responsive -->
					</div>
				</div>
			</div>
			<!-- ROW-1 CLOSED -->
		</div>
	</div>
						</div>
						<!-- ROW-4 CLOSED -->
					</div>
				</div>
				<!-- CONTAINER CLOSED -->
			</div>

	<script type="text/javascript">
		$(function(e) {
			$('#receipt_data').DataTable({
				"paging": true,
				"processing": true,
				"scrollCollapse": true,
				"order": [[0, 'desc']],
				"iDisplayLength": 100,
				"lengthMenu": [ [100, 150, 200, -1], [100, 150, 200, "All"] ],
				"info": true,
				"pagingType": 'full_numbers',
				dom: 'lBfrtip',
				buttons: [
					{ extend: 'copyHtml5',title: '',text: 'Copy',header: false, text:'<i class="fa fa-copy"></i>',titleAttr: 'Copy', className: 'btn-primary' },
					{ extend: 'excelHtml5',title: 'General Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'GeneralReceiptExcelExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Excel', text:'<i class="fa fa-file-excel-o"></i>',titleAttr: 'Excel', className: 'btn-success' },
					{ extend: 'print',title: 'General Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'GeneralReceiptPrintExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Print', text:'<i class="fa fa-print"></i>',titleAttr: 'Print', className: 'btn-warning' },
					
				]
			});
			//
			// Select2 { extend: 'csvHtml5',text: 'CSV',header: false, text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'CSV', className: 'btn-warning' },
			//{ extend: 'colvis',title: '',filename: 'fileName',text: 'Pdf', text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'Pdf', className: 'btn-warning' },
			$('.select2').select2({
				minimumResultsForSearch: Infinity
			});
		} );
		function ConfirmDelete(journal_code,journal_id){
			$('body').removeClass('timer-alert');
			swal({
					title: "Alert",
					text: "Are you sure you want to Cancel this Journal ??",
					type: "warning",
					showCancelButton: true,
					confirmButtonText: 'Yes',
					cancelButtonText: 'Cancel'
				},
				function(isConfirm){
				if (isConfirm) {
					document.location.href="<?php echo site_url('Journal/cancel_journal'); ?>/"+journal_code+"/"+journal_id;
					//window.location = "Receipt/cancel_receipt/"+receipt_number+"/"+quotation_divisionid+"/"+receipt_id;
				} else {
					swal("Cancelled", "Something went wrong :)", "error");
				}
			});
		}
	</script>
