<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hr_search extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('Hr_model');
	}	
	public function cpr_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('cpr_expiry>='=>$today,'cpr_expiry<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>CPR No</th>
						<th>CPR Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['cpr_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['cpr_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_statuatory" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}

	public function cpr_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$type = $this->input->post('type');
		$test=$this->Hr_model->get_employee_details(array('cpr_expiry<'=>$today,'cpr_expiry!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>CPR No</th>
						<th>CPR Expired</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['cpr_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['cpr_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_statuatory" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}

	public function passport_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('passport_expiry_date>='=>$today,'passport_expiry_date<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Passport No</th>
						<th>Passport Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['passport_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['passport_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}

	public function passport_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('passport_expiry_date<'=>$today,'passport_expiry_date!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Passport No</th>
						<th>Passport Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['passport_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['passport_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}
	public function driving_licence_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('driving_licence_expiry>='=>$today,'driving_licence_expiry<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Driving Licence No</th>
						<th>Driving Licence Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['driving_licence_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['driving_licence_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_statuatory" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}
	public function driving_licence_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('driving_licence_expiry<'=>$today,'driving_licence_expiry!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Driving Licence No</th>
						<th>Driving Licence Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['driving_licence_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['driving_licence_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_statuatory" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}

	public function visa_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('visa_expiry_date>='=>$today,'visa_expiry_date<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Visa No</th>
						<th>Visa Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['visa_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['visa_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}
	public function visa_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('visa_expiry_date<'=>$today,'visa_expiry_date!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Visa No</th>
						<th>Visa Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['visa_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['visa_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}
	public function contract_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('contract_expiry_date>='=>$today,'contract_expiry_date<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
			/* <th>Work Permit No</th>
		<td>'.$myAction['work_permit_number'].'</td> */
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Contract Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['contract_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}
	public function contract_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$test=$this->Hr_model->get_employee_details(array('contract_expiry_date<'=>$today,'contract_expiry_date!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		/* <th>Work Permit No</th>
		<td>'.$myAction['work_permit_number'].'</td> */
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee No</th>
						<th>Employee Name</th>
						<th>Contract Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td>'.$myAction['employee_number'].'</td>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['contract_expiry_date'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_passport" >Update</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		} 
		echo json_encode($list);
	}

	public function dependent_expiry() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$newDate= date('Y-m-d', strtotime($today . ' +60 days'));
		$dependent_cpr_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_cpr_expiry>='=>$today,'dependent_cpr_expiry<='=>$newDate));
		$dependent_passport_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_passport_expiry>='=>$today,'dependent_passport_expiry<='=>$newDate));
		$dependent_visa_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_visa_expiry>='=>$today,'dependent_visa_expiry<='=>$newDate));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee Name</th>
						<th>Dependent Name</th>
						<th>Doc Type</th>
						<th>Doc No</th>
						<th>Doc Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($dependent_cpr_expiry_list!=false){
			foreach($dependent_cpr_expiry_list as $myAction){ 
				$list.='<tr>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['dependent_name'].'</td>
					<td>CPR</td>
					<td>'.$myAction['dependent_cpr'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['dependent_cpr_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_passport_expiry_list!=false){
			foreach($dependent_passport_expiry_list as $myAction2){ 
				$list.='<tr>
					<td>'.$myAction2['employee_name'].'</td>
					<td>'.$myAction2['dependent_name'].'</td>
					<td>Passport</td>
					<td>'.$myAction2['dependent_passport'].'</td>
					<td>'.date("M d, Y", strtotime($myAction2['dependent_passport_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction2['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_visa_expiry_list!=false){
			foreach($dependent_visa_expiry_list as $myAction3){ 
				$list.='<tr>
					<td>'.$myAction3['employee_name'].'</td>
					<td>'.$myAction3['dependent_name'].'</td>
					<td>Visa</td>
					<td>'.$myAction3['dependent_visa'].'</td>
					<td>'.date("M d, Y", strtotime($myAction3['dependent_visa_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction3['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_cpr_expiry_list==false && $dependent_passport_expiry_list==false && $dependent_visa_expiry_list==false){
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function dependent_expired() {
		$search_item = '';
		$today 	= date('Y-m-d');
		$dependent_cpr_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_cpr_expiry<'=>$today,'dependent_cpr_expiry!='=>'0000-00-00'));
		$dependent_passport_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_passport_expiry<'=>$today,'dependent_passport_expiry!='=>'0000-00-00'));
		$dependent_visa_expiry_list=$this->Hr_model->get_employee_dependent_details(array('dependent_visa_expiry<'=>$today,'dependent_visa_expiry!='=>'0000-00-00'));
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Employee Name</th>
						<th>Dependent Name</th>
						<th>Doc Type</th>
						<th>Doc No</th>
						<th>Doc Expiry</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($dependent_cpr_expiry_list!=false){
			foreach($dependent_cpr_expiry_list as $myAction){ 
				$list.='<tr>
					<td>'.$myAction['employee_name'].'</td>
					<td>'.$myAction['dependent_name'].'</td>
					<td>CPR</td>
					<td>'.$myAction['dependent_cpr'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['dependent_cpr_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_passport_expiry_list!=false){
			foreach($dependent_passport_expiry_list as $myAction2){ 
				$list.='<tr>
					<td>'.$myAction2['employee_name'].'</td>
					<td>'.$myAction2['dependent_name'].'</td>
					<td>Passport</td>
					<td>'.$myAction2['dependent_passport'].'</td>
					<td>'.date("M d, Y", strtotime($myAction2['dependent_passport_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction2['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_visa_expiry_list!=false){
			foreach($dependent_visa_expiry_list as $myAction3){ 
				$list.='<tr>
					<td>'.$myAction3['employee_name'].'</td>
					<td>'.$myAction3['dependent_name'].'</td>
					<td>Visa</td>
					<td>'.$myAction3['dependent_visa'].'</td>
					<td>'.date("M d, Y", strtotime($myAction3['dependent_visa_expiry'])).'</td>
					<td><a href="'.base_url().'index.php/masters/Employee/editEmployee/'.$myAction3['employee_id'].'/add_dependent" >Update</a></td>';
				$list.='</tr>';
			}
		}
		if($dependent_cpr_expiry_list==false && $dependent_passport_expiry_list==false && $dependent_visa_expiry_list==false){
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

}
?>