<?php
class Login extends CI_Controller {
	public function __construct()
{
    parent::__construct();// you have missed this line.
    $this->load->library('session');
}
	public function index()
	{
		if($this->session->userdata('user_logged_in') == true)
		{
			redirect('Dashboard/home');
		}
		else
		{
			//$this->load->view('templates/header');
			$this->load->view('login/login');
			//$this->load->view('templates/footer');
		}
	}

	function do_login()
	{
		$this->form_validation->set_rules('user_email_id', 'Name', 'required|max_length[100]');
		$this->form_validation->set_rules('user_password', 'Password', 'required|min_length[6]|max_length[50]');
		if ($this->form_validation->run() == FALSE)
		{	// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			//$this->load->view('templates/header');
			$this->load->view('login/login');
			//$this->load->view('templates/footer');
		}
		else
		{	// true section
			
			// check if login credentials are valid from db
			//$this->load->model('auth_model');
			$user_email_id=$this->input->post('user_email_id');
			$user_password=$this->input->post('user_password');
			$user_record = $this->auth_model->check_user_login($user_email_id,$user_password);
			if($user_record == false){
				// throw invalid email id or password error
				$this->session->set_flashdata('response','Invalid Email ID or Password',':old:');
				$this->load->view('login/login');
			}
			else
			{
				$user_group_id=$user_record['user_group_id'];
				$query = $this->db->query("SELECT user_group_name FROM `user_groups` where user_group_id='$user_group_id' ");
				if(isset($query->row()->user_group_name) && $query->row()->user_group_name!="") {  $user_group_name=$query->row()->user_group_name;  } else { $user_group_name=''; }
				// create session
				$userdata = array(
					'user_logged_in' => true,
					'name' => $user_record['name'],
					'user_id' => $user_record['user_id'],
					'user_email_id' => $user_record['user_email_id'],
					'user_name' => $user_record['user_name'],
					'user_group_id' => $user_record['user_group_id'],
					'user_group_name' => $user_group_name,
					'is_estimator' => $user_record['is_estimator'],
					'is_approver' => $user_record['is_approver'],
					'is_salesman' => $user_record['is_salesman'],
					'is_user_type' => $user_record['is_user_type'],
					'enable_file_deletion' => $user_record['enable_file_deletion'],
					'default_controller_name' => $user_record['default_controller_name'],
					'user_division' => $user_record['user_division'],
					'credit_permission' => $user_record['is_credit_permission'],
					'discount_limit' => $user_record['discount_limit'],
					'is_labour_disc' => $user_record['is_labour_disc'],
					'is_spare_disc'  => $user_record['is_spare_disc'],
					'advisor_id'  => $user_record['advisor_id']
				);
				$this->session->set_userdata($userdata);
				
				$str_arr = preg_split ("/\,/", $user_record['is_user_type']);
				redirect('Dashboard/home');
			}
		}
	}
	function do_send_new_password($user_email_id="")
	{
		/*$this->form_validation->set_rules('user_email_id', 'Email ID', 'required|min_length[5]|max_length[100]|valid_email');
		if($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			
			$this->load->view('templates/header');
			$this->load->view('login/forgot_password');
			$this->load->view('templates/footer');
		}
		else
		{*/
			//true section
			$this->load->helper('string');
			//$user_email_id = $this->input->post('user_email_id');
			$where = array('user_email_id' => $user_email_id);

			$records = $this->crud_model->get('users',$where);

			if($records!=false)
			{// true section
				// email id found
				$random_password=strtoupper(random_string('alnum', 8));
				
				$update = array('user_password'=>md5($random_password));
				
				$this->crud_model->update('users',$update,$where);
				log_message('INFO','New password for '.$user_email_id.' is '.$random_password);
				
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Password Reset';
				$to 		= $user_email_id;
				$subject 	= 'Your new password';
				$message 	= '
	<p>Hello,</p>
	<p>Based on your request to reset the password we are sending you the updated password here. Please note down the new password and <a href="'.site_url().'">login here</a></p>
	<p>New Password: '.$random_password.'</p>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);
				
				$this->session->set_flashdata('response','<div class="alert alert-info">New password sent to your Email ID. Please use your new password for login.</div>');
				redirect('login');
			}
			else
			{// false section
				// no email id found
				$this->session->set_flashdata('response','<div class="alert alert-error">Email ID not available in our database</div>');
				redirect('login');
			}
		//}
	}
}
