<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class SalesBillOutstanding extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	
	
	
	public function by_party($status='') {
		$this->users_model->permission("SalesBillOutstandingby_party", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('client_code', 'Client', 'required');
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['status'] = 1;
				if($this->input->post('user_id') != '0' ) {
					$where['cust_bill_allocations.sm_id'] = $this->input->post('user_id');
				}
				if($this->input->post('quotation_status') != '' ) {
					$where['cust_bill_allocations.status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('client_code') != '' ) {
					$where['cust_bill_allocations.customer_code'] = $this->input->post('client_code');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['cust_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				//$where['bill_type'] = 'Invoice';

				$this->db->select('cust_bill_allocations.id,cust_bill_allocations.bill_id,cust_bill_allocations.bill_type,cust_bill_allocations.trn_no,cust_bill_allocations.bill_date,cust_bill_allocations.status,cust_bill_allocations.bill_amt,cust_bill_allocations.bill_os_amount,(`cust_bill_allocations`.`bill_amt`-`cust_bill_allocations`.`bill_os_amount`) as openig_paid,cust_bill_allocations.po_no,new_client_master.client_name,new_client_master.client_code,new_client_master.credit_days,users.user_name' );
				$this->db->from('cust_bill_allocations');
				$this->db->where($where);
				$this->db->join('new_client_master','cust_bill_allocations.customer_code = new_client_master.client_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by('cust_bill_allocations.bill_id');
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				}
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}

				$this->db->where('jc.`job_card_status` !=', 'Cancelled');
				if($this->input->post('report_date_to')!='') {
					$this->db->where('DATE(jc.`job_card_date`) >=', $this->input->post('report_date_to'));
				}
				if($this->input->post('client_id') != '') {
					$this->db->where('jc.`client_id`', $this->input->post('client_id'));
				}
				if($this->input->post('user_id') != '0' ) {
					$this->db->where('jc.`salesman_id`', $this->input->post('user_id'));
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('jc.`job_card_divisionid`', $this->input->post('division'));
				}
				
				$this->db->query("SET SQL_BIG_SELECTS=1");
				$this->db->select("jc.`job_card_id`,jc.`job_card_number`,jc.`job_card_date`,`job_card_total_with_vat` as job_card_amount_with_vat,jc.client_name,jc.`quotation_id`,jc.`quotation_number_full`,sum(if(cba.bill_type = 'Invoice', cba.bill_amt, 0)) as invoiced_amount,sum(if(cba.bill_type = 'Receipt', cba.bill_amt, 0)) as received_amount,sum(if(cba.bill_type = 'Credit Note', cba.bill_amt, 0)) as cr_amount,jc.user_name as sales_man" );
				$this->db->from('view_furniture_job_card as jc');
				$this->db->join('furniture_invoice as fi','fi.job_card_id = jc.job_card_id','left');
				$this->db->join('cust_bill_allocations as cba',' cba.bill_id = fi.invoice_id and cba.`trn_type` !="Opening"','left');
				$this->db->limit(200);
				$this->db->group_by("jc.`job_card_id`");
				$inv_rs = $this->db->get();
				$data['uninvoiced_records'] =  $inv_rs->result_array();
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['uninvoiced_records'] =  "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();

			$this->load->view('templates/header');
			$this->load->view('reports/sales_bill_outstanding_by_party',$data);
			$this->load->view('templates/footer');
		}
	}

	public function by_party_age_wise($status='') {
		$this->users_model->permission("SalesBillOutstandingby_party_age_wise", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('client_code', 'Client', 'required');
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['status'] = 1;
				if($this->input->post('user_id') != '0' ) {
					$where['cust_bill_allocations.sm_id'] = $this->input->post('user_id');
				}
				if($this->input->post('quotation_status') != '' ) {
					$where['cust_bill_allocations.status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('client_code') != '' ) {
					$where['cust_bill_allocations.customer_code'] = $this->input->post('client_code');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['cust_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				//$where['bill_type'] = 'Invoice';

				$this->db->select('cust_bill_allocations.id,cust_bill_allocations.bill_id,cust_bill_allocations.bill_type,cust_bill_allocations.trn_no,cust_bill_allocations.bill_date,cust_bill_allocations.status,cust_bill_allocations.bill_amt,cust_bill_allocations.bill_os_amount,cust_bill_allocations.po_no,new_client_master.client_name,new_client_master.client_code,new_client_master.credit_days,users.user_name' );
				$this->db->from('cust_bill_allocations');
				$this->db->where($where);
				$this->db->join('new_client_master','cust_bill_allocations.customer_code = new_client_master.client_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by('cust_bill_allocations.bill_id');
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				}
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();

			$this->load->view('templates/header');
			$this->load->view('reports/sales_bill_outstanding_by_party_age_wise',$data);
			$this->load->view('templates/footer');
		}
	}

	public function all_customers($status='') {
		$this->users_model->permission("SalesBillOutstandingall", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['status'] = 1;
				
				
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['cust_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				$where['bill_type'] = 'Invoice';

				$this->db->select('cust_bill_allocations.id,cust_bill_allocations.bill_id,cust_bill_allocations.trn_no,cust_bill_allocations.customer_code,cust_bill_allocations.bill_date,cust_bill_allocations.status,sum(`cust_bill_allocations`.`bill_amt`) as bill_amt, sum(`cust_bill_allocations`.`bill_os_amount`) as bill_os_amount,sum(`cust_bill_allocations`.`bill_amt`)-sum(`cust_bill_allocations`.`bill_os_amount`) as openig_paid,new_client_master.client_name,new_client_master.client_code,new_client_master.credit_days,users.user_name' );
				$this->db->from('cust_bill_allocations');
				$this->db->where($where);
				$this->db->join('new_client_master','cust_bill_allocations.customer_code = new_client_master.client_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by("`cust_bill_allocations`.`customer_code`");
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				}
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$this->load->view('templates/header');
			$this->load->view('reports/sales_bill_outstanding_all',$data);
			$this->load->view('templates/footer');
		}
	}

	public function all_customers_age_wise($status='') {
		$this->users_model->permission("SalesBillOutstandingall_age_wise", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['status'] = 1;
				
				
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['cust_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(cust_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(cust_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				$where['bill_type'] = 'Invoice';

				$this->db->select('cust_bill_allocations.id,cust_bill_allocations.bill_id,cust_bill_allocations.trn_no,cust_bill_allocations.customer_code,cust_bill_allocations.bill_date,cust_bill_allocations.status,sum(`cust_bill_allocations`.`bill_amt`) as bill_amt, sum(`cust_bill_allocations`.`bill_os_amount`) as bill_os_amount,sum(`cust_bill_allocations`.`bill_amt`)-sum(`cust_bill_allocations`.`bill_os_amount`) as openig_paid,new_client_master.client_name,new_client_master.client_code,new_client_master.credit_days,users.user_name' );
				$this->db->from('cust_bill_allocations');
				$this->db->where($where);
				$this->db->join('new_client_master','cust_bill_allocations.customer_code = new_client_master.client_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by("`cust_bill_allocations`.`customer_code`");
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				}
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$this->load->view('templates/header');
			$this->load->view('reports/sales_bill_outstanding_all_customers_age_wise',$data);
			$this->load->view('templates/footer');
		}
	}
	
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		if($given_date <= $today_date) {
			return true;
		}else{
			$this->form_validation->set_message('date_check', 'Date cannot be Future date');
			return FALSE;
		}
	}
}

?>