<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Enquiry extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
	}
	


	public function listEnquiry($fromDate="NIL",$toDate="NIL",$client_id='NIL',$user_id='NIL',$unassigned='NIL',$attended='NIL',$quoted='NIL'){
		$this->users_model->permission("Enquiry", "View");
		$title['headerTitle']="Enquiry List";

		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}

		if (@$this->input->post('user_id')) {
			$user_id =   $this->input->post("user_id");
		}elseif ($user_id != "NIL") {
			$user_id	=	$user_id;
		} else {
			$user_id	= "NIL";
		}
		
		if (@$this->input->post('unassigned')) {
			$unassigned =   $this->input->post("unassigned");
		}elseif ($unassigned != "NIL") {
			$unassigned	=	$unassigned;
		} else {
			$unassigned	= "NIL";
		}
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('attended')) {
			$attended =   $this->input->post("attended");
		}elseif ($attended != "NIL") {
			$attended	=	$attended;
		} else {
			$attended	= "NIL";
		}

		if (@$this->input->post('quoted')) {
			$quoted =   $this->input->post("quoted");
		}elseif ($quoted != "NIL") {
			$quoted	=	$quoted;
		} else {
			$quoted	= "NIL";
		}

		$customer_name='NIL';
		
		$config["base_url"] = base_url() . "index.php/furniture/Enquiry/listEnquiry/".$fromDate."/".$toDate."/".$client_id."/".$user_id."/".$unassigned."/".$attended."/".$quoted;
		$config["total_rows"] = $this->EnquiryModel->record_count($fromDate,$toDate,$client_id,$user_id,$unassigned,$attended,$quoted);
		$config['num_links'] = 15;
		if(isset($_POST["ttttt"])) {
			$config["per_page"] = 10000000000000;
			$this->pagination->initialize($config);
			$page = 0;
			$i=1;
		} else {
			$config["per_page"] = 250;
			$this->pagination->initialize($config);
			$config['uri_segment'] = 11;
			if ($this->uri->segment(11)) {
				$page = $this->uri->segment(11)*250-250;
				$i=$page+1;
			} else {
				$page = 0;
				$i=1;
			}
		}

		//pagging end
		$list='';
		$headList='';
		$net_amount=0;
		$EditPermission=$this->users_model->check_permission("Enquiry","Edit"); 
		foreach ($this->EnquiryModel->listData($config["per_page"], $page,$fromDate,$toDate,$client_id,$user_id,$unassigned,$attended,$quoted) as $row) {
			$href='';
			if($row->status=='2'){
				$style='style="background:#dff1cc;color:#316100;"';
				$href.='<li><a href="'.site_url('furniture/Enquiry/editenquiry/'.$row->id).'"><i class="fa fa-eye"></i> View Enquiry</a></li>';
			} else if($row->status=='0'){
				$style='style="background: #f5d2d2;color:#6b1110;"';
			} else {
				$style='';
				if($EditPermission){
					$href.='<li><a href="'.site_url('furniture/Enquiry/editenquiry/'.$row->id).'"><i class="fa fa-edit"></i> Update</a></li>';
				}
			}
			if($row->salesman_id==='' || $row->salesman_id==='0' ){
				$status='Un Assigned';
			} else if($row->enquiry_details_id!='') {
				if($row->quotation_number!=''){
					$status='Quoted';
				} else {
					$status='Attended';
					$getClientID=$row->client_id;
					$this->db->select('*');
					$this->db->from('new_client_master');
					$this->db->where('client_id', $getClientID);
					$this->db->where('cstatus', 1);
					$query = $this->db->get();
					if($query->num_rows() > 0){
						$href.='<li><a href="javascript:createQuotation('.$row->id.')"><i class="fa fa-mail-forward"></i>Convert Quotation</a></li>';
					} 
					//'.site_url('furniture/Enquiry/do_draft/'.$row->id).'
				}
			} else {
				$status='Open';
			}
			if($status!='Quoted'){
				$now = time(); // or your date as well
				$your_date = strtotime($row->enquiry_date);
				$datediff = $now - $your_date;
				$days=round($datediff / (60 * 60 * 24));
				if($this->session->userdata('user_group_id') == 1 ) {
					$rrr="'".$row->id."','".$row->enquiry_number."'";
					$href.='<li><a href="javascript:isDel('.$rrr.')"><i class="fa fa-mail-forward"></i>Cancel</a></li>';
				}
			} else {
				$this->db->select('*');
				$this->db->from('furniture_quotation');
				$this->db->where('enquiry_id', $row->id); 
				$up_data = $this->db->get();
				if($up_data->num_rows() > 0){
					$test	=	$up_data->result_array();
					$now	=	strtotime($test[0]['quotation_date']);
					$your_date = strtotime($row->enquiry_date);
					$datediff = $now - $your_date;
					$days=round($datediff / (60 * 60 * 24));
				} else{
					$days='';
				}
			}

			$list.= '<tr '.$style.' >
						<td style="width:20px;">'.$i++.'</td>
						<th scope="row" style="width:110px;">'.$row->enquiry_number.'</th>
						<td style="width:110px;">'.date("M d, Y", strtotime($row->enquiry_date)).'</td>
						<td>'.$row->prospect_name.'</td>
						<td>'.$row->user_name.'</td>
						<td style="width:90px;">'.$status.'</td>
						<td>'.$row->enquiry_souce_name.'</td>
						<td style="width:20px;">'.$days.'</td>
						<td style="width:50px;"><div class="btn-group">
						<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
						Action <span class="caret"></span>
						</button>
						<ul class="dropdown-menu" role="menu">
							'.$href.'
						</ul>
					</div></td>
				</tr>';
				//
			if($client_id!="NIL"){
				$customer_name=$row->prospect_name;
			}									
		}
		$userList=$this->EnquiryModel->userList();
		$datas   =   array("data" => $list, "links" => $this->pagination->create_links(),"userList" => $userList,"client_id" => $client_id,"fromDate" => $fromDate,"toDate" => $toDate,"customer_name" => $customer_name,"user_id" => $user_id,"unassigned" => $unassigned,"attended" => $attended,"quoted" => $quoted);
	
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/listEnquiry',$datas);
		$this->load->view('templates/footer');
	}

	

	public function editenquiry($id,$type=NULl){
		$this->users_model->permission("Enquiry", "Edit");
		$title['headerTitle']="Enquiry Edit";
		if($type==='head') {
			$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');
			$this->form_validation->set_rules('enquiry_souce_id', 'Source of Enquiry', 'required');
		}
		
		if($type==='details') {
			$this->form_validation->set_rules('appointment_date', 'Appointment Date', 'required');
			$this->form_validation->set_rules('meeting_type_id', 'Meeting Type', 'required');
			$this->form_validation->set_rules('outcome_id', 'Outcome', 'required');
			$this->form_validation->set_rules('notes', 'Notes', 'required');
		}

		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('enquiry',$where); 

		

		if($records != false){
			
			if ($this->form_validation->run() == FALSE)
			{
				$data['type']			 			 = $type;
				$data['id']			 			 = $records[0]['id'];
				$data['enquiry_number']			 = $records[0]['enquiry_number'];
				$data['enquiry_date']			 = $records[0]['enquiry_date'];
				$data['division_id']			 = $records[0]['division_id'];
				$data['client_id']			 	 = $records[0]['client_id'];
				$data['contact_id']			 	 = $records[0]['contact_id'];
				$data['prospect_name']			 = $records[0]['prospect_name'];
				$data['hdcontact_person']		 = $records[0]['contact_person'];
				$data['phone']			 		 = $records[0]['phone'];
				$data['email']			 		 = $records[0]['email'];
				$data['salesman_id']			 = $records[0]['salesman_id'];
				$data['requirement']			 = $records[0]['requirement'];
				$data['status']			 		 = $records[0]['status'];
				$data['enquiry_souce_id']		 = $records[0]['enquiry_souce_id'];
				$data['quotation_number']		 = $records[0]['quotation_number'];

				$data['enquiry_details']=$this->crud_model->get('enquiry_details',array('enquiry_id'=>$id,'status'=>1), null,null,null,null,null, null);

				
				$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select Division- '));
				$data['division_list'] = $list;
				if($records[0]['salesman_id']==$this->session->userdata('user_id')) {
					$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(),array('is_salesman'=>1,'user_id'=>$records[0]['salesman_id']));
				} else if($this->session->userdata('is_salesman')==1 && $this->session->userdata('user_group_id') != 1) {
					$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1,'user_id'=>$this->session->userdata('user_id')),'user_name','asc');
				} else {
					$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1),'user_name','asc');
				}
				$data['salesman_list'] = $list2;
				$list3 = $this->crud_model->get_list('meeting_type_name','meeting_type_name','meeting_type',array(''=>'---Select---'),array('status'=>1));
				$data['meeting_type_list'] = $list3;
				$list4 = $this->crud_model->get_list('outcome_name','outcome_name','outcome',array(''=>'---Select---'),array('status'=>1));
				$data['outcome_list'] = $list4;

				$list5 = $this->crud_model->get_list('Contact_Id','Contact_Name','client_contact',array(''=>' - Select Contact Person - '),array('Client_Id'=>$records[0]['client_id']));
				$data['client_contact_list'] = $list5;

				$list6 = $this->crud_model->get_list2('enquiry_souce_id','enquiry_souce_name','enquiry_souce',array(''=>'Select Source Of Enquiry'),array('status'=>1),'enquiry_souce_name','asc');
				$data['enquiry_souce_list'] = $list6;


				$where2=array(
					'client_id' => $records[0]['client_id']
				);
				//$cust_records=$this->crud_model->get('new_client_master',$where2);
				$this->db->select('new_client_master.*,users.user_name');
				$this->db->from('new_client_master');
				$this->db->join('users', 'users.user_id = new_client_master.sales_man', 'left');
				$this->db->where('client_id', $records[0]['client_id']);
				$result = $this->db->get();
				$cust_records = $result->result_array();

				if($cust_records != false){
					$data['client_name']		= $cust_records[0]['client_name'];
					$data['client_telephone1']	= $cust_records[0]['client_telephone1'];
					$data['client_email']		= $cust_records[0]['client_email'];
					$data['client_address']		= $cust_records[0]['client_address'];
					$data['contact_person']		= $cust_records[0]['contact_person'];
					$data['tax_name']			= $cust_records[0]['tax_name'];
					$data['tax_no']				= $cust_records[0]['tax_no'];
					$data['user_name']			= $cust_records[0]['user_name'];
					$data['cstatus']			= $cust_records[0]['cstatus'];
				} else {
					$data['client_name']		= NULL;
					$data['client_telephone1']	= NULL;
					$data['client_email']		= NULL;
					$data['client_address']		= NULL;
					$data['contact_person']		= NULL;
					$data['tax_name']			= NULL;
					$data['tax_no']				= NULL;
					$data['user_name']			= NULL;
					$data['cstatus']			= NULL;
				}

				$this->db->select('*');
				$this->db->from('enquiry_upload_files');
				$this->db->where('enquiry_id', $id); 
				$up_data = $this->db->get();
				if($up_data->num_rows() > 0){
					$data['rec_file'] = $up_data->result_array();
				}
				else{
					$data['rec_file'] = array();
				}

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/edit_enquiry',$data);
				$this->load->view('templates/footer');
			} else {

				if($type==='head') {
					$data=array(
						'prospect_name'   =>  $this->input->post('prospect_name'),
						'client_id'   =>  $this->input->post('client_id'),
						'phone'  =>  $this->input->post('phone'),
						'email'   =>  $this->input->post('email'),
						'contact_id'   =>  @$this->input->post('client_contact'),
						'contact_person'   =>  $this->input->post('contact_person'),
						'requirement'  =>  $this->input->post('requirement'),
						'enquiry_souce_id'  =>  $this->input->post('enquiry_souce_id'),
						'salesman_id'  =>  $this->input->post('salesman_id')
					);
					$where = array('id' => $id);
					$this->crud_model->update('enquiry',$data,$where);
					$this->session->set_flashdata('success','The enquiry has been updated...');
				}

				if($type==='details') {
					$data=array(
							'enquiry_id'   =>  $id,
							'appointment_date'  =>  date("Y-m-d", strtotime($this->input->post('appointment_date'))),
							'meeting_type'   =>  $this->input->post('meeting_type_id'),
							'outcome'   =>  $this->input->post('outcome_id'),
							'notes'  =>  $this->input->post('notes'),
							'Created_User_id'  =>  $this->session->userdata('user_id'),
							'created_date'  => date('Y-m-d')
					);
					$this->crud_model->insert('enquiry_details',$data);
					$this->session->set_flashdata('success2','The enquiry has been updated...');
				}

				$log_data=array(
					'trans_no'  	=>  $records[0]['enquiry_number'],
					'trans_type'  	=>  'Enquiry',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
				redirect('furniture/Enquiry/editenquiry/'.$id.'/'.$type);
			}
		}
	}

	public function createenquiry(){
		$this->users_model->permission("Enquiry", "Add");
		$this->form_validation->set_rules('division_id', 'Division', 'required|max_length[50]');
		$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');
		$this->form_validation->set_rules('phone', 'Tel', 'required');
		$this->form_validation->set_rules('requirement', 'Requirement', 'required');
		$this->form_validation->set_rules('enquiry_souce_id', 'Souce of Enquiry', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			$title['headerTitle']="Enquiry Create";
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select Division- '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1),'user_name','asc');
			$data['salesman_list'] = $list2;
			$list3 = $this->crud_model->get_list2('enquiry_souce_id','enquiry_souce_name','enquiry_souce',array(''=>'Select Source Of Enquiry'),array('status'=>1),'enquiry_souce_name','asc');
			$data['enquiry_souce_list'] = $list3;

			if(get_cookie('division_val_id')!=false){ 
				$data['enq_no']= $this->getNo(get_cookie('division_val_id')); 
				$data['division_id']=get_cookie('division_val_id'); 
			} else { 
				$data['enq_no']= NULL; 
				$data['division_id']=NULL; 
			}

			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/create_enquiry',$data);
			$this->load->view('templates/footer');
		} else {
			$enquiry_no=$this->getNo($this->input->post('division_id'));
			$data=array(
				'enquiry_number'  =>  $enquiry_no,
				'enquiry_date'  =>  date('Y-m-d'),
				'division_id'  =>  $this->input->post('division_id'),
				'client_id'   =>  $this->input->post('client_id'),
				'prospect_name'   =>  $this->input->post('prospect_name'),
				'phone'  =>  $this->input->post('phone'),
				'email'   =>  $this->input->post('email'),
				'contact_person'   =>  $this->input->post('contact_person'),
				'contact_id'   =>  @$this->input->post('client_contact'),
				'requirement'  =>  $this->input->post('requirement'),
				'salesman_id'  =>  $this->input->post('salesman_id'),
				'enquiry_souce_id'  =>  $this->input->post('enquiry_souce_id'),
				'Created_User_id'  =>  $this->session->userdata('user_id'),
				'created_date'  => date('Y-m-d'),
				'status'   =>  1
			);
			$records=$this->crud_model->insert('enquiry',$data);
			$insert_id	=	$this->db->insert_id();

			$log_data=array(
				'trans_no'  =>  $enquiry_no,
				'trans_type'  =>  'Enquiry',
				'trans_op'  =>  'Create',
				'trans_user_id'  =>  $this->session->userdata('user_id')

			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$cookie_division_val = array(
				'name'   => 'division_val_id',
				'value'  => $this->input->post('division_id'),
				'expire' => 60*60*24*60
			);
			$this->input->set_cookie($cookie_division_val);

			
			$this->session->set_flashdata('success','Enquiry Created...');
			redirect('furniture/Enquiry/editEnquiry/'.$insert_id);
		}
	}

	function upload_it() {  
		$this->users_model->permission("Enquiry", "Edit");
		if($this->input->post('title')!=='' && $_FILES["fileField"]["name"]!=='' ){
			$this->load->helper('form');
			$uniqueID = 'enq'.$this->input->post('enquiry_id_redrct');
			if(!file_exists("uploads/".$uniqueID))
				mkdir("uploads/".$uniqueID);
				$config['upload_path'] = 'uploads/'.$uniqueID;
				$config['allowed_types'] = '*';
				$config['overwrite'] = FALSE;
				$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');
				$this->upload->do_upload("fileField");	
				$upload_data  =   $this->upload->data();
				$uploadImage = $upload_data['file_name'];
				$newdata = array(
					'title'		=> $this->input->post('title'),
					'enquiry_id'=> $this->input->post('enquiry_id_redrct'),
					'user_id'	=> $this->session->userdata('user_id'),
					'file_name' => $uploadImage,
				);
				$add_file = $this->db->insert('enquiry_upload_files', $newdata); 
				if($add_file) {
					$this->session->set_flashdata('success','File Uploaded Successfully...');
				} else {
					$this->session->set_flashdata('response','Something Wrong.Try Again...');
				}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	    redirect('furniture/Enquiry/editEnquiry/'.$this->input->post('enquiry_id_redrct').'');
	}

	public function do_draft($Enquiry_Id){
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
		$query_data= $this->db->query("SELECT * FROM `furniture_quotation` WHERE `enquiry_id`='$Enquiry_Id' limit 1");
		if ($query_data->num_rows()==0){
			$user_id  =	$this->session->userdata('user_id');
			$dbdata   = $this->EnquiryModel->enquiryRow($Enquiry_Id);
			$division = $dbdata->division_id;
			$SQL = "SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM furniture_quotation WHERE `quotation_divisionid`='$division';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();

			if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
				$quotation_number= $data[0]['new_quotation_number'];
			} else{
				$quotation_number= 10001;
			}

			$division_dbdata = $this->EnquiryModel->company_division($dbdata->division_id);
			$qtnmr=$division_dbdata.'-'.$quotation_number;

			if($dbdata->tax_perce==0){
				$vat_percentage=0;
			} else {
				$date=date("Y-m-d");
				$query2= $this->db->query("SELECT * FROM `vat_applicable` WHERE `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where `applicable_date`<'$date') order by `vat_percentage` DESC");
				$vat_percentage=$query2->row()->vat_percentage;
			}
			
			$data = array(
				'quotation_number' 			=> $quotation_number,
				'quotation_number_full' 	=> $qtnmr.'-0',
				'quotation_revisionnumber' 	=> 0,
				'quotation_date'   			=> date("Y-m-d"),
				'quotation_divisionid'    	=> $dbdata->division_id,
				'client_id'    				=> $dbdata->client_id,
				'contact_id'    			=> $dbdata->contact_id,
				'quotation_vat_percentage'  => $vat_percentage,
				'quotation_vat_amount'  	=> 0,
				'quotation_amount_with_vat'  => 0,
				'quotation_status'    		=> 'Draft',
				'enquiry_id'    			=> $Enquiry_Id,
				'salesman_id'  				=> $dbdata->salesman_id,
				'status'  					=> 3
			);
			
			
			$this->db->insert('furniture_quotation', $data);
			$insert_id = $this->db->insert_id();	
			$list='';
			$i=0;
			$log_data=array(
				'trans_no'  =>  $qtnmr.'-0',
				'trans_type'  =>  'Quotation',
				'trans_op'  =>  'Create',
				'trans_user_id'  =>  $this->session->userdata('user_id')

			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $insert_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Create',
				'flow_id'  		=>  3,
				'group_by'  	=>  1,
				'trans_user_id' =>  $this->session->userdata('user_id')

			);
			$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);			
			$u_data = array(
				'quotation_number' => $qtnmr,
				'status' => 2
			);
			$this->db->where('id', $Enquiry_Id);
			$this->db->update('enquiry', $u_data);
			
			if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    redirect("furniture/Enquiry/listEnquiry");
                } else {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('success', 'Quotation Created Successfully');
                    $path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$insert_id;
					redirect($path);
             }
			
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'Quotation Already created!!!');
			//$path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$query_data->row()->id;
			$path	=	base_url()."index.php/furniture/Enquiry/listEnquiry";
			redirect($path);
		}
		
	}
	public function delete_img($id){
		$this->users_model->permission("Enquiry", "Delete");
		$this->db->where('id',$id);
		$this->db->delete('enquiry_upload_files');
		$this->session->set_flashdata('response','File Deleted...');
		redirect('furniture/Enquiry/editenquiry/'.$id.'');
	}

	public function delete($id,$enquiry_number){
		$this->users_model->permission("Enquiry", "Delete");
		if($id!=''){
			$update_data = array(
				'status' 		=> 0
			);
			$this->db->where('id', $id);
			$this->db->update('enquiry', $update_data);

			$log_data=array(
				'trans_no'  =>  $enquiry_number,
				'trans_type'  =>  'Enquiry',
				'trans_op'  =>  'Delete',
				'trans_user_id'  =>  $this->session->userdata('user_id')
			);

			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$this->session->set_flashdata('response', 'Deleted Successfully');
            redirect("furniture/Enquiry/listEnquiry");
		} else {
			redirect("furniture/Enquiry/listEnquiry");
		}
	}

	public function getNo($division_id){  
		$query= $this->db->query("SELECT count(id) as enquiry_no FROM `enquiry` WHERE division_id='$division_id' ");
		$no=$query->row()->enquiry_no+1;
		if($division_id!=0){
			$query2= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
			$division_code=$query2->row()->division_code;
		} else {
			$division_code='';
		}
		$data='ENQ'.sprintf("%'.05d",$no).$division_code;
	    return $data;
		
	}
		
	public function getEnquiryNo(){  
		$division_id =$this->input->post('division_id');
		$query= $this->db->query("SELECT count(id) as enquiry_no FROM `enquiry` WHERE division_id='$division_id' ");
		$no=$query->row()->enquiry_no+1;
		if($division_id!=0){
			$query2= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
			$division_code=$query2->row()->division_code;
		} else {
			$division_code='';
		}
		$j='ENQ'.sprintf("%'.05d",$no).$division_code;
		$data   =   json_encode(array('2',$j));
	    echo $data;
		
	}

	public function search_client() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where cstatus=1 AND ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%'  )  union (SELECT * FROM `new_client_master` where cstatus=1 AND   `client_id` not in (SELECT `client_id` FROM `new_client_master` where  cstatus=1 AND  ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%' ) ) ".$sql." order by client_name) limit 50 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" /><input type="hidden" class="client_telephone1" value="'.$client_contact_datas['client_telephone1'].'" /><input type="hidden" class="client_email" value="'.$client_contact_datas['client_email'].'" /><input type="hidden" class="cperson" value="'.$client_contact_datas['contact_person'].'" /><input type="hidden" class="tax_name" value="'.$client_contact_datas['tax_name'].'" /><input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />'.$client_contact_datas['client_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}


	public function search_client_in_enquiry() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where ( cstatus=1 OR cstatus=2 ) AND  ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%'  )  union (SELECT * FROM `new_client_master` where cstatus=1 AND `client_id` not in (SELECT `client_id` FROM `new_client_master` where cstatus=1 AND ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%' ) ) ".$sql." order by client_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='<tr class="no_result_button" tabindex="-1"><th><b>Name</b></th><th><b>Tel 1</b></th><th><b>Tel 2</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr tabindex="-1" ><td class="client_button" ><input type="hidden" class="nbcli_id" value="' .$client_contact_datas['client_id'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" /><input type="hidden" class="client_telephone1" value="'.$client_contact_datas['client_telephone1'].'" /><input type="hidden" class="client_email" value="'.$client_contact_datas['client_email'].'" /><input type="hidden" class="cperson" value="'.$client_contact_datas['contact_person'].'" /><input type="hidden" class="sales_man" value="'.$client_contact_datas['sales_man'].'" /><input type="hidden" class="tax_name" value="'.$client_contact_datas['tax_name'].'" /><input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" /> '.$client_contact_datas['client_name'].'</td><td>'.$client_contact_datas['client_telephone1'].'</td><td>'.$client_contact_datas['client_telephone2'].'</td></tr>';
			}
		} else {
			$html.='<tr class="no_result_button" tabindex="-1"><td style="color:red;" colspan="3" > No Results Found </td></tr>';
		}
		print $html;
	}

	public function search_contact_person() {
		$client_id	=	$this->input->post('client_id');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$client_contact_data = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id'");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='<option value="" > - Select Contact Person- </option>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<option value="'.$client_contact_datas['Contact_Id'].'">'.$client_contact_datas['Contact_Name'].'</option>';
			}
		} else {
			$html.='<option value="" > - Select Contact Person- </option>';
		}
		
		print $html;
	}

	public function get_salesman() {
		$sales_man	=	$this->input->post('sales_man');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$client_contact_data = $this->db->query("SELECT * FROM `users` where `user_id`='$sales_man'");
		$result=	$client_contact_data->row_array();
		if($result!=false){
			print $result['user_name'];
		} else {
			print 0;
		}
		$n=1;
		/* if(count($client_contact_data->result_array())>0){
			$html ='<option value="" > - Select Contact Person- </option>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<option value="'.$client_contact_datas['Contact_Id'].'">'.$client_contact_datas['Contact_Name'].'</option>';
			}
		} else {
			$html.='<option value="" > - Select Contact Person- </option>';
		}
		
		print $html; */
	}
}

?>