<?php
class Vehicle_jobcard extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("Vehicle_jobcard", "View");
		$title['headerTitle']="Vehicle Job Card";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();
		$data['vjobcard'] = $this->Vehicle->getVjobcard();
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create_jobcard(){
		$this->users_model->permission("Vehicle_jobcard", "Add");
		$title['headerTitle']="Create Vehicle Job Card";
        if(get_cookie('division_val_id')!=false){ 
            $data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
            $title['h_division_id']=get_cookie('division_val_id'); 
        } else { 
            $data['enq_no']= NULL; 
            $title['h_division_id']=NULL; 
        }
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$this->load->view('furniture/quotations/jobcard/create_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("Vehicle_jobcard", "Add");
		$reg_no_id = $this->input->post('reg_no');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$config = array(		 
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
			),
		  array(
			'field' => 'client',
			'label' => 'Customer Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'conatct_name',
			'label' => 'Contact Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_num',
			'label' => 'Contact Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),array(
			'field' => 'advisor',
			'label' => 'Advisor',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),array(
			'field' => 'item[]',
			'label' => 'Labour Charges',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Add %s For Create Job Card.'
			)
	   		),
		);	
		if($this->input->post('reg_val') == 1 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);
			$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			
		}
		if($this->input->post('reg_val') == 0 || empty($this->input->post('reg_val'))  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'This Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				); 
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  set_value('model');			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			$data['conatct_name']  =  set_value('conatct_name');
			$data['km_in']  =  set_value('km_in');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
			$data['advisor']    =  set_value('advisor');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']     = $this->Vehicle->getMake();
			$data['staff']    = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			if(get_cookie('division_val_id')!=false){ 
				echo 'sss';
              
				$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
				$data['division_id']=get_cookie('division_val_id'); 
			} else { 
				$data['enq_no']= NULL; 
				$data['division_id']=NULL; 
			}
			$this->load->view('furniture/quotations/jobcard/create_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$division_id = $this->input->post('division_id');
			$job_card_number  = $this->crud_model->get_job_no($division_id);
			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			if($this->input->post('reg_val') == 0 ){
				$data = array(
					'reg_no'	 =>	$this->input->post('reg_no'),
					'make_id' => $this->input->post('make'),
					'model_id' => $this->input->post('model'),
					'client_id' => $this->input->post('client_id'),				 
					'car_year' => $this->input->post('car_year'),
					'car_color' => $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
			 $this->Vehicle->insertregistration($data);
			}
			$data = array(
				'job_card_number' => $job_card_number,
				'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
				'client_id' => $this->input->post('client_id'),
				'divisionid' => $division_id,
				'created_user_id' => $this->session->userdata('user_id'),
				'reg_no' =>  $this->input->post('reg_no'),
				'make' =>  $this->input->post('make'),
				'model' =>  $this->input->post('model'),
				'car_year' =>  $this->input->post('car_year'),
				'car_color' =>  $this->input->post('car_color'),
				'conatct_name' =>  $this->input->post('conatct_name'),
				'contact_num' =>  $this->input->post('contact_num'),
				'km_in' =>  $this->input->post('km_in'),
				'next_km' =>  $this->input->post('next_km'),
				'is_insurance' =>  $is_insurance,
				'salesman_id' =>  $this->input->post('advisor'),
				'job_card_status' =>  'Draft',
				'job_card_total' =>  $this->input->post('job_card_total'),
				'job_card_vat_perc' =>  10,
				'job_card_vat_amount' =>  $this->input->post('jbcdvat_amount'),
				'job_card_amount_with_vat' =>  $this->input->post('job_card_amount_with_vat'),
			);
			$res = $this->Vehicle->insertjobcard($data);
			if($res != ''){
				$insert_id = $res;
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description =$this->input->post('desc');
				$vat_perce =$this->input->post('item_vat');
				$vat_amount =$this->input->post('item_vat_amount');
				$item_discount =$this->input->post('item_discount');
				$net_amount =$this->input->post('item_net_amount');
				$sl = 1;
				for($i = 0; $i < count($item_id);$i++ ){
					$data  = array(
						'job_card_id' => $insert_id,
						'sl_no' => $sl++,
						'item_id' => $item_id[$i],
						'furniture_model' =>$furniture_model[$i],
						'furniture_description' =>$furniture_description[$i],
						'vat_perce' =>$vat_perce[$i],
						'vat_amount' =>$vat_amount[$i],
						'item_discount' =>$item_discount[$i],
						'net_amount' =>$net_amount[$i],
						'jb_type' =>1,
					);
					  $this->Vehicle->insertjobcarddetail($data);
				}
				
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Job Card',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Created');
				$cookie_division_val = array(
					'name'   => 'division_val_id',
					'value'  => $this->input->post('division_id'),
					'expire' => 60*60*24*60
				);
				$this->input->set_cookie($cookie_division_val);
				
			}
			else{
					$this->session->set_flashdata('response', 'Something WentWrong');
					 
				}
			redirect('jobcard/Vehicle_jobcard/create_jobcard');
		}
	}
	public function editVjobcard($id = ''){
		$this->users_model->permission("Vehicle_jobcard", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['vjobcard']  = $this->Vehicle->getVjobcard_detail($id);	
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['model']  = $this->Vehicle->getregisterModel($data['vjobcard']->make);
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$this->load->view('furniture/quotations/jobcard/edit_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		$this->users_model->permission("Vehicle_jobcard", "Edit");
		
		$reg_no_id = $this->input->post('reg_no_id');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
	
		$config = array(
			array(
				'field' => 'reg_no',
				'label' => 'This Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
			),
			array(
				'field' => 'make',
				'label' => 'Make',
				'rules' => 'required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
			),
			array(
				'field' => 'model',
				'label' => 'Model',
				'rules' => 'required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
			)
			);
	
		if($this->input->post('reg_no')!='' && $dbdata->reg_no!=$this->input->post('reg_no')){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'This Registration Number',
				'rules' => 'trim|is_unique[reg_no_table.reg_no]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
	
		if($this->input->post('chassi_number') != '' && $dbdata->chassi_number!= $this->input->post('chassi_number')){
			$config[] = array(
				'field' => 'chassi_number',
				'label' => 'Chassi Number',
				'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
				'errors' => array(
					'is_unique'      => '%s already exists.'
				)
			);
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  set_value('model');
			$data['client']   =  set_value('client');
			$data['chassi_number']  =  set_value('chassi_number');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Update Vehicle Registration";
		$this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();	
			$data['customer']  = $this->Vehicle->getCustomer();
			$data['edit_reg'] = $this->Vehicle->getUpdateRegi($reg_no_id);
			$data['model']  = $this->Vehicle->getregisterModel($data['edit_reg']->make_id);
			$this->load->view('masters/vehicle/edit_registration',$data);
			$this->load->view('templates/footer');
			//redirect('masters/VehicleRegistration/editRegistration/'.$this->input->post('reg_no_id').'');
		}
		else {
			$data = array(
				'make_id' 		=> $this->input->post('make'),
				'model_id'    	=> $this->input->post('model'),
				'car_year' 		=> $this->input->post('car_year'),
				'car_color' 	=> $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
				'radio_code' 	=> $this->input->post('radio_code'),
				'key_number' 	=> $this->input->post('key_number')
			);
			$res = $this->Vehicle->Updateregistration($data);
			if($res){
				$insert_id = $this->input->post('reg_no');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'VehicleRegistration',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Vehicle Registration Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				
			}
			redirect('masters/VehicleRegistration');
		}
	}
	public function updateNewRegistration(){
		$this->users_model->permission("VehicleRegistration", "Edit");
		$this->users_model->permission("VehicleRegistration", "Edit");
		$config = array(
			array(
                    'field' => 'reg_no',
                    'label' => 'Registration Number',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.'
                    )
            ),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            )
		);
		$reg_no_id = $this->input->post('reg_no_id');	
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('masters/VehicleRegistration/editRegistration/'.$this->input->post('reg_no_id').'');
		}
		else{
				$data = array(
				'make_id'   => $this->input->post('make'),
				'model_id'  => $this->input->post('model'),
				'client_id' => $this->input->post('client_id'),				 
			);
			$res = $this->Vehicle->Updatenameregistration($data);
			if($res){
				$insert_id = $this->input->post('reg_no');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'VRegister Change Name',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Name Changed Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				
			}
			redirect('masters/VehicleRegistration');

		}	
	}
	public function do(){

		echo 'ssss';
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/is_insurance');
		$this->load->view('templates/footer');
	}
	public function insurance($id = ''){
		echo 'dddd';
		exit();
		$this->users_model->permission("Vehicle_jobcard", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/is_insurance');
		$this->load->view('templates/footer');
	}
}