<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class Job_card extends CI_Controller {

	public function __construct(){
		parent::__construct();// you have missed this line.\
		if($this->session->userdata('user_logged_in') != true){
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}    
	}

	
	function estimation($job_card_id,$division_id,$job_card_number=0)	{
		$title['headerTitle']="Estimation";
		$data['records'] 		= $this->crud_model->get('job_card_details', array('job_card_details.job_card_id'=>$job_card_id), null, null, "ex_furniture_area", "ASC", null, null, null, "ex_furniture_area");
		$data['job_id']	=	$job_card_id;
		$data['job_card_number']	=	$job_card_number;
		$data['division_id']	=	$division_id;
		$data = html_escape($data);
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/job_estimation_view',$data);
		$this->load->view('templates/footer');
	}	

	public function jobEstimation($quotation_id,$job_card_details_id){
		//$this->hooks->call_hook('test');
		$title['headerTitle']="Estimation - Job Estimation";
		
		$estimation 				=  $this->Job_card_model->jobestimation($job_card_details_id);
		$estimationMaterialsAdded 	=  $this->Job_card_model->jobestimationMaterialsAdded($job_card_details_id);
		$estimationLabourCostAdded 	=  $this->Job_card_model->jobestimationLabourCostAdded($job_card_details_id);
		$estimationSubContractAdded =  $this->Job_card_model->jobestimationSubContractAdded($job_card_details_id);
		$estimationHiringAdded 		=  $this->Job_card_model->jobestimationHiringAdded($job_card_details_id);
		$estimationOthersAdded 		=  $this->Job_card_model->jobestimationOthersAdded($job_card_details_id);

		$quotation_details =  $this->Job_card_model->jobitemWiseDatarow($job_card_details_id);
		
		$data['records']=$quotation_details;
	
		//$data['boq_no'] =  $this->furniture_quotation_model->get_boq_no($quotation_details['furniture_id'],$quotation_details['quotation_divisionid'],$quotation_details['quotation_number']);
		
		$data['estimation'] 				= $estimation;
		$data['estimationMaterialsAdded'] 	= $estimationMaterialsAdded;
		$data['estimationLabourCostAdded'] 	= $estimationLabourCostAdded;
		$data['estimationSubContractAdded'] = $estimationSubContractAdded;
		$data['estimationHiringAdded'] 		= $estimationHiringAdded;
		$data['estimationOthersAdded'] 		= $estimationOthersAdded;
		
		$data['quotation_id']		= $quotation_id;
		$data['boq_no']				= $estimation['boq_no'];
		$data['quotation_number']	= $quotation_details['quotation_number'];
		$data['job_card_number']	= $quotation_details['job_card_number'];
		$data['job_id']				= $quotation_details['job_id'];
		$data['furniture_id']		= $estimation['furniture_id'];
		$data['job_card_details_id']= $job_card_details_id;
		$data['divisionid']			= $quotation_details['quotation_divisionid'];

		$unit_list = $this->crud_model->get_list2('unit_name','unit_name','unit_master',array(''=>' - Select Unit- '),array('status'=>'1'),'unit_name','asc');
		$data['unit_list'] = $unit_list;

		$department_list = $this->crud_model->get_list2('department_name','department_name','department_master',array(''=>' - Select Department- '),array('status'=>'1'),'department_name','asc');
		$data['department_list'] = $department_list;

		$emp_cat_data = $this->db->query("SELECT * FROM `emp_category` where `status`='1' order by emp_category_name asc");
		//$emp_category_list = $this->crud_model->get_list2('emp_category_name','emp_category_name','emp_category',array(''=>' - Select Emp Category- '),array('status'=>'1'),'emp_category_name','asc');
		$data['emp_category_list'] = $emp_cat_data->result();

		$supplier_list = $this->crud_model->get_list2('supplier_name','supplier_name','supplier_master',array(''=>' - Select Vendor- '),array('status'=>'1'),'supplier_name','asc');
		$data['supplier_list'] = $supplier_list;

		$data['overhead'] 		=  $this->furniture_quotation_model->overhead();

		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/jobEstimation',$data);
		$this->load->view('templates/footer');
	}

	public function materialAdd(){
		
		//$this->hooks->call_hook('check_permission');

		if ($this->input->post('item_id')!='' && $this->input->post('item_name')!='' && $this->input->post('uom')!='' && $this->input->post('material_qty')!='' && $this->input->post('material_unitprice')!=''  && $this->input->post('material_total')!='' && $this->input->post('item_id')!='undefined' && $this->input->post('item_name')!='undefined'  && $this->input->post('uom')!='undefined' && $this->input->post('material_qty')!='undefined'  && $this->input->post('material_unitprice')!='undefined' && $this->input->post('material_total')!='undefined'  && $this->input->post('item_id')!='undefined' && $this->input->post('item_name')!='undefined'){
				
			$job_id					=	$this->input->post('job_id');
			$quotation_id			=	$this->input->post('quotation_id');
			$job_card_details_id	=	$this->input->post('job_card_details_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$item_id	=	$this->input->post('item_id');
			$item_name	=	$this->input->post('item_name');
			$uom		=	$this->input->post('uom');
			$item_description		=	$this->input->post('item_description');
			$material_qty	=	$this->input->post('material_qty');
			$material_unitprice		=	$this->input->post('material_unitprice');
			$material_total	=	$this->input->post('material_total');
			$material_id	=	$this->input->post('material_id');
			$Creation_date=date("Y-m-d");
			if($material_id==='NO'){
				$query = $this->db->query("INSERT INTO `job_estimation_material`(`boq_no`,`job_card_id`,`job_card_details_id`,`furniture_id`,`item_id`, `item_name`, `item_description`, `material_qty`, `material_unitprice`, `material_total`, `material_uom`, `user_id`) VALUES ('$boq_no','$job_id','$job_card_details_id','$furniture_id','$item_id','$item_name','$item_description','$material_qty','$material_unitprice','$material_total','$uom','$user_id') ");
			} else {
				$query = $this->db->query("UPDATE `job_estimation_material` SET `item_id`='$item_id',`item_name`='$item_name',`item_description`='$item_description',`material_qty`='$material_qty',`material_uom`='$uom',`material_unitprice`='$material_unitprice',`material_total`='$material_total',`user_id`='$user_id' WHERE id='$material_id'");
			}
			if ($query){
				//$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				//$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
			
				if($material_id==='NO'){
					$c_id	=	$this->db->insert_id();
				} else {
					$c_id	=	$material_id;
				}
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function labourAdd(){
		
		if ($this->input->post('labour_department')!='' && $this->input->post('labour_no_of_ppl')!='' && $this->input->post('labour_hours')!='' && $this->input->post('labour_rate')!='' && $this->input->post('labour_department')!='undefined' && $this->input->post('labour_emp_category')!='undefined' && $this->input->post('labour_no_of_ppl')!='undefined'  && $this->input->post('labour_hours')!='undefined' && $this->input->post('labour_rate')!='undefined'  ){
				
			$job_id					=	$this->input->post('job_id');
			$quotation_id			=	$this->input->post('quotation_id');
			$job_card_details_id	=	$this->input->post('job_card_details_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id				=	$this->session->userdata('user_id');
			$labour_department		=	$this->input->post('labour_department');
			$labour_emp_category	=	$this->input->post('labour_emp_category');
			$labour_no_of_ppl		=	$this->input->post('labour_no_of_ppl');
			$labour_hours			=	$this->input->post('labour_hours');
			$labour_total_man_hours	=	round($labour_no_of_ppl*$labour_hours,3);
			$labour_rate			=	$this->input->post('labour_rate');
			$labour_total_amount	=	round(($labour_no_of_ppl*$labour_hours*$labour_rate),3);
			$labour_id				=	$this->input->post('labour_id');
			$Creation_date			=	date("Y-m-d");
			if($labour_id==='NO'){
				$query = $this->db->query("INSERT INTO `job_estimation_labourcost`(`boq_no`,`job_card_id`,`job_card_details_id`,`furniture_id`,`labour_department`,`labour_emp_category`, `labour_no_of_ppl`, `labour_hours`, `labour_total_man_hours`, `labour_rate`, `labour_total_amount`, `user_id`) VALUES ('$boq_no','$job_id','$job_card_details_id','$furniture_id','$labour_department','$labour_emp_category','$labour_no_of_ppl','$labour_hours','$labour_total_man_hours','$labour_rate','$labour_total_amount','$user_id') ");
			} else {
				$query = $this->db->query("UPDATE `job_estimation_labourcost` SET `labour_department`='$labour_department',`labour_emp_category`='$labour_emp_category',`labour_no_of_ppl`='$labour_no_of_ppl',`labour_hours`='$labour_hours',`labour_total_man_hours`='$labour_total_man_hours',`labour_rate`='$labour_rate',`labour_total_amount`='$labour_total_amount',`user_id`='$user_id' WHERE id='$labour_id'");
			}
			
			if ($query){
				//$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				//$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
			
				if($labour_id==='NO'){
					$c_id	=	$this->db->insert_id();
				} else {
					$c_id	=	$labour_id;
				}
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function subcontractAdd(){
		
		if ($this->input->post('subcontract_vendor')!='' && $this->input->post('subcontract_work_type')!='' && $this->input->post('subcontract_amount')!='' && $this->input->post('subcontract_vendor')!='undefined' && $this->input->post('subcontract_work_type')!='undefined'  && $this->input->post('subcontract_amount')!='undefined'){
			
			$job_id					=	$this->input->post('job_id');
			$quotation_id			=	$this->input->post('quotation_id');
			$job_card_details_id	=	$this->input->post('job_card_details_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$subcontract_vendor	=	$this->input->post('subcontract_vendor');
			$subcontract_work_type	=	$this->input->post('subcontract_work_type');
			$subcontract_amount		=	$this->input->post('subcontract_amount');
			$subcontract_id	=	$this->input->post('subcontract_id');
			$Creation_date=date("Y-m-d");
			if($subcontract_id==='NO'){
				$query = $this->db->query("INSERT INTO `job_estimation_subcontract`(`boq_no`,`job_card_id`,`job_card_details_id`,`furniture_id`,`subcontract_vendor`, `subcontract_work_type`, `subcontract_amount`, `user_id`) VALUES ('$boq_no','$job_id','$job_card_details_id','$furniture_id','$subcontract_vendor','$subcontract_work_type','$subcontract_amount','$user_id') ");
			} else {
				$query = $this->db->query("UPDATE `job_estimation_subcontract` SET `subcontract_vendor`='$subcontract_vendor',`subcontract_work_type`='$subcontract_work_type',`subcontract_amount`='$subcontract_amount',`user_id`='$user_id' WHERE id='$subcontract_id'");
			}
			
			
			if ($query){
				//$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				//$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
			
				if($subcontract_id==='NO'){
					$c_id	=	$this->db->insert_id();
				} else {
					$c_id	=	$subcontract_id;
				}
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function hiringAdd(){
		
		if ($this->input->post('hiring_vendor')!='' && $this->input->post('hiring_work_type')!='' && $this->input->post('hiring_amount')!='' && $this->input->post('hiring_vendor')!='undefined' && $this->input->post('hiring_work_type')!='undefined'  && $this->input->post('hiring_amount')!='undefined'){
				
			$job_id					=	$this->input->post('job_id');
			$quotation_id			=	$this->input->post('quotation_id');
			$job_card_details_id	=	$this->input->post('job_card_details_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$hiring_vendor	=	$this->input->post('hiring_vendor');
			$hiring_work_type	=	$this->input->post('hiring_work_type');
			$hiring_amount		=	$this->input->post('hiring_amount');
			$hiring_id	=	$this->input->post('hiring_id');
			$Creation_date=date("Y-m-d");
			if($hiring_id==='NO'){
				$query = $this->db->query("INSERT INTO `job_estimation_hiring`(`boq_no`,`job_card_id`,`job_card_details_id`,`furniture_id`,`hiring_vendor`, `hiring_work_type`, `hiring_amount`, `user_id`) VALUES ('$boq_no','$job_id','$job_card_details_id','$furniture_id','$hiring_vendor','$hiring_work_type','$hiring_amount','$user_id') ");
			} else {
				$query = $this->db->query("UPDATE `job_estimation_hiring` SET `hiring_vendor`='$hiring_vendor',`hiring_work_type`='$hiring_work_type',`hiring_amount`='$hiring_amount',`user_id`='$user_id' WHERE id='$hiring_id'");
			}
			
			if ($query){
				//$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				//$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
			
				if($hiring_id==='NO'){
					$c_id	=	$this->db->insert_id();
				} else {
					$c_id	=	$hiring_id;
				}
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}	
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function othersAdd(){
		
		if ($this->input->post('others_work_type')!='' && $this->input->post('others_amount')!='' && $this->input->post('others_vendor')!='undefined' && $this->input->post('others_work_type')!='undefined'  && $this->input->post('others_amount')!='undefined'){
				
			$job_id					=	$this->input->post('job_id');
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$job_card_details_id	=	$this->input->post('job_card_details_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$others_vendor	=	$this->input->post('others_vendor');
			$others_work_type	=	$this->input->post('others_work_type');
			$others_amount		=	$this->input->post('others_amount');
			$others_id	=	$this->input->post('others_id');
			$Creation_date=date("Y-m-d");
			if($others_id==='NO'){
				$query = $this->db->query("INSERT INTO `job_estimation_others`(`boq_no`,`job_card_id`,`job_card_details_id`,`furniture_id`,`others_vendor`, `others_work_type`, `others_amount`, `user_id`) VALUES ('$boq_no','$job_id','$job_card_details_id','$furniture_id','$others_vendor','$others_work_type','$others_amount','$user_id') ");
			} else {
				$query = $this->db->query("UPDATE `job_estimation_others` SET `others_vendor`='$others_vendor',`others_work_type`='$others_work_type',`others_amount`='$others_amount',`user_id`='$user_id' WHERE id='$others_id'");
			}
			
			if ($query){
				//$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				//$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
			
				if($others_id==='NO'){
					$c_id	=	$this->db->insert_id();
				} else {
					$c_id	=	$others_id;
				}
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}	
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function managejobcard($job_card_id=0,$division_id=0,$quotation_number=0){
		$this->users_model->permission("Job_card", "View");
		$title['headerTitle']="Manage Job";
		$where=array('view_furniture_job_card.job_card_id' => $job_card_id);
		//$this->session->set_userdata('furniture_quotation_id', $quotation_id);
		$records=$this->crud_model->get_view_job_card($where);
		$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($job_card_id);
		$records[0]['amount_paid'] =$amount_paid;
		$records[0]['balance_amount'] =$records[0]['job_card_total_with_vat']- $amount_paid;
		$this->data['records'] = $records;
		
		if($this->furniture_quotation_model->check_invoice($job_card_id) == 0){
			$this->data['invoice'] = 0;
		} else {
			$this->data['invoice'] = 1;
		}
		$this->db->select('*');
		$this->db->from('furniture_invoice');
		$this->db->join('company_division','company_division.division_id = furniture_invoice.quotation_divisionid','inner');
		$this->db->where('job_card_id', $job_card_id); 
		$this->db->where('invoice_status','0');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$this->data['receipt_inv'] = $rs->result_array();
		} else {
			$this->data['receipt_inv'] = array();
		}				
		$SQL = "SELECT * FROM proforma inner join company_division on company_division.division_id = proforma.quotation_divisionid where job_card_id='$job_card_id' And (proforma_status='0' OR proforma_status='2') ;";
		$ps = $this->db->query($SQL);
		if($ps->num_rows() > 0){
			$this->data['proforma_qtn'] = $ps->result_array();
		} else {
			$this->data['proforma_qtn'] = array();
		}
		$nb_quotation_id=	$records[0]['quotation_id'];
		$this->db->select('*');
		$this->db->from('upload_files');
		$this->db->where('qutation_id', $nb_quotation_id);
		$this->db->where('division_id', $division_id);
		//$this->db->where('qutation_id', $quotation_id); 
		$up_data = $this->db->get();
		if($up_data->num_rows() > 0){
			$this->data['rec_file'] = $up_data->result_array();
		} else {
			$this->data['rec_file'] = array();
		}

		$DSQL = "SELECT * FROM delivery_note where job_card_id='$job_card_id' And (delivery_note_status='1' OR delivery_note_status='2') ;";
		$dnrow = $this->db->query($DSQL);
		if($dnrow->num_rows() > 0){
			$this->data['delivery_notes'] = $dnrow->result_array();
		} else {
			$this->data['delivery_notes'] = array();
		}
		$this->load->view('templates/header',$title);
		$this->load->view('manage/managejobcard',$this->data);
		$this->load->view('templates/footer');
	}

	function client($job_card_id=NULL) {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Job Edit";
		if($job_card_id== NULL) {
			$data['job_card_mode']='new';
		} else {
			$records=$this->Job_card_model->get_job_card_data($job_card_id);
			$quotation_status = $records['job_card_status'];
			
			$data['job_card_mode']='edit';
			$data['job_card_id']=$job_card_id;
			$data['job_card_number'] = $records['job_card_number'];
			$data['quotation_id'] = $records['quotation_id'];
			$data['job_card_date'] = $records['job_card_date'];
			$data['quotation_number'] = $records['quotation_number'];
			$data['division_name'] = $records['division_name'];
			$data['division_id'] = $records['division_id'];
			$data['client_id'] = $records['client_id'];
			$data['client_name'] = $records['client_name'];
			$data['client_address'] = $records['client_address'];
			$data['client_country'] = $records['client_country'];
			$data['client_telephone1'] = $records['client_telephone1'];
			$data['client_telephone2'] = $records['client_telephone2'];
			$data['client_email'] = $records['client_email'];
			$data['client_fax'] = $records['client_fax'];
			$data['contact_person'] = $records['contact_person'];
			$data['tax_name'] = $records['tax_name'];
			$data['tax_no'] = $records['tax_no'];
			$data['project_name'] = $records['project_name'];
			$data['project_location'] = $records['project_location'];
			$data['project_remarks'] = $records['project_remarks'];
			$data['project_contact_person_email'] = $records['project_contact_person_email'];
			$data['project_contact_person_number'] = $records['project_contact_person_number'];
			$data['j_po_no'] = $records['j_po_no'];
		}
		
		$where2=array(
			'job_card_id'=> $job_card_id
		);
		$jobrecords=$this->crud_model->get('job_card_details',$where2);
		$data['jobrecords'] = $jobrecords;
		

		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;
		
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/create_job_card',$data);
		$this->load->view('templates/footer');
	}

	public function updateBom($quotation_id,$job_card_id){
		if($quotation_id!='' && $job_card_id!=''){
			$this->db->trans_begin();
			$furniture_items=$this->Job_card_model->qouteitemWiseDatarow($quotation_id);
			foreach($furniture_items as $furniture_item){
				$slip_no = $furniture_item['ex_furniture_area'].'.'.$furniture_item['sub_group_id'].'.'.$furniture_item['item_order'];
				$datas=$this->Job_card_model->jobDetailsRow($job_card_id,$slip_no);
				$job_card_details_id = $datas['job_card_details_id'];
				if(@$job_card_details_id!=''){
					
					$furniture_id				=  $furniture_item['furniture_id'];
					$estimation 				=  $this->furniture_quotation_model->estimation($furniture_id);
					$estimationMaterialsAdded 	=  $this->furniture_quotation_model->estimationMaterialsAdded($furniture_id);
					$estimationLabourCostAdded 	=  $this->furniture_quotation_model->estimationLabourCostAdded($furniture_id);
					$estimationSubContractAdded =  $this->furniture_quotation_model->estimationSubContractAdded($furniture_id);
					$estimationHiringAdded 		=  $this->furniture_quotation_model->estimationHiringAdded($furniture_id);
					$estimationOthersAdded 		=  $this->furniture_quotation_model->estimationOthersAdded($furniture_id);

					$where=array(
						'job_card_details_id'=> $job_card_details_id
					);

					$this->crud_model->delete('job_estimation',$where);
					$this->crud_model->delete('job_estimation_material',$where);
					$this->crud_model->delete('job_estimation_labourcost',$where);
					$this->crud_model->delete('job_estimation_subcontract',$where);
					$this->crud_model->delete('job_estimation_hiring',$where);
					$this->crud_model->delete('job_estimation_others',$where);

					//$boq_no =  $this->furniture_quotation_model->get_boq_no($furniture_id,$new_quotation_divisionid,$new_quotation_number);
					$user_id	=	$this->session->userdata('user_id');

					if($estimation!=false){
						$summary_data=array(
							'boq_no'   			=>  $estimation['boq_no'],
							'job_card_id' 		=>  $job_card_id,
							'job_card_details_id' =>  $job_card_details_id,
							'furniture_id' 		=>  $furniture_id,
							'material'  		=>  $estimation['material'],
							'labourCost'   		=>  $estimation['labourCost'],
							'subcontract'   	=>  $estimation['subcontract'],
							'hiring'   			=>  $estimation['hiring'],
							'others'  			=>  $estimation['others'],
							'materialperce'  	=>  $estimation['materialperce'],
							'labourCostperce'   =>  $estimation['labourCostperce'],
							'subcontractperce'  =>  $estimation['subcontractperce'],
							'hiringperce'   	=>  $estimation['hiringperce'],
							'othersperce'  		=>  $estimation['othersperce'],
							'profitperce'  		=>  $estimation['profitperce'],
							'selling_price'  	=>  $estimation['selling_price'],
							'user_id'  			=>  $user_id
						);
						$this->db->insert('job_estimation', $summary_data);
					}
					if($estimationMaterialsAdded!=false){
						foreach($estimationMaterialsAdded as $rowz){
							$material_data=array(
								'boq_no'   			=>  $estimation['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'item_id'  			=>  $rowz['item_id'],
								'item_name'   		=>  $rowz['item_name'],
								'item_description'  =>  $rowz['item_description'],
								'material_qty'   	=>  $rowz['material_qty'],
								'material_uom'  	=>  $rowz['material_uom'],
								'material_unitprice'=>  $rowz['material_unitprice'],
								'material_total'   	=>  $rowz['material_total'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_material', $material_data);
						}
					}
					if($estimationLabourCostAdded!=false){
						foreach($estimationLabourCostAdded as $row2){
							$labour_data=array(
								'boq_no'   				=>  $row2['boq_no'],
								'job_card_id' 			=>  $job_card_id,
								'job_card_details_id' 	=>  $job_card_details_id,
								'furniture_id' 			=>  $furniture_id,
								'labour_department'  	=>  $row2['labour_department'],
								'labour_emp_category'  	=>  $row2['labour_emp_category'],
								'labour_no_of_ppl'   	=>  $row2['labour_no_of_ppl'],
								'labour_hours'  		=>  $row2['labour_hours'],
								'labour_total_man_hours'=>  $row2['labour_total_man_hours'],
								'labour_rate'  			=>  $row2['labour_rate'],
								'labour_total_amount'	=>  $row2['labour_total_amount'],
								'user_id'  				=>  $user_id
							);
							$this->db->insert('job_estimation_labourcost', $labour_data);
						}
					}
					if($estimationSubContractAdded!=false){
						foreach($estimationSubContractAdded as $row3){
							$subcontract_data=array(
								'boq_no'   				=>  $row3['boq_no'],
								'job_card_id' 			=>  $job_card_id,
								'job_card_details_id' 	=>  $job_card_details_id,
								'furniture_id' 			=>  $furniture_id,
								'subcontract_vendor'  	=>  $row3['subcontract_vendor'],
								'subcontract_work_type' =>  $row3['subcontract_work_type'],
								'subcontract_amount'  	=>  $row3['subcontract_amount'],
								'user_id'  				=>  $user_id
							);
							$this->db->insert('job_estimation_subcontract', $subcontract_data);
						}
					}
					if($estimationHiringAdded!=false){
						foreach($estimationHiringAdded as $row4){
							$hiring_data=array(
								'boq_no'   			=>  $row4['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'hiring_vendor'  	=>  $row4['hiring_vendor'],
								'hiring_work_type' 	=>  $row4['hiring_work_type'],
								'hiring_amount'  	=>  $row4['hiring_amount'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_hiring', $hiring_data);
						}
					}
					if($estimationOthersAdded!=false){
						foreach($estimationOthersAdded as $row5){
							$others_data=array(
								'boq_no'   			=>  $row5['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'others_vendor'  	=>  $row5['others_vendor'],
								'others_work_type' 	=>  $row5['others_work_type'],
								'others_amount'  	=>  $row5['others_amount'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_others', $others_data);
						}
					}
				}
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Something went wrong Please try agian later.');
				redirect("jobcard/Job_card");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'BOM updated Successfully');
				redirect('jobcard/Job_card');
			}
		} else {
			$this->session->set_flashdata('response','Sorry! Something went wrong .');
			redirect("jobcard/Job_card");
		}
	}

	public function update_comments($job_card_id){
		$data = array(
			'j_po_no' => $this->input->post('j_po_no'),
		);
		$this->db->where('id', $job_card_id);
		$this->db->update(' job_card', $data);
		$nbjob_no=$this->input->post('nbjob_no');
		$division_id=$this->input->post('division_id');
		$nbxfurniture_item_id=$this->input->post('nbxfurniture_item_id');
		$furniture_comments=$this->input->post('furniture_comments');
		for($i=0; $i<count($nbxfurniture_item_id); $i++){
			if($nbxfurniture_item_id[$i]!==''){
				$update_data = array(
					'furniture_comments' 	 => $furniture_comments[$i],
				);
				$this->db->where('job_card_details_id', $nbxfurniture_item_id[$i]);
				$this->db->update(' job_card_details', $update_data);
			}
		}
		$this->session->set_flashdata('success', 'Comments Updated Successfully');
		redirect("jobcard/Job_card/client/".$job_card_id);
	}

	function create_job_card($quotation_id=NULL,$quotation_divisionid=NULL,$quotation_number=NULL) {
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Job Create";
		if($quotation_id!=Null && $quotation_divisionid!=Null && $quotation_number!=Null) {
			$this->db->trans_begin();
			$job_card_query= $this->db->query("SELECT * FROM `job_card` WHERE `quotation_id`='$quotation_id'");
			if($job_card_query->row() != false){
				$this->db->trans_rollback();
				//$this->session->set_flashdata('response','Sorry! You have already created job card in this quotation .');
				redirect('jobcard/Job_card/managejobcard/'.$job_card_query->row()->id.'/'.$job_card_query->row()->divisionid.'/'.$job_card_query->row()->job_card_number);
			} else {
				$quotation_data= $this->db->query("SELECT * FROM `furniture_quotation` FQ INNER JOIN `company_division` CD ON CD.division_id=FQ.quotation_divisionid WHERE FQ.`id`='$quotation_id'");
				$dbdata = $quotation_data->row();
				$query2= $this->db->query("SELECT count(`job_card_number`) as `MaxID` FROM `job_card` WHERE `divisionid`='$quotation_divisionid' ");
				$maxId      = $query2->row();
				if ($maxId->MaxID==NULL){
					$mid	=0;
				} else {
					$mid=$maxId->MaxID+1;
				}
				$job_card_number = 'JB'.date("y").$dbdata->division_code.sprintf("%'.05d", ($mid));
				$data = array(
					'job_card_number' 		  => $job_card_number,
					'job_card_date'    		  => date("Y-m-d"),
					'divisionid'    		  => $dbdata->quotation_divisionid,
					'job_card_currencyid'  	  => $dbdata->quotation_currencyid,
					'salesman_id'  			  => $dbdata->salesman_id,
					'client_id'  			  => $dbdata->client_id,
					'project_name'    		  => $dbdata->project_name,
					'project_location'    	  => $dbdata->project_location,
					'project_remarks'  		  => $dbdata->project_remarks,
					'job_card_total'    	  => $dbdata->quotation_total,
					'job_card_vat_perc'    	  => $dbdata->quotation_vat_percentage,
					'job_card_vat_amount'     => $dbdata->quotation_vat_amount,
					'job_card_amount_with_vat'=> $dbdata->quotation_amount_with_vat,
					'advance_percentage'      => $dbdata->advance_percentage,
					'advance_amount'    	  => $dbdata->advance_amount,
					'quotation_discount'      => $dbdata->quotation_discount,
					'exstock_paymenttermid'   => $dbdata->exstock_paymenttermid,
					'byorder_paymenttermid'   => $dbdata->byorder_paymenttermid,
					'job_card_status'    	  => 'Draft',
					'last_modified_by'    	  => $this->session->userdata('user_id'),
					'last_modified_date'      => date("Y-m-d"),
					'created_user_id'  		  => $this->session->userdata('user_id'),
					'quotation_id'    		  => $dbdata->id,
					'qtn_no'    		  	  => $dbdata->quotation_number_full
				);
				
				$this->db->insert('job_card', $data);
				$job_card_id = $this->db->insert_id();

				$log_data=array(
					'trans_no'  	=>  $job_card_number,
					'trans_type'  	=>  'Job Card',
					'trans_op'  	=>  'Create',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				$quotation_details_data= $this->db->query("SELECT * FROM `furniture_items` FQ WHERE FQ.`quotation_id`='$quotation_id'");
				$detailsdbdata = $quotation_details_data->result();
				
				foreach ($detailsdbdata as $row) {
					$sl_no	=	$row->ex_furniture_area.'.'.$row->sub_group_id.'.'.$row->item_order;
					$data_array = array(
						'job_card_id' 		   => $job_card_id,
						'furniture_reference'  => $row->furniture_reference,
						'sl_no' 			   => $sl_no,
						'furniture_brand'  	   => $row->furniture_brand,
						'furniture_brand_other'=> $row->furniture_brand_other,
						'furniture_area' 	   => $row->furniture_area,
						'ex_furniture_area'    => $row->ex_furniture_area,
						'sub_group' 		   => $row->sub_group,
						'sub_group_id' 		   => $row->sub_group_id,
						'item_order' 		   => $row->item_order,
						'item_id' 			   => $row->item_id,
						'furniture_model' 	   => $row->furniture_model,
						'furniture_description'=> $row->furniture_description,
						'furniture_comments'   => $row->furniture_comments,
						'furniture_upholstery' => $row->furniture_upholstery,
						'furniture_brand_other'=> $row->furniture_brand_other,
						'furniture_height' 	   => $row->furniture_height,
						'furniture_width' 	   => $row->furniture_width,
						'furniture_uom' 	   => $row->furniture_uom,
						'furniture_ratem2' 	   => $row->furniture_ratem2,
						'furniture_unitprice'  => $row->furniture_unitprice,
						'furniture_quantity'   => $row->furniture_quantity,
						'furniture_amount' 	   => $row->furniture_unitprice*$row->furniture_quantity,
						'furniture_type' 	   => $row->furniture_type,
						'furniture_stock_type' => $row->furniture_stock_type,
						'job_bag' 			   => $row->job_bag,
						'category'  		   => $row->category,
						'fabric_width' 		   => $row->fabric_width,
						'gathering' 		   => $row->gathering,
						'uom' 				   => $row->uom,
						'vat_perce' 		   => $row->vat_perce,
						'vat_amount' 		   => $row->vat_amount,
						'item_discount' 	   => $row->item_discount,
						'net_amount' 		   => $row->net_amount,
						'total_discount' 	   => $row->total_discount,
						'image' 			   => $row->image,
						'bom_h_id' 			   => $row->bom_h_id
					);
					$this->db->insert('job_card_details', $data_array);	
					
					$furniture_id		=	$row->furniture_id;
					$job_card_details_id		= 	$this->db->insert_id();
					//$new_quotation_number		= 	$row->quotation_number;
					$new_quotation_divisionid	= 	$dbdata->quotation_divisionid;
					

					$estimation 				=  $this->furniture_quotation_model->estimation($furniture_id);
					$estimationMaterialsAdded 	=  $this->furniture_quotation_model->estimationMaterialsAdded($furniture_id);
					$estimationLabourCostAdded 	=  $this->furniture_quotation_model->estimationLabourCostAdded($furniture_id);
					$estimationSubContractAdded =  $this->furniture_quotation_model->estimationSubContractAdded($furniture_id);
					$estimationHiringAdded 		=  $this->furniture_quotation_model->estimationHiringAdded($furniture_id);
					$estimationOthersAdded 		=  $this->furniture_quotation_model->estimationOthersAdded($furniture_id);

					$where=array(
						'job_card_details_id'=> $job_card_details_id
					);

					$this->crud_model->delete('job_estimation',$where);
					$this->crud_model->delete('job_estimation_material',$where);
					$this->crud_model->delete('job_estimation_labourcost',$where);
					$this->crud_model->delete('job_estimation_subcontract',$where);
					$this->crud_model->delete('job_estimation_hiring',$where);
					$this->crud_model->delete('job_estimation_others',$where);

					//$boq_no =  $this->furniture_quotation_model->get_boq_no($furniture_id,$new_quotation_divisionid,$new_quotation_number);
					$user_id	=	$this->session->userdata('user_id');

					if($estimation!=false){
						$summary_data=array(
							'boq_no'   			=>  $estimation['boq_no'],
							'job_card_id' 		=>  $job_card_id,
							'job_card_details_id' =>  $job_card_details_id,
							'furniture_id' 		=>  $furniture_id,
							'material'  		=>  $estimation['material'],
							'labourCost'   		=>  $estimation['labourCost'],
							'subcontract'   	=>  $estimation['subcontract'],
							'hiring'   			=>  $estimation['hiring'],
							'others'  			=>  $estimation['others'],
							'materialperce'  	=>  $estimation['materialperce'],
							'labourCostperce'   =>  $estimation['labourCostperce'],
							'subcontractperce'  =>  $estimation['subcontractperce'],
							'hiringperce'   	=>  $estimation['hiringperce'],
							'othersperce'  		=>  $estimation['othersperce'],
							'profitperce'  		=>  $estimation['profitperce'],
							'selling_price'  	=>  $estimation['selling_price'],
							'user_id'  			=>  $user_id
						);
						$this->db->insert('job_estimation', $summary_data);
					}
					if($estimationMaterialsAdded!=false){
						foreach($estimationMaterialsAdded as $rowz){
							$material_data=array(
								'boq_no'   			=>  $estimation['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'item_id'  			=>  $rowz['item_id'],
								'item_name'   		=>  $rowz['item_name'],
								'item_description'  =>  $rowz['item_description'],
								'material_qty'   	=>  $rowz['material_qty'],
								'material_uom'  	=>  $rowz['material_uom'],
								'material_unitprice'=>  $rowz['material_unitprice'],
								'material_total'   	=>  $rowz['material_total'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_material', $material_data);
						}
					}
					if($estimationLabourCostAdded!=false){
						foreach($estimationLabourCostAdded as $row2){
							$labour_data=array(
								'boq_no'   				=>  $row2['boq_no'],
								'job_card_id' 			=>  $job_card_id,
								'job_card_details_id' 	=>  $job_card_details_id,
								'furniture_id' 			=>  $furniture_id,
								'labour_department'  	=>  $row2['labour_department'],
								'labour_emp_category'  	=>  $row2['labour_emp_category'],
								'labour_no_of_ppl'   	=>  $row2['labour_no_of_ppl'],
								'labour_hours'  		=>  $row2['labour_hours'],
								'labour_total_man_hours'=>  $row2['labour_total_man_hours'],
								'labour_rate'  			=>  $row2['labour_rate'],
								'labour_total_amount'	=>  $row2['labour_total_amount'],
								'user_id'  				=>  $user_id
							);
							$this->db->insert('job_estimation_labourcost', $labour_data);

							$whr=array(
								'department_name'=> $row2['labour_department']
							);
							$dptrecords=$this->crud_model->get('department_master',$whr);
							if($dptrecords!=false) {
								$set_department_data=array(
									'job_card_no'  		 => $job_card_number,
									'job_card_id'  		 => $job_card_id,
									'job_card_details_id'=> $job_card_details_id,
									'client_id'   		 => $dbdata->client_id,
									'project_name'   	 => $dbdata->project_name,
									'job_card_date'  	 => date("Y-m-d"),
									'sl_no'   			 => $sl_no,
									'qty'   			 => $row->furniture_quantity,
									'item_id'   		 => $row->item_id,
									'item_name'   		 => $row->furniture_model,
									'department_id'      => $dptrecords[0]['department_id'],
									'status'   			 => 3,
								);
								$this->crud_model->insert('set_departments',$set_department_data);

								$log_datax=array(
									'trans_no'  	=>  $job_card_number,
									'trans_type'  	=>  'Job Card',
									'trans_op'  	=>  'Pending',
									'job_card_details_id'  	=>  $job_card_details_id,
									'dept_id'  		=>  $dptrecords[0]['department_id'],
									'trans_date'  	=>  date('Y-m-d H:i:s'),
									'trans_user_id' =>  $this->session->userdata('user_id')
								);
								$log_for_transactions=$this->crud_model->insert('log_for_job_update',$log_datax);
							}

						}
					}
					if($estimationSubContractAdded!=false){
						foreach($estimationSubContractAdded as $row3){
							$subcontract_data=array(
								'boq_no'   				=>  $row3['boq_no'],
								'job_card_id' 			=>  $job_card_id,
								'job_card_details_id' 	=>  $job_card_details_id,
								'furniture_id' 			=>  $furniture_id,
								'subcontract_vendor'  	=>  $row3['subcontract_vendor'],
								'subcontract_work_type' =>  $row3['subcontract_work_type'],
								'subcontract_amount'  	=>  $row3['subcontract_amount'],
								'user_id'  				=>  $user_id
							);
							$this->db->insert('job_estimation_subcontract', $subcontract_data);
						}
					}
					if($estimationHiringAdded!=false){
						foreach($estimationHiringAdded as $row4){
							$hiring_data=array(
								'boq_no'   			=>  $row4['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'hiring_vendor'  	=>  $row4['hiring_vendor'],
								'hiring_work_type' 	=>  $row4['hiring_work_type'],
								'hiring_amount'  	=>  $row4['hiring_amount'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_hiring', $hiring_data);
						}
					}
					if($estimationOthersAdded!=false){
						foreach($estimationOthersAdded as $row5){
							$others_data=array(
								'boq_no'   			=>  $row5['boq_no'],
								'job_card_id' 		=>  $job_card_id,
								'job_card_details_id' =>  $job_card_details_id,
								'furniture_id' 		=>  $furniture_id,
								'others_vendor'  	=>  $row5['others_vendor'],
								'others_work_type' 	=>  $row5['others_work_type'],
								'others_amount'  	=>  $row5['others_amount'],
								'user_id'  			=>  $user_id
							);
							$this->db->insert('job_estimation_others', $others_data);
						}
					}
				}
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response','Sorry! Something went wrong .');
					redirect('Dashboard/home');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Job Card Created Successfully');
					redirect("jobcard/Job_card/client/".$job_card_id);
				 }
			}			
		} else {
			$this->session->set_flashdata('response','Sorry! Something went wrong .');
			redirect('Dashboard/home');
		}
	}

	public function index($page=1,$client_id='NIL',$user_id='NIL',$qtnNo='NIL',$project='NIL',$job_card_status='NIL') {
		$this->users_model->permission("Job_card", "View");
		$title['headerTitle']="Job List";
	
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('user_id')) {
			$user_id =   $this->input->post("user_id");
		}elseif ($user_id != "NIL") {
			$user_id	=	$user_id;
		} else {
			$user_id	= "NIL";
		}
		if (@$this->input->post('qtnNo')) {
			$qtnNo =   $this->input->post("qtnNo");
		}elseif ($qtnNo != "NIL") {
			$qtnNo	=	$qtnNo;
		} else {
			$qtnNo	= "NIL";
		}
		if (@$this->input->post('project')) {
			$project =   $this->input->post("project");
		}elseif ($project != "NIL") {
			$project	=	$project;
		} else {
			$project	= "NIL";
		}

		if (@$this->input->post('job_card_status')) {
			$job_card_status =   $this->input->post("job_card_status");
		}elseif ($job_card_status != "NIL") {
			$job_card_status	=	$job_card_status;
		}	else {
			$job_card_status	= "NIL";
		}

		$customer_name='NIL';
		$config["base_url"] = base_url() . "index.php/jobcard/Job_card/index/"."/".$client_id."/".$user_id."/".$qtnNo."/".$project;
		$config["total_rows"] = 250;
		$config['num_links'] = 15;
		if(isset($_POST["ttttt"])) {
			$config["per_page"] = 10000000000000;
			$this->pagination->initialize($config);
			$page = 0;
			$i=1;
		} else {
			$config["per_page"] = 250;
			$this->pagination->initialize($config);
			$config['uri_segment'] = 11;
			if ($this->uri->segment(11)) {
				$page = $this->uri->segment(11)*250-250;
				$i=$page+1;
			} else {
				$page = 0;
				$i=1;
			}
		}
		$list='';
		$headList='';
		$net_amount=0;
		$where=array();
		$like=array();
		if($client_id!='NIL') {
			$where['job_card.client_id='] = $client_id;	
		}
		$user_group_id   =   $this->session->userdata('user_group_id');
		if ($user_group_id != 1 and $user_group_id != 11  and $user_group_id != 12  and $user_group_id != 13 and $user_group_id != 10) {
			$logged_user_id   =   $this->session->userdata('user_id');
			$where['job_card.salesman_id='] = $logged_user_id;	
		}

		if($user_id!='NIL') {
			$like['job_card.salesman_id'] = $user_id;
		}

		if($qtnNo!='NIL') {
			$like['job_card.job_card_number'] = $qtnNo;	
		}
		if($project!='NIL') {
			$like['job_card.project_name'] = $project;	
		}
		if($job_card_status!='NIL') {
			if($job_card_status==='Quote-Edited'){
				$where['job_card_status'] = 'Quote Edited';
			} else {
				$where['job_card_status'] = $job_card_status;
			}
		}
		//$where['job_card.divisionid !='] = 2;
		$get_view_job_card=$this->Job_card_model->get_view_job_card($where,$config["per_page"],$page,null,null,$like,null);
		$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array());
		$userList=$this->crud_model->userList();
		$datas   =   array("records" => $get_view_job_card, "links" => $this->pagination->create_links(),"userList" => $userList,"division_list" => $division_list,"client_id" => $client_id,"customer_name" => $customer_name,"user_id" => $user_id,"qtnNo" => $qtnNo,"project" => $project,"job_card_status" => $job_card_status);
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/job_card_view',$datas);
		$this->load->view('templates/footer');
	}

	public function printJobEstimation($job_card_details_id){
		$mpdf = new \Mpdf\Mpdf();
		$estimation 				=  $this->Job_card_model->jobestimation($job_card_details_id);
		$estimationMaterialsAdded 	=  $this->Job_card_model->jobestimationMaterialsAdded($job_card_details_id);
		$estimationLabourCostAdded 	=  $this->Job_card_model->jobestimationLabourCostAdded($job_card_details_id);
		$estimationSubContractAdded =  $this->Job_card_model->jobestimationSubContractAdded($job_card_details_id);
		$estimationHiringAdded 		=  $this->Job_card_model->jobestimationHiringAdded($job_card_details_id);
		$estimationOthersAdded 		=  $this->Job_card_model->jobestimationOthersAdded($job_card_details_id);

		$quotation_details =  $this->Job_card_model->jobitemWiseDatarow($job_card_details_id);
		
		$datas['records']=$quotation_details;
		
		$datas['estimation'] 				= $estimation;
		$datas['estimationMaterialsAdded'] 	= $estimationMaterialsAdded;
		$datas['estimationLabourCostAdded'] 	= $estimationLabourCostAdded;
		$datas['estimationSubContractAdded'] = $estimationSubContractAdded;
		$datas['estimationHiringAdded'] 		= $estimationHiringAdded;
		$datas['estimationOthersAdded'] 		= $estimationOthersAdded;
		
		$datas['boq_no']				= $estimation['boq_no'];
		$datas['overhead'] 		=  $this->furniture_quotation_model->overhead();

		$uniqueID='JobEstimation';
		if(!file_exists("pdfexport/".$uniqueID)) {
       		mkdir("pdfexport/".$uniqueID);
		}

		$mpdf->setFooter("Page {PAGENO} of {nb}");
		$html = $this->load->view('general/quotations/printJobEstimation', $datas , true);
		$aaa=	str_replace("/","_",$estimation['boq_no']);
		$mpdf->WriteHTML($html);
		$filename = __DIR__ . '/../../../pdfexport/'.$uniqueID.'/'.$aaa.'.pdf';
		$mpdf->Output($filename, 'F');
		$mpdf->Output(''.$estimation['boq_no'].'.pdf','I');
	}

	public function printJobCard($job_card_id,$type,$image_type,$chekval,$without_sub,$without_group,$print_status=''){
		$this->users_model->permission("Job_card", "View");
		$records2=$this->Job_card_model->get_job_card_data($job_card_id);
		$where2=array(
			'job_card_id'=> $job_card_id
		);
		//$jobrecords=$this->crud_model->get('job_card_details',$where2);
		$jobrecords=$this->crud_model->get('job_card_details',$where2, null, null, "ex_furniture_area", "ASC", null, null, null, "furniture_area");
		$data['jobrecords'] = $jobrecords;
		//echo $this->db->last_query();
		//print_r($jobrecords);
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row){
			$company_email_name =  $row->company_name;
		}
		if($image_type=="with_image"){
			$records['image']	=	"with_image";
		}else{
			$records['image']	=	"without_image";
		}
		$records['chekval'] = $chekval;
		$records['without_sub'] = $without_sub;
		$records['without_group'] = $without_group;
		$records['print_status'] = $print_status;
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			//$this->load->helper(array('dompdf', 'file'));
			//$html = $this->load->view('general/quotations/printview4', $records, true);
			//pdf_create($html, 'Invoice_No_'.$records['division_code'].'-'.$records['invoice_number']);
			$mpdf = new \Mpdf\Mpdf();
			$datas   =   array("records" => $records,'print_type'=>'pdf_print_type',"nbdata" => $records2,"jobrecords" => $jobrecords);
			$html = $this->load->view('general/quotations/printpdfjobcard', $datas , true);
			//echo $html;
			//$html = $this->load->view('welcome_message',[],true);
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if($type=="normal"){
			$records['print_type'] = "normal_print_type";
			//$this->load->view('general/quotations/printdeliverynote', $records);
		}
	 	//if you want to write it to disk and/or send it as an attachment  
	}
	function upload_it(){  
		if($this->input->post('title')!=='' && $_FILES["fileField"]["name"]!=='' ){
			$this->load->helper('form');
			$uniqueID = $this->input->post('quotation_number');
			if(!file_exists("uploads/".$uniqueID))
			mkdir("uploads/".$uniqueID);
			$config['upload_path'] = 'uploads/'.$uniqueID;
			$config['allowed_types'] = '*';
			$config['overwrite'] = FALSE;
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->upload->set_allowed_types('*');
			$this->upload->do_upload("fileField");
			echo $this->upload->display_errors();
			$upload_data  =   $this->upload->data();
			$uploadImage = $upload_data['file_name'];
			$newdata = array(
				'title'			  =>$this->input->post('title'),
				'quotation_number'=>$this->input->post('quotation_number'),
				'division_id'	  =>$this->input->post('quotation_division'),
				'qutation_id'	  =>$this->input->post('quotation_id_redrct'),
				'user_id'		  =>$this->session->userdata('user_id'),
				'file_name'       =>$uploadImage,
			);
			$add_file = $this->db->insert('upload_files', $newdata); 
			if($add_file){
				$this->session->set_flashdata('success','File Uploaded Successfully...');
			}else{
				$this->session->set_flashdata('response','Something Wrong.Try Again...');
			}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	    redirect('jobcard/Job_card/managejobcard/'.$this->input->post('job_card_id').'/'.$this->input->post('quotation_division').'/'.$this->input->post('job_card_number').'');
	}

	function upload_item_wise_image($id){  
		if($id!='' && $_FILES["fileField"]["name"]!=='' ){
			$this->load->helper('form');
			$uniqueID = 'estimation/'.$id;
			if(!file_exists("uploads/".$uniqueID))
			mkdir("uploads/".$uniqueID);
			$config['upload_path'] = 'uploads/'.$uniqueID;
			$config['allowed_types'] = '*';
			$config['overwrite'] = FALSE;
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->upload->set_allowed_types('*');
			$this->upload->do_upload("fileField");
			echo $this->upload->display_errors();
			$upload_data  =   $this->upload->data();
			$uploadImage = $upload_data['file_name'];
			$newdata = array(
				'img_2'       =>$uploadImage,
			);
			$this->db->where('job_card_details_id', $id);
			$add_file = $this->db->update('job_card_details', $newdata); 
			if($add_file){
				$this->session->set_flashdata('success','File Uploaded Successfully...');
			}else{
				$this->session->set_flashdata('response','Something Wrong.Try Again...');
			}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	    redirect('jobcard/Job_card/client/'.$this->input->post('job_card_id').'');
	}


	public function search_item() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql=" and item_name LIKE '%$client%' ";
		$client_contact_data = $this->db->query("SELECT * FROM `items` where `item_name` like '%$client%' and item_type='1'   ".$sql." order by item_name");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='<tr  class="no_result_button"><th><b>Item Name</b></th><th><b>Cost</b></th><th><b>Stock</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$item_id=$client_contact_datas['id'];
				$contact_data = $this->db->query("SELECT item_rate FROM `item_trans` where `item_id`='$item_id' order by `item_trans_id` desc limit 0,1 ");
				if($contact_data->row()!=false){
					$cost_price	=	$contact_data->row()->item_rate;
				} else {
					$cost_price	=	$client_contact_datas['cost_price'];
				}
				$html.='<tr><td value="' .$client_contact_datas['id'].'" class="item_button" tabindex="'.$n++.'" style="width:500px;" ><input type="hidden" class="item_name" value="'.$client_contact_datas['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$client_contact_datas['item_name'].'</td><td style="width:50px;text-align:right;">'.$cost_price.'</td><td style="width:50px;text-align:right;">1</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" > No Results Found </td>';
		}
		
		print $html;
	}

	public function search_vendor() {
		$supplier_name	=	$this->input->post('supplier_name');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` where `supplier_name` like '%$supplier_name%' order by supplier_name");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr><td value="' .$client_contact_datas['supplier_id'].'" class="subcontract_button" tabindex="'.$n++.'" style="width:500px;" ><input type="hidden" class="supplier_name" value="'.$client_contact_datas['supplier_name'].'" />'.$client_contact_datas['supplier_name'].'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" > No Results Found </td>';
		}
		
		print $html;
	}
	public function matDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `job_estimation_material` WHERE `id`='$id' ");
	}
	public function labDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `job_estimation_labourcost` WHERE `id`='$id' ");
	}
	public function subDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `job_estimation_subcontract` WHERE `id`='$id' ");
	}

	public function hirDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `job_estimation_hiring` WHERE `id`='$id' ");
	}

	public function othDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `job_estimation_others` WHERE `id`='$id' ");
	}

	public function do_delete($job_card_id){
		$this->users_model->permission("Job_card", "Delete");
		if($job_card_id!=''){
			$this->db->trans_begin();

			$details_data = array(
				'job_card_status' => 'Cancelled'
			);
			
			$this->db->where('id', $job_card_id);
			$this->db->update('job_card', $details_data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Something went wrong Please try agian later.');
				redirect("jobcard/Job_card/index");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Deleted Successfully');
				redirect("jobcard/Job_card/index");
			}

		} else {
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect("jobcard/Job_card/index");
		}
	}

	public function do_complete($job_card_id){
		if($job_card_id!=''){
			$this->db->trans_begin();

			$details_data = array(
				'job_card_status' => 'Completed',
				'completion_date' => date('Y-m-d h:m:s')
			);
			
			$this->db->where('id', $job_card_id);
			$this->db->update('job_card', $details_data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Something went wrong Please try agian later.');
				redirect("jobcard/Job_card/index");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Job Completed Successfully');
				redirect("jobcard/Job_card/index");
			}

		} else {
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect("jobcard/Job_card/index");
		}
	}

	public function do_open($job_card_id){
		if($job_card_id!=''){
			$this->db->trans_begin();

			$details_data = array(
				'job_card_status' => 'Draft'
			);
			
			$this->db->where('id', $job_card_id);
			$this->db->update('job_card', $details_data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Something went wrong Please try agian later.');
				redirect("jobcard/Job_card/index");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Job Opened Successfully');
				redirect("jobcard/Job_card/index");
			}
		} else {
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect("jobcard/Job_card/index");
		}
	}
} // Closing of main class
?>