<?php
class Group extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($name='NIL',$page=1)	{
		$this->users_model->permission("Vendor", "View");
		$where=array();
		$like=array();
		if (@$this->input->post('name')) {
			$name =   $this->input->post("name");
		} elseif ($name != "NIL") {
			$name	=	$name;
		} else {
			$name	= "NIL";
		}
		if($name != "NIL") {
			$like = array('stock_group_name'=>$name);
		}
		$title['headerTitle']="Vendor List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('masters/Group/index/'.$name.'/');
		
		$config['total_rows'] = $this->crud_model->get_count('stock_group',$where);
		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('stock_group',array(),$config['per_page'],$offset,'id','desc',$like);		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/group/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Vendor", "Add");
		$title['headerTitle']="Vendor Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/group/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Vendor", "Edit");
		$title['headerTitle']="Vendor Edit";
		$where=array(
				'id' => $id
		);
		$records=$this->crud_model->get('stock_group',$where);
		if($records != false){
			//true section
			$data['stock_group_name']	= $records[0]['stock_group_name'];
			$data['id']			 		= $records[0]['id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/group/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Group');
		}
	}
	function do_insert() {
		$this->users_model->permission("Vendor", "Add");
		$title['headerTitle']="Vendor Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/group/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('stock_group_name' => $name);

			$rr=$this->crud_model->insert('stock_group',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Vendor',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Vendor cannot be inserted',':old:');
				$redirect('masters/Group');
			} else {
				// redirect
				$this->session->set_flashdata('success','Vendor added successfully');
				redirect('masters/Group');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("Vendor", "Edit");
		$title['headerTitle']="Vendor Edit";
		$id = ascii_to_entities($this->input->post('id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("id"=>$id);
					
			$records=$this->crud_model->get('stock_group', $where);
			if($records != false){
				//true section
				$data['stock_group_name']	= $records[0]['stock_group_name'];
				$data['id']			 	= $records[0]['id'];
				$data['status']			= $records[0]['status'];

				$data['user_status'] = $this->config->item('user_status_array');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/group/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'id'  => $id
			);
			$data=array(
				'stock_group_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('stock_group',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Vendor',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Vendor updated');
			redirect('masters/Group');

		}
	}
	function do_delete($unit_id=0) {
		$this->users_model->permission("Vendor", "Delete");
		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Vendor',	
				'masters_id'=>$unit_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Vendor deleted');
		redirect('masters/Unit');
	}
}