<?php
class ItemType extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$title['headerTitle']="Item Type List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/ItemType/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('item_type_master',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('item_type_master',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/item_type/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$title['headerTitle']="Item Type Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/item_type/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$title['headerTitle']="Item Type Edit";
		$where=array(
				'item_type_id' => $id
		);
		$records=$this->crud_model->get('item_type_master',$where);
		if($records != false){
			//true section
			$data['item_type_name']		= $records[0]['item_type_name'];
			$data['item_type_id']		= $records[0]['item_type_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/item_type/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/ItemType');
		}
	}
	function do_insert() {
		$title['headerTitle']="Item Type Create";
		$this->form_validation->set_rules('name', 'Name', 'required|is_unique[item_type_master.item_type_name]');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item_type/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('item_type_name' => $name);

			$rr=$this->crud_model->insert('item_type_master',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Item Type cannot be inserted',':old:');
				$redirect('masters/ItemType');
			} else {
				// redirect
				$this->session->set_flashdata('success','Item Type added successfully');
				redirect('masters/ItemType');

			}
		}

	}

	function do_update() {
		$title['headerTitle']="Item Type Edit";
		$item_type_id = ascii_to_entities($this->input->post('item_type_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("item_type_id"=>$item_type_id);
					
			$records=$this->crud_model->get('item_type_master', $where);
			if($records != false){
				//true section
			$data['item_type_name']	= $records[0]['item_type_name'];
			$data['item_type_id']		= $records[0]['item_type_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item_type/edit',$data);
			$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'item_type_id'  => $item_type_id
			);
			$data=array(
				'item_type_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('item_type_master',$data,$where);

			$this->session->set_flashdata('success','Item Type updated');
			redirect('masters/ItemType');

		}
	}
	function do_delete($department_id=0) {

		$where=array(
			'department_id'  => $department_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('department_master',$data,$where);

		$this->session->set_flashdata('success','Department deleted');
		redirect('masters/Department');
	}
}