<?php
class Outcome extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("Outcome", "View");
		$title['headerTitle']="Outcome List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/Outcome/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('outcome',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('outcome',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/outcome/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Outcome", "Add");
		$title['headerTitle']="Outcome Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/outcome/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Outcome", "Edit");
		$title['headerTitle']="Outcome Edit";
		$where=array(
				'outcome_id' => $id
		);
		$records=$this->crud_model->get('outcome',$where);
		if($records != false){
			//true section
			$data['outcome_name']			 = $records[0]['outcome_name'];
			$data['outcome_id']			 = $records[0]['outcome_id'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/outcome/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Outcome');
		}
	}
	function do_insert() {
		$this->users_model->permission("Outcome", "Add");
		$title['headerTitle']="Outcome Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/Outcome/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			
			$data=array('outcome_name' => $name);

			$rr=$this->crud_model->insert('outcome',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Outcome',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Outcome cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/Outcome');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('success','Outcome added successfully');
				redirect('masters/Outcome');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("Outcome", "Edit");
		$title['headerTitle']="Outcome Edit";
		$outcome_id = ascii_to_entities($this->input->post('outcome_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("outcome_id"=>$outcome_id);
					
			$records=$this->crud_model->get('outcome', $where);
			if($records != false){
				//true section
				$data['outcome_name']			 = $records[0]['outcome_name'];
				$data['outcome_id']			 = $records[0]['outcome_id'];
				$data['status']				= $records[0]['status'];

				$data['user_status'] = $this->config->item('user_status_array');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/outcome/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'outcome_id'  => $outcome_id
			);
			$data=array(
				'outcome_name' => $name,
				'status' => $status
			);

			$records=$this->crud_model->update('outcome',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Outcome',	
				'masters_id'=>$outcome_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Outcome updated');
			redirect('masters/Outcome');

		}
	}
	function do_delete($id=0) {
		$this->users_model->permission("Outcome", "Delete");
		$where=array(
			'outcome_id'=> $id
		);
			
		$this->crud_model->delete('outcome',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Outcome',	
			'masters_id'=>$id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Outcome deleted');
		redirect('masters/Outcome');
	}
}