<?php
class terms_and_conditions extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$this->users_model->permission("TermsandConditionsTemplate", "View");
		$title['headerTitle']="Terms and Conditions Template";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/terms_and_conditions/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('terms_and_conditions',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('terms_and_conditions',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/terms_and_conditions/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->users_model->permission("TermsandConditionsTemplate", "Add");
		$title['headerTitle']="Terms and Conditions Template Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/terms_and_conditions/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$this->users_model->permission("TermsandConditionsTemplate", "Edit");
		$title['headerTitle']="Terms and Conditions Template Edit";
		$where=array(
				'terms_id' => $id
		);
		$records=$this->crud_model->get('terms_and_conditions',$where);
		if($records != false){
			//true section
			$data['terms_name']			 = $records[0]['terms_name'];
			$data['terms_content']			 = $records[0]['terms_content'];
			$data['terms_id']			 = $records[0]['terms_id'];
			$this->load->view('templates/header',$title);
			$this->load->view('masters/terms_and_conditions/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/terms_and_conditions');
		}

	}
	function do_insert()
	{
		$this->users_model->permission("TermsandConditionsTemplate", "Add");
		$title['headerTitle']="Terms and Conditions Template Create";
		$this->form_validation->set_rules('cl_template_name', 'Terms and Conditions Name', 'required');
		$this->form_validation->set_rules('cl_template_content', 'Terms and Conditions Content', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/terms_and_conditions/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$cl_template_name=$this->input->post('cl_template_name');
			$cl_template_content=$this->input->post('cl_template_content');

			$data=array(
			                'terms_name' => $cl_template_name,
			                'terms_content' => str_replace('<p><br></p>', '', trim($cl_template_content))

			);

			$rr=$this->crud_model->insert('terms_and_conditions',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Terms And Conditions',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','Terms and Conditions cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/terms_and_conditions');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','Terms and Conditions added successfully');
				redirect('masters/terms_and_conditions');
			}
		}

	}

	function do_update()
	{
		$this->users_model->permission("TermsandConditionsTemplate", "Edit");
		$this->form_validation->set_rules('cl_template_name', 'Terms and Conditions Name', 'required');
		$this->form_validation->set_rules('cl_template_content', 'Terms and Conditions Content', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$records=$this->crud_model->get('terms_and_conditions');
			if($records != false){
				//true section
				$data['terms_name']			 = $records[0]['terms_name'];
				$data['terms_content']			 = $records[0]['terms_content'];
				$data['terms_id']			 = $records[0]['terms_id'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/terms_and_conditions/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','error');
				redirect('masters/terms_and_conditions');
			}
		}
		else
		{// true section

			$cl_template_name   = $this->input->post('cl_template_name');
			$cl_template_content   = $this->input->post('cl_template_content');
			$cl_template_id     = $this->input->post('cl_template_id');

			$where=array(
					       'terms_id'   => $cl_template_id
			);
			$data=array(
					       'terms_name' => $cl_template_name,
			               'terms_content' => str_replace('<p><br></p>', '', trim($cl_template_content)),

			);

			$records=$this->crud_model->update('terms_and_conditions',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Terms And Conditions',	
				'masters_id'=>$cl_template_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('response','Terms and Conditions Updated');
			redirect('masters/terms_and_conditions');

		}

	}
	function do_delete($id=0)
	{
		$this->users_model->permission("TermsandConditionsTemplate", "Delete");
		$where=array(
				'terms_id'=> $id
		);

		$this->crud_model->delete('terms_and_conditions',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Terms And Conditions',	
			'masters_id'=>$id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Terms and Conditions Deleted');
		redirect('masters/terms_and_conditions');
	}
}