<?php
class Worktop_ept extends CI_Controller {
	function Worktop_ept()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/worktop_ept/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_worktop_ept_with_price_group',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_worktop_ept_with_price_group',
				array(),

				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_ept/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{

		$list = $this->crud_model->get_list('price_group_id','price_group_name','worktop_price_groups',array(0=>' - Select - '));
		$data['worktop_price_groups'] = $list;

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_ept/create',$data);
		$this->load->view('templates/footer');


	}
	function edit($id)
	{
		$where=array(
				'worktop_ept_id' => $id
		);
		$records=$this->crud_model->get('worktop_ept',$where);
		if($records != false){
			//true section
			$data['worktop_ept_name']			 = $records[0]['worktop_ept_name'];
			$data['worktop_ept_id']			     = $records[0]['worktop_ept_id'];
			$data['price_group_id']			     = $records[0]['price_group_id'];
			$data['price']			             = $records[0]['price'];
		

			$list = $this->crud_model->get_list('price_group_id','price_group_name','worktop_price_groups',array(0=>' - Select - '));
			$data['worktop_price_groups'] = $list;

			$this->load->view('templates/header');
			$this->load->view('masters/worktop_ept/edit',$data);
			$this->load->view('templates/footer');
		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/worktop_ept');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('worktop_ept_name', 'Worktop Edge Profile Thickness Name', 'required|max_length[50]');
		$this->form_validation->set_rules('price_group_id', 'Price Group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('price', 'price', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->create();
		}
		else
		{	// true section

			$worktop_ept_name=$this->input->post('worktop_ept_name');
			$price_group_id=$this->input->post('price_group_id');
			$price=$this->input->post('price');

			$data=array(
					'worktop_ept_name'   => $worktop_ept_name,
					'price_group_id'     => $price_group_id,
					'price'              => $price,

			);

			$rr=$this->crud_model->insert('worktop_ept',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Worktop Edge Profile Thickness cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/worktop_ept');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Edge Profile Thickness added successfully</div>');
				redirect('masters/worktop_ept');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('worktop_ept_name', 'Worktop Edge Profile Thickness Name', 'required|max_length[50]');
		$this->form_validation->set_rules('price_group_id', 'Price Group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('price', 'Price', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit($this->input->post('worktop_ept_id'));
		
		}
		else
		{// true section

			$worktop_ept_name     = $this->input->post('worktop_ept_name');
			$worktop_ept_id       = $this->input->post('worktop_ept_id');
			$price_group_id       = $this->input->post('price_group_id');

			$price=  $this->input->post('price');


			$where=array(
					         'worktop_ept_id'=> $worktop_ept_id
			);
			$data=array(
					          'worktop_ept_name' => $worktop_ept_name,
					          'price_group_id'   => $price_group_id,
					           'price'           => $price,
			);

			$records=$this->crud_model->update('worktop_ept',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Edge Profile Thickness updated</div>');
			redirect('masters/worktop_ept');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'worktop_ept_id'=> $id
		);

		$this->crud_model->delete('worktop_ept',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Edge Profile Thickness deleted</div>');
		redirect('masters/worktop_ept');
	}
}


