
<?php
class Quotation_worktop extends CI_Controller {
	function Quotation_worktop()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$list = $this->quotation_model->get_quotation_kitchen_list(array('quotation_id' => $this->session->userdata('quotation_id')));
		$data['quotation_kitchens'] = $list;

		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('quotations/quotation_worktop/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_quotation_worktop_with_qkitchen_wbrand_wfinish_wmodel_wept',array('quotation_id'=>$this->session->userdata('quotation_id')));

		$offset = ($page-1) * $config['per_page'];
		$data['records']=$this->crud_model->get('view_quotation_worktop_with_qkitchen_wbrand_wfinish_wmodel_wept',
				array('quotation_id'=>$this->session->userdata('quotation_id')),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$list = $this->crud_model->get_list('worktop_brand_id','worktop_brand_name','worktop_brands',array(''=>' - Select - ', 0=>'Other'));
		$data['worktop_brands'] = $list;
		//$list = $this->crud_model->get_list('worktop_finish_id','worktop_finish_name','worktop_finish',array(0=>' - Select - '));
		$list=array(''=>'-Select-');
		$data['worktop_finish'] = $list;

		$list=array(''=>'-Select-');
		$data['worktop_models'] = $list;

		$list=array(''=>'-Select-');
		$data['worktop_ept'] = $list;

		$data['linear_meter_per_kitchen']= $this->config->item('linear_meter_per_kitchen');
			
		$rs=$this->crud_model->get('quotation_worktop',array('quotation_id' => $this->session->userdata('quotation_id')));
		if($rs!=false)
		{
			$data['quotation_kitchen_id'] = $rs[0]['quotation_kitchen_id'];
			$data['quotation_worktop_id'] = $rs[0]['quotation_worktop_id'];
		}

		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_worktop/create',$data);
		$this->load->view('templates/footer');
	}
	function do_insert()
	{
		//$this->form_validation->set_rules('quotation_kitchen_id', 'Quotation Kitchen', 'required');
		if( $this->input->post('worktop_brand_id')!='' and  $this->input->post('worktop_finish_id')!='')
		{

			$this->form_validation->set_rules('worktop_brand_id', 'Worktop  Brand', 'required|is_natural_no_zero');
			$this->form_validation->set_rules('worktop_finish_id', 'Worktop Finish', 'required');
			$this->form_validation->set_rules('worktop_model_id', 'Worktop Model', 'required');
			$this->form_validation->set_rules('worktop_ept_id', 'Worktop EPT', 'required');
			$this->form_validation->set_rules('worktop_quantity', 'Quantity', 'required');
			$this->form_validation->set_rules('worktop_lm', 'Linear Meter Per Kitchen', 'required');
			$this->form_validation->set_rules('worktop_price_per_lm', 'Rate Per Linear Meter', 'required');
		}
		else
		{
			$this->form_validation->set_rules('finish_text', 'Worktop Finish', 'required');
			$this->form_validation->set_rules('model_text', 'Worktop Model', 'required');
			$this->form_validation->set_rules('ept_text', 'Worktop Ept', 'required');
			$this->form_validation->set_rules('worktop_quantity', 'Quantity', 'required');
			$this->form_validation->set_rules('worktop_lm', 'Linear Meter Per Kitchen', 'required');
			$this->form_validation->set_rules('worktop_price_per_lm', 'Rate Per Linear Meter', 'required');
		}

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{	// true section

			$data=array(
					'quotation_id'               =>$this->session->userdata('quotation_id'),
					'quotation_kitchen_id'       => $this->input->post('quotation_kitchen_id'),
					'worktop_brand_id'          => $this->input->post('worktop_brand_id'),
					'worktop_finish_id'         => $this->input->post('worktop_finish_id'),
					'worktop_finish_name'         => $this->input->post('finish_text'),
					'worktop_model_id'          => $this->input->post('worktop_model_id'),
					'worktop_model_name'          => $this->input->post('model_text'),
					'worktop_ept_id'            => $this->input->post('worktop_ept_id'),
					'worktop_ept_name'            => $this->input->post('ept_text'),
					'worktop_quantity'          => $this->input->post('worktop_quantity'),
					'worktop_lm'                => $this->input->post('worktop_lm'),
					'worktop_price_per_lm'      => $this->input->post('worktop_price_per_lm')
			);
			
				$rr=$this->crud_model->insert('quotation_worktop',$data);

				if($rr == false){
					// error

					$this->session->set_flashdata('response','<div class="alert alert-error">worktop cannot be inserted</div>',':old:');
					$this->load->view('templates/header');
					$this->load->view('quotations/quotation_worktop');
					$this->load->view('templates/footer');
				}
				else
				{
					// redirect
					$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Worktop Details added successfully</div>');
					redirect('quotations/quotation_worktop');

				}
			
				}
	}
	function do_update()
	{
		if( $this->input->post('worktop_brand_id')!='' and  $this->input->post('worktop_finish_id')!='')
		{

			$this->form_validation->set_rules('worktop_brand_id', 'Worktop  Brand', 'required|is_natural_no_zero');
			$this->form_validation->set_rules('worktop_finish_id', 'Worktop Finish', 'required');
			$this->form_validation->set_rules('worktop_model_id', 'Worktop Model', 'required');
			$this->form_validation->set_rules('worktop_ept_id', 'Worktop EPT', 'required');
			$this->form_validation->set_rules('worktop_quantity', 'Quantity', 'required');
			$this->form_validation->set_rules('worktop_lm', 'Linear Meter Per Kitchen', 'required');
			$this->form_validation->set_rules('worktop_price_per_lm', 'Rate Per Linear Meter', 'required');
		}
		else
		{
			$this->form_validation->set_rules('finish_text', 'Worktop Finish', 'required');
			$this->form_validation->set_rules('model_text', 'Worktop Model', 'required');
			$this->form_validation->set_rules('ept_text', 'Worktop Ept', 'required');
			$this->form_validation->set_rules('worktop_quantity', 'Quantity', 'required');
			$this->form_validation->set_rules('worktop_lm', 'Linear Meter Per Kitchen', 'required');
			$this->form_validation->set_rules('worktop_price_per_lm', 'Rate Per Linear Meter', 'required');
		}
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{	// true section

			$data=array(
					'quotation_id'               =>$this->input->post('quotation_id'),
					'quotation_kitchen_id'       => $this->input->post('quotation_kitchen_id'),
					'worktop_brand_id'          => $this->input->post('worktop_brand_id'),
					'worktop_finish_id'         => $this->input->post('worktop_finish_id'),
					'worktop_finish_name'         => $this->input->post('finish_text'),
					'worktop_model_id'          => $this->input->post('worktop_model_id'),
					'worktop_model_name'          => $this->input->post('model_text'),
					'worktop_ept_id'            => $this->input->post('worktop_ept_id'),
					'worktop_ept_name'            => $this->input->post('ept_text'),
					'worktop_quantity'          => $this->input->post('worktop_quantity'),
					'worktop_lm'                => $this->input->post('worktop_lm'),
					'worktop_price_per_lm'      => $this->input->post('worktop_price_per_lm')
			);
			$where= array(
					'quotation_worktop_id'  => $this->input->post('quotation_worktop_id')
			);

			$rr=$this->crud_model->update('quotation_worktop',$data,$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Quotation worktop Details Updated successfully</div>');
			redirect('quotations/quotation_worktop/edit/'.$quotation_id);
		}

	}
	function edit($quotation_id,$page=1)
	{

		$where=array(
				'quotation_id'    => $quotation_id
		);
		$data['quotation_id']  = $quotation_id;
		$rs=$this->crud_model->get('view_quotation_worktop_with_qkitchen_wbrand_wfinish_wmodel_wept',$where);

		if($rs!=false)
		{
			$data['quotation_id']               = $quotation_id;
			$data['quotation_kitchen_id']       = $rs[0]['quotation_kitchen_id'];
			$data['worktop_brand_id']          = $rs[0]['worktop_brand_id'];
			$data['worktop_finish_id']         = $rs[0]['worktop_finish_id'];
			//$data['worktop_finish_name']         = $rs[0]['finish_text'];
			$data['worktop_model_id']          = $rs[0]['worktop_model_id'];
			//$data['worktop_model_name']          = $rs[0]['model_text'];
			$data['worktop_ept_id']            = $rs[0]['worktop_ept_id'];
			//$data['worktop_ept_name']            = $rs[0]['ept_text'];
			$data['worktop_quantity']          = $rs[0]['worktop_quantity'];
			$data['worktop_lm']                = $rs[0]['worktop_lm'];
			$data['worktop_price_per_lm']      = $rs[0]['worktop_price_per_lm'];
		}

		$list = $this->quotation_model->get_quotation_kitchen_list(array('quotation_id' => $this->session->userdata('quotation_id')));
		$data['quotation_kitchens'] = $list;

		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('quotations/quotation_worktop/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_quotation_worktop_with_qkitchen_wbrand_wfinish_wmodel_wept',array('quotation_id'=>$this->session->userdata('quotation_id')));

		$offset = ($page-1) * $config['per_page'];
		$data['records']=$this->crud_model->get('view_quotation_worktop_with_qkitchen_wbrand_wfinish_wmodel_wept',
				array('quotation_id'=>$this->session->userdata('quotation_id')),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$list = $this->crud_model->get_list('worktop_brand_id','worktop_brand_name','worktop_brands',array(''=>' - Select - ', 0=>'Other'));
		$data['worktop_brands'] = $list;
		//$list = $this->crud_model->get_list('worktop_finish_id','worktop_finish_name','worktop_finish',array(0=>' - Select - '));
		$list=array(''=>'-Select-');
		$data['worktop_finish'] = $list;

		$list=array(''=>'-Select-');
		$data['worktop_models'] = $list;

		$list=array(''=>'-Select-');
		$data['worktop_ept'] = $list;

		$data['linear_meter_per_kitchen']= $this->config->item('linear_meter_per_kitchen');
			
		$rs=$this->crud_model->get('quotation_worktop',array('quotation_id' => $this->session->userdata('quotation_id')));
		if($rs!=false)
		{
			$data['quotation_kitchen_id']=$rs[0]['quotation_kitchen_id'];
		}

		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_worktop/create',$data);
		$this->load->view('templates/footer');

	}
	function get_worktop_price($worktop_ept_id)
	{
		$where=array(
				'worktop_ept_id' =>$worktop_ept_id
		);
		$rs=$this->crud_model->get('worktop_ept',$where);
		if($rs!=false)
		{
			$data['price']=$rs[0]['price'];
			echo $data['price'];
			exit;
		}
	}
	function get_worktop_finish($worktop_brand_id=0)
	{
		if($worktop_brand_id>0)
		{
			$where=array(
					'worktop_brand_id' =>$worktop_brand_id
			);

			$rs=$this->crud_model->get('worktop_finish',$where);
			$select='<select id="worktop_finish_id" name="worktop_finish_id" onChange="get_worktop_model(); get_worktop_ept()">';
			if($rs!=false)
			{
				foreach($rs as $row)
				{
					$select .='<option value="'.$row['worktop_finish_id'].'">'.$row['worktop_finish_name'].'</option>';
				}
			}
			$select.='</select>';
			echo $select;
			exit;
		}
		else
		{
			echo '<input type="text" name="finish_text">';
			exit;
		}

	}
	function display_model_text()
	{

		echo '<input type="text" name="model_text">';
		exit;
	}
	function display_ept_text()
	{

		echo '<input type="text" name="ept_text">';
		exit;
	}
	function get_worktop_model($finish_id=0)
	{


		$where=array(
				'worktop_finish_id' =>$finish_id
		);

		$rs=$this->crud_model->get('worktop_price_groups',$where);

		if($rs!=false){
			$price_group_id=$rs[0]['price_group_id'];
		}
		else
		{
			$price_group_id=0;
		}
		$where=array(
				'price_group_id' => $price_group_id
		);
		if($price_group_id!=0)
			$rs=$this->crud_model->get('worktop_models',$where);
		$select='<select id="worktop_model_id" name="worktop_model_id">';
		if($price_group_id!=0)
		{
			if($rs!=false)
			{
				foreach($rs as $row)
				{
					$select .='<option value="'.$row['worktop_model_id'].'">'.$row['worktop_model_name'].'</option>';
						
				}
			}
		}
		$select.='</select>';
		echo $select;

		exit;


	}
	function get_worktop_ept($finish_id=0)
	{
		$where=array(
				'worktop_finish_id' =>$finish_id
		);

		$rs=$this->crud_model->get('worktop_price_groups',$where);
		if($rs!=false){
			$price_group_id=$rs[0]['price_group_id'];
		}
		else
		{
			$price_group_id=0;
		}
		$where=array(
				'price_group_id' => $price_group_id
		);
		if($price_group_id!=0)
			$rs=$this->crud_model->get('worktop_ept',$where);
		$select='<select id="worktop_ept_id" name="worktop_ept_id" onChange="display_price();">';
		if($price_group_id!=0)
		{
			if($rs!=false)
			{
				foreach($rs as $row)
				{
					$select .='<option value="'.$row['worktop_ept_id'].'">'.$row['worktop_ept_name'].'</option>';
				}
			}
		}
		$select.='</select>';
		echo $select;
		exit;


	}
	function display_price($worktop_ept_id=0)
	{

		$where=array('worktop_ept_id'=>$worktop_ept_id);
		$rs=$this->crud_model->get('worktop_ept',$where);


		if($rs!=false){
			$price=$rs[0]['price'];
			echo $price;

		}
		else {
			echo '';
		}
		exit;
	}
	function do_delete($id=0)
	{
		$where=array(
				'quotation_worktop_id'=> $id
		);
		$this->crud_model->delete('quotation_worktop',$where);
		$this->session->set_flashdata('response','<div class="alert alert-success">Worktop deleted</div>');
		redirect('quotations/quotation_worktop');
	}


}

