<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Quotation_covering_letter extends CI_Controller {

	public function __construct() {
		parent::__construct();

		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('tw');
	}

	function index()
	{
		$quotation_id=$this->session->userdata('quotation_id');

		$where=array(
			'quotation_id' => $quotation_id
		);
		//$rs = $this->crud_model->get('quotations',$where);
		$this->load->model('quotation_model');
		$data = $this->quotation_model->get_full_quotation_details($quotation_id);

		/*if($rs!=false)
		{
			$data=$rs[0];
		}*/
		//print_r($data);exit;
		//echo $this->db->last_query();
		$records = $this->crud_model->get('covering_letter_template');

		
		$list = $this->crud_model->get_list('cl_template_id','cl_template_name','covering_letter_template',array(0=>' - Select - '));
		$data['covering_letter_template'] = $list;
		
		if($this->session->userdata('user_group_id') == 1) {	
			$list = $this->crud_model->get_list('payment_id','payment_label','payment_terms',array());
			$data['payment_terms'] = $list;
			$list = $this->crud_model->get_list('payment_id','payment_text','payment_terms',array());
			$data['payment_terms_text'] = $list;
		}	
		
		$this->load->view('templates/header');
		$this->load->view('transactions/quotation_covering_letter/covering_letter_view',$data);
		$this->load->view('templates/footer');

	}
	function get_covering_contents($template_id)
	{

		$where=array('cl_template_id'  =>$template_id);
		$rs=$this->crud_model->get('covering_letter_template',$where);

		if($rs!=false)
		{
			$data['cl_template_content']=$rs[0]['cl_template_content'];
			
			
			
			$quotation_data = $this->quotation_model->get_full_quotation_details($this->session->userdata('quotation_id'));
			
			
			$data['cl_template_content'] = str_replace("{project_name}", $quotation_data['project_name'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{project_location}", $quotation_data['project_location'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_name}", $quotation_data['user_name'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_contact_no}", $quotation_data['user_contact_number'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_direct_no}", $quotation_data['user_direct_number'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_email_id}", $quotation_data['user_email_id'], $data['cl_template_content']);	
			echo $data['cl_template_content'];
			exit;
		}
	}
	
	function get_covering_contents_furniture($template_id,$quotation_id)
	{
		$this->load->model('furniture_quotation_model');
		$where=array('cl_template_id'  =>$template_id);
		$rs=$this->crud_model->get('covering_letter_template',$where);

		if($rs!=false)
		{
			$data['cl_template_content']=$rs[0]['cl_template_content'];
			
			
			
			$quotation_data = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
			
			
			$data['cl_template_content'] = str_replace("{project_name}", $quotation_data['project_name'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{project_location}", $quotation_data['project_location'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_name}", $quotation_data['salesman_name'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_contact_no}", $quotation_data['salesman_contact_number'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_direct_no}", $quotation_data['salesman_direct_number'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{salesman_email_id}", $quotation_data['salesman_email_id'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{quotation_no}",$quotation_data['quotation_number_full'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{quotation_date}",date('M d, Y',strtotime($quotation_data['quotation_date'])), $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{customer_name}",$quotation_data['client_name'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{customer_address}",$quotation_data['client_address'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{quotation_total}",$quotation_data['quotation_net_total'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{advance_amount}",$quotation_data['advance_amount'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{advance_percentage}",$quotation_data['advance_percentage'], $data['cl_template_content']);
			$data['cl_template_content'] = str_replace("{today}",date('M d, Y'), $data['cl_template_content']);	
			$data['cl_template_content'] = str_replace("{contact_name}",$quotation_data['Contact_Name'], $data['cl_template_content']);	
			echo $data['cl_template_content'];
			exit;
		}
	}
	function get_terms_and_conditions($cl_terms_id,$quotation_id)
	{
		$this->load->model('furniture_quotation_model');
		$where=array('terms_id'  =>$cl_terms_id);
		$rs=$this->crud_model->get('terms_and_conditions',$where);

		if($rs!=false)
		{
			$data['terms_content']=$rs[0]['terms_content'];
			
			
			
			$quotation_data = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
			
			
			$data['terms_content'] = str_replace("{project_name}", $quotation_data['project_name'], $data['terms_content']);
			$data['terms_content'] = str_replace("{project_location}", $quotation_data['project_location'], $data['terms_content']);
			$data['terms_content'] = str_replace("{salesman_name}", $quotation_data['salesman_name'], $data['terms_content']);
			$data['terms_content'] = str_replace("{salesman_contact_no}", $quotation_data['salesman_contact_number'], $data['terms_content']);
			$data['terms_content'] = str_replace("{salesman_direct_no}", $quotation_data['salesman_direct_number'], $data['terms_content']);
			$data['terms_content'] = str_replace("{salesman_email_id}", $quotation_data['salesman_email_id'], $data['terms_content']);
			$data['terms_content'] = str_replace("{quotation_no}",$quotation_data['quotation_number_full'], $data['terms_content']);
			$data['terms_content'] = str_replace("{quotation_date}",date('M d, Y',strtotime($quotation_data['quotation_date'])), $data['terms_content']);
			$data['terms_content'] = str_replace("{customer_name}",$quotation_data['client_name'], $data['terms_content']);
			$data['terms_content'] = str_replace("{customer_address}",$quotation_data['client_address'], $data['terms_content']);
			$data['terms_content'] = str_replace("{quotation_total}",$quotation_data['quotation_net_total'], $data['terms_content']);
			$data['terms_content'] = str_replace("{advance_amount}",$quotation_data['advance_amount'], $data['terms_content']);	
			$data['terms_content'] = str_replace("{advance_percentage}",$quotation_data['advance_percentage'], $data['terms_content']);	
			$data['terms_content'] = str_replace("{today}",date('M d, Y'), $data['terms_content']);	
			$data['terms_content'] = str_replace("{contact_name}",$quotation_data['Contact_Name'], $data['terms_content']);
			echo $data['terms_content'];
			exit;
		}
	}
	
	function do_update()
	{
		$this->form_validation->set_rules('discount_percentage', 'Discount %', 'numeric|callback_discount_check');
		$this->form_validation->set_rules('cl_template_content', 'Template Content', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{
			
			//Check if the edit was already cloned and revisioned, else clone and increase revision
			$this->quotation_model->check_changes_cloned();
			
			if($this->session->userdata('user_group_id') == 1) {
				$payment_id=$this->input->post('payment_terms');
			} else {
				$payment_id=1;
			}
			$data_quo=array(
					'discount_percentage'		  => $this->input->post('discount_percentage'),
					'cl_template_id'              => $this->input->post('cl_template_id'),
					'cl_content'                  => $this->input->post('cl_template_content'),
					'payment_id'				  => $payment_id
			);
			$where=array('quotation_id'       =>$this->session->userdata('quotation_id'));

			$rr_quo=$this->crud_model->update('quotations',$data_quo,$where);
			//echo $this->db->last_query();exit;
			$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Details Updated successfully</div>');
			
			if($this->input->post('update') == "Update Quotation & Close"){
				redirect('transactions/quotations');
			}
			else{
				redirect('transactions/quotation_covering_letter');
			}
			
		}
	}
	
	function do_update_quotation_status(){
		
		$this->form_validation->set_rules('quotation_status', 'Quotation Status', 'required');
		
		if($this->input->post('quotation_status') == 'Confirmed'){
			$this->form_validation->set_rules('client_cpr_number', 'Client CPR Number', 'required');
		}
		elseif($this->input->post('quotation_status') == 'Closed'){
			$this->form_validation->set_rules('quotation_closed_reason', 'Reason for Quotation Close', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response_status_update','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{
			
			if($this->input->post('quotation_status') == 'Draft'){
				//Check if the edit was already cloned and revisioned, else clone and increase revision
				$this->quotation_model->check_changes_cloned();
			}
			$where=array('quotation_id'	=> $this->session->userdata('quotation_id'));
			
			$data_quo = array(
				'quotation_status'		=> $this->input->post('quotation_status'),
				'last_modified_date' => date('Y-m-d')
			);
			
			
			if($this->input->post('quotation_status') == 'Confirmed'){
				$data_quo['client_cpr_number'] = $this->input->post('client_cpr_number');
				//--------agreement creation--------
				$res=$this->quotation_model->get_full_quotation_details($this->session->userdata('quotation_id'));
				$payment_id=$res['payment_id'];
				if($payment_id == 0) {
					$payment_id=1;
				}
				$pm=$this->crud_model->get('payment_terms',array('payment_id' => $payment_id));
				$payment_term='';
				if($pm) {
					$payment_term=$pm[0]['payment_text'];
				}
								
				$data = array(
						'{agreement_date}' 				=> date('M d, Y'),
						'{quotation_date}' 				=> date('M d, Y',strtotime($res['quotation_date'])),
						'{quotation_number}' 			=> $res['quotation_number'].'-'.$res['quotation_revision_number'],
						'{client_name}' 				=> $res['client_name'],
						'{client_address}' 				=> $res['client_address'],
						'{client_area}' 				=> $res['client_area'],
						'{quotation_total}' 			=> 'BD.'.number_format( $res['quotation_net_total'],2),
						'{quotation_total_words}' 		=> ucwords(convert_number_to_words( $res['quotation_net_total']).' dinars only'),
						'{payment_term}'				=>$payment_term
					);
					
				$agr_tpls = $this->crud_model->get('agreement_template');
				if($agr_tpls!=false){
					$tpl_content = $agr_tpls[0]['a_template_content'];
					//echo $tpl_content.'<br/><br/><br/><br/>';
					foreach($data as $var => $value){
						$tpl_content = str_replace($var, $value, $tpl_content);
						$data_quo['agreement_content'] = $tpl_content;
						//echo $tpl_content.'<br/><br/><br/><br/>';
					}
				
				}
					
					
				$update_flag=false;
				
				if($_FILES['client_cpr_file_name']['size']>0){
					$config['upload_path'] = 'files';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['max_size']	= '100';
					$config['max_width']  = '2000';
					$config['max_height']  = '2000';
					
					$this->load->library('upload', $config);
										
					if ( ! $this->upload->do_upload('client_cpr_file_name'))
					{
						$this->session->set_flashdata('response_status_update','<div class="alert alert-error">'.$this->upload->display_errors().'</div>',':old:');
						$this->index();
					}
					else
					{
						$udata = $this->upload->data();
							
						$data_quo['client_cpr_file_name'] = $udata['file_name'];
						$update_flag=true;
					}
				}
				else{
					$data_quo['client_cpr_file_name'] = '';
					$update_flag=true;
				}

				if($update_flag) {

					$rr_quo=$this->crud_model->update('quotations',$data_quo,$where);
					$links          = 'http://khalaifat.com/qms/index.php/transactions/quotations/view2/'.$res['quotation_id'];

					/*	email notification start	*/

						$this->load->library('tw_email');
						// send mail code
						$from 		= ADMIN_MAIL;
						$fromname 	= 'QMS Admin';
						$to 		= CONFIRM_GROUP_EMAIL;
						$subject 	= 'QMS - Quotation for '.$res['client_name'].'('.$res['quotation_number'].'-'.$res['quotation_revision_number'].') is confirmed';
						$message 	= '
						<table>
							<tr>
								<td>Quotation No.</td>
								<td>:</td>
								<td><a href='.$links.'>'.$res['quotation_number'].'-'.$res['quotation_revision_number'].'</a></td>

							</tr>
							<tr>
								<td>Client : </td>
								<td>:</td>
								<td>'.$res['client_name'].'</td>
							</tr>
							<tr>
								<td>Salesperson : </td>
								<td>:</td>
								<td>'.$res['salesman_name'].'</td>
							</tr>
							<tr>
								<td>Value : </td>
								<td>:</td>
								<td>BD.'.number_format( $res['quotation_net_total'],2).'</td>
							</tr>
							<tr>
								<td>Payment Terms : </td>
								<td>:</td>
								<td>'.$payment_term.'</td>
							</tr>
						</table>';

						$this->tw_email->send($from,$fromname,$to,$subject,$message);

						/*	email notification end		*/
						
						/*	salesman email notification start	*/

						$this->load->library('tw_email');
						// send mail code
						$from 		= ADMIN_MAIL;
						$fromname 	= 'QMS Admin';
						$to 		= $res['user_email_id'];
                                                
						$subject 	= 'Congratulations on Confirming the order for '.$res['client_name'];
						$message 	= '
                                                Dear ' .$res['user_name']. ',
                                                <BR><BR>
                                                Congratulations on confirming the order for '.$res['client_name'].'!!
                                                <BR><BR>
                                                Please click on this <a href='.$links.'> link to view the quotation.</a>
                                                <BR>
                                                <BR><BR>
                                                Regards,<BR>
                                                KC Management

                                                ';

						$this->tw_email->send($from,$fromname,$to,$subject,$message);

						/*	salesman email notification end		*/
							
						$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Status Updated successfully</div>');
						redirect('transactions/quotations/index/1/2/'.$this->session->userdata('quotation_id'));
				}
							
			}
			elseif($this->input->post('quotation_status') == 'Closed'){
				$data_quo['quotation_closed_reason'] = $this->input->post('quotation_closed_reason');
				
				$rr_quo=$this->crud_model->update('quotations',$data_quo,$where);
				$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Status Updated successfully</div>');
				//redirect('transactions/quotation_covering_letter');
				redirect('transactions/quotations/index/1/1/'.$this->session->userdata('quotation_id'));
			}
			else 
			{//Draft or open
				
				$data_quo['quotation_date']=date('Y-m-d');
				$rr_quo=$this->crud_model->update('quotations',$data_quo,$where);
				$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Status Updated successfully</div>');
				//redirect('transactions/quotation_covering_letter');
				if($this->input->post('quotation_status') == 'Open') {
					redirect('transactions/quotations/index/1/1/'.$this->session->userdata('quotation_id'));
				} else {
					redirect('transactions/quotations/index');
				}
			}
				
		}
		
	}
	
	
	function discount_check($discount){
		$rs = $this->crud_model->get('user_groups',array('user_group_id'=>$this->session->userdata('user_group_id')));
		if($rs != false){
			$discount_percentage_allowed = $rs[0]['discount_limit'];
			if($discount_percentage_allowed >= $discount){
				return TRUE;
			}
			else{
				$this->form_validation->set_message('discount_check', 'Allowed maximum discount percentage is '.$discount_percentage_allowed.'%%');
				return FALSE;
			}
		}
		else{
			return TRUE;
		}
	}
	
	function do_close()
	{
		$this->session->unset_user_data('quotation_id');

		redirect('transactions/quotations');
	}
}
