<?php

class Hr_model extends CI_Model {

	public function __construct() {
	
		// Call the Model constructor
		parent::__construct();
	}

	function get_employee($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('employee.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->row_array();
		}
		else{
			return false;
		}
	}

	function get_count_with_group_by($table_name = '', $where = array(), $group_by = '') {
		$this->db->select('COUNT(*) as count');
		if (!empty($group_by)) {
			$this->db->group_by($group_by);
		}
		$rs = $this->db->get_where($table_name, $where);
		return $rs->num_rows();
	}

	function get_employee_count($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		$this->db->select('employee.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return 0;
		}
	}

	function get_employee_details($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('employee.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_employee_department_count($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		$this->db->select('employee.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee_dependent_details');
		$this->db->join('employee','employee.employee_id = employee_dependent_details.employee_id','left');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return 0;
		}
	}

	function get_employee_dependent_details($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('employee.*,employee_dependent_details.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee_dependent_details');
		$this->db->join('employee','employee.employee_id = employee_dependent_details.employee_id','left');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_all_attendance(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('attendance_date >=',$fromDate);
				$this->db->where('attendance_date <=',$toDate);
			} else if($this->input->post('fromDate')!="" && $this->input->post('toDate')==""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$this->db->where('attendance_date >=',$fromDate);
			} else if($this->input->post('fromDate')=="" && $this->input->post('toDate')!=""){
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('attendance_date <=',$toDate);
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('attendance_date,pay_unit_id,pay_value,employee.employee_number,employee.employee_id,employee.employee_name,employee.employee_status,employee.nationality,pay_unit.pay_unit_name,attendance_no' );
			$this->db->from('employee_attendance');
			$this->db->join('employee','employee.employee_id = employee_attendance.employee_id','left');
			$this->db->join('pay_unit','pay_unit.id = employee_attendance.pay_unit_id','left');
			$this->db->group_by('employee_attendance.attendance_no');
			$this->db->order_by("employee.employee_id","desc");
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}else{
				return false;
			}
		} else {
			return false;
		}
	}
	function get_attendance($attendance_no){
		if($attendance_no!=""){
			$this->db->like('employee_attendance.attendance_no',$attendance_no);
		}
		$this->db->select('attendance_id,attendance_date,pay_unit_id,pay_value,comments,employee.employee_number,employee.employee_id,employee.employee_name,employee.employee_status,employee.nationality,pay_unit.pay_unit_name,attendance_no' );
		$this->db->from('employee_attendance');
		$this->db->join('employee','employee.employee_id = employee_attendance.employee_id','left');
		$this->db->join('pay_unit','pay_unit.id = employee_attendance.pay_unit_id','left');
		//$this->db->group_by('employee_attendance.attendance_no');
		$this->db->order_by("employee.employee_id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_payroll_processing(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('attendance_date >=',$fromDate);
				$this->db->where('attendance_date <=',$toDate);
			} else if($this->input->post('fromDate')!="" && $this->input->post('toDate')==""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$this->db->where('attendance_date >=',$fromDate);
			} else if($this->input->post('fromDate')=="" && $this->input->post('toDate')!=""){
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('attendance_date <=',$toDate);
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('attendance_date,pay_unit_id,pay_hash_unit,sum(pay_value) as pay_value,employee.employee_number,employee.employee_id,employee.employee_name,employee.employee_status,employee.nationality,pay_unit.pay_unit_name,attendance_no' );
			$this->db->from('employee_attendance');
			$this->db->join('employee','employee.employee_id = employee_attendance.employee_id','left');
			$this->db->join('pay_unit','pay_unit.id = employee_attendance.pay_unit_id','left');
			$this->db->group_by('`pay_unit_id`');
			if($this->input->post('employee_id')===""){
				$this->db->group_by('employee.employee_id');
			}
			$this->db->order_by("employee.employee_id","desc");
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}else{
				return false;
			}
		} else {
			return false;
		}
	}

	function available_payroll(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$this->db->where('employee_pay_heads.applicable_date <=',$fromDate);
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee_pay_heads.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('employee_pay_heads.*,pay_head.*,employee.employee_name' );
			$this->db->from('employee_pay_heads');
			$this->db->join('pay_head','pay_head.id = employee_pay_heads.pay_head_id','left');
			$this->db->join('employee','employee.employee_id = employee_pay_heads.employee_id','left');
			if($this->input->post('employee_id')===""){
				$this->db->group_by('employee_pay_heads.employee_id');
				$this->db->group_by('employee_pay_heads.pay_head_id');
			}
			$this->db->order_by("employee.employee_name","desc");
			$this->db->order_by("pay_head.id","asc");
			$rs = $this->db->get();
			//echo $this->db->last_query();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}else{
				return false;
			}
		} else {
			return false;
		}
	}

	function employee_attendance_processed(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('processing_year', date('Y', strtotime($fromDate)));
				$this->db->where('processing_month', date('m', strtotime($toDate)));
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('employee_attendance_processed.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('*');
			$this->db->from('employee_attendance_processed');
			if($this->input->post('employee_id')===""){
				$this->db->group_by('employee_attendance_processed.employee_id');
			}
			$this->db->order_by("employee_attendance_processed.employee_id","desc");
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}else{
				return false;
			}
		} else {
			return false;
		}
	}

	function get_payroll_report(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('year')!=""){
				$year=$this->input->post('year');
				$this->db->where('processing_year',$year);
			}	
			if($this->input->post('month')!=""){
				$month=$this->input->post('month');
				$this->db->where('processing_month',$month);
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('eap.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('eap.employee_id,eap.processed_no,eap.processing_year,eap.processing_month,eap.pay_head_id,eap.amount,e.employee_name,e.employee_number');
			$this->db->from('employee_attendance_processed eap');
			$this->db->join('employee e','e.employee_id = eap.employee_id','left');
			$this->db->order_by("eap.employee_id","desc");
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	function get_emp_earnings($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		$this->db->select('eap.*,ph.pay_head_name,ph.pay_head_display_name');
		$this->db->where($where);
		$this->db->from('employee_attendance_processed eap');
		$this->db->join('pay_head AS ph','ph.id = eap.pay_head_id','inner');
		$this->db->where('ph.effect_net_salary',1);
		$this->db->where('eap.amount >',0);
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	function get_emp_deductions($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		$this->db->select('eap.*,ph.pay_head_name,ph.pay_head_display_name');
		$this->db->where($where);
		$this->db->from('employee_attendance_processed eap');
		$this->db->join('pay_head AS ph','ph.id = eap.pay_head_id','inner');
		$this->db->where('ph.effect_net_salary',1);
		$this->db->where('eap.amount <',0);
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	function get_emp_ot($where = array()){
		$this->db->select('sum(ea.pay_value) as pay_value,pu.pay_unit_name,pu.pay_uom');
		$this->db->where($where);
		$this->db->from('employee_attendance ea');
		$this->db->join('pay_unit AS pu','pu.id = ea.pay_unit_id','inner');
		$this->db->where('pu.type',1);
		$this->db->group_by('pu.id');
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_payroll_processed(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('fromDate')!="" && $this->input->post('toDate')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('fromDate')));
				$toDate=date('Y-m-d',strtotime($this->input->post('toDate')));
				$this->db->where('eap.processing_year', date('Y', strtotime($fromDate)));
				$this->db->where('eap.processing_month', date('m', strtotime($toDate)));
			}
			if($this->input->post('employee_id')!=""){
				$this->db->where('eap.employee_id',$this->input->post('employee_id'));
			}
			$this->db->select('eap.*,e.employee_number,e.employee_name');
			$this->db->from('employee_attendance_processed eap');
			$this->db->join('employee e','e.employee_id = eap.employee_id','inner');
			//if($this->input->post('employee_id')===""){
				$this->db->group_by('eap.employee_id');
			//}
			$this->db->order_by("eap.employee_id","desc");
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}else{
				return false;
			}
		} else {
			return false;
		}
	}
	function get_payroll_account_debit(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('year')!=""){
				$year=$this->input->post('year');
				$this->db->where('processing_year',$year);
			}	
			if($this->input->post('month')!=""){
				$month=$this->input->post('month');
				$this->db->where('processing_month',$month);
			}
			/* if($this->input->post('employee_id')!=""){
				$this->db->where('eap.employee_id',$this->input->post('employee_id'));
			} */
			$this->db->where('eap.amount>',0);
			$this->db->select('`eap`.`employee_id`, `eap`.`processed_no`, `eap`.`processing_year`, `eap`.`processing_month`, `eap`.`pay_head_id`, `eap`.`amount`,`ph`.`pay_head_name`,max(`eap`.`processed_date`) as processed_date,`ph`.`accounts_ledger`,sum(`eap`.`amount`) as ledger_amount,`l`.`ledger_name`');
			$this->db->from('employee_attendance_processed eap');
			$this->db->join('pay_head ph','ph.id = eap.pay_head_id','inner');
			$this->db->join('ledgers l','l.ledger_code = ph.accounts_ledger','left');
			$this->db->group_by('ph.accounts_ledger');
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	function get_payroll_account_credit(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('year')!=""){
				$year=$this->input->post('year');
				$this->db->where('processing_year',$year);
			}	
			if($this->input->post('month')!=""){
				$month=$this->input->post('month');
				$this->db->where('processing_month',$month);
			}
			/* if($this->input->post('employee_id')!=""){
				$this->db->where('eap.employee_id',$this->input->post('employee_id'));
			} */
			$this->db->where('eap.amount<',0);
			$this->db->select('`eap`.`employee_id`, `eap`.`processed_no`, `eap`.`processing_year`, `eap`.`processing_month`, `eap`.`pay_head_id`, `eap`.`amount`,`ph`.`pay_head_name`,max(`eap`.`processed_date`) as processed_date,`ph`.`accounts_ledger`,sum(`eap`.`amount`) as ledger_amount,`l`.`ledger_name`');
			$this->db->from('employee_attendance_processed eap');
			$this->db->join('pay_head ph','ph.id = eap.pay_head_id','inner');
			$this->db->join('ledgers l','l.ledger_code = ph.accounts_ledger','left');
			$this->db->group_by('ph.accounts_ledger');
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->result_array();
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}
?>