	<style>
		div.dt-buttons {
			float: right;
			padding-left: 15px;
			padding-right: 15px;
		}
		.dataTables_length {
			position: absolute;
		}
	</style>
	<!--app-content open-->
	<div class="app-content main-content">
		<div class="side-app">
			<div class="main-container">
				<!-- PAGE-HEADER -->
				<div class="page-header">
					<div class="col-xl-5 col-lg-6 col-md-5 col-sm-6">
						<h1 class="page-title">Ledger List</h1>
                    </div>
					<div class="col-xl-7 col-lg-6 col-md-7 col-sm-6">
                        <div class="float-sm-end float-none my-1">
							<?php if($this->users_model->check_permission("Ledger","Add")!=false){ ?>
								<a id="add__new__list" type="button" class="btn btn-md btn-primary " data-bs-target=".bd-example-modal-lg" href="<?php echo site_url('masters/Ledger/create');?>"><i class="fa fa-plus"></i> Add a new</a>
							<?php } ?>
						</div>
                    </div>
				</div>
			</div>
			<!-- PAGE-HEADER END -->
			<!-- ROW-1 -->
			<div class="row">
				<div class="col-md-12 col-lg-12">
					<div class="card" style="padding-top: 25px;" >
						<?php
							if($this->session->flashdata("response")!='') {
								echo '<div class="alert alert-danger">' . $this->session->flashdata("response") . '</div>';
								$this->session->unset_userdata('response');
							}
						?>
						<?php
							if($this->session->flashdata("success")!='') {
								echo '<div class="alert alert-success">' . $this->session->flashdata("success") . '</div>';
								$this->session->unset_userdata('success');
							}
						?>
						<form id="data-form" class="form-search" method="post" enctype="multipart/form-data" action="<?php echo site_url('masters/Ledger');?>">
							<div class="form-row">
								<div class="form-group col-md-2 mb-0">
									<div class="form-group">
										<input type="text" class="form-control" id="filter_value" name="filter_value" placeholder="Ledger Name or Code" value="<?php if ($this->input->post('filter_value')){  echo $this->input->post('filter_value'); } //elseif($filter_value!=='NIL'){ echo $filter_value; }?>"  autocomplete="off" >
									</div>
								</div>
						
								<div class="col-md-1 mb-0">
									<div class="form-group">
										<button class="btn btn-primary" type="submit" name="ttttt" ><i class="fe fe-search"></i></button>
									</div>
								</div>
                    		</div>
						</from>
						<div class="table-responsive">
							<table class="table" id="ledger_data" >
								<thead class="thead-light" >
									<tr>
										<th>#</th>
										<th>Ledger Code</th>
										<th>Ledger Name</th>
        								<th>Accounts Group</th>
										<th>&nbsp;</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$DeletePermission=$this->users_model->check_permission("Ledger","Delete");
									$EditPermission=$this->users_model->check_permission("Ledger","Edit");  
									if($records != false) {
										$i=1;
										foreach($records as $record){
									?>
									<tr>
										<td><?php echo $i; ?></td>
										<td><?php echo $record['ledger_code']; ?></td>
										<td><?php echo $record['ledger_name']; ?></td>
										<td><?php echo $record['acc_group_name']; ?></td>
										<td>
											<?php if($EditPermission){ ?>
											<?php if($record['is_edit']==1) { ?><a class="btn btn-sm btn-primary" href="<?php echo site_url('masters/Ledger/edit/'.$record['ledger_id']); ?>">Edit</a> <?php } ?>
											<?php } ?>
											<!--<a class="btn btn-sm btn-danger " href="javascript:isDel('<?php //echo $record['terms_id']; ?>');">Delete</a>-->
										</td>
									</tr>
									<?php
											$i++;
											}
										} else {
									?>
									<tr>
										<td colspan="3">No records available</td>
									</tr>
									<?php
									}
									?>
								</tbody>
							</table>
						</div>
						<?php //echo $pagination; ?>
						<!-- table-responsive -->
					</div>
				</div>
			</div>
			<!-- ROW-1 CLOSED -->
		</div>
	</div>
	<script type="text/javascript">
		$(function(e) {
			$('#ledger_data').DataTable({
				"paging": true,
				"processing": true,
				"scrollCollapse": true,
				"ordering": true,
				"iDisplayLength": 100,
				"lengthMenu": [ [100, 150, 200, -1], [100, 150, 200, "All"] ],
				"info": true,
				dom: 'lBfrtip',
				buttons: [
					{ extend: 'copyHtml5',title: '',text: 'Copy',header: false, text:'<i class="fa fa-copy"></i>',titleAttr: 'Copy', className: 'btn-primary' },
					{ extend: 'excelHtml5',title: 'Ledger Data',filename: function(){ var today = new Date();var n = today.getTime();return 'LedgerExcelExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Excel', text:'<i class="fa fa-file-excel-o"></i>',titleAttr: 'Excel', className: 'btn-success' },
					{ extend: 'print',title: 'Ledger Data',filename: function(){ var today = new Date();var n = today.getTime();return 'LedgerPrintExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Print', text:'<i class="fa fa-print"></i>',titleAttr: 'Print', className: 'btn-warning' },
					
				]
			});
		});
		function isDel(id){
			$('body').removeClass('timer-alert');
			swal({
					title: "Alert",
					text: "Are you sure you want to delete??",
					type: "warning",
					showCancelButton: true,
					confirmButtonText: 'Yes',
					cancelButtonText: 'Cancel'
				},
				function(isConfirm){
				if (isConfirm) {
					document.location.href="<?php echo site_url('masters/terms_and_conditions/do_delete'); ?>/"+id;
				} else {
					swal("Cancelled", "Something went wrong :)", "error");
				}
			});	
		}
	</script>
