<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class General_receipt extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}

	public function list_general_receipt($division_id="NIL",$filter_by="NIL",$filter_value="NIL") {
		$this->users_model->permission("General_receipt", "View");
		$title['headerTitle']="Receipt List";
		$this->load->library('pagination');
		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		}elseif ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		if (@$this->input->post('filter_by')) {
			$filter_by =   $this->input->post("filter_by");
		}elseif ($filter_by != "NIL") {
			$filter_by	=	$filter_by;
		} else {
			$filter_by	= "NIL";
		}

		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		$config["base_url"] = base_url() . "index.php/General_receipt/list_general_receipt/".$division_id."/".$filter_by."/".$filter_value;
        $config["total_rows"] = $this->furniture_quotation_model->general_record_count($division_id,$filter_by,$filter_value);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =6;
        $this->pagination->initialize($config);
        if ($this->uri->segment(6)) {
            $page = $this->uri->segment(6)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->get_all_general_receipts($config["per_page"], $page,$division_id,$filter_by,$filter_value);
		$data['pagination'] = $this->pagination->create_links();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header',$title);
		$this->load->view('manage/list_general_receipt',$data);
		$this->load->view('templates/footer');
	}

	public function index($quotation_id=0) {
		$this->data['receipts'] = $this->furniture_quotation_model->get_all_receipts();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header');
		$this->load->view('manage/receipts',$this->data);
		$this->load->view('templates/footer');
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and ledger_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where status=1 and  (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and `ledger_name` like '$client%'   union (SELECT * FROM `ledgers` where status=1 and  (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and  `ledger_id` not in (SELECT `ledger_id` FROM `ledgers` where status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and `ledger_name` like '$client%' ) ".$sql." order by ledger_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}
	
	public function create_general_receipt(){
		$this->users_model->permission("General_receipt", "Add");
		$title['headerTitle']="New General Receipt";
		$data['cash_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
		$data['bank_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
		$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');	
		$this->load->view('templates/header',$title);
		$this->load->view('manage/create_general_receipt',$data);
		$this->load->view('templates/footer');
	}

	public function edit_general_receipt($g_receipt_id){
		$this->users_model->permission("General_receipt", "Edit");
		$title['headerTitle']="Edit General Receipt";
		$where=array(
			'g_receipt_id' => $g_receipt_id
		);
		$data['dbdata']=$this->crud_model->get('general_receipts',$where);

		$data['cash_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
		$data['bank_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');

		$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
		
		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`ledger_amount` <', 0);
		$rs = $this->db->get();
		$data['details']    = $rs->result_array();

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`vch_ref`','Cash');
		$cash_rs = $this->db->get();
		$data['cash_details']    = $cash_rs->result_array();

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`vch_ref`','Bank Transfer');
		$bank_rs = $this->db->get();
		$data['bank_details']    = $bank_rs->result_array();

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`vch_ref`','Credit Card');
		$c_card_rs = $this->db->get();
		$data['c_card_details']    = $c_card_rs->result_array();

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`vch_ref`','Wallet');
		$wallet_rs = $this->db->get();
		$data['wallet_details']    = $wallet_rs->result_array();

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
		$this->db->where('accounts.`vch_ref`','Cheque');
		$cheque_rs = $this->db->get();
		$data['cheque_details']    = $cheque_rs->result_array();
		
		$this->load->view('templates/header',$title);
		$this->load->view('manage/edit_general_receipt',$data);
		$this->load->view('templates/footer');
	}

	public function validate_amount() {
		$net_amount = (float)$this->input->post('bank_amt') + (float)$this->input->post('cash') + (float)$this->input->post('c_card') + (float)$this->input->post('cheque_amt') + (float)$this->input->post('wallet_amnt');
		$total_paying_amount = 0;
		$ledger_code=$this->input->post('ledger_code');
		$ledger_amount =$this->input->post('ledger_amount');
		for($kn=0;$kn<count($ledger_code);$kn++){
			if($ledger_code[$kn]!=='' &&  $ledger_amount[$kn]!=='' ){
				$total_paying_amount = $total_paying_amount + (float)$ledger_amount[$kn];
			}
		}

		if ($net_amount == $total_paying_amount) {
			return true;
		} else {
			$this->form_validation->set_message('validate_amount', 'The total amount does not match the total ledger wise amount.');
			return false;
		}
	}

	public function save_general_receipt(){
		$this->users_model->permission("General_receipt", "Add");
		$this->form_validation->set_rules('general_receipt_date','Date', 'required');
		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		if($this->input->post('bank_check')==1){
			$this->form_validation->set_rules('bank_ledgers','Bank Ledger', 'required');
		} else {
			$this->form_validation->set_rules('bank_ledger_code','Bank Ledger', 'required');
		}
		if($this->input->post('cash_check')==1){
			$this->form_validation->set_rules('cash_ledgers','Cash Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cash_ledger_code','Cash Ledger', 'required');
		}
		if($this->input->post('c_card_check')==1){
			$this->form_validation->set_rules('c_card_ledgers','C Card Ledgers', 'required');
		} else {
			$this->form_validation->set_rules('c_card_ledger_code','C Card Ledger', 'required');
		}
		if($this->input->post('wallet_check')==1){
			$this->form_validation->set_rules('wallet_ledgers','Wallet Ledger', 'required');
		} else {
			$this->form_validation->set_rules('wallet_ledger_code','Wallet Ledger', 'required');
		}
		if($this->input->post('cheque_check')==1){
			$this->form_validation->set_rules('cheque_ledgers','Cheque Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cheque_ledger_code','Cheque Ledger', 'required');
		}
		$this->form_validation->set_rules('i_total', 'Amount', 'callback_validate_amount');

		if ($this->form_validation->run() == FALSE) {
			$title['headerTitle']="New General Receipt";
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			$data['cash_ledgers']= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
			$data['bank_ledgers']= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
			$data['records'] 	 = $this->crud_model->get('voucher_ledger_mapping');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('manage/create_general_receipt',$data);
			$this->load->view('templates/footer');
		} else {
			$largest=max((float)$this->input->post('c_card'),(float)$this->input->post('cheque_amt'),(float)$this->input->post('wallet_amnt'),(float)$this->input->post('cash'),(float)$this->input->post('bank_amt'));
			if((float)$this->input->post('cash')==$largest) {
				if($this->input->post('cash_check')==1){
					$rev_ledger_code=$this->input->post('cash_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cash_ledger_code');
				}
			} else if((float)$this->input->post('bank_amt')==$largest){
				if($this->input->post('bank_check')==1){
					$rev_ledger_code=$this->input->post('bank_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('bank_ledger_code');
				}	
			} else if((float)$this->input->post('c_card')==$largest){
				if($this->input->post('c_card_check')==1){
					$rev_ledger_code=$this->input->post('c_card_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('c_card_ledger_code');
				}	
			}  else if((float)$this->input->post('wallet_amnt')==$largest) {
				if($this->input->post('wallet_check')==1){
					$rev_ledger_code=$this->input->post('wallet_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('wallet_ledger_code');
				}
			} else if((float)$this->input->post('cheque_amt')==$largest) {
				if($this->input->post('cheque_check')==1){
					$rev_ledger_code=$this->input->post('cheque_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cheque_ledger_code');
				}
			}
			$this->db->trans_begin();
			$SQL = "SELECT MAX(general_receipt_no)+1 as `general_receipt_no` FROM general_receipts where 1 ;";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			
			if($data[0]['general_receipt_no'] != NULL and $data[0]['general_receipt_no'] != ""){
				$receipt_no = $data[0]['general_receipt_no'];
			} else{
				$receipt_no = 1;
			}
			$ref_div_id	=	1;
			$general_receipt_date	=	date("Y-m-d h:m:s", strtotime($this->input->post('general_receipt_date')));
			//$receipt_code	=	$this->furniture_quotation_model->get_receipt_code($ref_div_id,$receipt_no);
			$receipt_code = 'GR'.date("y").sprintf("%'.05d", ($receipt_no));
			$receipt['general_receipt_no'] = $receipt_no;
			$receipt['general_receipt_code']   = $receipt_code;
			$receipt['division_id'] = 1;
			$receipt['general_receipt_date'] = $general_receipt_date;
			$receipt['receipt_amount'] = ((float)$this->input->post('i_total'));
			$receipt['cash_amount'] = ((float)$this->input->post('cash'));
			$receipt['bank_amount'] = ((float)$this->input->post('bank_amt'));
			$receipt['bank_name'] = ($this->input->post('bank_name'));
			$receipt['c_card_amount'] = ((float)$this->input->post('c_card'));
			$receipt['c_card_type'] = ($this->input->post('c_type'));
			$receipt['c_card_authorized'] = ($this->input->post('authorized'));
			$receipt['wallet_amount'] = ((float)$this->input->post('wallet_amnt'));
			$receipt['wallet_type'] = ($this->input->post('wallet_type'));
			$receipt['wallet_authorized'] = ($this->input->post('wallet_authorized'));
			$receipt['cheque_amount'] = ((float)$this->input->post('cheque_amt'));
			$receipt['cheque_number'] = ($this->input->post('cheque_no'));
			$receipt['cheque_bank'] = ($this->input->post('cheque_bank'));
			$receipt['general_receipt_status'] = 1;
			$receipt['receipt_remarks'] = $this->input->post("remarks");
			$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
			$rcpt = $this->crud_model->insert('general_receipts',$receipt);
			$receipt_id = $this->db->insert_id();
			if($receipt_id){
				$this->db->where("vch_no",$receipt_code);
				$this->db->where("vch_type",'GENERAL RECEIPT');
				$this->db->delete('accounts');
				$ledger_code = $this->input->post('ledger_code');
				$ledger_amount = $this->input->post('ledger_amount');
				$narrations = $this->input->post('narrations');
				$a=0;
				$nb_rev_ledger_code	='';
				$total_le_amount=0;
				for($i=0; $i<count($ledger_code); $i++){	
					if($ledger_code[$i]!=="" && $ledger_amount[$i]!==""){
						if($a<(float)$ledger_amount[$i]){
							$a=(float)$ledger_amount[$i];
							$nb_rev_ledger_code	= $ledger_code[$i];
						}
						$total_le_amount=$total_le_amount+(float)$ledger_amount[$i];
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => '',
							'ledger_code' => $ledger_code[$i],
							'rev_ledger_code' => $rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> -(float)$ledger_amount[$i],
							'ledger_narration'=> $narrations[$i],
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}		
				}
				$up_accnt_data = array(
					'receipt_amount' => $total_le_amount,
				);
				$this->db->where('g_receipt_id', $receipt_id);
				$this->db->update('general_receipts', $up_accnt_data);

				if($this->input->post('cash')!==''){
					if($this->input->post('cash_check')==1){
						$cash_ledger_code=$this->input->post('cash_ledgers');
					} else {
						$cash_ledger_code=$this->input->post('cash_ledger_code');
					}
					if($cash_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Cash',
							'ledger_code' => $cash_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => ((float)$this->input->post('i_total'))-((float)$this->input->post('bank_amt')+(float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration' => 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}

				if($this->input->post('bank_amt')!=''){
					if($this->input->post('bank_check')==1){
						$bank_ledger_code	=	$this->input->post('bank_ledgers');
					} else {
						$bank_ledger_code	=	$this->input->post('bank_ledger_code');
					}
					if($bank_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Bank Transfer',
							'ledger_code' => $bank_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('bank_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}	
				}

				if($this->input->post('c_card')!=''){
					if($this->input->post('c_card_check')==1){
						$c_card_ledger_code	=	$this->input->post('c_card_ledgers');
					} else {
						$c_card_ledger_code	=	$this->input->post('c_card_ledger_code');
					}
					if($c_card_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Credit Card',
							'ledger_code' => $c_card_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('c_card'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}	
				}
				
				if($this->input->post('cheque_amt')!=''){
					if($this->input->post('cheque_check')==1){
						$cheque_ledger_code	=	$this->input->post('cheque_ledgers');
					} else {
						$cheque_ledger_code	=	$this->input->post('cheque_ledger_code');
					}
					if($cheque_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Cheque',
							'ledger_code' => $cheque_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('cheque_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}
				if($this->input->post('wallet_amnt')!=''){
					if($this->input->post('wallet_check')==1){
						$wallet_ledger_code	=	$this->input->post('wallet_ledgers');
					} else {
						$wallet_ledger_code	=	$this->input->post('wallet_ledger_code');
					}
					if($wallet_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Wallet',
							'ledger_code' => $wallet_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('wallet_amnt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}
				$log_data=array(
					'trans_no'  	=>  $receipt_code,
					'trans_type'  	=>  'GENERAL RECEIPT',
					'trans_op'  	=>  'Create',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
				$account_result =$this->furniture_quotation_model->validate_debit_or_credit($receipt_code,'GENERAL RECEIPT');
				if($account_result===false){
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Debit amount and Credit amount are not equal...');	
					redirect('General_receipt/list_general_receipt');
				}
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
					redirect('General_receipt/list_general_receipt');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'New General Receipt Created...');	
					redirect('General_receipt/list_general_receipt');
				}
			}
		}
	}

	public function do_update_general_receipt($g_receipt_id){
		$this->users_model->permission("General_receipt", "Edit");
		$this->form_validation->set_rules('general_receipt_code','Receipt code', 'required');
		$this->form_validation->set_rules('general_receipt_date','Date', 'required');
		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		if($this->input->post('bank_check')==1){
			$this->form_validation->set_rules('bank_ledgers','Bank Ledger', 'required');
		} else {
			$this->form_validation->set_rules('bank_ledger_code','Bank Ledger', 'required');
		}
		if($this->input->post('cash_check')==1){
			$this->form_validation->set_rules('cash_ledgers','Cash Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cash_ledger_code','Cash Ledger', 'required');
		}
		if($this->input->post('c_card_check')==1){
			$this->form_validation->set_rules('c_card_ledgers','C Card Ledgers', 'required');
		} else {
			$this->form_validation->set_rules('c_card_ledger_code','C Card Ledger', 'required');
		}
		if($this->input->post('wallet_check')==1){
			$this->form_validation->set_rules('wallet_ledgers','Wallet Ledger', 'required');
		} else {
			$this->form_validation->set_rules('wallet_ledger_code','Wallet Ledger', 'required');
		}
		if($this->input->post('cheque_check')==1){
			$this->form_validation->set_rules('cheque_ledgers','Cheque Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cheque_ledger_code','Cheque Ledger', 'required');
		}
		$this->form_validation->set_rules('i_total', 'Amount', 'callback_validate_amount');
		if ($this->form_validation->run() == FALSE) {
			$title['headerTitle']="Edit General Receipt";
			$where=array(
				'g_receipt_id' => $g_receipt_id
			);
			$data['dbdata']=$this->crud_model->get('general_receipts',$where);
			$data['cash_ledgers']= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
			$data['bank_ledgers']= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
			
			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`ledger_amount` <', 0);
			$rs = $this->db->get();
			$data['details']    = $rs->result_array();

			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`vch_ref`','Cash');
			$cash_rs = $this->db->get();
			$data['cash_details']    = $cash_rs->result_array();

			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`vch_ref`','Bank Transfer');
			$bank_rs = $this->db->get();
			$data['bank_details']    = $bank_rs->result_array();

			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`vch_ref`','Credit Card');
			$c_card_rs = $this->db->get();
			$data['c_card_details']    = $c_card_rs->result_array();

			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`vch_ref`','Wallet');
			$wallet_rs = $this->db->get();
			$data['wallet_details']    = $wallet_rs->result_array();

			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['general_receipt_code']);
			$this->db->where('accounts.`vch_ref`','Cheque');
			$cheque_rs = $this->db->get();
			$data['cheque_details']    = $cheque_rs->result_array();

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('manage/edit_general_receipt',$data);
			$this->load->view('templates/footer');
		} else {
			$largest=max((float)$this->input->post('c_card'),(float)$this->input->post('cheque_amt'),(float)$this->input->post('wallet_amnt'),(float)$this->input->post('cash'),(float)$this->input->post('bank_amt'));
			if((float)$this->input->post('cash')==$largest) {
				if($this->input->post('cash_check')==1){
					$rev_ledger_code=$this->input->post('cash_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cash_ledger_code');
				}
			} else if((float)$this->input->post('bank_amt')==$largest){
				if($this->input->post('bank_check')==1){
					$rev_ledger_code=$this->input->post('bank_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('bank_ledger_code');
				}	
			} else if((float)$this->input->post('c_card')==$largest){
				if($this->input->post('c_card_check')==1){
					$rev_ledger_code=$this->input->post('c_card_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('c_card_ledger_code');
				}	
			}  else if((float)$this->input->post('wallet_amnt')==$largest) {
				if($this->input->post('wallet_check')==1){
					$rev_ledger_code=$this->input->post('wallet_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('wallet_ledger_code');
				}
			} else if((float)$this->input->post('cheque_amt')==$largest) {
				if($this->input->post('cheque_check')==1){
					$rev_ledger_code=$this->input->post('cheque_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cheque_ledger_code');
				}
			}
			$this->db->trans_begin();
			
			$ref_div_id	=	1;
			$general_receipt_date	=	date("Y-m-d h:m:s", strtotime($this->input->post('general_receipt_date')));
			$receipt_code = $this->input->post('general_receipt_code');
			$receipt['division_id'] = 1;
			$receipt['general_receipt_date'] = $general_receipt_date;
			$receipt['receipt_amount'] = ((float)$this->input->post('i_total'));
			$receipt['cash_amount'] = ((float)$this->input->post('cash'));
			$receipt['bank_amount'] = ((float)$this->input->post('bank_amt'));
			$receipt['bank_name'] = ($this->input->post('bank_name'));
			$receipt['c_card_amount'] = ((float)$this->input->post('c_card'));
			$receipt['c_card_type'] = ($this->input->post('c_type'));
			$receipt['c_card_authorized'] = ($this->input->post('authorized'));
			$receipt['wallet_amount'] = ((float)$this->input->post('wallet_amnt'));
			$receipt['wallet_type'] = ($this->input->post('wallet_type'));
			$receipt['wallet_authorized'] = ($this->input->post('wallet_authorized'));
			$receipt['cheque_amount'] = ((float)$this->input->post('cheque_amt'));
			$receipt['cheque_number'] = ($this->input->post('cheque_no'));
			$receipt['cheque_bank'] = ($this->input->post('cheque_bank'));
			
			$receipt['general_receipt_status'] = 1;
			$receipt['receipt_remarks'] = $this->input->post("remarks");
			$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
			$rcpt = $this->crud_model->update('general_receipts',$receipt,array("g_receipt_id"=>$g_receipt_id));
			$receipt_id = $g_receipt_id;
			
			if($receipt_id){
				$this->db->where("vch_no",$receipt_code);
				$this->db->where("vch_type",'GENERAL RECEIPT');
				$this->db->delete('accounts');
				$ledger_code = $this->input->post('ledger_code');
				$ledger_amount = $this->input->post('ledger_amount');
				$narrations = $this->input->post('narrations');
				$acc_id = $this->input->post('acc_id');
				$a=0;
				$nb_rev_ledger_code	='';
				$total_le_amount=0;
				for($i=0; $i<count($ledger_code); $i++){	
					if($ledger_code[$i]!=="" && $ledger_amount[$i]!==""){
						if($a<(float)$ledger_amount[$i]){
							$a=(float)$ledger_amount[$i];
							$nb_rev_ledger_code	=	$ledger_code[$i];
						}
						$total_le_amount=$total_le_amount+(float)$ledger_amount[$i];
						if(@$acc_id[$i]!=''){
							$id=$acc_id[$i];
						} else {
							$id=NULL;
						}
						$accounts_data = array(
							'id'		  => $id,
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => '',
							'ledger_code' => $ledger_code[$i],
							'rev_ledger_code' => $rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> -(float)$ledger_amount[$i],
							'ledger_narration'=> $narrations[$i],
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}		
				}

				$up_accnt_data = array(
					'receipt_amount' => $total_le_amount,
				);
				$this->db->where('g_receipt_id', $receipt_id);
				$this->db->update('general_receipts', $up_accnt_data);

				if($this->input->post('cash')!==''){
					if($this->input->post('cash_check')==1){
						$cash_ledger_code=$this->input->post('cash_ledgers');
					} else {
						$cash_ledger_code=$this->input->post('cash_ledger_code');
					}
					if($cash_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Cash',
							'ledger_code' => $cash_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => ((float)$this->input->post('i_total'))-((float)$this->input->post('bank_amt')+(float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration' => 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}

				if($this->input->post('bank_amt')!=''){
					if($this->input->post('bank_check')==1){
						$bank_ledger_code	=	$this->input->post('bank_ledgers');
					} else {
						$bank_ledger_code	=	$this->input->post('bank_ledger_code');
					}
					if($bank_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Bank Transfer',
							'ledger_code' => $bank_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('bank_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}	
				}

				if($this->input->post('c_card')!=''){
					if($this->input->post('c_card_check')==1){
						$c_card_ledger_code	=	$this->input->post('c_card_ledgers');
					} else {
						$c_card_ledger_code	=	$this->input->post('c_card_ledger_code');
					}
					if($c_card_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Credit Card',
							'ledger_code' => $c_card_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('c_card'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}	
				}
				
				if($this->input->post('cheque_amt')!=''){
					if($this->input->post('cheque_check')==1){
						$cheque_ledger_code	=	$this->input->post('cheque_ledgers');
					} else {
						$cheque_ledger_code	=	$this->input->post('cheque_ledger_code');
					}
					if($cheque_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Cheque',
							'ledger_code' => $cheque_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('cheque_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}
				
				if($this->input->post('wallet_amnt')!=''){
					if($this->input->post('wallet_check')==1){
						$wallet_ledger_code	=	$this->input->post('wallet_ledgers');
					} else {
						$wallet_ledger_code	=	$this->input->post('wallet_ledger_code');
					}
					if($wallet_ledger_code!=''){
						$accounts_data = array(
							'vch_type' 	  => 'GENERAL RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $general_receipt_date,
							'vch_ref'     => 'Wallet',
							'ledger_code' => $wallet_ledger_code,
							'rev_ledger_code' => $nb_rev_ledger_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('wallet_amnt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from General Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}

				$log_data=array(
					'trans_no'  	=>  $receipt_code,
					'trans_type'  	=>  'GENERAL RECEIPT',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
				$account_result =$this->furniture_quotation_model->validate_debit_or_credit($receipt_code,'GENERAL RECEIPT');
				if($account_result===false){
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Debit amount and Credit amount are not equal...');	
					redirect('General_receipt/list_general_receipt');
				}
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
					redirect('General_receipt/list_general_receipt');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'General Receipt Updated...');	
					redirect('General_receipt/list_general_receipt');
				}
			}
		}
	}
	
	public function cancel_general_receipt($general_receipt_code,$g_receipt_id){
		$this->users_model->permission("General_receipt", "Delete");
		$this->db->where('g_receipt_id',$g_receipt_id);
		$data = array(
			'general_receipt_status' => 0,
			'receipt_cancelledby' => $this->session->userdata('user_name'),
			'receipt_cancelled_date' => date('Y-m-d h:m:s')
		);
		$receipt_cancel	= $this->db->update('general_receipts', $data);
		
		$this->db->where('vch_no',$general_receipt_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);
		
		$log_data=array(
			'trans_no'  	=>  $general_receipt_code,
			'trans_type'  	=>  'GENERAL RECEIPT',
			'trans_op'  	=>  'Cancel',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		if($receipt_cancel){
			$this->session->set_flashdata('response', 'Receipt Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('General_receipt/list_general_receipt');
	}
	function view1($g_receipt_id,$type){

		//$where= array('receipt_number'=>$payment_no);
		//$data['records'] = $this->furniture_quotation_model->get_payment_details($payment_no,$quotation_id,$quotation_divisionid);
		//$data['receipt_inv'] = $this->furniture_quotation_model->get_all_payments_invdetails($payment_no,$quotation_id,$quotation_divisionid);
		//$data['receipt_pay'] = $this->furniture_quotation_model->get_all_payments_paydetails($payment_no,$quotation_id,$quotation_divisionid);
		//$data['ledgers_from_accounts'] = $this->furniture_quotation_model->get_all_ledgers_from_accounts($data['records'][0]['payment_code']);
		$where=array(
			'g_receipt_id' => $g_receipt_id
		);
		$data['records']=$this->crud_model->get('general_receipts',$where);

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
		$this->db->where('accounts.`vch_type`', 'GENERAL RECEIPT');
		$this->db->where('accounts.`vch_no`', $data['records'][0]['general_receipt_code']);
		//$this->db->where('accounts.`ledger_amount` <', 0);
		$this->db->order_by('accounts.id', 'ASC');
		$rs = $this->db->get();
		$data['details']    = $rs->result_array();

		$data['logos_url'] 		= array();

		$data['general_receipt_code'] 	  = $data['records'][0]['general_receipt_code'];
		$data['receipt_number']   = $data['records'][0]['general_receipt_no'];
		//$data['division_code'] 	  = $data['records'][0]['division_code'];
		//$data['currency_code'] 	  = $data['records'][0]['currency_code'];
		$data['general_receipt_date'] 	  = $data['records'][0]['general_receipt_date'];
		$data['payment_status'] 	  = $data['records'][0]['general_receipt_status'];
		$data['payment_amount'] 	  = $data['records'][0]['receipt_amount'];
		$data['receipt_remarks'] 	  = $data['records'][0]['receipt_remarks'];
		$data['cash_amount'] 	  = $data['records'][0]['cash_amount'];
		$data['bank_amount'] 	  = $data['records'][0]['bank_amount'];
		$data['wallet_amount'] 	  = $data['records'][0]['wallet_amount'];
		$data['wallet_type'] 	  = $data['records'][0]['wallet_type'];
		$data['cheque_amount'] 	  = $data['records'][0]['cheque_amount'];
		$data['cheque_number'] 	  = $data['records'][0]['cheque_number'];
		$data['cheque_bank'] 	  = $data['records'][0]['cheque_bank'];
		$data['c_card_amount'] 	  = $data['records'][0]['c_card_amount'];
		$data['c_card_type'] 	  = $data['records'][0]['c_card_type'];

		$temp = $data['records'][0]['receipt_generatedby'];
		$where= array('user_id'=>$temp);
		$generated_by_user = $this->crud_model->get('users',$where);
		$data["generated_by"] = $generated_by_user[0]['user_name'];
		//$data["received_from"] = $data['records'][0]['supplier_name'];

		$data['quotation_id'] = $g_receipt_id;
		
		$query = $this->db->get('company_details');  
		$data['company_details'] = $query->row();
		foreach ($query->result() as $row){
			$company_email_name =  $row->company_name;
		}

		/* $this->db->select_sum('payment_discount');
		$this->db->from('payment_details');
		$this->db->where('payment_id',$quotation_id);
		$this->db->limit(1);
		$ttt=	$this->db->get();
		$discount = $ttt->result_array();
		$data['payment_discount'] = $discount[0]['payment_discount']; */
		
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$mpdf = new \Mpdf\Mpdf();
			$html = $this->load->view('manage/print_general_receipt', $data, true);
			$mpdf->WriteHTML($html);
			$file_name	=	'General Receipt Voucher - '.$data['records'][0]['general_receipt_code'];
			$mpdf->Output($file_name, 'I');
		}
	}
}

?>