<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_reports extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	
	
	
	public function index($status='') {
	
		if($status == "result" ) {

			$this->form_validation->set_rules('report_date_from', 'Date', 'callback_date_check');
			$this->form_validation->set_rules('report_date_to', 'Date', 'callback_date_check');
			$this->form_validation->set_rules('client_phone_number1', 'Client Telephone 1', 'max_length[15]|numeric');
			
			$error_flag = false;
			$error_msg = '';
			
			$quotation_type = "furniture";
			
			if(!$quotation_type) {
				$error_msg = '<p>Please select a quotation type first.</p>';
				$error_flag = true;
			}
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().$error_msg.'</div>',':old:');
				$data['records'] = false;
			}
			else {

				$data['records']=false;
				if($quotation_type == 'kitchen') {

					$data['quotation_type'] = "kitchen";
					//Kitchen Quotations...
					if(	$this->input->post('quotation_type') == 0 or $this->input->post('user_id') > 0  or $this->input->post('report_date_from')!='1970-01-01' or
						$this->input->post('report_date_to')!='1970-01-01' or $this->input->post('quotation_status') != '0' or
						$this->input->post('report_dae_from')!='' or $this->input->post('report_dae_to')!='' or $this->input->post('project_location')!='' or
						$this->input->post('client_phone_number1')!=''){

						$this->db->select('*');

						if($this->input->post('revisions')=='all') {
							$this->db->from('view_quotations_client_project_users_all');
						}
						else{
							$this->db->from('view_quotations_client_project_users');
						}
						if($this->input->post('project_location')!='') {
							$this->db->where('project_location =', $this->input->post('project_location'));
						}
						if($this->input->post('user_id')> 0) {
							$this->db->where('salesman_id =',$this->input->post('user_id'));
						}
						if($this->input->post('quotation_status') != '0') {
							$this->db->where('quotation_status =',$this->input->post('quotation_status'));
						}
						if($this->input->post('report_date_from')!=''  or $this->input->post('report_date_to')!='' ) {
							$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
							if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
								$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));
								$this->db->where('last_modified_date >=',$date_fmt);
								$this->db->where('last_modified_date <=',$date_to);
							}
							else  if($this->input->post('report_date_from')!='') {
								$this->db->where('last_modified_date >=',$date_fmt);
							}
							else if($this->input->post('report_date_to')!=''){
								$this->session->set_flashdata('response','<div class="alert alert-error">'.'From Date is Mandatory'.'</div>',':old:');
							}
						}
						$records= $this->db->get();
						if($records->num_rows >0) {
							$data['records']=$records->result_array();
						}
						else {
							$data['records']=false;
						}
					}
					else {
						$data['records']=false;
					}
				} else {

					//Furniture Quotations...
					$data['quotation_type'] = "furniture";
					$where = array();

					if($this->input->post('user_id') != 0 ) {
						$where['salesman_id'] = $this->input->post('user_id');
					}
					if($this->input->post('quotation_status')) {
						$where['quotation_status'] = $this->input->post('quotation_status');
					}
					if($this->input->post('division') and $this->input->post('division')!="select" ) {
						$where['quotation_divisionid'] = $this->input->post('division');
						$div_total_flag = 1;
					}
					if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

						$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
						$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to').' + 1 day'));



						if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and 
                                                   (($this->input->post('quotation_status')) == 'Confirmed' )) {
							$where['quotation_confirmationdate >='] = $date_fmt;
							$where['quotation_confirmationdate <='] = $date_to;
						}
                                                elseif($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
							$where['last_modified_date >='] = $date_fmt;
							$where['last_modified_date <='] = $date_to;
						}
						else if($this->input->post('report_date_from') != '') {
							$where['last_modified_date >='] = $date_fmt;
						}
						else if($this->input->post('report_date_to')!=''){
							$where['last_modified_date <='] = $date_to;
						}

					}

					$data['records']=$this->crud_model->get('view_furniture_quotations_client_project_users', $where);
					$data['submitted_division_id'] = $this->input->post('division');
					if(isset($div_total_flag) and $data['records']) {
						$furniture_division_total = 0;
						foreach($data['records'] as $record) {
							if($record["quotation_amount_with_vat"]!=''){
								$furniture_division_total += ($record["quotation_amount_with_vat"]-$record["quotation_discount"]);
							} else {
								if($record['quotation_date']>'2019-07-01'){
									$furniture_division_total += (($record['quotation_total']-$record['quotation_discount'])*0.05)+($record['quotation_total']-$record['quotation_discount']);
								} else {
								$furniture_division_total += ($record["quotation_total"]-$record["quotation_discount"]);
								}
							}
						}
						$data["furniture_division_total"] = $furniture_division_total;
					}
					
					
				}	
								
				
				
			}
		} else {
			
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
			
		}// End of if($status == "result" )				
				
		$data['quotation_type_list'] = array('furniture' => 'Furniture Quotations');
		
		
		$records = $this->crud_model->get('users');
		if($records!=false){


			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
			$data['division_list'] = $division_list;



			$list = array(0 => ' - Select - ');
			foreach($records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');
			
			$data=html_escape($data);
			
			$this->load->view('templates/header');
			$this->load->view('reports/view_reports',$data);
			$this->load->view('templates/footer');
		}
		
		
	}
	
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		/* echo date('Y-m-d',$given_date);
		 echo date('Y-m-d',$today_date);
		exit ; */
		if($given_date <= $today_date){
			//true
			return true;
		}
		else{
			//false
			$this->form_validation->set_message('date_check', 'Date cannot be future date');
			return FALSE;
		}

	}
	
	
	
	
}

?>