<?php
class User_groups extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$this->users_model->permission("User_group", "View");
		$title['headerTitle']="User Group List";
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('admin/user_groups/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('user_groups',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('user_groups',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		

		$this->load->view('templates/header',$title);
		$this->load->view('admin/user_groups/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->users_model->permission("User_group", "Add");
		$title['headerTitle']="User Group Create";
		$this->load->view('templates/header',$title);
		$this->load->view('admin/user_groups/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$this->users_model->permission("User_group", "Edit");
		$title['headerTitle']="User Group Edit";
		$where=array(
				'user_group_id' => $id
		);
		$records=$this->crud_model->get('user_groups',$where);
		if($records != false){
			//true section
			$data['user_group_name']			 = $records[0]['user_group_name'];
			$data['user_group_id']			 = $records[0]['user_group_id'];
			$data['discount_limit']			 = $records[0]['discount_limit'];
			$this->load->view('templates/header',$title);
			$this->load->view('admin/user_groups/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','Error');
			redirect('admin/user_groups');
		}

	}
	function do_insert()
	{
		$this->users_model->permission("User_group", "Add");
		$title['headerTitle']="User Group Create";
		$this->form_validation->set_rules('user_group_name', 'User Group Name', 'required|max_length[50]');
		$this->form_validation->set_rules('discount_limit', 'Discount Limit', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('admin/user_groups/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$user_group_name=$this->input->post('user_group_name');
			$discount_limit=$this->input->post('discount_limit');

			$data=array(
			         'user_group_name'  => $user_group_name,
					 'discount_limit'   => $discount_limit

			);

			$rr=$this->crud_model->insert('user_groups',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'User Groups',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','Group cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('admin/user_groups/create');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('success','User Group added successfully');
				redirect('admin/user_groups');

			}
		}

	}

	function do_update()
	{
		$this->users_model->permission("User_group", "Edit");
		$title['headerTitle']="User Group Edit";
		$this->form_validation->set_rules('user_group_name', 'User Groups Name', 'required|max_length[50]');
		$this->form_validation->set_rules('discount_limit', 'Discount Limit', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$records=$this->crud_model->get('user_groups');
			if($records != false){
				//true section
				$data['user_group_name']			 = $records[0]['user_group_name'];
				$data['user_group_id']			 = $records[0]['user_group_id'];
				$data['discount_limit']			 = $records[0]['discount_limit'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('admin/user_groups/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','error');
				redirect('admin/user_groups');
			}




		}
		else
		{// true section

			$user_group_name= $this->input->post('user_group_name');
			$user_group_id=  $this->input->post('user_group_id');
			$discount_limit=  $this->input->post('discount_limit');

			$where=array(
					'user_group_id'=> $user_group_id
			);
			$data=array(
					'user_group_name'  =>  $user_group_name,
					'discount_limit'   =>  $discount_limit

			);


			$records=$this->crud_model->update('user_groups',$data,$where);
 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'User Groups',	
				'masters_id'=>$user_group_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','User Group updated');
			redirect('admin/user_groups');

		}

	}
	function do_delete($id=0)
	{
		$this->users_model->permission("User_group", "Delete");
		$where=array(
				'user_group_id'=> $id
		);

		$this->crud_model->delete('user_groups',$where);
	    	$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'User Groups',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','User Group deleted');
		redirect('admin/user_groups');
	}
}