<?php

class Estimation extends CI_Controller {

	private $mode='new',$furniture_id=0;

	public function __construct() {
		parent::__construct();
		
		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		
	}
		
	function index($furniture_quotation_id,$page=1,$details_id=0)	{
		$title['headerTitle']="Estimation";

		$data['general_quotation'] = 0;
		$quotation_details =  $this->furniture_quotation_model->get_full_quotation_details($furniture_quotation_id,'unique');
		$quotation_id=$furniture_quotation_id;


		$data['quotation_total'] = $quotation_details['quotation_total'];
		$data['quotation_discount_amount'] = $quotation_details['quotation_discount_amount'];
		$data['quotation_net_total'] = round($quotation_details['quotation_net_total'],3);	
		$data['quotation_vat_percentage'] = $quotation_details['quotation_vat_percentage'];	
		$data['quotation_vat_amount'] = $quotation_details['quotation_vat_amount'];		
		$data['quotation_amount_with_vat'] = $quotation_details['quotation_amount_with_vat'];	
		$data['quotation_discount'] = $quotation_details['quotation_discount'];	
		$data['common_comments'] = $quotation_details['common_comments'];
		$data['contact_id'] = $quotation_details['contact_id'];
		$data['project_name'] = $quotation_details['project_name'];
		$data['tax_perce'] = $quotation_details['tax_perce'];
		$data['quotation_number'] = $quotation_details['quotation_number'];
		$data['division_id'] = $quotation_details['division_id'];
		$data['quotation_id'] = $furniture_quotation_id;
														
		$data['records'] 		= $this->crud_model->get('furniture_items', array('furniture_items.quotation_id'=>$quotation_id), null, null, "ex_furniture_area", "ASC", null, null, null, "ex_furniture_area");
		
		$data = html_escape($data);

		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/estimation/estimation_view',$data);
		$this->load->view('templates/footer');
	}	

	public function do_clear($quotation_id,$furniture_id){
		
		$this->db->trans_begin();
		
		$where=array(
			'furniture_id'=> $furniture_id
		);

		$this->crud_model->delete('estimation',$where);
		$this->crud_model->delete('estimation_material',$where);
		$this->crud_model->delete('estimation_labourcost',$where);
		$this->crud_model->delete('estimation_subcontract',$where);
		$this->crud_model->delete('estimation_hiring',$where);
		$this->crud_model->delete('estimation_others',$where);

		$data2=array(
			'furniture_unitprice'   =>  0,
			'vat_amount'   			=>  0,
			'net_amount'   			=>  0,
			'item_discount'   		=>  0,
			'total_discount'   		=>  0,
			'estimate_yes_or_no'	=> 'No',
			'total_cost_including_overhead'=>0
		);
		$this->db->where('furniture_id', $furniture_id);
		$this->db->update('furniture_items', $data2);

		$this->furniture_quotation_model->update_quotation_total($quotation_id);

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect("furniture/Estimation/index/".$quotation_id);
		} else {
			$this->db->trans_commit();
			$this->session->set_flashdata('success', 'BOM cleared Successfully');
			redirect('furniture/Estimation/index/'.$quotation_id);
		}

	}

	public function copyJobEstimation($quotation_id=NULL,$furniture_id=NULL){
		$selected_furniture_id = $this->input->post('furniture_id');
		$quotation_number = $this->input->post('quotation_number');
		$division_id = $this->input->post('division_id');
		if ($quotation_id!='' && $furniture_id!='' && $selected_furniture_id!=''){
			$this->db->trans_begin();
			
			$datarow=$this->furniture_quotation_model->itemWiseDatarow($furniture_id);
			$estimation 				=  $this->furniture_quotation_model->estimation($selected_furniture_id);
			$estimationMaterialsAdded 	=  $this->furniture_quotation_model->estimationMaterialsAdded($selected_furniture_id);
			$estimationLabourCostAdded 	=  $this->furniture_quotation_model->estimationLabourCostAdded($selected_furniture_id);
			$estimationSubContractAdded =  $this->furniture_quotation_model->estimationSubContractAdded($selected_furniture_id);
			$estimationHiringAdded 		=  $this->furniture_quotation_model->estimationHiringAdded($selected_furniture_id);
			$estimationOthersAdded 		=  $this->furniture_quotation_model->estimationOthersAdded($selected_furniture_id);

			$where=array(
				'furniture_id'=> $furniture_id
			);

			$this->crud_model->delete('estimation',$where);
			$this->crud_model->delete('estimation_material',$where);
			$this->crud_model->delete('estimation_labourcost',$where);
			$this->crud_model->delete('estimation_subcontract',$where);
			$this->crud_model->delete('estimation_hiring',$where);
			$this->crud_model->delete('estimation_others',$where);

			$boq_no =  $this->furniture_quotation_model->get_boq_no($furniture_id,$division_id,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			if($estimation!=false){
				$summary_data=array(
					'boq_no'   			=>  $boq_no,
					'furniture_id' 		=>  $furniture_id,
					'material'  		=>  $estimation['material'],
					'labourCost'   		=>  $estimation['labourCost'],
					'subcontract'   	=>  $estimation['subcontract'],
					'hiring'   			=>  $estimation['hiring'],
					'others'  			=>  $estimation['others'],
					'materialperce'  	=>  $estimation['materialperce'],
					'labourCostperce'   =>  $estimation['labourCostperce'],
					'subcontractperce'  =>  $estimation['subcontractperce'],
					'hiringperce'   	=>  $estimation['hiringperce'],
					'othersperce'  		=>  $estimation['othersperce'],
					'profitperce'  		=>  $estimation['profitperce'],
					'selling_price'  	=>  $estimation['selling_price'],
					'user_id'  			=>  $user_id
				);
				$this->db->insert('estimation', $summary_data);
			}
			
			foreach($estimationMaterialsAdded as $row){
				$material_data=array(
					'boq_no'   			=>  $boq_no,
					'furniture_id' 		=>  $furniture_id,
					'item_id'  			=>  $row['item_id'],
					'item_name'   		=>  $row['item_name'],
					'item_description'  =>  $row['item_description'],
					'material_qty'   	=>  $row['material_qty'],
					'material_uom'  	=>  $row['material_uom'],
					'material_unitprice'=>  $row['material_unitprice'],
					'material_total'   	=>  $row['material_total'],
					'user_id'  			=>  $user_id
				);
				$this->db->insert('estimation_material', $material_data);
			}

			foreach($estimationLabourCostAdded as $row2){
				$labour_data=array(
					'boq_no'   				=>  $boq_no,
					'furniture_id' 			=>  $furniture_id,
					'labour_department'  	=>  $row2['labour_department'],
					'labour_no_of_ppl'   	=>  $row2['labour_no_of_ppl'],
					'labour_hours'  		=>  $row2['labour_hours'],
					'labour_total_man_hours'=>  $row2['labour_total_man_hours'],
					'labour_rate'  			=>  $row2['labour_rate'],
					'labour_total_amount'	=>  $row2['labour_total_amount'],
					'user_id'  				=>  $user_id
				);
				$this->db->insert('estimation_labourcost', $labour_data);
			}

			foreach($estimationSubContractAdded as $row3){
				$subcontract_data=array(
					'boq_no'   				=>  $boq_no,
					'furniture_id' 			=>  $furniture_id,
					'subcontract_vendor'  	=>  $row3['subcontract_vendor'],
					'subcontract_work_type' =>  $row3['subcontract_work_type'],
					'subcontract_amount'  	=>  $row3['subcontract_amount'],
					'user_id'  				=>  $user_id
				);
				$this->db->insert('estimation_subcontract', $subcontract_data);
			}

			foreach($estimationHiringAdded as $row4){
				$hiring_data=array(
					'boq_no'   			=>  $boq_no,
					'furniture_id' 		=>  $furniture_id,
					'hiring_vendor'  	=>  $row4['hiring_vendor'],
					'hiring_work_type' 	=>  $row4['hiring_work_type'],
					'hiring_amount'  	=>  $row4['hiring_amount'],
					'user_id'  			=>  $user_id
				);
				$this->db->insert('estimation_hiring', $hiring_data);
			}

			foreach($estimationOthersAdded as $row5){
				$others_data=array(
					'boq_no'   			=>  $boq_no,
					'furniture_id' 		=>  $furniture_id,
					'others_vendor'  	=>  $row5['others_vendor'],
					'others_work_type' 	=>  $row5['others_work_type'],
					'others_amount'  	=>  $row5['others_amount'],
					'user_id'  			=>  $user_id
				);
				$this->db->insert('estimation_others', $others_data);
			}

			$a=$estimation['material']+($estimation['material']*($estimation['materialperce']/100));
			$b=$estimation['labourCost']+($estimation['labourCost']*($estimation['labourCostperce']/100));
			$c=$estimation['subcontract']+($estimation['subcontract']*($estimation['subcontractperce']/100));
			$d=$estimation['hiring']+($estimation['hiring']*($estimation['hiringperce']/100));
			$e=$estimation['others']+($estimation['others']*($estimation['othersperce']/100));

			$data2=array(
				'furniture_unitprice'   =>  $estimation['selling_price'],
				'vat_amount'   			=>  $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100),
				'net_amount'   			=>  ($estimation['selling_price']* $datarow['furniture_quantity'])+( $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100)),
				'item_discount'   		=>  0,
				'total_discount'   		=>  0,
				'estimate_yes_or_no'	=> 'Yes',
				'total_cost_including_overhead'	=> $a+$b+$c+$d+$e
			);
			$this->db->where('furniture_id', $furniture_id);
			$this->db->update('furniture_items', $data2);

			$this->furniture_quotation_model->update_quotation_total($quotation_id);
			
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Something went wrong Please try agian later.');
				redirect("furniture/Estimation/index/".$quotation_id);
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'BOM updated Successfully');
				redirect('furniture/Estimation/index/'.$quotation_id);
		 	}


		} else {
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect('furniture/Estimation/index/'.$quotation_id);
		}
	}

	public function jobEstimation($quotation_id,$furniture_id){
		//$this->hooks->call_hook('test');
		$title['headerTitle']="Estimation - Job Estimation";
		
		$estimation 				=  $this->furniture_quotation_model->estimation($furniture_id);
		$estimationMaterialsAdded 	=  $this->furniture_quotation_model->estimationMaterialsAdded($furniture_id);
		$estimationLabourCostAdded 	=  $this->furniture_quotation_model->estimationLabourCostAdded($furniture_id);
		$estimationSubContractAdded =  $this->furniture_quotation_model->estimationSubContractAdded($furniture_id);
		$estimationHiringAdded 		=  $this->furniture_quotation_model->estimationHiringAdded($furniture_id);
		$estimationOthersAdded 		=  $this->furniture_quotation_model->estimationOthersAdded($furniture_id);

		$quotation_details =  $this->furniture_quotation_model->itemWiseDatarow($furniture_id);
		
		$data['records']=$quotation_details;
		
		$data['boq_no'] =  $this->furniture_quotation_model->get_boq_no($furniture_id,$quotation_details['quotation_divisionid'],$quotation_details['quotation_number']);
		
		$data['estimation'] 				=$estimation;
		$data['estimationMaterialsAdded'] 	=$estimationMaterialsAdded;
		$data['estimationLabourCostAdded'] 	=$estimationLabourCostAdded;
		$data['estimationSubContractAdded'] =$estimationSubContractAdded;
		$data['estimationHiringAdded'] 		=$estimationHiringAdded;
		$data['estimationOthersAdded'] 		=$estimationOthersAdded;
		

		$data['quotation_id']=$quotation_id;
		$data['quotation_number']=$quotation_details['quotation_number'];
		$data['furniture_id']=$furniture_id;
		$data['divisionid']=$quotation_details['quotation_divisionid'];

		$unit_list = $this->crud_model->get_list2('unit_name','unit_name','unit_master',array(''=>' - Select Unit- '),array('status'=>'1'),'unit_name','asc');
		$data['unit_list'] = $unit_list;

		$department_list = $this->crud_model->get_list2('department_name','department_name','department_master',array(''=>' - Select Department- '),array('status'=>'1'),'department_name','asc');
		$data['department_list'] = $department_list;

		$emp_cat_data = $this->db->query("SELECT * FROM `emp_category` where `status`='1' order by emp_category_name asc");
		//$emp_category_list = $this->crud_model->get_list2('emp_category_name','emp_category_name','emp_category',array(''=>' - Select Emp Category- '),array('status'=>'1'),'emp_category_name','asc');
		$data['emp_category_list'] = $emp_cat_data->result();

		$supplier_list = $this->crud_model->get_list2('supplier_name','supplier_name','supplier_master',array(''=>' - Select Vendor- '),array('status'=>'1'),'supplier_name','asc');
		$data['supplier_list'] = $supplier_list;

		$data['overhead'] 		=  $this->furniture_quotation_model->overhead();

		/*$this->db->query("SET SQL_BIG_SELECTS=1"); 
		$this->db->select('*' );
		$this->db->from('items');
		$this->db->join('view_get_purchase_cost','items.id = view_get_purchase_cost.item_id','left');
		$this->db->where('items.item_type', 1);
		
		$this->db->limit(8000);
		$this->db->order_by("items.item_name","desc");
		$rs = $this->db->get();
		$n=1;
		if($rs->num_rows() > 0){	
			$html='<tr  class="no_result_button"><th><b>Item Name</b></th><th><b>Cost</b></th><th><b>Stock</b></th></tr>';
			foreach ($rs->result_array() as $row){
				$item_id=$row['id'];
				if($row['item_rate']!=NULL){
					$cost_price	=	$row['item_rate'];
				} else {
					$cost_price	=	$row['cost_price'];
				}
				if($row['balance_qty']==='' OR $row['balance_qty']===NULL){
					$balance_qty	=	'0.000';
				} else {
					$balance_qty	=	$row['balance_qty'];
				}
				$html.='<tr><td value="' .$row['id'].'" class="item_button" tabindex="'.$n++.'" style="width:500px;" ><input type="hidden" class="item_name" value="'.$row['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($row['description']).'" /><input type="hidden" class="item_unit" value="'.$row['unit'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$row['item_name'].'</td><td style="width:50px;text-align:right;">'.$cost_price.'</td><td style="width:50px;text-align:right;">'.$balance_qty.'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" > No Results Found </td>';
		}

		$data['item_data']=$html;*/

		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/estimation/jobEstimation',$data);
		$this->load->view('templates/footer');
	}

	public function summaryUpdate($quotation_id=NULL,$furniture_id=NULL,$divisionid=NULL,$quotation_number=NULL,$comment_flag=NULL){
		if ($quotation_id!='' && $furniture_id!='' && $divisionid!='' && $quotation_number!=''){
			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);
			$user_id	=	$this->session->userdata('user_id');
			$data=array(
				'boq_no'   			=>  $boq_no,
				'furniture_id' 		=>  $furniture_id,
				'material'  		=>  $this->input->post('materialOH'),
				'labourCost'   		=>  $this->input->post('labourCostOH'),
				'subcontract'   	=>  $this->input->post('subcontractOH'),
				'hiring'   			=>  $this->input->post('hiringOH'),
				'others'  			=>  $this->input->post('othersOH'),
				'materialperce'  	=>  $this->input->post('materialOHperce'),
				'labourCostperce'   =>  $this->input->post('labourCostOHperce'),
				'subcontractperce'  =>  $this->input->post('subcontractOHperce'),
				'hiringperce'   	=>  $this->input->post('hiringOHperce'),
				'othersperce'  		=>  $this->input->post('othersOHperce'),
				'profitperce'  		=>  $this->input->post('profitperce'),
				'selling_price'  	=>  $this->input->post('sellingPriceManual'),
				'user_id'  			=>  $user_id
			);
			
			if ($this->input->post('estimation_id')!=NULL) {
				$this->db->where('id', $this->input->post('estimation_id'));
				$this->db->update('estimation', $data);
			} else {
				$this->db->insert('estimation', $data);
			}

			$a=$this->input->post('materialOH')+($this->input->post('materialOH')*($this->input->post('materialOHperce')/100));
			$b=$this->input->post('labourCostOH')+($this->input->post('labourCostOH')*($this->input->post('labourCostOHperce')/100));
			$c=$this->input->post('subcontractOH')+($this->input->post('subcontractOH')*($this->input->post('subcontractOHperce')/100));
			$d=$this->input->post('hiringOH')+($this->input->post('hiringOH')*($this->input->post('hiringOHperce')/100));
			$e=$this->input->post('othersOH')+($this->input->post('othersOH')*($this->input->post('othersOHperce')/100));

			if($comment_flag==='Yes') {
				$comment_flag='Done';
			}
			$newly_added_item=0;
			if($this->input->post('quotation_revisionnumber')!='0') {
				$newly_added_item=1;
			}

			$data2=array(
				'furniture_unitprice' => $this->input->post('sellingPriceManual'),
				'vat_amount'   		  => $this->input->post('furniture_quantity')*$this->input->post('sellingPriceManual')*($this->input->post('vat_perce')/100),
				'net_amount'   		  => ($this->input->post('sellingPriceManual')* $this->input->post('furniture_quantity'))+( $this->input->post('furniture_quantity')*$this->input->post('sellingPriceManual')*($this->input->post('vat_perce')/100)),
				'item_discount'   	  => 0,
				'total_discount'   	  => 0,
				'comment_flag'   	  => $comment_flag,
				'estimate_yes_or_no'  => 'Yes',
				'newly_added_item'	  => $newly_added_item,
				'total_cost_including_overhead'   =>  $a+$b+$c+$d+$e,
			);
			$this->db->where('furniture_id', $furniture_id);
			$this->db->update('furniture_items', $data2);

			$this->furniture_quotation_model->update_quotation_total($quotation_id);
			$quotation_type =	$this->input->post("quotation_type");
			if($quotation_type==1){
				$this->session->set_flashdata('success','Updated.');
				redirect('furniture/Estimation/index/'.$quotation_id);
			} else if($quotation_type==2){
				redirect("furniture/furnitures/index/".$quotation_id);
			} else {
				redirect("furniture/Estimation/index/".$quotation_id);
			}
		} else{
			$this->session->set_flashdata('response','Something went wrong Please try agian later.');
			redirect('furniture/Estimation/index/'.$quotation_id);
		}
	}


	public function matDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `estimation_material` WHERE `id`='$id' ");
		$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
		$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
	}
	public function labDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `estimation_labourcost` WHERE `id`='$id' ");
		$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
		$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
	}
	public function subDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `estimation_subcontract` WHERE `id`='$id' ");
		$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
		$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
	}

	public function hirDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `estimation_hiring` WHERE `id`='$id' ");
		$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
		$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
	}

	public function othDelete($id,$furniture_id){
		$records= $this->db->query("DELETE FROM `estimation_others` WHERE `id`='$id' ");
		$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
		$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
	}


	public function esupdate($furniture_id){
		$data2=array(
			'material'  		=>  NULL,
			'labourCost'   		=>  NULL,
			'subcontract'   	=>  NULL,
			'hiring'   			=>  NULL,
			'others'  			=>  NULL,
			'materialperce'  	=>  NULL,
			'labourCostperce'   =>  NULL,
			'subcontractperce'  =>  NULL,
			'hiringperce'   	=>  NULL,
			'othersperce'  		=>  NULL,
			'profitperce'  		=>  NULL,
			'selling_price'  	=>  NULL,
			'user_id'  			=>  $user_id
		);
		$this->db->where('furniture_id', $furniture_id);
		$this->db->update('estimation', $data2);
		
		$data3=array(
			'furniture_unitprice'   =>  NULL,
			'estimate_yes_or_no'	=> 'No',
			'total_cost_including_overhead'	=> 0
		);
		$this->db->where('furniture_id', $furniture_id);
		$this->db->update('furniture_items', $data3);
		return true;
	}

	public function materialAdd(){
		
		//$this->hooks->call_hook('check_permission');

		if ($this->input->post('item_id')!='' && $this->input->post('item_name')!='' && $this->input->post('uom')!='' && $this->input->post('material_qty')!='' && $this->input->post('material_unitprice')!=''  && $this->input->post('material_total')!='' && $this->input->post('item_id')!='undefined' && $this->input->post('item_name')!='undefined'  && $this->input->post('uom')!='undefined' && $this->input->post('material_qty')!='undefined'  && $this->input->post('material_unitprice')!='undefined' && $this->input->post('material_total')!='undefined'  && $this->input->post('item_id')!='undefined' && $this->input->post('item_name')!='undefined'){
				
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$item_id	=	$this->input->post('item_id');
			$item_name	=	addslashes($this->input->post('item_name'));
			$uom		=	$this->input->post('uom');
			$item_description		=	addslashes($this->input->post('item_description'));
			$material_qty	=	$this->input->post('material_qty');
			$material_unitprice		=	$this->input->post('material_unitprice');
			$material_total	=	$this->input->post('material_total');
			$material_id	=	$this->input->post('material_id');
			$Creation_date=date("Y-m-d");
			if($material_id==='NO'){
				$query = $this->db->query("INSERT INTO `estimation_material`(`boq_no`,`furniture_id`,`item_id`, `item_name`, `item_description`, `material_qty`, `material_unitprice`, `material_total`, `material_uom`, `user_id`) VALUES ('$boq_no','$furniture_id','$item_id','$item_name','$item_description','$material_qty','$material_unitprice','$material_total','$uom','$user_id') ");
				$c_id	=	$this->db->insert_id();
			} else {
				$query = $this->db->query("UPDATE `estimation_material` SET `item_id`='$item_id',`item_name`='$item_name',`item_description`='$item_description',`material_qty`='$material_qty',`material_uom`='$uom',`material_unitprice`='$material_unitprice',`material_total`='$material_total',`user_id`='$user_id' WHERE id='$material_id'");
				$c_id	=	$material_id;
			}
			if ($query){
				$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function labourAdd(){
		
		

		if ($this->input->post('labour_department')!='' && $this->input->post('labour_no_of_ppl')!='' && $this->input->post('labour_hours')!='' && $this->input->post('labour_rate')!='' && $this->input->post('labour_department')!='undefined' && $this->input->post('labour_emp_category')!='undefined' && $this->input->post('labour_no_of_ppl')!='undefined'  && $this->input->post('labour_hours')!='undefined' && $this->input->post('labour_rate')!='undefined'  ){
				
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id				=	$this->session->userdata('user_id');
			$labour_department		=	$this->input->post('labour_department');
			$labour_emp_category	=	$this->input->post('labour_emp_category');
			$labour_no_of_ppl		=	$this->input->post('labour_no_of_ppl');
			$labour_hours			=	$this->input->post('labour_hours');
			$labour_total_man_hours	=	round($labour_no_of_ppl*$labour_hours,3);
			$labour_rate			=	$this->input->post('labour_rate');
			$labour_total_amount	=	round(($labour_no_of_ppl*$labour_hours*$labour_rate),3);
			$labour_id				=	$this->input->post('labour_id');
			$Creation_date			=	date("Y-m-d");
			if($labour_id==='NO'){
				$query = $this->db->query("INSERT INTO `estimation_labourcost`(`boq_no`,`furniture_id`,`labour_department`,`labour_emp_category`, `labour_no_of_ppl`, `labour_hours`, `labour_total_man_hours`, `labour_rate`, `labour_total_amount`, `user_id`) VALUES ('$boq_no','$furniture_id','$labour_department','$labour_emp_category','$labour_no_of_ppl','$labour_hours','$labour_total_man_hours','$labour_rate','$labour_total_amount','$user_id') ");
				$c_id	=	$this->db->insert_id();
			} else {
				$query = $this->db->query("UPDATE `estimation_labourcost` SET `labour_department`='$labour_department',`labour_emp_category`='$labour_emp_category',`labour_no_of_ppl`='$labour_no_of_ppl',`labour_hours`='$labour_hours',`labour_total_man_hours`='$labour_total_man_hours',`labour_rate`='$labour_rate',`labour_total_amount`='$labour_total_amount',`user_id`='$user_id' WHERE id='$labour_id'");
				$c_id	=	$labour_id;
			}
			
			
			if ($query){
				$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function subcontractAdd(){
		
		

		if ($this->input->post('subcontract_vendor')!='' && $this->input->post('subcontract_work_type')!='' && $this->input->post('subcontract_amount')!='' && $this->input->post('subcontract_vendor')!='undefined' && $this->input->post('subcontract_work_type')!='undefined'  && $this->input->post('subcontract_amount')!='undefined'){
				
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$subcontract_vendor	=	$this->input->post('subcontract_vendor');
			$subcontract_work_type	=	$this->input->post('subcontract_work_type');
			$subcontract_amount		=	$this->input->post('subcontract_amount');
			$subcontract_id	=	$this->input->post('subcontract_id');
			$Creation_date=date("Y-m-d");
			if($subcontract_id==='NO'){
				$query = $this->db->query("INSERT INTO `estimation_subcontract`(`boq_no`,`furniture_id`,`subcontract_vendor`, `subcontract_work_type`, `subcontract_amount`, `user_id`) VALUES ('$boq_no','$furniture_id','$subcontract_vendor','$subcontract_work_type','$subcontract_amount','$user_id') ");
				$c_id	=	$this->db->insert_id();
			} else {
				$query = $this->db->query("UPDATE `estimation_subcontract` SET `subcontract_vendor`='$subcontract_vendor',`subcontract_work_type`='$subcontract_work_type',`subcontract_amount`='$subcontract_amount',`user_id`='$user_id' WHERE id='$subcontract_id'");
				$c_id	=	$subcontract_id;
			}
			
			
			if ($query){
				$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function hiringAdd(){
		
		

		if ($this->input->post('hiring_vendor')!='' && $this->input->post('hiring_work_type')!='' && $this->input->post('hiring_amount')!='' && $this->input->post('hiring_vendor')!='undefined' && $this->input->post('hiring_work_type')!='undefined'  && $this->input->post('hiring_amount')!='undefined'){
				
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$hiring_vendor	=	$this->input->post('hiring_vendor');
			$hiring_work_type	=	$this->input->post('hiring_work_type');
			$hiring_amount		=	$this->input->post('hiring_amount');
			$hiring_id	=	$this->input->post('hiring_id');
			$Creation_date=date("Y-m-d");
			if($hiring_id==='NO'){
				$query = $this->db->query("INSERT INTO `estimation_hiring`(`boq_no`,`furniture_id`,`hiring_vendor`, `hiring_work_type`, `hiring_amount`, `user_id`) VALUES ('$boq_no','$furniture_id','$hiring_vendor','$hiring_work_type','$hiring_amount','$user_id') ");
				$c_id	=	$this->db->insert_id();
			} else {
				$query = $this->db->query("UPDATE `estimation_hiring` SET `hiring_vendor`='$hiring_vendor',`hiring_work_type`='$hiring_work_type',`hiring_amount`='$hiring_amount',`user_id`='$user_id' WHERE id='$hiring_id'");
				$c_id	=	$hiring_id;
			}
			
			
			if ($query){
				$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}

	public function othersAdd(){
		
		

		if ($this->input->post('others_work_type')!='' && $this->input->post('others_amount')!='' && $this->input->post('others_vendor')!='undefined' && $this->input->post('others_work_type')!='undefined'  && $this->input->post('others_amount')!='undefined'){
				
			$quotation_id			=	$this->input->post('quotation_id');
			$furniture_id			=	$this->input->post('furniture_id');
			$divisionid				=	$this->input->post('divisionid');
			$quotation_number		=	$this->input->post('quotation_number');

			$boq_no=$this->furniture_quotation_model->get_boq_no($furniture_id,$divisionid,$quotation_number);

			$user_id	=	$this->session->userdata('user_id');
			$others_vendor	=	$this->input->post('others_vendor');
			$others_work_type	=	$this->input->post('others_work_type');
			$others_amount		=	$this->input->post('others_amount');
			$others_id	=	$this->input->post('others_id');
			$Creation_date=date("Y-m-d");
			if($others_id==='NO'){
				$query = $this->db->query("INSERT INTO `estimation_others`(`boq_no`,`furniture_id`,`others_vendor`, `others_work_type`, `others_amount`, `user_id`) VALUES ('$boq_no','$furniture_id','$others_vendor','$others_work_type','$others_amount','$user_id') ");
				$c_id	=	$this->db->insert_id();
			} else {
				$query = $this->db->query("UPDATE `estimation_others` SET `others_vendor`='$others_vendor',`others_work_type`='$others_work_type',`others_amount`='$others_amount',`user_id`='$user_id' WHERE id='$others_id'");
				$c_id	=	$others_id;
			}
			
			
			if ($query){
				$query3 = $this->db->query("UPDATE `estimation` SET `material`=NULL,`labourCost`=NULL,`subcontract`=NULL,`hiring`=NULL,`others`=NULL,`materialperce`=NULL,`labourCostperce`=NULL,`subcontractperce`=NULL,`hiringperce`=NULL,`othersperce`=NULL,`profitperce`=NULL,`selling_price`=NULL,`user_id`='$user_id' WHERE furniture_id='$furniture_id'");
				$query4 = $this->db->query("UPDATE `furniture_items` SET `furniture_unitprice`=NULL,`estimate_yes_or_no`='No',`total_cost_including_overhead`=0,`vat_amount`=NULL,`net_amount`=NULL,`item_discount`=NULL,`total_discount`=NULL WHERE furniture_id='$furniture_id'");
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			} else {
				$c_id	=	0;
				$data   =   json_encode(array('1',$c_id));
				echo $data;
			}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('1',$c_id));
			echo $data;
		}
	}


	public function search_item() {
		$item			= $this->input->post('item');
		$search_type	= $this->input->post('search_type');
		$stock_group_id	= @$this->input->post('stock_group_id');
		$brand_id		= @$this->input->post('brand_id');
		$today			= date("Y-m-d");
		$html			= '';

		if($search_type==='anywhere'){
			$sql="";
			$items = explode(" ", trim($item));
			for($i=0;$i<count($items);$i++) {
				$r	= $items[$i];
				$sql.=" and item_name LIKE '%$r%' ";
			}
			$sql2="";
			if($stock_group_id!=''){
				$sql2.=" and stock_group_id='$stock_group_id' ";
			}
			if($brand_id!=''){
				$sql2.=" and brand_id='$brand_id' ";
			}
			$client_contact_data = $this->db->query("SELECT * FROM `items` where `item_name` like '%$item%' and item_type='1' ".$sql2." union (SELECT * FROM `items` where `id` not in (SELECT `id` FROM `items` where `item_name` like '%$item%'  and item_type='1' ".$sql2." ) ".$sql." order by item_name)  limit 50 ");
		} else {
			$sql=" and item_name LIKE '%$item%' ";
			if($stock_group_id!=''){
				$sql.=" and stock_group_id='$stock_group_id' ";
			}
			if($brand_id!=''){
				$sql.=" and brand_id='$brand_id' ";
			}
			$client_contact_data = $this->db->query("SELECT * FROM `items` where item_type='1' ".$sql." order by item_name limit 50 ");
		}

		$n=1;
		if(count($client_contact_data->result_array())>0){	
			$html='<tr class="no_result_button" tabindex="-1" ><th ><b>Item Name</b> ( <a href="'.site_url('masters/item/create').'" class="product" target="_blank">Create New Product</a> )</th><th><b>Cost</b></th><th><b>Stock</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){ 
				$item_id=$client_contact_datas['id'];				
				$contact_data = $this->db->query("Select s.`item_trans_id`,s.`trans_no`,s.`item_id`,s.`item_rate`,t.balance_qty,s.`user_id`,s.created_date,s.status from `item_trans` s inner join (SELECT max(`item_trans_id`) as tid,sum(`item_qty`) as balance_qty FROM `item_trans` WHERE status='1' and item_id='$item_id' ) as t on t.tid=s.item_trans_id ORDER BY `item_trans_id` desc  limit 1 ");
				if($contact_data->row()!=false){
					$cost_price	=	$contact_data->row()->item_rate;
					$balance_qty	=	$contact_data->row()->balance_qty;
				} else {
					$cost_price	=	$client_contact_datas['cost_price'];
					$balance_qty=0;
				}
				$html.='<tr tabindex="-1" ><td  value="' .$client_contact_datas['id'].'" class="item_button" style="width:500px;" ><input type="hidden" class="nb_id" value="'.$client_contact_datas['id'].'" /><input type="hidden" class="item_name" value="'.htmlspecialchars($client_contact_datas['item_name']).'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" /><input type="hidden" class="item_size" value="'.$client_contact_datas['item_size'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$client_contact_datas['item_name'].'</td><td style="width:50px;text-align:right;">'.$cost_price.'</td><td style="width:50px;text-align:right;">'.$balance_qty.'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" tabindex="-1" > No Results Found </td>';
		}
		print $html;
	}

	public function search_item2() {
		$item			= $this->input->post('item');
		$search_type	= $this->input->post('search_type');
		$stock_group_id	= @$this->input->post('stock_group_id');
		$brand_id		= @$this->input->post('brand_id');
		$today			= date("Y-m-d");
		$html			= '';
		if($search_type==='anywhere'){
			$quotation_number		= @$this->input->post('quotation_number');
			$sql="";
			$items = explode(" ", trim($item));
			for($i=0;$i<count($items);$i++) {
				$r	= $items[$i];
				$sql.=" and item_name LIKE '%$r%' ";
			}
			$sql2="";
			
			$client_contact_data = $this->db->query("SELECT * FROM `short_list_for_estmation` where `item_name` like '%$item%' and quotation_number='$quotation_number' ".$sql2." union (SELECT * FROM `short_list_for_estmation` where `item_id` not in (SELECT `item_id` FROM `short_list_for_estmation` where `item_name` like '%$item%'  and quotation_number='$quotation_number' ".$sql2." ) ".$sql." order by item_name asc)  limit 50 ");
		} else {
			$quotation_number		= @$this->input->post('quotation_number');
			$sql=" and item_name LIKE '%$item%' and quotation_number='$quotation_number' ";
			$client_contact_data = $this->db->query("SELECT * FROM `short_list_for_estmation` where 1 ".$sql." order by item_name asc limit 50 ");
		}
		$n=1;
		if(count($client_contact_data->result_array())>0){	
			$html='<tr class="no_result_button" tabindex="-1" ><th ><b>Item Name</b> ( <a href="'.site_url('masters/item/create').'" class="product" target="_blank">Create New Product</a> )</th><th><b>Cost</b></th><th><b>Stock</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){ 
				$item_id=$client_contact_datas['item_id'];				
				$contact_data = $this->db->query("Select s.`item_trans_id`,s.`trans_no`,s.`item_id`,s.`item_rate`,t.balance_qty,s.`user_id`,s.created_date,s.status from `item_trans` s inner join (SELECT max(`item_trans_id`) as tid,sum(`item_qty`) as balance_qty FROM `item_trans` WHERE status='1' and item_id='$item_id' ) as t on t.tid=s.item_trans_id ORDER BY `item_trans_id` desc  limit 1 ");
				if($contact_data->row()!=false){
					$cost_price	=	$contact_data->row()->item_rate;
					$balance_qty	=	$contact_data->row()->balance_qty;
				} else {
					$cost_price	=	$client_contact_datas['cost_price'];
					$balance_qty=0;
				}
				$html.='<tr tabindex="-1" ><td  value="' .$client_contact_datas['item_id'].'" class="item_button" style="width:500px;" ><input type="hidden" class="nb_id" value="'.$client_contact_datas['item_id'].'" /><input type="hidden" class="item_name" value="'.htmlspecialchars($client_contact_datas['item_name']).'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['item_description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$client_contact_datas['item_name'].'</td><td style="width:50px;text-align:right;">'.$cost_price.'</td><td style="width:50px;text-align:right;">'.$balance_qty.'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" tabindex="-1" > No Results Found </td>';
		}
		print $html;
	}

	public function search_stock_group() {
		$stock_group_name	=	$this->input->post('stock_group_name');
		$today	=	date("Y-m-d");
		$html	='';
		$stock_group_data = $this->db->query("SELECT * FROM `stock_group` where status='1' and  `stock_group_name` like '%$stock_group_name%' order by stock_group_name");
		$n=1;
		$html='';
		if(count($stock_group_data->result_array())>0){
			foreach ($stock_group_data->result_array() as $stock_group_datas){
				$html.='<li  value="' .$stock_group_datas['id'].'" class="stock_group_name_button" tabindex="-1" ><input type="hidden" class="stock_group_name" value="'.$stock_group_datas['stock_group_name'].'" />'.$stock_group_datas['stock_group_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_brand() {
		$brand_name	=	$this->input->post('brand_name');
		$stock_group_id	=	$this->input->post('stock_group_id');
		$today	=	date("Y-m-d");
		$html	='';
		$brand_data = $this->db->query("SELECT * FROM `furniture_brands` where status='1' and `stock_group_id`='$stock_group_id' and `brand_name` like '%$brand_name%' order by brand_name");
		$n=1;
		$html='';
		if(count($brand_data->result_array())>0){
			foreach ($brand_data->result_array() as $brand_datas){
				$html.='<li value="' .$brand_datas['brand_id'].'" class="brand_button" tabindex="-1" ><input type="hidden" class="brand_name" value="'.$brand_datas['brand_name'].'" />'.$brand_datas['brand_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_itemxxx() {
		
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		
		//$client_contact_data = $this->db->query("SELECT * FROM `items` i left join `view_get_purchase_cost` vp on vp.item_id=i.id where i.`item_name` like '%$client%' and i.item_type='1'    order by i.item_name limit 0,50");
		/*$this->db->query("SET SQL_BIG_SELECTS=1"); 
		$this->db->select('*' );
		$this->db->from('view_get_purchase_cost');
		if($client!=''){
			$this->db->like('view_get_purchase_cost.item_name', $client);
		}
		$this->db->limit(25);
		$this->db->order_by("view_get_purchase_cost.item_name","desc");
		$rs = $this->db->get();*/

		$getItem=$this->Job_card_model->getItem($client);

		$n=1;
		/*if($getItem!=false){	
			//$datas=	$rs->result_array();
			$data   =   json_encode($getItem);
			$data;
		}*/
		//echo $this->db->last_query();

		if($getItem!=false){
			$html='<tr  class="no_result_button"><th><b>Item Name</b></th><th><b>Cost</b></th><th><b>Stock</b></th></tr>';
			foreach ($getItem as $row){
				$item_id=$row['id'];
				if($row['item_rate']!=NULL){
					$cost_price	=	$row['item_rate'];
				} else {
					$cost_price	=	$row['cost_price'];
				}
				if($row['balance_qty']==='' OR $row['balance_qty']===NULL){
					$balance_qty	=	'0.000';
				} else {
					$balance_qty	=	$row['balance_qty'];
				}
				$html.='<tr><td value="' .$row['id'].'" class="item_button" tabindex="'.$n++.'" style="width:500px;" ><input type="hidden" class="item_name" value="'.$row['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($row['description']).'" /><input type="hidden" class="item_unit" value="'.$row['unit'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$row['item_name'].'</td><td style="width:50px;text-align:right;">'.$cost_price.'</td><td style="width:50px;text-align:right;">'.$balance_qty.'</td></tr>';
			}		
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" > No Results Found </td>';
		}	
		print $html;
	}

	public function search_vendor() {
		$supplier_name	=	$this->input->post('supplier_name');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` where `supplier_name` like '%$supplier_name%' order by supplier_name");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr><td value="' .$client_contact_datas['supplier_id'].'" class="subcontract_button" tabindex="'.$n++.'" style="width:500px;" ><input type="hidden" class="supplier_name" value="'.$client_contact_datas['supplier_name'].'" />'.$client_contact_datas['supplier_name'].'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" > No Results Found </td>';
		}
		
		print $html;
	}

	public function search_bom() {
		$bom	=	$this->input->post('bom');
		$quotation_id	=	$this->input->post('quotation_id');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$data = $this->db->query("SELECT E.`furniture_id`,E.boq_no,F.furniture_model,F.furniture_description,F.furniture_comments,Q.quotation_number,Q.project_name,N.client_name,CONCAT(F.ex_furniture_area,'.', F.sub_group_id,'.', F.item_order) as sl_no FROM `estimation` E INNER JOIN `furniture_items` F ON F.furniture_id=E.furniture_id LEFT JOIN `furniture_quotation` Q ON Q.id=F.quotation_id LEFT JOIN `new_client_master` N ON N.client_id=Q.client_id  WHERE F.quotation_id='$quotation_id' AND (E.selling_price!='0.000' OR E.selling_price!=NULL) AND ( F.furniture_model LIKE '%$bom%' OR  E.boq_no LIKE '%$bom%'  OR  CONCAT(F.ex_furniture_area,'.', F.sub_group_id,'.', F.item_order) LIKE '%$bom%'  )  ");
		$n=1;
		if(count($data->result_array())>0){
			$html ='';
			foreach ($data->result_array() as $datas){
				$html.='<tr class="client_button" style="cursor: pointer;" ><td>' .$datas['sl_no'].'</td><td value="' .$datas['furniture_id'].'"  tabindex="'.$n++.'" ><input type="hidden" class="pop_furniture_id" value="'.$datas['furniture_id'].'" /><input type="hidden" class="boq_no" value="'.$datas['boq_no'].'" /><input type="hidden" class="furniture_model" value="'.$datas['furniture_model'].'" /><input type="hidden" class="furniture_description" value="'.htmlspecialchars($datas['furniture_description']).'" /><input type="hidden" class="furniture_comments" value="'.htmlspecialchars($datas['furniture_comments']).'" />'.$datas['boq_no'].'</td><td>' .$datas['furniture_model'].'</td></tr>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_bom_temp() {
		$bom	=	$this->input->post('bom');
		$quotation_id	=	$this->input->post('quotation_id');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$data = $this->db->query("SELECT E.`furniture_id`,E.boq_no,F.furniture_model,F.furniture_description,F.furniture_comments,Q.quotation_number,Q.project_name,N.client_name FROM `estimation` E INNER JOIN `furniture_items` F ON F.furniture_id=E.furniture_id LEFT JOIN `furniture_quotation` Q ON Q.id=F.quotation_id LEFT JOIN `new_client_master` N ON N.client_id=Q.client_id  WHERE F.quotation_id='$quotation_id' AND (E.selling_price!='0.000' OR E.selling_price!=NULL) AND ( F.furniture_model LIKE '%$bom%' OR  E.boq_no LIKE '%$bom%'  OR  CONCAT(F.ex_furniture_area,'.', F.sub_group_id,'.', F.item_order) LIKE '%$bom%'  )  ");
		$n=1;
		if(count($data->result_array())>0){
			$html ='';
			foreach ($data->result_array() as $datas){
				$html.='<li value="' .$datas['furniture_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="boq_no" value="'.$datas['boq_no'].'" /><input type="hidden" class="furniture_model" value="'.$datas['furniture_model'].'" /><input type="hidden" class="furniture_description" value="'.htmlspecialchars($datas['furniture_description']).'" /><input type="hidden" class="furniture_comments" value="'.htmlspecialchars($datas['furniture_comments']).'" />'.$datas['boq_no'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	public function addItem(){
		if ($this->input->post('quotation_number')!='' && $this->input->post('item_name')!='' && $this->input->post('unit')!='' && $this->input->post('item_id')!='' && $this->input->post('quotation_number')!='undefined' && $this->input->post('item_name')!='undefined' && $this->input->post('unit')!='undefined'  && $this->input->post('item_id')!='undefined'){
				
				$quotation_number	=	$this->input->post('quotation_number');
				$item_name	=	addslashes($this->input->post('item_name'));
				$item_id	=	$this->input->post('item_id');
				$unit	=	$this->input->post('unit');
				$cost_price	=	$this->input->post('cost_price');
				$item_description	=	addslashes($this->input->post('item_description'));
				$user_id	=	$this->session->userdata('user_id');
				$Creation_date=date("Y-m-d");
				$query = $this->db->query("INSERT INTO `short_list_for_estmation` (`quotation_number`,`item_id`,`item_name`,`unit`,`item_description`,`cost_price`) VALUES ('$quotation_number','$item_id','$item_name','$unit','$item_description','$cost_price') ");
				if ($query){
					$c_id	=	$this->db->insert_id();
					$data   =   json_encode(array('1',$c_id));
					echo $data;
				} else {
					$c_id	=	0;
					$data   =   json_encode(array('0',$c_id));
					echo $data;
				}
			
		} else {
			$c_id	=	0;
			$data   =   json_encode(array('0',$c_id));
			echo $data;
		
		}
	}
	public function itemDelete($id){
		$records= $this->db->query("DELETE FROM `short_list_for_estmation` WHERE `id`='$id' ");
	}

}
?>