<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Proforma extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}

	public function index($quotation_id=0,$fromDate="NIL",$toDate="NIL",$filter_division='NIL',$client_id='NIL',$filter_value='NIL',$qtnNo='NIL') {
		$this->users_model->permission("Proforma", "View");
		$title['headerTitle']="Proforma List";

		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}

		if (@$this->input->post('filter_division')) {
			$filter_division =   $this->input->post("filter_division");
		}elseif ($filter_division != "NIL") {
			$filter_division	=	$filter_division;
		} else {
			$filter_division	= "NIL";
		}
		
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		if (@$this->input->post('qtnNo')) {
			$qtnNo =   $this->input->post("qtnNo");
		}elseif ($qtnNo != "NIL") {
			$qtnNo	=	$qtnNo;
		} else {
			$qtnNo	= "NIL";
		}
          
		
		$sql=' where 1';
		
		if(@$filter_division!="NIL") {
			$sql.=" and FI.quotation_divisionid='$filter_division'";
		} 
		if($filter_value!="NIL"){
			$sql.=" and FI.proforma_number like '%$filter_value%'";
		}
		if($client_id!='NIL') {
			$sql.=" and FI.client_id='$client_id'";
		}

		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`proforma_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`proforma_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`proforma_date`	<=	'$toDate' ";
		}

		if($qtnNo!="NIL"){
			$sql.=" and FQ.quotation_number_full like '%$qtnNo%'";
		}
		
		$config['uri_segment'] = 3;
        //$config['use_page_numbers'] = TRUE;
		$config['base_url'] = base_url() . "index.php/furniture/Proforma/index/".$fromDate."/".$toDate."/".$quotation_id.'/'.$filter_division.'/'.$client_id.'/'.$filter_value;
        //$config["total_rows"] = $data12->num_rows();
		$config["total_rows"] = 250;
		if(isset($_POST["ttttt"])) {
			$config['num_links'] = 10;
			$config["per_page"] = 10000000000000;
			$this->pagination->initialize($config);
			$page = 0;
			$i=1;
		} else {
			$config['num_links'] = 10;
			$config["per_page"] = 250;
			$this->pagination->initialize($config);
			if ($this->uri->segment(9)) {
				$page = $this->uri->segment(9)*250-250;
				$i=$page+1;
			} else {
				$page = 0;
				$i=1;
			}
		}
		
		$data1				=	$this->db->query("SELECT * FROM `proforma` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id LEFT JOIN `furniture_quotation` FQ ON  FQ.id = FI.quotation_id ".$sql." ORDER BY FI.`proforma_id` DESC limit ".$page.",".$config["per_page"]);
		$records['invoices']	=	$data1->result_array();
		$this->pagination->initialize($config);
		$records['pagination'] = $this->pagination->create_links();
		
		$records['filter_division']	=	$filter_division;
		$records['client_id']	=	$client_id;
		if($filter_value==='NIL'){
			$filter_value='';
		}
		$records['filter_value']	=	$filter_value;
		$records['toDate']			=	$toDate;
		$records['fromDate']		=	$fromDate;
		$records['qtnNo']			=	$qtnNo;
		
		$this->load->view('templates/header',$title);
		$this->load->view('manage/proforma',$records);
		$this->load->view('templates/footer');

    }

	public function addProforma($job_card_id,$client=""){
		$this->users_model->permission("Proforma", "Add");
		$title['headerTitle']="Proforma Invoice Create";
		$this->load->model('proforma_model');
		$this->db->trans_begin();
		$query_data= $this->db->query("SELECT `proforma_amount`-sum(`proforma_percentage_amount`) as amount FROM `proforma` WHERE ( proforma_status='1' OR proforma_status='2' ) and `job_card_id`='$job_card_id' ");
		
		if ($query_data->row()->amount>0 or $query_data->row()->amount ==null){
			$this->load->view('templates/header',$title);
			$this->load->model('proforma_model');
			$invoice_data				=	$this->db->query("SELECT sum(`invoice_percentage_amount`) as invoice_percentage_amount FROM `furniture_invoice` WHERE ( invoice_status='0' ) and `job_card_id`='$job_card_id' ");
			$data['invoice_percentage_amount']	=	$invoice_data->result_array()[0]['invoice_percentage_amount'];

			$this->db->query("SET SQL_BIG_SELECTS=1");
			$re_data				=	$this->db->query("SELECT sum(ca.bill_amt)*-1 as received_amount FROM `proforma` p left join `furniture_invoice` fi on fi.`proforma_id`=p.`proforma_id` left join `cust_bill_allocations` ca on ca.bill_id=fi.invoice_id and ca.bill_type='Receipt' WHERE p.`job_card_id`='$job_card_id' ");
			$data['received_amount']	=	$re_data->result_array()[0]['received_amount'];

			$data['proforma']=$this->proforma_model->getonerow($job_card_id);
			$data['proforma_number']=$this->proforma_model->get_proforma_no($data['proforma']->divisionid);
			if($query_data->row()->amount==null){
				$xxamount=$data['proforma']->job_card_amount_with_vat;
			} else {
				$xxamount=$query_data->row()->amount;
			}
			$data['proforma_percentage_amount']=$xxamount;

			if($this->furniture_quotation_model->config($data['proforma']->divisionid)){
				$config_data=$this->furniture_quotation_model->config($data['proforma']->divisionid);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}
			$data['is_posted'] = 0;
			$data['client_det']=$client;
			$data['client_det_id']=$this->input->post('client_id');
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
			$data['division_list'] = $list;
	
			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
			if(isset($_POST["pull_items_from_job"])) {
				$data['is_posted']=1;
				$data['h']=$this->proforma_model->list_job_details($job_card_id);
			} else {
				$data['h']=array();
			}
			$this->load->view('furniture/quotations/addProforma',$data);
			$this->load->view('templates/footer');
			$trading_or_project = $this->input->post('trading_or_project');
			if(isset($_POST["invoice_save"])) {
			
				$pull_nb_item = $this->input->post('pull_nb_item');
				
				if($pull_nb_item==0){
					$proforma_percentage_amount=$this->input->post('proforma_amount');
					$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);
					$ttt=(($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_amount'))/$this->input->post('proforma_amount_hidden'))*100;
					$proforma_percentagexx=100-$ttt;
				} else {
					$proforma_percentage_amount=$this->input->post('proforma_net_amount');
					$ttt=(($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_net_amount'))/$this->input->post('proforma_amount_hidden'))*100;
					$proforma_percentagexx=100-$ttt;
					$proforma_vat_amount=round($proforma_percentage_amount-($proforma_percentage_amount/(1+($data['proforma']->job_card_vat_perc/100))),3);
				}

				if(@$trading_or_project==='2'){
					$is_project=1;
				} else {
					$is_project=0;
				}
				$proforma_date2 = strtotime( $this->input->post('proforma_date') );
				$proforma_date = date( 'Y-m-d h:m:s', $proforma_date2);
				$data2we = array(
					'proforma_number' 			=> $data['proforma_number'],
					'quotation_divisionid' 		=> $data['proforma']->divisionid,
					'proforma_date'   			=> $proforma_date,
					'quotation_id'    			=> $data['proforma']->quotation_id,
					'job_card_id'    			=> $job_card_id,
					'item_amount'     			=> $this->input->post('total_item'),
					'proforma_amount'    		=> $data['proforma']->job_card_amount_with_vat,
					'proforma_vat_percentage'   => $data['proforma']->job_card_vat_perc,
					'proforma_percentage'     	=> $proforma_percentagexx,
					'proforma_percentage_amount'=> $proforma_percentage_amount,
					'proforma_discount'     	=> 0,
					'client_id'    				=> $data['proforma']->client_id,
					'client'    				=> $data['proforma']->client_name,
					'qoute_discount'    		=> $data['proforma']->quotation_discount,
					'proforma_vat_amount'		=> $proforma_vat_amount,
					'proforma_created_by'  		=> $this->session->userdata('user_name'),
					'created_id'  				=> $this->session->userdata('user_id'),
					'proforma_status'  			=> 1,
					'is_project'  				=> $is_project,
					'po_no'     				=> $this->input->post('po_no'),
				);
				//print_r($data2we);
				$this->db->insert('proforma', $data2we);
				$proforma_id = $this->db->insert_id();
				//exit();
				$log_data=array(
					'trans_no'  	=>  $data['proforma_number'],
					'trans_type'  	=>  'Proforma',
					'trans_op'  	=>  'Create',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
				
				$count = $this->input->post('hiddenCount');
				
				if($pull_nb_item==1){

					
					if($trading_or_project==='2'){
						$tpdatanew = array(
							'proforma_id' 		=> $proforma_id,
							'sl_no' 			=> '1',
							'group_name' 		=> '',
							'group_id' 			=> 0,
							'sub_group_name' 	=> '',
							'sub_group_id' 		=> 0,
							'item_order' 		=> 0,
							'item_name' 		=> $this->input->post('project_description'),
							'quantity' 			=> 1,
							'item_discount' 	=> 0,
							'unit_price' 		=> $this->input->post('total_item'),
							'amount' 			=> $this->input->post('total_item'),
							'vat_perce' 		=> $data['proforma']->job_card_vat_perc,
							'vat_amount' 		=> $proforma_vat_amount,
							'net_amount' 		=> $this->input->post('total_item')+$proforma_vat_amount,
							'description' 		=> $this->input->post('project_text_area'),
							'uom' 				=> 'No',
							'total_discount' 	=> 0
						);
						$this->db->insert('proforma_details',$tpdatanew); 
					} else {

					$h	=	$this->proforma_model->list_job_details($job_card_id);
					foreach ($h->result() as $row) {
					//for($i=0; $i<=count($h->result()) ; $i++){
							$this->db->select('*');
							$this->db->where(array('job_card_id'=>$job_card_id,'ex_furniture_area'=>$row->ex_furniture_area));
							$this->db->from('job_card_details');
							$this->db->order_by("sub_group_id", "ASC");
							$this->db->group_by("sub_group");
							$rs = $this->db->get();
						foreach($rs->result() as $holi_per_mnth){ 
												
							$this->db->select('*');
							$this->db->where(array('job_card_id'=>$row->job_card_id,'ex_furniture_area'=>$row->ex_furniture_area,'sub_group_id'=>$holi_per_mnth->sub_group_id));
							$this->db->from('job_card_details');
							$this->db->order_by("job_card_id", "ASC");
							$sub_val 	   = $this->db->get();
							
							foreach($sub_val->result() as $sub_records){
							
								$datanew = array(
									'proforma_id' 		=> $proforma_id,
									'sl_no' 			=> $sub_records->sl_no,
									'group_name' 		=> $sub_records->furniture_area,
									'group_id' 			=> $sub_records->ex_furniture_area,
									'sub_group_name' 	=> $sub_records->sub_group,
									'sub_group_id' 		=> $sub_records->sub_group_id,
									'item_order' 		=> $sub_records->item_order,
									'item_name' 		=> $sub_records->furniture_model,
									'quantity' 			=> $sub_records->furniture_quantity,
									'item_discount' 	=> $sub_records->item_discount,
									'unit_price' 		=> $sub_records->furniture_unitprice,
									'amount' 			=> $sub_records->furniture_amount,
									'vat_perce' 		=> $sub_records->vat_perce,
									'vat_amount' 		=> $sub_records->vat_amount,
									'net_amount' 		=> $sub_records->net_amount,
									'description' 		=> $sub_records->furniture_description,
									'internal_comments' => $sub_records->furniture_comments,
									'uom' 				=> $sub_records->uom,
									'total_discount' 	=> $sub_records->total_discount
								);
								
								$this->db->insert('proforma_details',$datanew); 
							}
						}
					}
				}
				} else {					
					$this->db->where('proforma_id',$proforma_id);
					$this->db->delete('proforma_details');
					for($i=1; $i<$count ; $i++){
						if($this->input->post('item_row'.$i)!=""){
							$datanew = array(
								'proforma_id' 		=> $proforma_id,
								'sl_no' 			=> $i,
								'group_name' 		=> '',
								'group_id' 			=> 0,
								'sub_group_name' 	=> '',
								'sub_group_id' 		=> 0,
								'item_order' 		=> $i,
								'item_name' 		=> $this->input->post('item_row'.$i),
								'quantity' 			=> $this->input->post('quantity_row'.$i),
								'item_discount' 	=> $this->input->post('disc_row'.$i),
								'unit_price' 		=> str_replace(",","",$this->input->post('rate_row'.$i)),
								'amount' 			=> str_replace(",","",$this->input->post('quantity_row'.$i)*$this->input->post('rate_row'.$i)),
								'vat_perce' 		=> $this->input->post('vat_perc_row'.$i),
								'vat_amount' 		=> $this->input->post('vat_amount_row'.$i),
								'net_amount' 		=> $this->input->post('total'.$i),
								'description' 		=> $this->input->post('description_row'.$i),
								'uom' 				=> $this->input->post('uom_nb'.$i),
								'total_discount' 	=> 0
							);
							$this->db->insert('proforma_details',$datanew);
						} 
					 }
				}
	
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Proforma Created Successfully...');
				redirect('furniture/Proforma');
			}

		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'Sorry! You have already created proforma in this job card...');
			redirect('furniture/Proforma');
		}
	}

	function editProforma($proforma_id,$client="") {
		$this->users_model->permission("Proforma", "Edit");
		$title['headerTitle']="Proforma Edit";
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['proforma']=$this->proforma_model->getProformaRow($proforma_id);
		
		$data['proforma_no']='';
		
		$data['sumdetail']=$this->proforma_model->getsumrow($proforma_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;
		$job_card_id=$data['proforma']->job_card_id;
		$query_xxx= $this->db->query("SELECT j.job_card_amount_with_vat,p.`proforma_amount`-sum(p.`proforma_percentage_amount`) as amount,sum(p.`proforma_percentage_amount`) as excluding_balance FROM `proforma` p left join  `job_card` j on p.job_card_id=j.id WHERE ( p.proforma_status='1' OR p.proforma_status='2' ) and p.`job_card_id`='$job_card_id' and  p.proforma_id!='$proforma_id'");
		if ($query_xxx->row()->amount ==null){
			$proformed_amount=0;
		} else {
			$proformed_amount=$query_xxx->row()->amount;
		}

		if($this->furniture_quotation_model->config($data['proforma']->quotation_divisionid)){
			$config_data=$this->furniture_quotation_model->config($data['proforma']->quotation_divisionid);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=$data['proforma']->proforma_date;
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		
		$data['proforma_amount_hidden']=$data['proforma']->proforma_amount;

		$data['nb_project_value']=$data['proforma']->job_card_amount_with_vat;
		$data['nb_proforma_raised']=$proformed_amount;
		$data['excluding_balance']=$query_xxx->row()->excluding_balance;

		$data['job_card_total']=$data['proforma']->job_card_total;
		$data['job_card_vat_amount']=$data['proforma']->job_card_vat_amount;
		$data['proforma_amount']=$data['proforma']->proforma_amount;
		$data['proforma_percentage_amount']=$proformed_amount;
		$data['job_card_total']=$data['proforma']->job_card_total;
		$data['is_project']=$data['proforma']->is_project;
		
		if(isset($_POST["pull_items_from_job"])) {
			$data['is_posted']=1;
			$data['j']=$this->proforma_model->list_job_details($job_card_id);
			$data['h']=array();
		} else {
			$data['job_card_total']=$data['proforma']->item_amount;
			$data['job_card_vat_amount']=$data['proforma']->proforma_vat_amount;
			$data['proforma_amount']=$data['proforma']->proforma_percentage_amount;
			$data['is_posted']=0;
			$data['h']=$this->proforma_model->list_details($proforma_id);
			$data['j']=array();
		}
		
		$this->load->view('furniture/quotations/editProforma',$data);
		$this->load->view('templates/footer');
		$trading_or_project = $this->input->post('trading_or_project');

		if(isset($_POST["invoice_save"])) {
			$pull_nb_item = $this->input->post('pull_nb_item');
			if($this->input->post('proforma_net_amount')>$data['proforma_amount']){
				$this->session->set_flashdata('response', 'Proforma Invoice amount not exceed Quotation amount...');
				redirect('furniture/Proforma');
			} else {
				if($pull_nb_item==2){
					$proforma_percentage_amountqq=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_percentagexx=100-((($this->input->post('proforma_amount_hidden')-$this->input->post('proforma_amount'))/$this->input->post('proforma_amount_hidden'))*100);
				} else if($pull_nb_item==1){ 
					$proforma_percentage_amountqq=$this->input->post('proforma_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_vat_amount=$this->input->post('proforma_vat_amount')*($this->input->post('proforma_percentage')/100);
					$proforma_percentagexx=$this->input->post('proforma_percentage');
				} else {
					$proforma_percentage_amountqq= (float)$this->input->post('proforma_net_amount');
					$proforma_vat_amount=$this->input->post('proforma_vat_amount');
					$proforma_percentagexx=$this->input->post('proforma_percentage');
				}

				if(@$trading_or_project==='2'){
					$is_project=1;
				} else {
					$is_project=0;
				}

				$datazz = array(
					'item_amount'     			=> $this->input->post('total_item'),
					'proforma_percentage'     	=> $proforma_percentagexx,
					'proforma_percentage_amount'=> $proforma_percentage_amountqq,
					'proforma_vat_amount'		=> $proforma_vat_amount,
					'proforma_discount'     	=> 0,
					'is_project'  				=> $is_project,
					'po_no'     				=> $this->input->post('po_no'),
				);
				$this->db->where('proforma_id', $proforma_id);
				$this->db->update('proforma', $datazz);

				$log_data=array(
					'trans_no'  	=>  $this->input->post('proforma_number'),
					'trans_type'  	=>  'Proforma',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				$count = $this->input->post('hiddenCount');
				if($pull_nb_item==2){
					$this->db->where('proforma_id',$proforma_id);
					$this->db->delete('proforma_details');
					for($i=1; $i<$count ; $i++){
						if($this->input->post('item_row'.$i)!=""){
							$datanew = array(
								'proforma_id' 		=> $proforma_id,
								'sl_no' 			=> $i,
								'group_name' 		=> '',
								'group_id' 			=> 0,
								'sub_group_name' 	=> '',
								'sub_group_id' 		=> 0,
								'item_order' 		=> $i,
								'item_name' 		=> $this->input->post('item_row'.$i),
								'quantity' 			=> $this->input->post('quantity_row'.$i),
								'item_discount' 	=> $this->input->post('disc_row'.$i),
								'unit_price' 		=> str_replace(",","",$this->input->post('rate_row'.$i)),
								'amount' 			=> str_replace(",","",$this->input->post('quantity_row'.$i)*$this->input->post('rate_row'.$i)),
								'vat_perce' 		=> $this->input->post('vat_perc_row'.$i),
								'vat_amount' 		=> $this->input->post('vat_amount_row'.$i),
								'net_amount' 		=> $this->input->post('total'.$i),
								'description' 		=> $this->input->post('description_row'.$i),
								'uom' 				=> $this->input->post('uom_nb'.$i),
								'total_discount' 	=> 0
							);
							$this->db->insert('proforma_details',$datanew);
					 	} 
				 	}
				} else if($pull_nb_item==1){
					$trading_or_project = $this->input->post('trading_or_project');
					if($trading_or_project==='2'){
						$tpdatanew = array(
							'proforma_id' 		=> $proforma_id,
							'sl_no' 			=> '1',
							'group_name' 		=> '',
							'group_id' 			=> 0,
							'sub_group_name' 	=> '',
							'sub_group_id' 		=> 0,
							'item_order' 		=> 0,
							'item_name' 		=> $this->input->post('project_description'),
							'quantity' 			=> 1,
							'item_discount' 	=> 0,
							'unit_price' 		=> $this->input->post('total_item'),
							'amount' 			=> $this->input->post('total_item'),
							'vat_amount' 		=> $proforma_vat_amount,
							'net_amount' 		=> $this->input->post('total_item')+$proforma_vat_amount,
							'description' 		=> $this->input->post('project_text_area'),
							'uom' 				=> 'No',
							'total_discount' 	=> 0
						);
						$this->db->insert('proforma_details',$tpdatanew); 
					} else {
						$jobCardDetails=$this->proforma_model->jobCardDetails($job_card_id);
						$this->db->where('proforma_id',$proforma_id);
						$this->db->delete('proforma_details');
						foreach($jobCardDetails as $sub_records){
							$datanew = array(
								'proforma_id' 		=> $proforma_id,
								'sl_no' 			=> $sub_records->sl_no,
								'group_name' 		=> $sub_records->furniture_area,
								'group_id' 			=> $sub_records->ex_furniture_area,
								'sub_group_name' 	=> $sub_records->sub_group,
								'sub_group_id' 		=> $sub_records->sub_group_id,
								'item_order' 		=> $sub_records->item_order,
								'item_name' 		=> $sub_records->furniture_model,
								'quantity' 			=> $sub_records->furniture_quantity,
								'item_discount' 	=> $sub_records->item_discount,
								'unit_price' 		=> str_replace(",","",$sub_records->furniture_unitprice),
								'amount' 			=> str_replace(",","",$sub_records->furniture_unitprice*$sub_records->furniture_quantity),
								'vat_perce' 		=> $sub_records->vat_perce,
								'vat_amount' 		=> $sub_records->vat_amount,
								'net_amount' 		=> $sub_records->net_amount,
								'description' 		=> $sub_records->furniture_description,
								'uom' 				=> $sub_records->uom,
								'total_discount' 	=> $sub_records->total_discount
							);
							$this->db->insert('proforma_details',$datanew); 
						}
					}
				}
				$this->session->set_flashdata('success', 'The proforma has been updated...');
				redirect('furniture/Proforma');
			}
		}
	}

	public function delete($id,$proforma_number){
		$this->users_model->permission("Proforma", "Delete");
		$this->load->model('proforma_model');
		$this->proforma_model->delete($id,$proforma_number);
		$this->session->set_flashdata('response', 'Proforma Cancelled...');
		redirect('furniture/Proforma');
	}
}

?>