<?php
class Worktop_models extends CI_Controller {
	function Worktop_models()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/worktop_models/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_worktop_models_with_price_group',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_worktop_models_with_price_group',
				array(),
				$config['per_page'],
				$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_models/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$list = $this->crud_model->get_list('price_group_id','price_group_name','worktop_price_groups',array(0=>' - Select - '));
		$data['worktop_price_groups'] = $list;

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_models/create',$data);
		$this->load->view('templates/footer');




	}
	function edit($id)
	{
		$where=array(
				'worktop_model_id' => $id
		);
		$records=$this->crud_model->get('worktop_models',$where);
		if($records != false){
			//true section
			$data['worktop_model_name']			 = $records[0]['worktop_model_name'];
			$data['worktop_model_id']			 = $records[0]['worktop_model_id'];
			$data['price_group_id']			     = $records[0]['price_group_id'];
			$list = $this->crud_model->get_list('price_group_id','price_group_name','worktop_price_groups',array(0=>' - Select - '));
			$data['worktop_price_groups'] = $list;
				
			$this->load->view('templates/header');
			$this->load->view('masters/worktop_models/edit',$data);
			$this->load->view('templates/footer');
				
				
				

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/worktop_models');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('worktop_model_name', 'Worktop Model Name', 'required|max_length[50]');
		$this->form_validation->set_rules('price_group_id', 'Price Group', 'required|is_natural_no_zero');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->create();
		}
		else
		{	// true section

			 $worktop_model_name     = $this->input->post('worktop_model_name');
			 $price_group_id         = $this->input->post('price_group_id');

			$data=array(
					         'worktop_model_name'   => $worktop_model_name,
					         'price_group_id'       => $price_group_id
			);

			$rr=$this->crud_model->insert('worktop_models',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Worktop Model cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/worktop_models');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Model added successfully</div>');
				redirect('masters/worktop_models');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('worktop_model_name', 'Worktop Model Name', 'required|max_length[50]');
        $this->form_validation->set_rules('price_group_id', 'Price Group', 'required|is_natural_no_zero');
	
	
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit( $this->input->post('worktop_model_id'));
		
		}
		else
		{// true section

			$worktop_model_name   = $this->input->post('worktop_model_name');
			$worktop_model_id     = $this->input->post('worktop_model_id');
			$price_group_id       = $this->input->post('price_group_id');
			$where=array(
					           'worktop_model_id'  => $worktop_model_id
			);
			$data=array(
					         'worktop_model_name'  => $worktop_model_name,
					         'price_group_id'      => $price_group_id

			);

			$records=$this->crud_model->update('worktop_models',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Model updated</div>');
			redirect('masters/worktop_models');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'worktop_model_id'=> $id
		);

		$this->crud_model->delete('worktop_models',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Model deleted</div>');
		redirect('masters/worktop_models');
	}
}



