<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2011, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------
function num_words($price, $prefix=''){	
	if ($price == 0) {
		return '';
	}	
	$words = array(
	1=>'One', 2=>'Two', 3=>'Three',4=>'Four', 5=>'Five', 6=>'Six',7=>'Seven', 8=>'Eight', 9=>'Nine',
	11=>'Eleven', 12=>'Twelve', 13=>'Thirteen', 14=>'Fourteen', 15=>'Fifteen', 16=>'Sixteen', 17=>'Seventeen', 18=>'Eighteen',
	19=>'Nineteen', 10=>'Ten', 20=>'Twenty', 30=>'Thirty', 40=>'Forty', 50=>'Fifty', 60=>'Sixty', 70=>'Seventy', 80=>'Eighty', 90=>'Ninty'
	);
	
		
	(int)$thousands = $price / 1000;
	if((int)$thousands > 0){
		$pos = " Thousand ";
		if ($price%1000 != 0) {
			return num_words($price%1000, num_words((int)$thousands, '') . $pos) ;
		} else {
			return num_words((int)$thousands, '') . $pos; 
		}
	}
	
	
	(int)$hundreds = $price / 100;
	if((int)$hundreds > 0){
		$pos = " Hundred ";
		if ($price%100 != 0) {
			return num_words($price%100,  $prefix . num_words((int)$hundreds, '') . $pos) ;
		} else {
			if ($prefix != '') {
				return $prefix . ' and ' . num_words((int)$hundreds, '') . $pos; 	
			} else {
				return num_words((int)$hundreds, '') . $pos;
			}		
		}
	}


	if (($price < 21) || ((int)$price%10 == 0)) {
		if ($prefix != '') {
			return $prefix . ' and ' . $words[$price];
		} else {
			return $words[$price];
		}
	}
	
	(int)$tens = $price / 10;
	if ($prefix != '' ) {
		return $prefix . ' and ' . $words[(int)$tens * 10] . " " . $words[(int)$price%10];
	} else {
		return $words[(int)$tens * 10] . " " . $words[(int)$price%10];
	}

}




?>