

(function ($) {
    "use strict";

    // ______________ PAGE LOADING
    $(window).on("load", function (e) {
        $("#global-loader").fadeOut("slow");
    })

    // ______________Color-Theme
    $(document).on("click", "a[data-theme]", function () {
        $("head link#theme").attr("href", $(this).data("theme"));
        $(this).toggleClass('active').siblings().removeClass('active');
    });

    // ______________Full screen
    $(document).on("click", ".fullscreen-button", function toggleFullScreen() {
        $('html').addClass('fullscreenie');
        if ((document.fullScreenElement !== undefined && document.fullScreenElement === null) || (document.msFullscreenElement !== undefined && document.msFullscreenElement === null) || (document.mozFullScreen !== undefined && !document.mozFullScreen) || (document.webkitIsFullScreen !== undefined && !document.webkitIsFullScreen)) {
            if (document.documentElement.requestFullScreen) {
                document.documentElement.requestFullScreen();
            } else if (document.documentElement.mozRequestFullScreen) {
                document.documentElement.mozRequestFullScreen();
            } else if (document.documentElement.webkitRequestFullScreen) {
                document.documentElement.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
            } else if (document.documentElement.msRequestFullscreen) {
                document.documentElement.msRequestFullscreen();
            }
        } else {
            $('html').removeClass('fullscreenie');
            if (document.cancelFullScreen) {
                document.cancelFullScreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    })

    // ______________ BACK TO TOP BUTTON
    $(window).on("scroll", function (e) {
        if ($(this).scrollTop() > 0) {
            $('#back-to-top').fadeIn('slow');
        } else {
            $('#back-to-top').fadeOut('slow');
        }
    });
    $(document).on("click", "#back-to-top", function (e) {
        $("html, body").animate({
            scrollTop: 0
        }, 0);
        return false;
    });


    // ______________ COVER IMAGE
    $(".cover-image").each(function () {
        var attr = $(this).attr('data-image-src');
        if (typeof attr !== typeof undefined && attr !== false) {
            $(this).css('background', 'url(' + attr + ') center center');
        }
    });

    // ______________Live Toast
    var toastTrigger = document.getElementById('liveToastBtn')
    var toastLiveExample = document.getElementById('liveToast')
    if (toastTrigger) {
        toastTrigger.addEventListener('click', function () {
            var toast = new bootstrap.Toast(toastLiveExample)
            toast.show()
        })
    }

    //Increment & Decrement
    var quantitiy = 0;
    $('.quantity-right-plus').on('click', function (e) {
        e.preventDefault();
        var quantity = parseInt($('.quantity').val());
        $('.quantity').val(quantity + 1);

    });
    $('.quantity-left-minus').on('click', function (e) {
        e.preventDefault();
        var quantity = parseInt($('.quantity').val());
        if (quantity > 0) {
            $('.quantity').val(quantity - 1);
        }
    });

    // ______________Chart-circle
    if ($('.chart-circle').length) {
        $('.chart-circle').each(function () {
            let $this = $(this);
            $this.circleProgress({
                fill: {
                    color: $this.attr('data-color')
                },
                size: $this.height(),
                startAngle: -Math.PI / 4 * 2,
                emptyFill: 'rgba(119, 119, 142, 0.2)',
                lineCap: 'round'
            });
        });
    }

    // ______________ CARD
    const DIV_CARD = 'div.card';

    // ______________ TOOLTIP
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })

    // ______________ POPOVER
    var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
    var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl)
    })

    // ______________ FUNCTION FOR REMOVE CARD
    $(document).on('click', '[data-bs-toggle="card-remove"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.remove();
        e.preventDefault();
        return false;
    });


    // ______________ FUNCTIONS FOR COLLAPSED CARD
    $(document).on('click', '[data-bs-toggle="card-collapse"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.toggleClass('card-collapsed');
        e.preventDefault();
        return false;
    });

    // ______________ CARD FULL SCREEN
    $(document).on('click', '[data-bs-toggle="card-fullscreen"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.toggleClass('card-fullscreen').removeClass('card-collapsed');
        e.preventDefault();
        return false;
    });

    let html = document.querySelector('html');
    // ______________ SWITCHER-toggle ______________//

    $('.layout-setting').on("click", function (e) {
        if (!(document.querySelector('body').classList.contains('dark-mode'))) {
            $('body').addClass('dark-mode');
            $('body').removeClass('light-mode');

            $('body')?.removeClass('color-menu');
            $('body')?.removeClass('light-menu');
            $('body')?.removeClass('color-header');
            $('body')?.removeClass('header-light');

            localStorage.setItem('volghdarkMode', true);
            localStorage.removeItem('volghlightMode');
        }
        else {
            $('body').addClass('light-mode');
            $('body').removeClass('dark-mode');
            localStorage.removeItem('volghdarkMode');
        }
    });


    //---- HORIZONTAL CLICK MENU START ----- //
        // $('body').addClass('horizontal');
        let bodyhorizontal = $('body').hasClass('horizontal');
        if (bodyhorizontal) {
            if (!document.querySelector('.login-img')) {
                ActiveSubmenu();
                checkHoriMenu();
                responsive();
            }
            if (window.innerWidth >= 992) {
                let li = document.querySelectorAll('.side-menu li')
                li.forEach((e, i) => {
                    e.classList.remove('is-expanded')
                })
                var animationSpeed = 300;
                // first level
                var parent = $("[data-bs-toggle='sub-slide']").parents('ul');
                var ul = parent.find('ul:visible').slideUp(animationSpeed);
                ul.removeClass('open');
                var parent1 = $("[data-bs-toggle='sub-slide2']").parents('ul');
                var ul1 = parent1.find('ul:visible').slideUp(animationSpeed);
                ul1.removeClass('open');
            }
            $(".main-content").addClass("hor-content");
            $(".main-content").removeClass("app-content");
            $(".main-container").addClass("container");
            $(".main-container").removeClass("container-fluid");
            $(".app-header").addClass("hor-header");
            $(".hor-header").removeClass("app-header");
            $(".app-sidebar").addClass("horizontal-main")
            $(".main-sidemenu").addClass("container")
            $('body').removeClass('sidebar-mini');
            $('body').removeClass('sidenav-toggled');
            // To enable no-wrap horizontal style
            $('#slide-left').removeClass('d-none');
            $('#slide-right').removeClass('d-none');
            // To enable wrap horizontal style
            // $('#slide-left').addClass('d-none');
            // $('#slide-right').addClass('d-none');
            // document.querySelector('.horizontal .side-menu').style.flexWrap = 'wrap'

        }
   //---- HORIZONTAL CLICK MENU END ----- //

   //---- HORIZONTAL HOVER MENU START
        // $('body').addClass('horizontal-hover');  
        let bodyhorizontalHover = $('body').hasClass('horizontal-hover');
        if (bodyhorizontalHover) {
            if (!document.querySelector('.login-img')) {
                checkHoriMenu();
                responsive();
            }
            if (window.innerWidth >= 992) {
                let li = document.querySelectorAll('.side-menu li')
                li.forEach((e, i) => {
                    e.classList.remove('is-expanded')
                })
                var animationSpeed = 300;
                // first level
                var parent = $("[data-bs-toggle='sub-slide']").parents('ul');
                var ul = parent.find('ul:visible').slideUp(animationSpeed);
                ul.removeClass('open');
                var parent1 = $("[data-bs-toggle='sub-slide2']").parents('ul');
                var ul1 = parent1.find('ul:visible').slideUp(animationSpeed);
                ul1.removeClass('open');
            }
            $('body').addClass('horizontal');
            $(".main-content").addClass("hor-content");
            $(".main-content").removeClass("app-content");
            $(".main-container").addClass("container");
            $(".main-container").removeClass("container-fluid");
            $(".app-header").addClass("hor-header");
            $(".app-header").removeClass("app-header");
            $(".app-sidebar").addClass("horizontal-main")
            $(".main-sidemenu").addClass("container")
            $('body').removeClass('sidebar-mini');
            // To enable wrap horizontal style
            // $('#slide-left').addClass('d-none');
            // $('#slide-right').addClass('d-none');
            // document.querySelector('.horizontal .side-menu').style.flexWrap = 'wrap'
            // To enable no-wrap horizontal style
            $('#slide-left').addClass('d-none');
            $('#slide-right').addClass('d-none');
            document.querySelector('.horizontal .side-menu')?.classList.add('flex-nowrap')
        }
    //---- HORIZONTAL HOVER MENU END ----- //

    //---- RTL START ----- //
        // $('body').addClass('rtl');
        let bodyRtl = $('body').hasClass('rtl');
        if (bodyRtl) {
            $('#slide-left').removeClass('d-none');
            $('#slide-right').removeClass('d-none');
            $("html[lang=en]").attr("dir", "rtl");
            $('body').removeClass('ltr');
            $("head link#style").attr("href", $(this));
            (document.getElementById("style").setAttribute("href", "../assets/plugins/bootstrap/css/bootstrap.rtl.min.css"));
            var carousel = $('.owl-carousel');
            $.each(carousel, function (index, element) {
                // element == this
                var carouselData = $(element).data('owl.carousel');
                carouselData.settings.rtl = true; //don't know if both are necessary
                carouselData.options.rtl = true;
                $(element).trigger('refresh.owl.carousel');
            });
        }
    //---- RTL END ----- //

    //---- DARK THEME START ----- //
        // $('body').addClass('dark-mode');
    //---- DARK THEME END ----- //

    //---- LIGHT LEFTMENU START ----- //
        // $('body').addClass('light-menu');
    //---- LIGHT LEFTMENU END ----- //

    //---- COLOR LEFTMENU START ----- //
        //  $('body').addClass('color-menu');
    //---- COLOR LEFTMENU END ----- //

    //---- DARK LEFTMENU START  ----- //
        // $('body').addClass('dark-menu');
    //---- DARK LEFTMENU END ----- //

    //---- LIGHT HEADER START ----- //
        // $('body').addClass('header-light');
    //---- LIGHT HEADER END ----- //

    //---- COLOR HEADER START ----- //
        // $('body').addClass('color-header');
    //---- COLOR HEADER END ----- //

    //---- DARK HEADER START ----- //
        // $('body').addClass('dark-header');
    //---- DARK HEADER END ----- //

    //---- FULL WIDTH LAYOUT START ----- //
        // $('body').addClass('layout-fullwidth');
        // checkHoriMenu();
    //---- FULL WIDTH LAYOUT END ----- //

    //---- BOXED LAYOUT START ----- //
        // $('body').addClass('layout-boxed');
        // checkHoriMenu();
    //---- BOXED LAYOUT END ----- //

    //---- HEADER POSITION STYLES START ----- //
        // $('body').addClass('fixed-layout');
        // $('body').addClass('scrollable-layout');
    //---- HEADER POSITION STYLES END ----- //

    //---- DEFAULT SIDEMENU START ----- //
        // $('body').addClass('default-menu');
        // hovermenu();
    //---- DEFAULT SIDEMENU END ----- //

    //---- ICON OVERLAY SIDEMENU START ----- //
        // $('body').addClass('icon-overlay');
        // hovermenu();
        // iconoverlay();
    //---- ICON OVERLAY SIDEMENU END ----- //

    //---- ICONTEXT SIDEMENU START ----- //
        // $('body').addClass('icontext-menu');
        // icontext();
    //---- ICONTEXT SIDEMENU END ----- //

    //---- CLOSED SIDEMENU START ----- //
        // $('body').addClass('closed-leftmenu');
        // $('body').addClass('sidenav-toggled');
    //---- CLOSED SIDEMENU END ----- //

    //---- HOVER SUBMENU START ----- //
        // $('body').addClass('hover-submenu');
        // $('body').addClass('sidenav-toggled');
        // hovermenu();
    //---- HOVER SUBMENU END ----- //

    //---- HOVER SUBMENU STYLE-1 START ----- //
        // $('body').addClass('hover-submenu1');
        // $('body').addClass('sidenav-toggled');
        // hovermenu();
    //---- HOVER SUBMENU STYLE-1 END ----- //
   
})(jQuery);
