<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Invoices extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
		$this->load->model('Crud_Model');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}

	public function index($quotation_id=0,$fromDate="NIL",$toDate="NIL",$filter_division='NIL',$client_id='NIL',$filter_value='NIL',$qtnNo='NIL') {
		$this->users_model->permission("Invoices", "View");
		$title['headerTitle']="Invoice List";

		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}

		if (@$this->input->post('filter_division')) {
			$filter_division =   $this->input->post("filter_division");
		}elseif ($filter_division != "NIL") {
			$filter_division	=	$filter_division;
		} else {
			$filter_division	= "NIL";
		}
		
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		if (@$this->input->post('qtnNo')) {
			$qtnNo =   $this->input->post("qtnNo");
		}elseif ($qtnNo != "NIL") {
			$qtnNo	=	$qtnNo;
		} else {
			$qtnNo	= "NIL";
		}
          
		
		$sql=' where 1';
		
		if(@$filter_division!="NIL") {
			$sql.=" and FI.quotation_divisionid='$filter_division'";
		} 
		if($filter_value!="NIL"){
			$sql.=" and FI.invoice_number like '%$filter_value%'";
		}
		if($client_id!='NIL') {
			$sql.=" and FI.client_id='$client_id'";
		}

		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}

		if($qtnNo!="NIL"){
			$sql.=" and FQ.quotation_number_full like '%$qtnNo%'";
		}
		
		//$data12	=	$this->db->query("SELECT invoice_id FROM `furniture_invoice` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id LEFT JOIN `furniture_quotation` FQ ON  FQ.id = FI.quotation_id  ".$sql." ");
		
		$config['uri_segment'] = 3;
        //$config['use_page_numbers'] = TRUE;
		$config['base_url'] = base_url() . "index.php/invoices/index/".$fromDate."/".$toDate."/".$quotation_id.'/'.$filter_division.'/'.$client_id.'/'.$filter_value;
        //$config["total_rows"] = $data12->num_rows();
		$config["total_rows"] = 250;
		if(isset($_POST["ttttt"])) {
			$config['num_links'] = 10;
			$config["per_page"] = 10000000000000;
			$this->pagination->initialize($config);
			$page = 0;
			$i=1;
		} else {
			$config['num_links'] = 10;
			$config["per_page"] = 250;
			$this->pagination->initialize($config);
			if ($this->uri->segment(9)) {
				$page = $this->uri->segment(9)*250-250;
				$i=$page+1;
			} else {
				$page = 0;
				$i=1;
			}
		}

		
		$data1				=	$this->db->query("SELECT * FROM `furniture_invoice` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id LEFT JOIN `furniture_quotation` FQ ON  FQ.id = FI.quotation_id ".$sql." ORDER BY FI.`invoice_id` DESC limit ".$page.",".$config["per_page"]);
		$records['invoices']	=	$data1->result_array();
		$this->pagination->initialize($config);
		$records['pagination'] = $this->pagination->create_links();
		
		$records['filter_division']	=	$filter_division;
		$records['client_id']	=	$client_id;
		if($filter_value==='NIL'){
			$filter_value='';
		}
		$records['filter_value']	=	$filter_value;
		$records['toDate']			=	$toDate;
		$records['fromDate']		=	$fromDate;
		$records['qtnNo']			=	$qtnNo;
		
		$this->load->view('templates/header',$title);
		$this->load->view('manage/invoice',$records);
		$this->load->view('templates/footer');
	}

	public function create($id){
		$this->users_model->permission("Invoices", "Add");
		$title['headerTitle']="Invoice Create";
		$this->load->model('proforma_model');
		$data['h1']=$this->proforma_model->pinvoice_getonerow($id);
		$job_card_id = $data['h1']->job_card_id;
		$quotation_divisionid = $data['h1']->quotation_divisionid;
		$invtype=1;
		$data['invoice_no']=$this->proforma_model->get_invoice_no($quotation_divisionid,$invtype);
		$data['sum']=$this->proforma_model->pinvoice_get_sum_amount($job_card_id);
		$data['h']=$this->proforma_model->group_pinvoice_details($id);
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/createpinvoice',$data);
		$this->load->view('templates/footer');
	}

	public function pupdate($id){
		$this->users_model->permission("Invoices", "Add");
		//$id = $this->input->post('invid');
		$proforma_id = $this->input->post('invid');
		$this->db->trans_begin();
		$query_data= $this->db->query("SELECT * FROM `furniture_invoice` WHERE ( invoice_status='0' ) and `proforma_id`='$proforma_id' ");
		if ($query_data->row()==false){
			$this->load->model('proforma_model');
			$this->proforma_model->pupdate($id);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				//$this->session->set_flashdata('response', 'Some Created...');
				redirect('Invoices/create/'.$id);
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Invoice created successfully...');
				redirect('Invoices');
			}
		} else {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'Already created...');
			redirect('Invoices/create/'.$id);
		}
	}
	public function delete($id,$invoice_number,$proforma_id=NULL){
		$this->users_model->permission("Invoices", "Delete");
		$this->load->model('invoice_model');
		$this->db->trans_begin();
		$this->invoice_model->delete($id,$invoice_number,$proforma_id);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'something went wrong please try again...');
			redirect('invoices');
		} else {
			$this->db->trans_commit();
			$this->session->set_flashdata('success', 'Invoice Cancelled...');
			redirect('invoices');
		}
	}

	public function invoice_from($id= '' ){
		$this->users_model->permission("Invoices", "View");
	
 		$title['headerTitle']="Create Invoce";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer'] = $this->Vehicle->getCustomer();	
		$data['staff']    = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['technician']  = $this->Vehicle->getServiceStaff();
		$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($id);
		$data['model']    = $this->Vehicle->getregisterModel($data['vjobcard']->make);
		$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($id);
		$Client_Id = $data['vjobcard']->client_id;
		$data['inv_no'] = $this->Crud_Model->getInvoiceTempNum($data['vjobcard']->divisionid);
		$division_id =  $this->Vehicle->getVjobcard_division($id);
		$data['material_details'] = $this->Vehicle->getPurchaseMaterial_job($id,$division_id);
		$data['material_issue']   = $this->Vehicle->getMaterialIssue_job($id,$division_id);
		$data['ContactDetails']   = $this->Vehicle->get_ContactDetails($Client_Id,$contact_name = '');
		$data['jobtype_spare']	  = $this->Vehicle->Chkjobtype_spare($id);
		$data['jobtype_labour']	  = $this->Vehicle->Chkjobtype_labour($id);
		$data['company_config']   = $this->Crud_Model->get_companyConfig();
		$data['vehicle_discount_limit']  = $this->Crud_Model->getVehicle_section_DiscountLimit($id);
		$this->load->view('furniture/quotations/jobcard/create_v_invoice',$data);
		$this->load->view('templates/footer');
	}

	public function insert_invoicedata(){
		$this->users_model->permission("Invoices", "Add");
		$this->db->trans_begin();
		$quotation_divisionid = $this->input->post('division_id');
		$invoice_number       = $this->Crud_Model->getInvoiceTempNum($quotation_divisionid);
		$job_card_id 		  = $this->input->post('job_card_id');
		$invoice_date		  = date('Y-m-d');
		$invoice_amount		  = $this->input->post('total_netamnt');
		$client_id			  = $this->input->post('client_id');
		$client				  = $this->input->post('client');
		$invoice_vat_amount	  = $this->input->post('total_vatamnt');
		$round_off			  = $this->input->post('round_off');
		$sign			 	  = $this->input->post('sign');
		$lpo_no			 	  = $this->input->post('lpo_no');
		$inv_data  = array(
			'quotation_divisionid'		 => $quotation_divisionid,
			'invoice_number'			 => $invoice_number,
			'invoice_date'				 => $invoice_date,
			'job_card_id'				 => $job_card_id,
			'invoice_amount'			 => $invoice_amount,
			'invoice_percentage'  		 => 100,
			'invoice_percentage_amount'  => $invoice_amount,
			'invoice_discount'			 => '0.000',
			'qoute_discount'			 => '0.000',
			'paid_amount'				 => '0.000',
			'receipt_discount'			 => '0.000',
			'client_id'					 => $client_id,
			'client'					 => $client,
			'invoice_created_by'         => $this->session->userdata('user_name'),
			'created_id'                 => $this->session->userdata('user_id'),
			'invoice_status'			 => '0',
			'invoice_vat_amount'		 => $invoice_vat_amount,
			'total_credit_note_amount'   => '0.000',
			'proforma_id'				 => '0',
			'from_proforma'              => '0',
			'po_no'					     => $lpo_no, 
			'round_off'					 => $round_off,
			'sign'					     => $sign 
		);
		$rrs = $this->Crud_Model->insert('furniture_invoice',$inv_data);
		if(!empty($rrs)){
			$inv_id  =  $rrs;
			$sl_no  =  1 ;
			$itm_order = 1 ;
			$item_name  	 = $this->input->post('inv_item');
			$quantity   	 = $this->input->post('inv_item_qty');
			$amount   		 = $this->input->post('inv_item_amount');
			$item_discount   = $this->input->post('inv_disc');
			$vat_perce   	 = $this->input->post('inv_vat_perce');
			$vat_amount   	 = $this->input->post('inv_item_vat_amount');
			$net_amount   	 = $this->input->post('inv_item_net_amount');
			$uom		   	 = $this->input->post('inv_item_uom');
			$uom_id		   	 = $this->input->post('inv_item_uom_id');
			$internal_comments = $this->input->post('internal_comments');
			if(!empty($item_name)){
				for($i = 0 ; $i < count($item_name); $i++){
					$ins_det_data = array(
						'invoice_id'   => $rrs,
						'sl_no'		   => $sl_no++,
						'group_name'   => '',
						'group_id'     => 0,
						'sub_group_name' => '',
						'item_order'   => $itm_order++,
						'item_name'	   => $item_name[$i],
						'quantity'	   => $quantity[$i],
						'amount'	   => $amount[$i],
						'item_discount' => $item_discount[$i],
						'vat_perce'		=> $vat_perce[$i],
						'vat_amount'	=> $vat_amount[$i],
						'net_amount'	=> $net_amount[$i],
						'description'   => '',
						'internal_comments' => $internal_comments,
						'uom'			=> $uom[$i],
						'uom_id'		=> $uom_id[$i]
					);
 					$this->Crud_Model->insert('furniture_invoice_details',$ins_det_data);
				}

				$total_amount = $total_vat_amount = $total_net_amount = 0;
				foreach ($amount as $key => $inv_amount) {
					$total_amount      += ($inv_amount - $item_discount[$key]);
					$total_vat_amount  += $vat_amount[$key];
					$total_net_amount  += $net_amount[$key];
				}
				$total_amount      = number_format($total_amount, 3);
				$total_vat_amount  = number_format($total_vat_amount, 3);
				//$total_net_amount  = number_format($invoice_amount, 3);
				$total_net_amount  = floatval($invoice_amount);
				if(!empty($round_off) || $round_off != 0){
					if($sign == '-'){
						$zerochecktotal   = ((floatval($total_amount)) + floatval($total_vat_amount)) - floatval($round_off);
						$ledger_roundoff  =  $round_off;
					//	echo $zerochecktotal; echo '<br>';
					}
					else{
						$zerochecktotal   = ((floatval($total_amount)) + floatval($total_vat_amount)) + floatval($round_off);
						$ledger_roundoff  =  number_format($round_off * -1 , 3, '.', '');

						//echo $zerochecktotal; echo '<br>';
						//echo $ledger_roundoff;
					}
					$zerochecktotal = ((floatval($total_amount)) + floatval($total_vat_amount))  ;
					$total_net_amount = floatval($invoice_amount);
				    $zerocheck        =  round(floatval($zerochecktotal - $total_net_amount), 10);
					//echo $invoice_amount; echo '<br>';
					//echo $total_net_amount; echo '<br>';
					//echo $zerochecktotal;  echo '<br>';
					//echo $zerocheck;
					//exit();
				}
				else{
					$zerochecktotal   = (floatval($total_amount)) + floatval($total_vat_amount);
					$zerocheck        =  round(floatval($zerochecktotal - $total_net_amount), 10);
					$ledger_roundoff  = 0 ;
				}

				if($zerocheck == 0){
					$invoice_no  = $this->Crud_Model->getlastInvoicenum($rrs);
					$client_code = $this->Crud_Model->getCustomerldgcode($client_id);
					$this->db->where("vch_no",$invoice_no);
					$this->db->where("vch_type",'SALES');
					$this->db->delete('accounts');

					$this->db->where("trn_no",$invoice_no);
					$this->db->where("bill_type",'Invoice');
					$this->db->where("trn_type",'Invoice');
					$this->db->delete('cust_bill_allocations');
			
					// $this->db->where("trans_no",$invoice_no);
					// $this->db->where("trans_type",6);
					// $this->db->delete('item_trans');

					if($total_net_amount > $total_amount &&  $total_net_amount > $total_vat_amount ){
						$ledger_amount  = $total_net_amount;
					}
					else if($total_amount > $total_net_amount  &&  $total_amount > $total_vat_amount ){
						$ledger_amount  = $total_amount;
					}
					else{
						$ledger_amount  = $total_vat_amount;
					}
					$l_total_amount 	 =  $total_amount == 0 ? '0.000' : ( number_format($total_amount * -1 , 3, '.', ''));
					$l_total_vat_amount  =  $total_vat_amount == 0 ? '0.000' : ( number_format($total_vat_amount * -1 ,3, '.', ''));
					$Accntdata   = array();
					$Accntdata[] = array(
						'vch_type'			=> 'SALES',
						'vch_no'			=> $invoice_no,
						'vch_date'			=> date('Y-m-d', strtotime($this->input->post('job_date'))),
						'ledger_code'   	=> $client_code,
						'cc_code'  	   		=> 1,
						'div_code'  		=> 1,
						'ledger_amount'	 	=> number_format($ledger_amount, 3,'.',''),
						'rev_ledger_code'	=> 'S0001',
						'vch_narration'		=> 'Auto entry from Invoice No "'.$invoice_no.'"',
						'created_date'		=> date("Y-m-d"),
						'user_id'           => $this->session->userdata('user_id'),						
					);
					$Accntdata[] = array(
						'vch_type'			=> 'SALES',
						'vch_no'			=> $invoice_no,
						'vch_date'			=> date('Y-m-d', strtotime($this->input->post('job_date'))),
						'ledger_code'   	=> 'R0001',
						'cc_code'  	   		=> 1,
						'div_code'  		=> 1,
						'ledger_amount'	 	=> $ledger_roundoff,
						'rev_ledger_code'	=> $client_code,
						'vch_narration'		=> 'Auto entry from Invoice No "'.$invoice_no.'"',
						'created_date'		=> date("Y-m-d"),
						'user_id'           => $this->session->userdata('user_id'),
					);
					$Accntdata[] = array(
						'vch_type'			=> 'SALES',
						'vch_no'			=> $invoice_no,
						'vch_date'			=> date('Y-m-d', strtotime($this->input->post('job_date'))),
						'ledger_code'   	=> 'S0001',
						'cc_code'  	   		=> 1,
						'div_code'  		=> 1,
						'ledger_amount'	 	=> $l_total_amount ,
						'rev_ledger_code'	=> $client_code,
						'vch_narration'		=> 'Auto entry from Invoice No "'.$invoice_no.'"',
						'created_date'		=> date("Y-m-d"),
						'user_id'           => $this->session->userdata('user_id'),
					);	
					$Accntdata[] = array(
						'vch_type'			=> 'SALES',
						'vch_no'			=> $invoice_no,
						'vch_date'			=> date('Y-m-d', strtotime($this->input->post('job_date'))),
						'ledger_code'   	=> 'V0001',
						'cc_code'  	   		=> 1,
						'div_code'  		=> 1,
						'ledger_amount'	 	=> $l_total_vat_amount,
						'rev_ledger_code'	=> $client_code,
						'vch_narration'		=> 'Auto entry from Invoice No "'.$invoice_no.'"',
						'created_date'		=> date("Y-m-d"),
						'user_id'           => $this->session->userdata('user_id'),
					);
					if(!empty($Accntdata)){				 
						$this->db->insert_batch('accounts',$Accntdata);						
					}					
					$cust_bill_allcdata = array(
						'customer_code' => $client_code,
						'bill_id'		=> $inv_id,
						'trn_no'		=> $invoice_no,
						'bill_date'		=> date('Y-m-d', strtotime($this->input->post('job_date'))),
						'bill_amt'      => number_format($total_net_amount,3, '.', ''),
						'bill_os_amount' => number_format($total_net_amount,3, '.', ''),
						'bill_type'		=> 'Invoice',
						'trn_type'      => 'Invoice',
						'sm_id'			=> 0,
						'division_id'   => $this->input->post('division_id'),
						'po_no'			=> $this->input->post('lpo_no'),
						'status'		=> 1
					);
					$this->db->insert('cust_bill_allocations',$cust_bill_allcdata);										
				}					
				else{
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'MissMatched Amount Calcution('.floatval($zerocheck).')...');
					redirect('invoices/invoice_from/'.$job_card_id.'');
				}
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'something went wrong please try again...');
					redirect('invoices/invoice_from/'.$job_card_id.'');
				}
				else{
					$date = date("Y-m-d H:i:s");
					$job_card_data= array(
						'jobcard_stage' =>40,			
					);
					$where_job_card = array(
						'id' => $job_card_id
					);
					$this->crud_model->update('job_card',$job_card_data,$where_job_card);
					$datajob_stage = array(
						'job_id' => $job_card_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 40,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);	

					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Invoice Created...');
					redirect('invoices');
				}
			}
		}
		else{
			$this->db->trans_rollback();
			$this->session->set_flashdata('response',  'something went wrong please try again...');
			redirect('invoices/invoice_from/'.$job_card_id.'');
		}
	}
}

?>