<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payment extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}


	public function list_payment($division_id="NIL",$filter_by="NIL",$filter_value="NIL") {
		$this->users_model->permission("Payment", "View");
		$title['headerTitle']="Payment List";
		$this->load->library('pagination');
		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		}elseif ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		if (@$this->input->post('filter_by')) {
			$filter_by =   $this->input->post("filter_by");
		}elseif ($filter_by != "NIL") {
			$filter_by	=	$filter_by;
		} else {
			$filter_by	= "NIL";
		}
		
		
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		$config["base_url"] = base_url() . "index.php/Payment/list_payment/".$division_id."/".$filter_by."/".$filter_value;
        $config["total_rows"] = $this->furniture_quotation_model->payrecord_count($division_id,$filter_by,$filter_value);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =6;
        $this->pagination->initialize($config);
        if ($this->uri->segment(6)) {
            $page = $this->uri->segment(6)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->get_all_payments($config["per_page"], $page,$division_id,$filter_by,$filter_value);
		$data['pagination'] = $this->pagination->create_links();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header',$title);
		$this->load->view('manage/list_payment',$data);
		$this->load->view('templates/footer');
	}

	function view1($quotation_id,$payment_no,$quotation_divisionid,$type){

		$where= array('receipt_number'=>$payment_no);
		$data['records'] = $this->furniture_quotation_model->get_payment_details($payment_no,$quotation_id,$quotation_divisionid);
		$data['receipt_inv'] = $this->furniture_quotation_model->get_all_payments_invdetails($payment_no,$quotation_id,$quotation_divisionid);
		$data['receipt_pay'] = $this->furniture_quotation_model->get_all_payments_paydetails($payment_no,$quotation_id,$quotation_divisionid);
		$data['ledgers_from_accounts'] = $this->furniture_quotation_model->get_all_ledgers_from_accounts($data['records'][0]['payment_code']);
		
		$data['logos_url'] 		= array();

		$data['payment_code'] 	  = $data['records'][0]['payment_code'];
		$data['receipt_number']   = $data['records'][0]['payment_number'];
		$data['division_code'] 	  = $data['records'][0]['division_code'];
		$data['currency_code'] 	  = $data['records'][0]['currency_code'];
		$data['payment_date'] 	  = $data['records'][0]['payment_date'];
		$data['payment_mode'] 	  = $data['records'][0]['payment_mode'];
		$data['payment_amount']   = $data['records'][0]['payment_amount'];
		$data['payment_discount'] = $data['records'][0]['payment_discount'];
		$data['payment_remarks']  = $data['records'][0]['payment_remarks'];
		$data['payment_bankname'] = $data['records'][0]['payment_bankname'];
		$data['payment_reference']= $data['records'][0]['payment_reference'];
		$data['currency_name1']   = $data['records'][0]['currency_name'];
		$data['payment_status']   = $data['records'][0]['payment_status'];
		$data['division_id']      = $data['records'][0]['division_id'];
		$data['division_code']    = $data['records'][0]['division_code'];
		$data['logo_filename']    = $data['records'][0]['logo_filename'];
		$data['client_code'] 	  = $data['records'][0]['supplier_code'];

		$temp = $data['records'][0]['payment_generatedby'];
		$where= array('user_id'=>$temp);
		$generated_by_user = $this->crud_model->get('users',$where);
		$data["generated_by"] = $generated_by_user[0]['user_name'];
		$data["received_from"] = $data['records'][0]['supplier_name'];

		$data['quotation_id'] = $quotation_id;
		
		$query = $this->db->get('company_details');  
		$data['company_details'] = $query->row();
		foreach ($query->result() as $row){
			$company_email_name =  $row->company_name;
		}
		
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$mpdf = new \Mpdf\Mpdf();
			$html = $this->load->view('manage/view_payment', $data, true);
			$mpdf->WriteHTML($html);
			$file_name	=	'Payment Voucher - '.$data['records'][0]['payment_code'];
			$mpdf->Output($file_name, 'I');
		}
	}
	
	public function create_payment(){
		$this->users_model->permission("Payment", "Add");
		$title['headerTitle']="New Payment";
		$data['cash_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
		$data['bank_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
		$this->load->view('templates/header',$title);
		$this->load->view('manage/createPayment',$data);
		$this->load->view('templates/footer');
	}
	
	function search_client_for_payment() {
		$html='';
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array('supplier_master.supplier_name'=>$search_mob);
		
		}else{
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array();
		}
		
		$this->db->select('supplier_master.supplier_id,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.address,supplier_master.mobile_no,supplier_master.supplier_telephone2,supplier_master.supplier_email,supplier_master.supplier_fax,supplier_master.tax_name');
		$this->db->from('supplier_master');
		$this->db->where($where);
		$this->db->like($like);
		$this->db->limit(25);
		$rs = $this->db->get();
		$records['client_list'] = $rs->result_array();
		if($records['client_list'] == false ){
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
			echo $html;
		} else {
			foreach($records['client_list'] as $index=>$client_entry) {
				$html.='<li  tabindex="-1"  value="' .$client_entry['supplier_id'] .'" ref="' .$search_name .'" data-client_code="' .$client_entry['supplier_code'] .'" data-client_name="' .$client_entry['supplier_name'] .'" class="client_buttonxxxxx" >'. $client_entry['supplier_name'] . '</li>';
			}
			echo $html;
		}
	}


	function get_outstanding_payments(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$invoices=$this->furniture_quotation_model->get_outstanding_payment($client_id,$ref_division);

        if ($invoices != false){
				foreach($invoices as $index =>$invoice){
				$amount_paid = $invoice['paid_amount'];
				$invoices[$index]['amount_paid'] =$amount_paid;
				/* if($invoice['invoice_amount']<0){
					if($invoice['paid_amount']>=0){
						$invoices[$index]['balance_amount'] =$invoice['invoice_amount']+$amount_paid;
					} else {
						$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
					}
				} else {
					$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
				} */
			}
        }
		
		$records['invoices'] = $invoices;
		//if($records['invoices'] == false ){
		//	echo '<li style="color:red; font-size:14.5px;">No Invoice List Available..!</li>';
		//} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_payment', $records);
		//}
	}
	

	public function validate_amount($amount) {
		$net_amount = (float)$this->input->post('cash') + (float)$this->input->post('c_card') + (float)$this->input->post('cheque_amt') + (float)$this->input->post('wallet_amnt');
		$total_paying_amount = 0;
		$no_of_invoices = $this->input->post('no_of_invoices');	
		for ($i = 1; $i <= $no_of_invoices; $i++) {
			$total_paying_amount = $total_paying_amount + (float)$this->input->post("current_amount_invoice_" . $i);
		}
		$total_paying_amount=$total_paying_amount+(float)$this->input->post('advance_payment');
		$common_ledger_code=$this->input->post('common_ledger_code');
		$common_led_amount =$this->input->post('common_led_amount');
		for($kn=0;$kn<count($common_ledger_code);$kn++){
			if($common_ledger_code[$kn]!=='' &&  $common_led_amount[$kn]!=='' ){
				$total_paying_amount = $total_paying_amount + (float)$common_led_amount[$kn];
			}
		}

		if ($net_amount == ROUND($total_paying_amount,3)) {
			return true;
		} else {
			$this->form_validation->set_message('validate_amount', 'The total amount does not match the total paying amount.');
			return false;
		}
	}


	public function save_payment_new(){
		$this->users_model->permission("Payment", "Add");
		$this->form_validation->set_rules('payment_date','Date', 'required');
		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		$this->form_validation->set_rules('clientIdHidden','Client', 'required');
		$this->form_validation->set_rules('client_code','Client', 'required');
		if($this->input->post('cash_check')==1){
			$this->form_validation->set_rules('cash_ledgers','Cash Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cash_ledger_code','Cash Ledger', 'required');
		}
		if($this->input->post('c_card_check')==1){
			$this->form_validation->set_rules('c_card_ledgers','C Card Ledgers', 'required');
		} else {
			$this->form_validation->set_rules('c_card_ledger_code','C Card Ledger', 'required');
		}
		if($this->input->post('wallet_check')==1){
			$this->form_validation->set_rules('wallet_ledgers','Wallet Ledger', 'required');
		} else {
			$this->form_validation->set_rules('wallet_ledger_code','Wallet Ledger', 'required');
		}
		if($this->input->post('cheque_check')==1){
			$this->form_validation->set_rules('cheque_ledgers','Cheque Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cheque_ledger_code','Cheque Ledger', 'required');
		}
		$this->form_validation->set_rules('amount', 'Amount', 'callback_validate_amount');

		if ($this->form_validation->run() == FALSE) {
			$data['cash_ledgers'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
			$data['bank_ledgers'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
			$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('manage/createPayment',$data);
			$this->load->view('templates/footer');
		} else {
			$largest=max((float)$this->input->post('c_card'),(float)$this->input->post('cheque_amt'),(float)$this->input->post('wallet_amnt'),(float)$this->input->post('cash'));
			if((float)$this->input->post('cash')==$largest) {
				if($this->input->post('cash_check')==1){
					$rev_ledger_code=$this->input->post('cash_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cash_ledger_code');
				}
			} else if((float)$this->input->post('c_card')==$largest){
				if($this->input->post('c_card_check')==1){
					$rev_ledger_code=$this->input->post('c_card_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('c_card_ledger_code');
				}
			}  else if((float)$this->input->post('wallet_amnt')==$largest) {
				if($this->input->post('wallet_check')==1){
					$rev_ledger_code=$this->input->post('wallet_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('wallet_ledger_code');
				}
			} else if((float)$this->input->post('cheque_amt')==$largest) {
				if($this->input->post('cheque_check')==1){
					$rev_ledger_code=$this->input->post('cheque_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cheque_ledger_code');
				}
			}
			$this->db->trans_begin();
			$no_of_invoices = $this->input->post('no_of_invoices');	
			$no_of_adv_receipts = $this->input->post('no_of_adv_receipts');

			$SQL = "SELECT MAX(payment_number)+1 as `new_payment_number` FROM furniture_payments where quotation_divisionid='".$this->input->post('ref_div_id')."';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			
			if($data[0]['new_payment_number'] != NULL and $data[0]['new_payment_number'] != ""){
				$payment_no = $data[0]['new_payment_number'];
			} else{
				$payment_no = 1;
			}

			$ref_div_id	=	$this->input->post('ref_div_id');
			$payment_code = $this->furniture_quotation_model->get_payment_code($ref_div_id,$payment_no);
			$payment_date = strtotime( $this->input->post('payment_date') );
			$mysqldate 	  = date( 'Y-m-d h:m:s', $payment_date);
			$receipt['payment_number']= $payment_no;
			$receipt['payment_code']  = $payment_code;
			$receipt['client_id']   = $this->input->post('clientIdHidden');
			$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
			$receipt['payment_date']  = $mysqldate;
			$receipt['payment_mode'] = @$this->input->post("payment_modes");
			$receipt['payment_amount'] = ((float)$this->input->post('i_total'));
			$receipt['payment_reference'] = $this->input->post("ref_number");
			$receipt['payment_bankname'] = $this->input->post("bank_name");
			$receipt['payment_remarks'] = $this->input->post("remarks");
			$receipt['payment_generatedby'] = $this->session->userdata("user_id");
			$rcpt = $this->crud_model->insert('furniture_payments',$receipt);
			$payment_id = $this->db->insert_id();

			$xxreceipt_discount	= 0;
			$xxreceipt_amount	= 0;
			$total_paying_amount= 0;
			$division_id		= $this->input->post('ref_div_id');

			for($z=1;$z<=$no_of_adv_receipts;$z++) {
				$total_paying_amount=$total_paying_amount-(float)$this->input->post("adv_current_amount_invoice_".$z);
				$adv_current_amount_invoice ="adv_current_amount_invoice_".$z;
				$adv_amount = $this->input->post($adv_current_amount_invoice);
				$adv_nbbbamount = $this->input->post($adv_current_amount_invoice);
				$adv_invoice_id ="adv_invoice_id_".$z;
				$advinvid = $this->input->post($adv_invoice_id);
				if($adv_amount!="" && $adv_amount!="0"){
					$adv_receiptdts['payment_amount'] = $adv_amount;
					$adv_receiptdts['payment_discount'] = 0;
					$adv_receiptdts['balance_amount'] = 0;
					$adv_receiptdts['payment_id'] = $payment_id;
					$adv_receiptdts['invoice_id'] = $advinvid;
					$inv2 = $this->crud_model->insert('payment_details',$adv_receiptdts);
					if($inv2){
						$cust_bill_allocations_data = array(
							'supplier_code' => $this->input->post('client_code'),
							'bill_id'       => $advinvid,
							'trn_no'        => $payment_code,
							'bill_date'     => $mysqldate,
							'bill_amt'      => ((float)$adv_nbbbamount),
							'bill_os_amount'=> ((float)$adv_nbbbamount),
							'bill_type'     => 'Payment',
							'division_id'   => $this->input->post('ref_div_id'),
							'trn_type'      => 'Payment'
						);			
						$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
					}
				}		
			}


			for($i=1;$i<=$no_of_invoices;$i++) {
				$total_paying_amount=$total_paying_amount+(float)$this->input->post("current_amount_invoice_".$i);
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$xxreceipt_discount=$xxreceipt_discount+(float)$this->input->post("receipt_discount_".$i);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				if($amount!="" && $amount!="0"){
					$receiptdts['payment_amount'] = $amount;
					$receiptdts['payment_discount'] = $this->input->post("receipt_discount_".$i);
					$receiptdts['balance_amount'] = $bal_amount;
					$receiptdts['payment_id'] = $payment_id;
					$receiptdts['invoice_id'] = $invid;
					$inv = $this->crud_model->insert('payment_details',$receiptdts);
					if($inv){
						$cust_bill_allocations_data = array(
							'supplier_code' => $this->input->post('client_code'),
							'bill_id'       => $invid,
							'trn_no'        => $payment_code,
							'bill_date'     => $mysqldate,
							'bill_amt'      => ((float)$nbbbamount)*-1,
							'bill_os_amount'=> ((float)$nbbbamount)*-1,
							'bill_type'     => 'Payment',
							'division_id'   => $division_id,
							'trn_type'      => 'Payment'
						);
						$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
					}
				}
			}

			if($payment_id){
				
				if($this->input->post('advance_payment')!='' && $this->input->post('advance_payment')!='0' && $this->input->post('advance_payment')!='0.000' ){
					$cust_bill_allocations_data = array(
						'supplier_code' => $this->input->post('client_code'),
						'bill_id'       => $payment_code,
						'trn_no'        => $payment_code,
						'bill_date'     => $mysqldate,
						'bill_amt'      => ((float)$this->input->post('advance_payment'))*-1,
						'bill_os_amount'=> ((float)$this->input->post('advance_payment'))*-1,
						'bill_type'     => 'Payment',
						'division_id'   => $division_id,
						'trn_type'      => 'Payment'
					);
					$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
				}

				if($this->input->post('client_code')!=''){
					if($xxreceipt_discount>0){
						$xxreceipt_amount	=	$total_paying_amount+(float)$xxreceipt_discount+(float)$this->input->post('advance_payment');
					} else {
						$xxreceipt_amount	=	$total_paying_amount+(float)$this->input->post('advance_payment');
					}
					$this->db->where("vch_no",$payment_code);
					$this->db->where("vch_type",'PAYMENT');
					$this->db->delete('accounts');
					$accounts_data[] = array(
						'vch_type' 	  => 'PAYMENT',
						'vch_no'  	  => $payment_code,
						'vch_date'    => $mysqldate,
						'vch_ref'     => '',
						'ledger_code' => $this->input->post('client_code'),
						'rev_ledger_code' => $rev_ledger_code,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> (float)$xxreceipt_amount,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					//$this->db->insert('accounts', $accounts_data);
				}

				if($xxreceipt_discount>0){
					$accounts_data[] = array(
						'vch_type' 	  => 'PAYMENT',
						'vch_no'  	  => $payment_code,
						'vch_date'    => $mysqldate,
						'vch_ref'     => '',
						'ledger_code' => 'D0002',
						'rev_ledger_code' => $this->input->post('client_code'),
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> -(float)$xxreceipt_discount,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					//$this->db->insert('accounts', $accounts_data);
				}

				if($this->input->post('cash')!==''){
					$paidData = array(
						'payment_id' 		=> $payment_id,
						'amount' 			=> $this->input->post('cash'),
						'name' 				=> 'Paid Amount',
						'payment_mode' 		=> 'Paid Amount'
					);
					$this->db->insert('payment_mode_details', $paidData);
					
					$data = array(
						'payment_id' 		=> $payment_id,
						'amount' 			=> ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
						'name' 				=> 'Cash',
						'payment_mode' 		=> 'Cash'
					);
					$this->db->insert('payment_mode_details', $data);
					if($this->input->post('cash_check')==1){
						$cash_ledger_code=$this->input->post('cash_ledgers');
					} else {
						$cash_ledger_code=$this->input->post('cash_ledger_code');
					}
					if($cash_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'PAYMENT',
							'vch_no'  	  => $payment_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Cash',
							'ledger_code' => $cash_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => (((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')))*-1,
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}
				}
				if($this->input->post('c_card')!=''){
					$data = array(
						'payment_id' 		=> $payment_id,
						'amount' 			=> $this->input->post('c_card'),
						'authorized' 		=> $this->input->post('authorized'),
						'name' 				=> $this->input->post('c_type'),
						'payment_mode' 		=> 'Credit Card'
					);
					$this->db->insert('payment_mode_details', $data);
					if($this->input->post('c_card_check')==1){
						$c_card_ledger_code	=	$this->input->post('c_card_ledgers');
					} else {
						$c_card_ledger_code	=	$this->input->post('c_card_ledger_code');
					}
					if($c_card_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'PAYMENT',
							'vch_no'  	  => $payment_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Credit Card',
							'ledger_code' => $c_card_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> -(float)$this->input->post('c_card'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}	
				}
				if($this->input->post('cheque_amt')!=''){
					$data = array(
						'payment_id' 		=> $payment_id,
						'amount' 			=> $this->input->post('cheque_amt'),
						'authorized' 		=> $this->input->post('cheque_no'),
						'name' 				=> $this->input->post('cheque_bank'),
						'payment_mode' 		=> 'Cheque'
					);
					$this->db->insert('payment_mode_details', $data);
					if($this->input->post('cheque_check')==1){
						$cheque_ledger_code	=	$this->input->post('cheque_ledgers');
					} else {
						$cheque_ledger_code	=	$this->input->post('cheque_ledger_code');
					}
					if($cheque_ledger_code!=''){
						
						$accounts_data[] = array(
							'vch_type' 	  => 'PAYMENT',
							'vch_no'  	  => $payment_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Cheque',
							'ledger_code' => $cheque_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> -(float)$this->input->post('cheque_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}
					
				}
				if($this->input->post('wallet_amnt')!=''){
					$data = array(
						'payment_id'  => $payment_id,
						'amount' 	  => $this->input->post('wallet_amnt'),
						'authorized'  => $this->input->post('wallet_authorized'),
						'name' 		  => $this->input->post('wallet_type'),
						'payment_mode'=> 'Wallet'
					);
					$this->db->insert('payment_mode_details', $data);

					if($this->input->post('wallet_ledger_code')!=''){
						if($this->input->post('wallet_check')==1){
							$wallet_ledger_code	=	$this->input->post('wallet_ledgers');
						} else {
							$wallet_ledger_code	=	$this->input->post('wallet_ledger_code');
						}
						$accounts_data[] = array(
							'vch_type' 	  => 'PAYMENT',
							'vch_no'  	  => $payment_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Wallet',
							'ledger_code' => $wallet_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> -(float)$this->input->post('wallet_amnt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}
				}

				$common_ledger_code=$this->input->post('common_ledger_code');
				$common_led_amount =$this->input->post('common_led_amount');
				$common_led_remarks=$this->input->post('common_led_remarks');
				for($kn=0;$kn<count($common_ledger_code);$kn++){
					if($common_ledger_code[$kn]!=='' &&  $common_led_amount[$kn]!=='' ){
						$accounts_data[] = array(
							'vch_type' 	  => 'PAYMENT',
							'vch_no'  	  => $payment_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Ledger',
							'ledger_code' => $common_ledger_code[$kn],
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> (float)$common_led_amount[$kn],
							'ledger_narration'=> $common_led_remarks[$kn],
							'vch_narration'=> 'Auto entry from Payment No '.$payment_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
					}
				}
				$this->db->insert_batch('accounts', $accounts_data);
			}

			$account_result =$this->furniture_quotation_model->validate_debit_or_credit($payment_code,'PAYMENT');
			if($account_result===false){
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Debit amount and Credit amount are not equal...');	
				redirect('Payment/list_payment');
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
				redirect('Payment/list_payment');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'New Payment Created...');	
				redirect('Payment/list_payment');
		 	}
			
		}
	}
	
	
	public function cancel_payment($receipt_number,$quotation_divisionid,$receipt_id,$receipt_code){
		$this->users_model->permission("Payment", "Delete");
		$this->db->where('payment_number',$receipt_number);
		$this->db->where('quotation_divisionid',$quotation_divisionid);
		$data = array(
			'payment_status' => 0,
			'payment_cancelledby' => $this->session->userdata('user_name'),
			'payment_cancelled_date' => date('Y-m-d h:m:s')
		);
		$payment_cancel	= $this->db->update('furniture_payments', $data);

		$this->db->where('trn_no',$receipt_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('supplier_bill_allocations', $data1);

		$this->db->where('vch_type','PAYMENT');
		$this->db->where('vch_no',$receipt_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);
				
		
		if($payment_cancel){
			$this->session->set_flashdata('response', 'Payment Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('Payment/list_payment');
	}
}

?>