<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PurchaseBillOutstanding extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	
	
	
	public function by_party($status='') {
		$this->users_model->permission("SalesBillOutstandingby_party", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('client_code', 'Client', 'required');
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['supplier_bill_allocations.status'] = 1;
				/* if($this->input->post('user_id') != '0' ) {
					$where['supplier_bill_allocations.sm_id'] = $this->input->post('user_id');
				} */
				if($this->input->post('quotation_status') != '' ) {
					$where['supplier_bill_allocations.status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('client_code') != '' ) {
					$where['supplier_bill_allocations.supplier_code'] = $this->input->post('client_code');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['supplier_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				//$where['bill_type'] = 'Invoice';

				$this->db->select('supplier_bill_allocations.id,supplier_bill_allocations.bill_id,supplier_bill_allocations.bill_type,supplier_bill_allocations.trn_no,supplier_bill_allocations.bill_date,supplier_bill_allocations.status,supplier_bill_allocations.bill_amt,supplier_bill_allocations.bill_os_amount,(`supplier_bill_allocations`.`bill_amt`-`supplier_bill_allocations`.`bill_os_amount`) as openig_paid,supplier_bill_allocations.sup_ref,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.credit_days' );
				$this->db->from('supplier_bill_allocations');
				$this->db->where($where);
				$this->db->join('supplier_master','supplier_bill_allocations.supplier_code = supplier_master.supplier_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				//$this->db->join('users','supplier_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by('supplier_bill_allocations.bill_id');
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				//echo $this->db->last_query();
				/* if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				} */
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();

			$this->load->view('templates/header');
			$this->load->view('reports/purchase_bill_outstanding_by_party',$data);
			$this->load->view('templates/footer');
		}
	}

	public function by_party_age_wise($status='') {
		$this->users_model->permission("PurchaseBillOutstandingby_party_age_wise", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('client_code', 'Client', 'required');
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['supplier_bill_allocations.status'] = 1;
				/* if($this->input->post('user_id') != '0' ) {
					$where['supplier_bill_allocations.sm_id'] = $this->input->post('user_id');
				} */
				if($this->input->post('quotation_status') != '' ) {
					$where['supplier_bill_allocations.status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('client_code') != '' ) {
					$where['supplier_bill_allocations.supplier_code'] = $this->input->post('client_code');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['supplier_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				//$where['bill_type'] = 'Invoice';

				$this->db->select('supplier_bill_allocations.id,supplier_bill_allocations.bill_id,supplier_bill_allocations.bill_type,supplier_bill_allocations.trn_no,supplier_bill_allocations.bill_date,supplier_bill_allocations.status,supplier_bill_allocations.bill_amt,supplier_bill_allocations.bill_os_amount,supplier_bill_allocations.sup_ref,supplier_bill_allocations.sup_ref,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.credit_days' );
				$this->db->from('supplier_bill_allocations');
				$this->db->where($where);
				$this->db->join('supplier_master','supplier_bill_allocations.supplier_code = supplier_master.supplier_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				//$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by('supplier_bill_allocations.bill_id');
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				/* if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				} */
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();

			$this->load->view('templates/header');
			$this->load->view('reports/purchase_bill_outstanding_by_party_age_wise',$data);
			$this->load->view('templates/footer');
		}
	}

	public function all_customers($status='') {
		$this->users_model->permission("PurchaseBillOutstandingall", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['supplier_bill_allocations.status'] = 1;
				
				
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['supplier_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				$where['bill_type'] = 'Purchase Invoice';

				$this->db->select('supplier_bill_allocations.id,supplier_bill_allocations.bill_id,supplier_bill_allocations.trn_no,supplier_bill_allocations.supplier_code,supplier_bill_allocations.bill_date,supplier_bill_allocations.status,sum(`supplier_bill_allocations`.`bill_amt`) as bill_amt, sum(`supplier_bill_allocations`.`bill_os_amount`) as bill_os_amount,sum(`supplier_bill_allocations`.`bill_amt`)-sum(`supplier_bill_allocations`.`bill_os_amount`) as openig_paid,supplier_bill_allocations.sup_ref,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.credit_days' );
				$this->db->from('supplier_bill_allocations');
				$this->db->where($where);
				$this->db->join('supplier_master','supplier_bill_allocations.supplier_code = supplier_master.supplier_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				$this->db->group_by("`supplier_bill_allocations`.`supplier_code`");
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				
				/* if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				} */
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$this->load->view('templates/header');
			$this->load->view('reports/purchase_bill_outstanding_all',$data);
			$this->load->view('templates/footer');
		}
	}

	public function all_customers_age_wise($status='') {
		$this->users_model->permission("PurchaseBillOutstandingall_age_wise", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_to', 'Date', 'required|callback_date_check');
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				$data['quotation_type'] = "furniture";
				$where = array();
				$where['supplier_bill_allocations.status'] = 1;
				
				
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['supplier_bill_allocations.division_id'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['DATE(supplier_bill_allocations.bill_date) >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['DATE(supplier_bill_allocations.bill_date) <='] = $date_to;
					}
				}

				$where['bill_type'] = 'Purchase Invoice';

				$this->db->select('supplier_bill_allocations.id,supplier_bill_allocations.bill_id,supplier_bill_allocations.trn_no,supplier_bill_allocations.supplier_code,supplier_bill_allocations.bill_date,supplier_bill_allocations.status,sum(`supplier_bill_allocations`.`bill_amt`) as bill_amt, sum(`supplier_bill_allocations`.`bill_os_amount`) as bill_os_amount,sum(`supplier_bill_allocations`.`bill_amt`)-sum(`supplier_bill_allocations`.`bill_os_amount`) as openig_paid,supplier_bill_allocations.sup_ref,supplier_master.supplier_name,supplier_master.supplier_code,supplier_master.credit_days' );
				$this->db->from('supplier_bill_allocations');
				$this->db->where($where);
				$this->db->join('supplier_master','supplier_bill_allocations.supplier_code = supplier_master.supplier_code','left');
				//$this->db->join('furniture_invoice','cust_bill_allocations.trn_no = furniture_invoice.invoice_number','left');
				//$this->db->join('users','cust_bill_allocations.sm_id = users.user_id','left');
				$this->db->group_by("`supplier_bill_allocations`.`supplier_code`");
				$rs = $this->db->get();
				$data['records']=$rs->result_array();
				/* if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				} */
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}	
		
		$user_records = $this->crud_model->get('users');
		if($user_records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($user_records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$this->load->view('templates/header');
			$this->load->view('reports/purchase_bill_outstanding_all_customers_age_wise',$data);
			$this->load->view('templates/footer');
		}
	}
	
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		if($given_date <= $today_date) {
			return true;
		}else{
			$this->form_validation->set_message('date_check', 'Date cannot be Future date');
			return FALSE;
		}
	}

	public function searchSupplier() {
		$client	=	$this->input->post('client');
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` WHERE `supplier_name` LIKE  '%$client%'");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['supplier_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['supplier_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['supplier_code'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['address'].'" />'.$client_contact_datas['supplier_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}
}

?>