<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Receipt extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}


	public function list_receipt($division_id="NIL",$filter_by="NIL",$filter_value="NIL") {
		$this->load->library('pagination');
		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		}elseif ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		if (@$this->input->post('filter_by')) {
			$filter_by =   $this->input->post("filter_by");
		}elseif ($filter_by != "NIL") {
			$filter_by	=	$filter_by;
		} else {
			$filter_by	= "NIL";
		}
		
		
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		$config["base_url"] = base_url() . "index.php/receipt/list_receipt/".$division_id."/".$filter_by."/".$filter_value;
        $config["total_rows"] = $this->furniture_quotation_model->rnbrecord_count($division_id,$filter_by,$filter_value);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =6;
        $this->pagination->initialize($config);
        if ($this->uri->segment(6)) {
            $page = $this->uri->segment(6)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->nbget_all_receipts($config["per_page"], $page,$division_id,$filter_by,$filter_value);
		$data['pagination'] = $this->pagination->create_links();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header');
		$this->load->view('manage/receipts',$data);
		$this->load->view('templates/footer');
	}

	public function index($quotation_id=0) {
		$this->data['receipts'] = $this->furniture_quotation_model->get_all_receipts();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header');
		$this->load->view('manage/receipts',$this->data);
		$this->load->view('templates/footer');
	}
	
	public function create_receipt(){
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
		$this->load->view('templates/header');
		$this->load->view('manage/createReceipt',$data);
		$this->load->view('templates/footer');
	}
	
	function search_client_for_receipt() {
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array('furniture_invoice.client'=>$search_mob);
		
		}else{
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array();
		}
		$this->db->distinct();
		$this->db->select('new_client_master.client_id,new_client_master.client_code,new_client_master.client_name,new_client_master.client_address,new_client_master.client_country,new_client_master.client_telephone1,new_client_master.client_telephone2,new_client_master.client_fax,new_client_master.client_email,furniture_invoice.quotation_divisionid');
		$this->db->from('furniture_invoice');
		$this->db->join('new_client_master', 'new_client_master.client_id = furniture_invoice.client_id','inner');
		$this->db->where($where);
		$this->db->where('furniture_invoice.invoice_status', '0'); 
		$this->db->like($like);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$records['client_list'] = $rs->result_array();
			if($records['client_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('manage/search_clients', $records);
			//$this->load->view('manage/search_result_receipt', $records);
		}
		}
		
		//$records['client_list']=$this->crud_model->get('new_client_master',array(), null,null,null,null,$like, $or_where);
		
	
		
		
	}
	
	function search_client_for_receiptxx() {
		$html='';
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array('furniture_invoice.client'=>$search_mob);
		
		}else{
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array();
		}
		
		
		$this->db->distinct();
		$this->db->select('new_client_master.client_id,new_client_master.client_name,new_client_master.client_address,new_client_master.client_country,new_client_master.client_telephone1,new_client_master.client_telephone2,new_client_master.client_fax,new_client_master.client_email,furniture_invoice.quotation_divisionid');
		$this->db->from('furniture_invoice');
		$this->db->join('new_client_master', 'new_client_master.client_id = furniture_invoice.client_id','inner');
		$this->db->where($where);
		$this->db->where('furniture_invoice.invoice_status', '0'); 
		$this->db->like($like);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$records['client_list'] = $rs->result_array();
			if($records['client_list'] == false ){
				$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
				echo $html;
			} else {
				foreach($records['client_list'] as $index=>$client_entry) {
					$html.='<li   value="' .$client_entry['client_id'] .'" ref="' .$client_entry['quotation_divisionid'] .'" class="client_buttonxxxxx" >'. $client_entry['client_name'] . '</li>';
			
				}
			
			echo $html;
			}
		}
		
		//$records['client_list']=$this->crud_model->get('new_client_master',array(), null,null,null,null,$like, $or_where);
		
	
		
		
	}

	/*$where = '(furniture_invoice.client_id ="'.$client_id.'" AND furniture_invoice.quotation_divisionid ="'.$ref_division.'" AND (furniture_invoice.invoice_amount > furniture_invoice.paid_amount) AND furniture_invoice.invoice_status!="1")';
		//$invoices=$this->furniture_quotation_model->get_outstanding_invoices_new($client_id,$ref_division);
		$this->db->select('*');
		$this->db->from('furniture_invoice');
		$this->db->join('company_division','company_division.division_id=furniture_invoice.quotation_divisionid','inner');
		$this->db->join('new_client_master','new_client_master.client_name=furniture_invoice.client','left');
		$this->db->where($where);
		$this->db->group_by("furniture_invoice.invoice_id");
		$rs = $this->db->get();*/


	/*function get_outstanding_invoices(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$invoices=$this->furniture_quotation_model->get_outstanding_invoices_new($client_id,$ref_division);

                if ($invoices != false){
                foreach($invoices as $index =>$invoice){
			$quotation_id = $invoice['quotation_id'];
			//$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
			$amount_paid = $invoice['paid_amount'];
                        $invoices[$index]['amount_paid'] =$amount_paid;
						
					
			$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
		
		}
                }
		$records['invoices'] = $invoices;
		if($records['invoices'] == false ){
			echo '<label style="color:red; font-size:14.5px;">No Invoice List Available..!</label>';
		} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_receipt', $records);

		}
	}*/

	function get_outstanding_invoices(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$invoices=$this->furniture_quotation_model->get_outstanding_invoices_new2($client_id,$ref_division);

        if ($invoices != false){
            foreach($invoices as $index =>$invoice){
			$quotation_id = $invoice['quotation_id'];
			//$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
			$amount_paid = $invoice['paid_amount'];
            $invoices[$index]['amount_paid'] =$amount_paid;
						
					
			$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
		
		}
                }
		
		$records['invoices'] = $invoices;
		if($records['invoices'] == false ){
			echo '<label style="color:red; font-size:14.5px;">No Invoice List Available..!</label>';
		} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_receipt', $records);

		}
	}

	function get_confirmed_quotations(){
		$client_id = $this->input->post('client_id');
		//$invoices = $this->furniture_quotation_model->get_outstanding_invoices($client_id);
		$invoices = $this->furniture_quotation_model->get_confirmed_quotes ($client_id);
              /*
                $not_included_quotations = array();
                if ($invoices != false ) {
                foreach($invoices as $index =>$invoice){
			if($invoice['invoice_number']){
				array_push($not_included_quotations,$invoice['invoice_id']);
			}
		}
                }
                */
		$confirmed_quotations = $this->furniture_quotation_model->get_confirmed_quotations($client_id,$not_included_quotations);
		if(is_array($confirmed_quotations)){
		foreach($confirmed_quotations as $index =>$invoice){
			$quotation_id = $invoice['id'];
			$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
			$confirmed_quotations[$index]['amount_paid'] =$amount_paid;
			$confirmed_quotations[$index]['balance_amount'] =$invoice['quotation_total']- $amount_paid;
		}
		}
		$records['confirmed_quotations'] = $confirmed_quotations;
		//var_dump($records['invoices']); exit;
		if($records['confirmed_quotations'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('manage/receipts_confirmed_quotations', $records);
			
		}
		
	}
	
	public function save_receipt_new_temp(){
		$no_of_invoices = $this->input->post('no_of_invoices');		
		$SQL = "SELECT MAX(receipt_number)+1 as `new_receipt_number` FROM furniture_receipts where quotation_divisionid='".$this->input->post('ref_div_id')."';";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		
		if($data[0]['new_receipt_number'] != NULL and $data[0]['new_receipt_number'] != ""){
			$receipt_no = $data[0]['new_receipt_number'];
		} else{
			$receipt_no = 101;
		}
				
		$receipt['receipt_number'] = $receipt_no;
		$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
		$receipt['receipt_date'] = date("Y-m-d h:m:s");
		$receiptd['receipt_mode'] = $this->input->post("payment_modes");
		$receipt['receipt_amount'] = ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt'));
		$receipt['receipt_reference'] = $this->input->post("ref_number");
		$receipt['receipt_bankname'] = $this->input->post("bank_name");
		$receipt['receipt_id'] = $this->input->post("remarks");
		$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
		$receiptdts['invoice_id'] = 0;
		//$this->furniture_quotation_model->set_receipt_id($quotation_id);
		//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
		//$where= array('receipt_id'=>$generated_receipt_id);
		$rcpt = $this->crud_model->insert('furniture_receipts',$receipt);
		//$receipt_no = $this->furniture_quotation_model->get_new_receipt_number();
		//$amount = $this->input->post($current_amount_invoice);
		$receipt_id = $this->db->insert_id();
			for($i=1;$i<=$no_of_invoices;$i++)
			{
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				if($amount!="" && $amount!="0"){
						//$receipt['quotation_id'] = $quotation_id;
						$receiptdts['receipt_amount'] = $amount;
						$receiptdts['receipt_discount'] = $this->input->post("receipt_discount_".$i);
						$receiptdts['balance_amount'] = $bal_amount;
						$receiptdts['receipt_id'] = $receipt_id;
						$receiptdts['invoice_id'] = $invid;
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						$inv = $this->crud_model->insert('receipts_details',$receiptdts);
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						if($inv){
							$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_invoice($invid);
							$receipt_discount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($invid);
							$creceipt_discount=$this->input->post("receipt_discount_".$i);
							$invoiceWhere = array('invoice_id' => $invid);
							$invoiceData = array('paid_amount' =>  (float)$paid_amount+ (float)$amount,'receipt_discount' =>  (float)$receipt_discount+ (float)$creceipt_discount);
							$invupdate = $this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);

							$division_id=$this->input->post('ref_div_id');
							$div_data = $this->db->query("SELECT * FROM `company_division` WHERE division_id='$division_id' ");
							$division_code=$div_data->row()->division_code;  

							$cust_bill_allocations_data = array(
								'customer_code' => $this->input->post('clientIdHidden'),
								'bill_id'         => $invid,
								'trn_no'       => $division_code.'-'.$receipt_no,
								'bill_date'         => date("Y-m-d h:m:s"),
								'bill_amt'       => -((float)$nbbbamount),
								'bill_os_amount'     => -((float)$nbbbamount),
								'bill_type'       => 'Receipt',
								'trn_type'               =>  'Receipt'
							);
								
							$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
						}
				}
					
			}
			if($receipt_id){
			
				if($this->input->post('cash')!==''){
					$paidData = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cash'),
						'name' 				=> 'Paid Amount',
						'payment_mode' 		=> 'Paid Amount'
					);
					$this->db->insert('receipt_payment_details', $paidData);
					
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
						'name' 				=> 'Cash',
						'payment_mode' 		=> 'Cash'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('c_card')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('c_card'),
						'authorized' 		=> $this->input->post('authorized'),
						'name' 				=> $this->input->post('c_type'),
						'payment_mode' 		=> 'Credit Card'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('cheque_amt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cheque_amt'),
						'authorized' 		=> $this->input->post('cheque_no'),
						'name' 				=> $this->input->post('cheque_bank'),
						'payment_mode' 		=> 'Cheque'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('wallet_amnt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('wallet_amnt'),
						'authorized' 		=> $this->input->post('wallet_authorized'),
						'name' 				=> $this->input->post('wallet_type'),
						'payment_mode' 		=> 'Wallet'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
		}
		if($inv){
		$SQLRECEIPT = "SELECT MAX(receipt_id) as `receipt_id` FROM furniture_receipts;";
		$receipt_result = $this->db->query($SQLRECEIPT);
		$receipt_details = $receipt_result->result_array();
		$receipt_id = $receipt_details[0]['receipt_id'];
		
		// MAILING ....

				/* mail recpt nbas close start $INVOICESQL = "SELECT company_division.division_code AS division_name,company_division.currency_code AS currency_name,furniture_invoice.client AS client,furniture_receipts.receipt_number,furniture_receipts.receipt_amount,furniture_receipts.quotation_divisionid FROM furniture_receipts JOIN furniture_invoice ON furniture_invoice.invoice_id=furniture_receipts.invoice_id JOIN company_division ON company_division.division_id=furniture_invoice.quotation_divisionid WHERE furniture_receipts.receipt_id=".$receipt_id;
				$invoice_result = $this->db->query($INVOICESQL);
				$invoice_details = $invoice_result->result_array();
				$this->db->select('*');
				$this->db->from('emails'); 
				$query_email = $this->db->get();
				$records_email=$query_email->result_array();

				$links =   site_url('furniture/furniture_receipt/view1/'.$receipt_id.'/'.$invoice_details[0]['receipt_number'].'/'.$invoice_details[0]['quotation_divisionid'].'/normal');
				
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Q-Pro Admin';
				$to 		= @$records_email[0]['receipt'];
				$subject 	= 'Q-Pro - Receipt for '.$invoice_details[0]['client'].'('.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].') is created';
				$message 	= '
				<table>
					<tr>
						<td>Receipt No.</td>
						<td>:</td>
						<td><a href='.$links.'>'.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].'</a></td>

					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$invoice_details[0]['client'].'</td>
					</tr>
					<tr>
						<td>Receipt Amount</td>
						<td>:</td>
						<td>'.$invoice_details[0]['currency_name'].'. '.number_format( $invoice_details[0]['receipt_amount'],2).'</td>
					</tr>
				</table>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);
			mail recpt nbas close close
				/*	email notification end		*/
		
		$this->session->set_flashdata('response', 'New Receipt Created...');	
		redirect('Receipt/list_receipt');}else{
		$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
		redirect('Receipt/list_receipt');
		}
	}


	public function save_receipt_new(){

		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		$this->form_validation->set_rules('cash_ledger_code','Cash Ledger code', 'required');
		$this->form_validation->set_rules('c_card_ledger_code','C Card Ledger code', 'required');
		$this->form_validation->set_rules('wallet_ledger_code','Wallet  Ledger code', 'required');
		$this->form_validation->set_rules('cheque_ledger_code','Cheque Ledger code', 'required');

		if ($this->form_validation->run() == FALSE) {
			$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('manage/createReceipt',$data);
			$this->load->view('templates/footer');
		} else {
		
			$this->db->trans_begin();
			$no_of_invoices = $this->input->post('no_of_invoices');		
			$SQL = "SELECT MAX(receipt_number)+1 as `new_receipt_number` FROM furniture_receipts where quotation_divisionid='".$this->input->post('ref_div_id')."';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			
			if($data[0]['new_receipt_number'] != NULL and $data[0]['new_receipt_number'] != ""){
				$receipt_no = $data[0]['new_receipt_number'];
			} else{
				$receipt_no = 1;
			}

			$ref_div_id	=	$this->input->post('ref_div_id');

			$receipt_code	=	$this->furniture_quotation_model->get_receipt_code($ref_div_id,$receipt_no);
					
			$receipt['receipt_number'] = $receipt_no;
			$receipt['receipt_code']   = $receipt_code;
			$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
			$receipt['receipt_date'] = date("Y-m-d h:m:s");
			$receiptd['receipt_mode'] = $this->input->post("payment_modes");
			$receipt['receipt_amount'] = ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt'));
			$receipt['receipt_reference'] = $this->input->post("ref_number");
			$receipt['receipt_bankname'] = $this->input->post("bank_name");
			$receipt['receipt_id'] = $this->input->post("remarks");
			$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
			$receiptdts['invoice_id'] = 0;
			//$this->furniture_quotation_model->set_receipt_id($quotation_id);
			//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
			//$where= array('receipt_id'=>$generated_receipt_id);
			$rcpt = $this->crud_model->insert('furniture_receipts',$receipt);
			//$receipt_no = $this->furniture_quotation_model->get_new_receipt_number();
			//$amount = $this->input->post($current_amount_invoice);
			$receipt_id = $this->db->insert_id();

			$xxreceipt_discount=0;

			$xxreceipt_amount=0;

			for($i=1;$i<=$no_of_invoices;$i++) {
				$xxreceipt_amount=$xxreceipt_amount+(float)$this->input->post("current_amount_invoice_".$i);
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				if($amount!="" && $amount!="0"){
						//$receipt['quotation_id'] = $quotation_id;
						$receiptdts['receipt_amount'] = $amount;
						$receiptdts['receipt_discount'] = $this->input->post("receipt_discount_".$i);
						$receiptdts['balance_amount'] = $bal_amount;
						$receiptdts['receipt_id'] = $receipt_id;
						$receiptdts['invoice_id'] = $invid;
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						$inv = $this->crud_model->insert('receipts_details',$receiptdts);
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						if($inv){
							$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_invoice($invid);
							$receipt_discount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($invid);
							$creceipt_discount=$this->input->post("receipt_discount_".$i);
							$xxreceipt_discount=$xxreceipt_discount+(float)$this->input->post("receipt_discount_".$i);
							$invoiceWhere = array('invoice_id' => $invid);
							$invoiceData = array('paid_amount' =>  (float)$paid_amount+ (float)$amount,'receipt_discount' =>  (float)$receipt_discount+ (float)$creceipt_discount);
							$invupdate = $this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);

							$division_id=$this->input->post('ref_div_id');
							$div_data = $this->db->query("SELECT * FROM `company_division` WHERE division_id='$division_id' ");
							$division_code=$div_data->row()->division_code;  

							$cust_bill_allocations_data = array(
								'customer_code' => $this->input->post('client_code'),
								'bill_id'       => $invid,
								'trn_no'        => $receipt_code,
								'bill_date'     => date("Y-m-d h:m:s"),
								'bill_amt'      => -((float)$nbbbamount),
								'bill_os_amount'=> -((float)$nbbbamount),
								'bill_type'     => 'Receipt',
								'trn_type'      =>  'Receipt'
							);
								
							$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);

							

						}
				}
					
			}
			if($receipt_id){
				

				if($this->input->post('client_code')!=''){
					$this->db->where("vch_no",$receipt_code);
					$this->db->where("vch_type",'RECEIPT');
					$this->db->delete('accounts');
					$accounts_data = array(
						'vch_type' 	  => 'RECEIPT',
						'vch_no'  	  => $receipt_code,
						'vch_date'    => date( "Y-m-d"),
						'vch_ref'     => '',
						'ledger_code' => $this->input->post('client_code'),
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'  => -(float)$xxreceipt_amount,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}

				if($xxreceipt_discount>0){
					$accounts_data = array(
						'vch_type' 	  => 'RECEIPT',
						'vch_no'  	  => $receipt_code,
						'vch_date'    => date( "Y-m-d"),
						'vch_ref'     => '',
						'ledger_code' => 'D0002',
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'   => $xxreceipt_discount,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}

				if($this->input->post('cash')!==''){
					$paidData = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cash'),
						'name' 				=> 'Paid Amount',
						'payment_mode' 		=> 'Paid Amount'
					);
					$this->db->insert('receipt_payment_details', $paidData);
					
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
						'name' 				=> 'Cash',
						'payment_mode' 		=> 'Cash'
					);
					$this->db->insert('receipt_payment_details', $data);

					if($this->input->post('cash_ledger_code')!=''){
						$accounts_data = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => date( "Y-m-d"),
							'vch_ref'     => '',
							'ledger_code' => $this->input->post('cash_ledger_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
					
				}
				if($this->input->post('c_card')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('c_card'),
						'authorized' 		=> $this->input->post('authorized'),
						'name' 				=> $this->input->post('c_type'),
						'payment_mode' 		=> 'Credit Card'
					);
					$this->db->insert('receipt_payment_details', $data);

					if($this->input->post('c_card_ledger_code')!=''){
						$accounts_data = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => date( "Y-m-d"),
							'vch_ref'     => '',
							'ledger_code' => $this->input->post('c_card_ledger_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => $this->input->post('c_card'),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
					
				}
				if($this->input->post('cheque_amt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cheque_amt'),
						'authorized' 		=> $this->input->post('cheque_no'),
						'name' 				=> $this->input->post('cheque_bank'),
						'payment_mode' 		=> 'Cheque'
					);
					$this->db->insert('receipt_payment_details', $data);

					if($this->input->post('cheque_ledger_code')!=''){
						$accounts_data = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => date( "Y-m-d"),
							'vch_ref'     => '',
							'ledger_code' => $this->input->post('cheque_ledger_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => $this->input->post('cheque_amt'),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
					
				}
				if($this->input->post('wallet_amnt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('wallet_amnt'),
						'authorized' 		=> $this->input->post('wallet_authorized'),
						'name' 				=> $this->input->post('wallet_type'),
						'payment_mode' 		=> 'Wallet'
					);
					$this->db->insert('receipt_payment_details', $data);

					if($this->input->post('wallet_ledger_code')!=''){
						$accounts_data = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => date( "Y-m-d"),
							'vch_ref'     => '',
							'ledger_code' => $this->input->post('wallet_ledger_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => $this->input->post('wallet_amnt'),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
					
				}
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
				redirect('Receipt/list_receipt');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'New Receipt Created...');	
				redirect('Receipt/list_receipt');
		 	}
			/*if($inv){
				$this->session->set_flashdata('response', 'New Receipt Created...');	
				redirect('Receipt/list_receipt');
			}else{
				$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
				redirect('Receipt/list_receipt');
			}*/
		}
	}

	public function save_receipt(){
		
		$no_of_invoices = $this->input->post('no_of_invoices');
		$no_of_confirmed_quotations = $this->input->post('no_of_confirmed_quotations');
		
		$this->form_validation->set_message('amount_check','Amount is invalid or greater than balance');
		$this->form_validation->set_rules('remarks', 'Remarks', 'max_length[48]');
		
		if($this->input->post("payment_modes") != "Cash"){
			$this->form_validation->set_rules('ref_number', 'Reference Number', 'max_length[20]');
			$this->form_validation->set_rules('bank_name', 'Bank Name', 'required|max_length[100]');
		}
		
		if ($this->form_validation->run() == TRUE){
			$receipt_no = $this->furniture_quotation_model->get_new_receipt_number();
		
			for($i=1;$i<=$no_of_invoices;$i++)
			{
				$quotation_id_name = "quotation_id_invoices_".$i;
				$new_receipt_tick ="new_receipt_tick_".$i;
				$quotation_id = $this->input->post($quotation_id_name);
				$receipt_chk = $this->input->post($new_receipt_tick);
				
				if($receipt_chk){
					$current_amount_invoice ="current_amount_invoice_".$i;
					$amount = $this->input->post($current_amount_invoice);
					$this->form_validation->set_rules($current_amount_invoice,'Receipt Amount','required|max_length[20]|numeric|callback_amount_check['.$amount.','.$quotation_id.']');
					if ($this->form_validation->run() == TRUE){
						$receipt['quotation_id'] = $quotation_id;
						$receipt['receipt_number'] = $receipt_no;
						$receipt['receipt_date'] = date("Y-m-d h:m:s");
						$receipt['receipt_mode'] = $this->input->post("payment_modes");
						$receipt['receipt_amount'] = $current_amount_invoice;
						$receipt['receipt_reference'] = $this->input->post("ref_number");
						$receipt['receipt_bankname'] = $this->input->post("bank_name");
						$receipt['receipt_remarks'] = $this->input->post("remarks");
						$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
						
						$this->furniture_quotation_model->set_receipt_id($quotation_id);
						$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						$where= array('receipt_id'=>$generated_receipt_id);
						$this->crud_model->insert('furniture_receipts',$receipt);
					}else{
						echo "Validation Error2";
					}		
				}
				$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_quotation($quotation_id);
				$invoiceWhere = array('quotation_id' => $quotation_id);
				$invoiceData = array('paid_amount' => $paid_amount + $current_amount_invoice);
				$this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);
				
			}
			echo "fgdf".$no_of_confirmed_quotations;
			for($i=1;$i<=$no_of_confirmed_quotations;$i++){
				$quotation_id_name = "quotation_id_quote_".$i;
				$new_receipt_tick ="new_receipt_tick_quote_".$i;
				$quotation_id = $this->input->post($quotation_id_name);
				$receipt_chk = $this->input->post($new_receipt_tick);
				
				if($receipt_chk){
					$current_amount_invoice ="current_amount_confirmed_quote_".$i;
					$amount = $this->input->post($current_amount_invoice);
					$this->form_validation->set_rules($current_amount_invoice,'Receipt Amount','required|max_length[20]|numeric|callback_amount_check['.$amount.','.$quotation_id.']');
					if ($this->form_validation->run() == TRUE){
						$receipt['quotation_id'] = $quotation_id;
						$receipt['receipt_number'] = $receipt_no;
						$receipt['receipt_date'] = date('Y-m-d h:m:s');
						$receipt['receipt_mode'] = $this->input->post("payment_modes");
						$receipt['receipt_amount'] = $this->input->post($current_amount_invoice);
						$receipt['receipt_reference'] = $this->input->post("ref_number");
						$receipt['receipt_bankname'] = $this->input->post("bank_name");
						$receipt['receipt_remarks'] = $this->input->post("remarks");
						$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
						
						$this->furniture_quotation_model->set_receipt_id($quotation_id);
						$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						$where= array('receipt_id'=>$generated_receipt_id);
						$this->crud_model->insert('furniture_receipts',$receipt);
					}else{
						echo "Validation Error2";
					}
				}
			}
		}else{
			echo "Validation Error1";
		}
		
		redirect('Receipt/list_receipt');
	}
	
	function amount_check($amount,$quotation_id){
		//$quotation_id =$this->session->userdata('receipt_quotation_id');
		$where1= array('quotation_id'=>$quotation_id);
		$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
		$receipt_total = 0;
			if($data['records'] != false) {
				foreach ($data['records'] as $recrd){
					if($recrd['receipt_status'] != 0){
						$receipt_total += $recrd['receipt_amount'];
					}
				}
			}
		$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		
		$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
		
		if($data['balance']< $amount){
			return false;
		} else{
			if($this->input->post('receipt_amount')<=0){
				return false;
			} else{
				return true;
			}
		}
	}
	
	function filter_receipts(){
	
	}
	
	
public function cancel_receipt($receipt_number,$quotation_divisionid,$receipt_id){
			$this->db->where('receipt_number',$receipt_number);
			$this->db->where('quotation_divisionid',$quotation_divisionid);
				 $data = array(
					'receipt_status' => 0,
					'receipt_cancelledby' => $this->session->userdata('user_name'),
					'receipt_cancelled_date' => date('Y-m-d h:m:s')
				);
			$receipt_cancel	= $this->db->update('furniture_receipts', $data);
				
			$this->db->select('receipt_amount,invoice_id,receipt_discount');
			$this->db->from('furniture_receipts');
			$this->db->where('furniture_receipts.receipt_number', $receipt_number);
			$this->db->where('furniture_receipts.quotation_divisionid', $quotation_divisionid); 
			$query = $this->db->get();
			if ($query->num_rows() > 0) {
				
			//for($i=1;$i<=$query->num_rows();$i++){
			foreach ($query->result() as $row) {
				//$data[] = $row;
				//}
				
				//$data["results"] = $data;
				//}
			$paid_amount 			 = $this->furniture_quotation_model->get_paid_amount_for_invoice($row->invoice_id);
			$receipt_discount_amount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($row->invoice_id);
			 $this->db->where('invoice_id',$row->invoice_id);
				 $invdata = array(
					'paid_amount' 		=> $paid_amount-($row->receipt_amount),
					'receipt_discount'  => $receipt_discount_amount-($row->receipt_discount)
				);
					$this->db->update('furniture_invoice', $invdata);
		 	}
			}
			//}
			//break;
			
			
			if($receipt_cancel){
			
			// MAILING ....

				$INVOICESQL = "SELECT company_division.division_code AS division_name,company_division.currency_code AS currency_name,furniture_invoice.client AS client,furniture_receipts.receipt_number,furniture_receipts.receipt_amount,furniture_receipts.quotation_divisionid FROM furniture_receipts JOIN furniture_invoice ON furniture_invoice.invoice_id=furniture_receipts.invoice_id JOIN company_division ON company_division.division_id=furniture_invoice.quotation_divisionid WHERE furniture_receipts.receipt_id=".$receipt_id;
				$invoice_result = $this->db->query($INVOICESQL);
				$invoice_details = $invoice_result->result_array();
				$this->db->select('*');
				$this->db->from('emails'); 
				$query_email = $this->db->get();
				$records_email=$query_email->result_array();
				//$links =   site_url('furniture/furniture_receipt/view1/'.$receipt_id.'/'.$invoice_details[0]['receipt_number'].'/'.$invoice_details[0]['quotation_divisionid'].'/normal');
				/*	email notification start	*/
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Q-Pro Admin';
				$to 		= @$records_email[0]['receipt'];
				$subject 	= 'Q-Pro - Receipt for '.$invoice_details[0]['client'].'('.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].') is cancelled';
				$message 	= '
				<table>
					<tr>
						<td>Invoice No.</td>
						<td>:</td>
						<td>'.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].'</td>

					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$invoice_details[0]['client'].'</td>
					</tr>
					<tr>
						<td>Invoice Amount</td>
						<td>:</td>
						<td>'.$invoice_details[0]['currency_name'].'. '.number_format( $invoice_details[0]['receipt_amount'],2).'</td>
					</tr>
				</table>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);

				/*	email notification end		*/
			
			$this->session->set_flashdata('response', 'Receipt Cancelled...');
			}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
			}
		    redirect('Receipt/list_receipt');
	}
	
		
}

?>